/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui;

import com.elluminate.platform.Platform;
import javax.swing.AbstractButton;
import javax.swing.JLabel;

public class Mnemonic {
    public static final char MnemonicPrefix = '&';

    public static char getMnemonic(String mnemonicText) {
        if (mnemonicText == null) {
            return '\u0000';
        }
        int len = mnemonicText.length();
        int prevChr = 0;
        for (int i = 0; i < len; ++i) {
            char curChr = mnemonicText.charAt(i);
            if (prevChr == 38) {
                return Character.toUpperCase(curChr);
            }
            prevChr = curChr;
        }
        return '\u0000';
    }

    public static int getMnemonicIndex(String mnemonicText) {
        if (mnemonicText == null) {
            return -1;
        }
        int len = mnemonicText.length();
        for (int i = 0; i < len; ++i) {
            if (mnemonicText.charAt(i) != '&') continue;
            return i;
        }
        return -1;
    }

    public static String getText(String mnemonicText) {
        if (mnemonicText == null) {
            return mnemonicText;
        }
        int prefixIdx = mnemonicText.indexOf(38);
        if (prefixIdx >= 0 && prefixIdx < mnemonicText.length() - 1) {
            return mnemonicText.substring(0, prefixIdx) + mnemonicText.substring(prefixIdx + 1);
        }
        return mnemonicText;
    }

    public static void setTextAndMnemonic(AbstractButton button, String mnemonicText) {
        button.setText(Mnemonic.getText(mnemonicText));
        Mnemonic.setMnemonic(button, mnemonicText);
    }

    public static void setMnemonic(AbstractButton button, String mnemonicText) {
        if (Platform.getLAF() == 502) {
            return;
        }
        char mnemonic = Mnemonic.getMnemonic(mnemonicText);
        if (mnemonic != '\u0000') {
            button.setMnemonic(mnemonic);
            button.setDisplayedMnemonicIndex(Mnemonic.getMnemonicIndex(mnemonicText));
        }
    }

    public static void setTextAndMnemonic(JLabel label, String mnemonicText) {
        label.setText(Mnemonic.getText(mnemonicText));
        Mnemonic.setMnemonic(label, mnemonicText);
    }

    public static void setMnemonic(JLabel label, String mnemonicText) {
        if (Platform.getLAF() == 502) {
            return;
        }
        char mnemonic = Mnemonic.getMnemonic(mnemonicText);
        if (mnemonic != '\u0000') {
            label.setDisplayedMnemonic(mnemonic);
            label.setDisplayedMnemonicIndex(Mnemonic.getMnemonicIndex(mnemonicText));
        }
    }
}

