/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui;

import com.elluminate.gui.GUIDebug;
import com.elluminate.gui.HotKey;
import com.elluminate.gui.NativeTheme;
import com.elluminate.gui.PlatformTheme;
import com.elluminate.gui.StringsProperties;
import com.elluminate.platform.Platform;
import com.elluminate.util.Debug;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.StringUtils;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import javax.swing.text.JTextComponent;

public class GuiUtils {
    public static final char DOCK_LEFT_EDGE = 'L';
    public static final char DOCK_RIGHT_EDGE = 'R';
    public static final char DOCK_TOP_EDGE = 'T';
    public static final char DOCK_BOTTOM_EDGE = 'B';
    public static final char DOCK_NONE = 'N';
    private static final boolean VIRTUAL_DISPLAY_SPACE = Platform.getPlatform() == 2 || Platform.getPlatform() == 1;
    private static final String LABELLED_BY_PROP = "labeledBy";
    private static PlatformGuiSupport support = null;

    public static void initialize() {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (!SwingRunnerSupport.getInstance().isEventDispatchThread()) {
            throw new RuntimeException("not event thread");
        }
        GuiUtils.getPlatformSupport();
    }

    public static Component getLabelOf(JComponent c) {
        return (Component)c.getClientProperty(LABELLED_BY_PROP);
    }

    public static void setLabelFor(JComponent cmp, Component label) {
        cmp.putClientProperty(LABELLED_BY_PROP, label);
    }

    public static Insets getScreenInsets(GraphicsConfiguration graphConfig) {
        if (graphConfig == null) {
            GraphicsEnvironment genv = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice gdev = genv.getDefaultScreenDevice();
            graphConfig = gdev.getDefaultConfiguration();
        }
        Insets result = null;
        result = GuiUtils.getPlatformSupport().getScreenInsets(graphConfig);
        if (GUIDebug.INSETS.show()) {
            LogSupport.message(GuiUtils.class, (String)"getScreenInsets", (String)("insets=" + result.top + "," + result.left + "," + result.bottom + "," + result.right));
        }
        return result;
    }

    public static Rectangle[] getScreenBounds(Rectangle allScreens, Insets insets) {
        return GuiUtils.getPlatformSupport().getScreenBounds(allScreens, insets);
    }

    public static Rectangle[] getScreenBounds(Rectangle allScreens) {
        return GuiUtils.getScreenBounds(allScreens, null);
    }

    public static Rectangle getDesktopBounds() {
        return GuiUtils.getDesktopBounds(null);
    }

    public static Rectangle getDesktopBounds(Insets insets) {
        Rectangle bounds = new Rectangle();
        GuiUtils.getScreenBounds(bounds, insets);
        return bounds;
    }

    public static GraphicsConfiguration getDevice(int x, int y, Component c) {
        GraphicsConfiguration result = GuiUtils.getPlatformSupport().getDevice(x, y, c);
        if (result == null) {
            GraphicsEnvironment genv = GraphicsEnvironment.getLocalGraphicsEnvironment();
            result = genv.getDefaultScreenDevice().getDefaultConfiguration();
        }
        return result;
    }

    public static Rectangle getDeviceBounds(Point loc, Component c) {
        return GuiUtils.getDeviceBounds(loc.x, loc.y, c);
    }

    public static Rectangle getDeviceBounds(int x, int y, Component c) {
        return GuiUtils.getDeviceBounds(x, y, c, null);
    }

    public static Rectangle getDeviceBounds(int x, int y, Component c, Insets ins) {
        Rectangle result = null;
        GraphicsConfiguration gconf = GuiUtils.getDevice(x, y, c);
        result = new Rectangle(gconf.getBounds());
        if (ins != null) {
            Insets devInsets = GuiUtils.getScreenInsets(gconf);
            if (devInsets != null) {
                ins.top = devInsets.top;
                ins.left = devInsets.left;
                ins.bottom = devInsets.bottom;
                ins.right = devInsets.right;
            } else {
                ins.top = 0;
                ins.left = 0;
                ins.bottom = 0;
                ins.right = 0;
            }
        }
        return result;
    }

    public static Icon getFileIcon(File f) {
        return GuiUtils.getPlatformSupport().getFileIcon(f);
    }

    public static String getKeystrokeText(int keyCode, int keyMod) {
        return GuiUtils.getPlatformSupport().getKeystrokeText(keyCode, keyMod);
    }

    public static String getKeystrokeText(KeyStroke stroke) {
        if (stroke == null) {
            return GuiUtils.getPlatformSupport().getKeystrokeText(0, 0);
        }
        return GuiUtils.getPlatformSupport().getKeystrokeText(stroke.getKeyCode(), stroke.getModifiers());
    }

    public static boolean checkKeyCode(int keyCode) {
        return GuiUtils.getPlatformSupport().checkKeyCode(keyCode);
    }

    public static String getKeyName(int keyCode) {
        return GuiUtils.getPlatformSupport().getKeyName(keyCode);
    }

    public static String getLAFID() {
        return GuiUtils.getPlatformSupport().getLAFID();
    }

    public static PlatformTheme getTheme() {
        return GuiUtils.getPlatformSupport().getTheme();
    }

    public static Frame getFrame(Component c) {
        return GuiUtils.getPlatformSupport().getFrame(c);
    }

    public static Runnable hideWindow(Window w) {
        return GuiUtils.getPlatformSupport().hideWindow(w);
    }

    public static boolean hasHotKeys() {
        return GuiUtils.getPlatformSupport().hasHotKeys();
    }

    public static HotKey createHotKey(int keyCode, int keyModifiers, Runnable action) {
        return GuiUtils.getPlatformSupport().createHotKey(keyCode, keyModifiers, action);
    }

    public static void shutDownHotKeys() {
        GuiUtils.getPlatformSupport().shutDownHotKeys();
    }

    public static boolean hasWindowHandles() {
        return GuiUtils.getPlatformSupport().hasWindowHandles();
    }

    public static Object getWindowHandle(Component c) {
        return GuiUtils.getPlatformSupport().getWindowHandle(c);
    }

    public static boolean isDockingSupported() {
        return GuiUtils.getPlatformSupport().isDockingSupported();
    }

    public static void dockFrame(Frame frame, char mode) {
        GuiUtils.getPlatformSupport().dockFrame(frame, mode);
    }

    public static void undockFrame(Frame frame) {
        GuiUtils.getPlatformSupport().undockFrame(frame);
    }

    public static String getComponentInfo(Component c) {
        Rectangle b;
        if (c == null) {
            return "" + null;
        }
        String result = GuiUtils.getMutableInfo(c);
        if (result == null || result.length() == 0) {
            result = c.getName();
        }
        if ((result == null || result.length() == 0) && (b = c.getBounds()) != null) {
            result = result + b.width + "x" + b.height + "@" + b.x + "," + b.y;
        }
        return c.getClass().getName() + " " + result;
    }

    private static String getMutableInfo(Component c) {
        String result = null;
        try {
            if (!(c instanceof JPasswordField)) {
                if (c instanceof JTextComponent) {
                    result = ((JTextComponent)c).getText();
                } else if (c instanceof JSpinner) {
                    Object msg = ((JSpinner)c).getValue();
                    if (msg != null) {
                        result = msg.toString();
                    }
                } else if (c instanceof JTabbedPane) {
                    JTabbedPane tabs = (JTabbedPane)c;
                    int nTabs = tabs.getTabCount();
                    int cur = tabs.getSelectedIndex();
                    if (cur >= 0 && cur < nTabs) {
                        result = tabs.getTitleAt(cur);
                    } else if (nTabs > 0) {
                        result = tabs.getTitleAt(0);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (result == null || result.length() == 0) {
            result = GuiUtils.getImmutableInfo(c);
        }
        return result;
    }

    private static String getImmutableInfo(Component c) {
        String result = null;
        try {
            if (c instanceof AbstractButton) {
                Icon icon;
                AbstractButton btn = (AbstractButton)c;
                result = btn.getText();
                if ((result == null || result.length() == 0) && (icon = btn.getIcon()) != null) {
                    result = icon.toString();
                }
            } else if (c instanceof JLabel) {
                Icon icon;
                JLabel lbl = (JLabel)c;
                result = lbl.getText();
                if ((result == null || result.length() == 0) && (icon = lbl.getIcon()) != null) {
                    result = icon.toString();
                }
            } else if (c instanceof Dialog) {
                result = ((Dialog)c).getTitle();
            } else if (c instanceof Frame) {
                result = ((Frame)c).getTitle();
            } else if (c instanceof JInternalFrame) {
                result = ((JInternalFrame)c).getTitle();
            } else if (c instanceof JOptionPane) {
                Object msg = ((JOptionPane)c).getMessage();
                result = msg instanceof Component ? "msg=" + GuiUtils.getComponentInfo((Component)msg) : "msg=" + StringUtils.getStringValue((Object)msg);
            } else if (c instanceof JPopupMenu) {
                result = ((JPopupMenu)c).getLabel();
            } else if (c instanceof JTable) {
                JTable tbl = (JTable)c;
                boolean hasHeaders = false;
                StringBuffer headers = new StringBuffer();
                for (int ix = 0; ix < tbl.getColumnCount(); ++ix) {
                    String colName = tbl.getColumnName(ix);
                    if (colName == null || "".equals(colName)) {
                        colName = StringUtils.afterLast((String)tbl.getColumnClass(ix).getName(), (String)".");
                    }
                    hasHeaders |= colName.length() > 0;
                    if (ix > 0) {
                        headers.append(":");
                    }
                    headers.append(colName);
                }
                if (hasHeaders) {
                    result = headers.toString();
                }
            }
        }
        catch (Throwable t) {
            result = null;
        }
        if ((result == null || result.length() == 0) && c instanceof JComponent) {
            String tip;
            result = tip = ((JComponent)c).getToolTipText();
        }
        return result;
    }

    public static void dumpComponentHierarchy(Component c) {
        GuiUtils.dumpComponentHierarchy(c, "");
    }

    public static void dumpComponentHierarchy(Component c, String indent) {
        if (c == null) {
            return;
        }
        System.err.println(indent + c.getClass().getName() + "#" + c.hashCode() + ": " + (c.isVisible() ? "" : "!vis ") + GuiUtils.getMutableInfo(c) + " " + c.getX() + "," + c.getY() + " " + c.getWidth() + "x" + c.getHeight());
        if (c instanceof Container) {
            Component[] children = ((Container)c).getComponents();
            String childIndent = indent + "  ";
            for (int ix = 0; ix < children.length; ++ix) {
                GuiUtils.dumpComponentHierarchy(children[ix], childIndent);
            }
        }
    }

    public static void dumpAncestry(Component c) {
        GuiUtils.dumpAncestry(c, "");
    }

    public static void dumpAncestry(Component c, String indent) {
        if (c == null) {
            return;
        }
        GuiUtils.dumpAncestry(c.getParent(), indent + "  ");
        System.err.println(indent + c.getClass().getName() + "#" + c.hashCode() + ": " + GuiUtils.getMutableInfo(c));
    }

    private static PlatformGuiSupport getPlatformSupport() {
        if (support == null) {
            GuiUtils.createPlatformSupport();
        }
        return support;
    }

    private static synchronized void createPlatformSupport() {
        if (support == null) {
            block12: {
                if (GraphicsEnvironment.isHeadless()) {
                    throw new HeadlessException();
                }
                String className = null;
                switch (Platform.getPlatform()) {
                    case 2: {
                        className = "com.elluminate.gui.macosx.MacGuiSupport";
                        break;
                    }
                    case 3: {
                        className = "com.elluminate.gui.x11.X11GuiSupport";
                        break;
                    }
                    case 1: {
                        className = "com.elluminate.gui.windows.WindowsGuiSupport";
                    }
                }
                if (className != null) {
                    try {
                        support = (PlatformGuiSupport)Class.forName(className).newInstance();
                        if (GUIDebug.UTILS.show()) {
                            LogSupport.message(GuiUtils.class, (String)"createPlatformSupport", (String)("Created helper: " + support.getClass().getName()));
                        }
                        return;
                    }
                    catch (Throwable t) {
                        if (!GUIDebug.UTILS.show()) break block12;
                        LogSupport.message(GuiUtils.class, (String)"createPlatformSupport", (String)("Failed to create helper " + className + ": " + t));
                    }
                }
            }
            support = new PlatformGuiSupport();
            if (GUIDebug.UTILS.show()) {
                LogSupport.message(GuiUtils.class, (String)"createPlatformSupport", (String)("Using fallback helper: " + support.getClass().getName()));
            }
        }
    }

    static synchronized void setPlatformSupport(PlatformGuiSupport support) {
        GuiUtils.support = support;
    }

    public static void removeKeyBinding(KeyStroke KeyStroke2, JComponent component) {
        InputMap imap = component.getInputMap(1);
        if (imap.get(KeyStroke2) != null) {
            for (InputMap map = imap; map != null; map = map.getParent()) {
                map.remove(KeyStroke2);
            }
        }
    }

    public static class PlatformGuiSupport {
        protected I18n i18n = I18n.create((Object)this);
        private FileSystemView fsView = null;
        private final MediaTracker tracker = new MediaTracker(new Component(){});
        private int trackerID = 0;
        private String LAFid = UIManager.getLookAndFeel().getID();

        protected PlatformGuiSupport() {
        }

        public Insets getScreenInsets(GraphicsConfiguration graphConfig) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            return tk.getScreenInsets(graphConfig);
        }

        public Rectangle[] getScreenBounds(Rectangle allScreens, Insets insets) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            boolean mainFound = false;
            ArrayList<Rectangle> screenBounds = new ArrayList<Rectangle>();
            ArrayList<Insets> screenInsets = null;
            Rectangle desktopBounds = null;
            if (insets != null) {
                screenInsets = new ArrayList<Insets>();
            }
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice mainScreen = ge.getDefaultScreenDevice();
            GraphicsDevice[] screens = ge.getScreenDevices();
            for (int i = 0; i < screens.length; ++i) {
                boolean isMain;
                boolean bl = isMain = screens[i] == mainScreen;
                if (GUIDebug.SCREENS.show()) {
                    LogSupport.message((Object)this, (String)"getScreenBounds", (String)("Device: " + screens[i].getIDstring() + (isMain ? " (Default) " : " ") + screens[i].getClass().getName()));
                }
                GraphicsConfiguration dftConfig = screens[i].getDefaultConfiguration();
                Rectangle configBounds = null;
                try {
                    configBounds = dftConfig.getBounds();
                }
                catch (Throwable t) {
                    LogSupport.exception((Object)this, (String)"getScreenBounds", (Throwable)t, (boolean)true);
                }
                Rectangle r = new Rectangle();
                if (configBounds == null) continue;
                r.setBounds(configBounds);
                if (GUIDebug.SCREENS.show()) {
                    LogSupport.message((Object)this, (String)"getScreenBounds", (String)("  Config: " + r.x + "," + r.y + " " + r.width + "x" + r.height + (dftConfig.getColorModel() != null ? " " + dftConfig.getColorModel().getPixelSize() + " bits/pixel " + dftConfig.getColorModel() : "")));
                }
                desktopBounds = desktopBounds == null ? r : desktopBounds.union(r);
                Insets devInsets = null;
                if (screenInsets != null) {
                    devInsets = GuiUtils.getScreenInsets(dftConfig);
                    if (devInsets == null) {
                        devInsets = new Insets(0, 0, 0, 0);
                    }
                    if (GUIDebug.SCREENS.show()) {
                        LogSupport.message((Object)this, (String)"getScreenBounds", (String)("  Insets:  " + devInsets));
                    }
                }
                if (!mainFound && isMain) {
                    screenBounds.add(0, r);
                    if (screenInsets != null) {
                        screenInsets.add(0, devInsets);
                    }
                    mainFound = true;
                    continue;
                }
                screenBounds.add(r);
                if (screenInsets == null) continue;
                screenInsets.add(devInsets);
            }
            if (insets != null) {
                int top = desktopBounds.y;
                int left = desktopBounds.x;
                int bottom = desktopBounds.y + desktopBounds.height;
                int right = desktopBounds.x + desktopBounds.width;
                int iTop = top;
                int iLeft = left;
                int iBottom = bottom;
                int iRight = right;
                Iterator iBounds = screenBounds.iterator();
                Iterator iInsets = screenInsets.iterator();
                while (iBounds.hasNext() && iInsets.hasNext()) {
                    Rectangle bounds = (Rectangle)iBounds.next();
                    Insets ins = (Insets)iInsets.next();
                    if (bounds == null || ins == null) continue;
                    int sTop = bounds.y + ins.top;
                    int sLeft = bounds.x + ins.left;
                    int sBottom = bounds.y + bounds.height - ins.bottom;
                    int sRight = bounds.x + bounds.width - ins.right;
                    if (ins.top > 0 && sTop > iTop) {
                        iTop = sTop;
                    }
                    if (ins.left > 0 && sLeft > iLeft) {
                        iLeft = sLeft;
                    }
                    if (ins.bottom > 0 && sBottom < iBottom) {
                        iBottom = sBottom;
                    }
                    if (ins.right <= 0 || sRight <= iRight) continue;
                    iRight = sRight;
                }
                insets.top = iTop - top;
                insets.left = iLeft - left;
                insets.bottom = bottom - iBottom;
                insets.right = right - iRight;
            }
            if (!VIRTUAL_DISPLAY_SPACE) {
                desktopBounds = screenBounds.size() > 0 ? new Rectangle((Rectangle)screenBounds.get(0)) : new Rectangle(0, 0, 0, 0);
            }
            if (GUIDebug.SCREENS.show()) {
                LogSupport.message((Object)this, (String)"getScreenBounds", (String)("Outer bounds: " + desktopBounds + " Insets: " + insets));
            }
            if (allScreens != null) {
                allScreens.setBounds(desktopBounds);
            }
            return screenBounds.toArray(new Rectangle[screenBounds.size()]);
        }

        public GraphicsConfiguration getDevice(int x, int y, Component c) {
            GraphicsConfiguration result = null;
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            if (VIRTUAL_DISPLAY_SPACE) {
                GraphicsDevice mainScreen = ge.getDefaultScreenDevice();
                GraphicsConfiguration config = mainScreen.getDefaultConfiguration();
                if (config.getBounds().contains(x, y)) {
                    return config;
                }
                int devSize = -1;
                int devDepth = -1;
                int devDist = Integer.MAX_VALUE;
                GraphicsDevice[] screens = ge.getScreenDevices();
                for (int i = 0; i < screens.length; ++i) {
                    Rectangle curBounds;
                    if (screens[i] == mainScreen || (curBounds = (config = screens[i].getDefaultConfiguration()).getBounds()) == null || !curBounds.contains(x, y)) continue;
                    int curDepth = screens[i].getDisplayMode().getBitDepth();
                    int curSize = curBounds.width * curBounds.height;
                    int curDist = curBounds.x * curBounds.x + curBounds.y * curBounds.y;
                    if (result != null && (devDepth > curDepth || devSize > curSize || devDist < curDist)) continue;
                    result = config;
                    devDepth = curDepth;
                    devSize = curSize;
                    devDist = curDist;
                }
            }
            if (result == null && c != null) {
                Window win = null;
                win = c instanceof Window ? (Window)c : SwingUtilities.windowForComponent(c);
                if (win != null) {
                    result = win.getGraphicsConfiguration();
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Icon getFileIcon(File f) {
            if (f == null) {
                return null;
            }
            if (!f.exists()) {
                return null;
            }
            try {
                PlatformGuiSupport platformGuiSupport = this;
                synchronized (platformGuiSupport) {
                    if (this.fsView == null) {
                        this.fsView = FileSystemView.getFileSystemView();
                    }
                }
                return this.fsView.getSystemIcon(f);
            }
            catch (Throwable t) {
                if (Platform.getPlatform() == 1 && t instanceof NullPointerException) {
                    LogSupport.error((Object)this, (String)"getFileIcon", (String)Debug.getStackTrace((Throwable)t));
                    return null;
                }
                LogSupport.exception((Object)this, (String)"getFileIcon", (Throwable)t, (boolean)true, (String)f.getAbsolutePath());
                return null;
            }
        }

        public String getKeystrokeText(int keyCode, int keyMod) {
            return (keyMod != 0 ? KeyEvent.getKeyModifiersText(keyMod) + this.i18n.getString((PropertiesEnum)StringsProperties.GUISUPPORT_MODKEYSEPARATOR) : "") + this.getKeyName(keyCode);
        }

        public String getKeyName(int keyCode) {
            return KeyEvent.getKeyText(keyCode);
        }

        public boolean checkKeyCode(int keyCode) {
            if (keyCode >= 65 && keyCode <= 90) {
                return true;
            }
            if (keyCode >= 48 && keyCode <= 57) {
                return true;
            }
            if (keyCode >= 96 && keyCode <= 105) {
                return true;
            }
            if (keyCode >= 112 && keyCode <= 123) {
                return true;
            }
            switch (keyCode) {
                case 8: 
                case 9: 
                case 10: 
                case 16: 
                case 17: 
                case 18: 
                case 20: 
                case 27: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 59: 
                case 61: 
                case 91: 
                case 92: 
                case 93: 
                case 106: 
                case 107: 
                case 109: 
                case 111: 
                case 127: 
                case 192: 
                case 222: {
                    return true;
                }
            }
            return false;
        }

        public String getLAFID() {
            return this.LAFid;
        }

        public PlatformTheme getTheme() {
            if (GraphicsEnvironment.isHeadless()) {
                throw new HeadlessException();
            }
            try {
                if (this.getLAFID().equals("Metal")) {
                    try {
                        return new NativeTheme();
                    }
                    catch (Throwable ignored) {
                        return new PlatformTheme();
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }

        public Frame getFrame(Component c) {
            while (c != null) {
                if (c instanceof Frame) {
                    return (Frame)c;
                }
                c = c.getParent();
            }
            return null;
        }

        public Runnable hideWindow(Window w) {
            WindowRestorer undo = new WindowRestorer(w);
            try {
                if (w instanceof Frame && undo.origState != 0 && (undo.origState & 1) == 0) {
                    ((Frame)w).setExtendedState(0);
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    undo.origBounds.setBounds(w.getBounds());
                }
                Rectangle dt = GuiUtils.getDesktopBounds();
                int xPos = dt.x + dt.width + 1;
                int yPos = dt.y + dt.height + 1;
                int width = w.getWidth();
                int height = w.getHeight();
                if (Platform.getOS() == 300) {
                    xPos -= 3;
                    yPos -= 3;
                }
                w.setBounds(xPos, yPos, width, height);
                undo.isMoved = true;
                return undo;
            }
            catch (Exception exception) {
                return null;
            }
        }

        public boolean hasHotKeys() {
            return false;
        }

        public HotKey createHotKey(int keyCode, int keyModifiers, Runnable action) {
            return null;
        }

        public void shutDownHotKeys() {
        }

        public boolean hasWindowHandles() {
            return false;
        }

        public Object getWindowHandle(Component c) {
            return null;
        }

        public boolean isDockingSupported() {
            return false;
        }

        public void dockFrame(Frame frame, char mode) {
            if (mode == 'N') {
                return;
            }
            throw new RuntimeException("Frame docking not supported for mode: " + mode);
        }

        public void undockFrame(Frame frame) {
        }
    }

    private static class WindowRestorer
    implements Runnable {
        Window win = null;
        boolean wasVisible = false;
        boolean isIconified = false;
        boolean isMoved = false;
        int origState = 0;
        Rectangle origBounds = null;

        WindowRestorer(Window w) {
            this.win = w;
            this.wasVisible = w.isVisible();
            this.origBounds = w.getBounds();
            if (w instanceof Frame) {
                this.origState = ((Frame)w).getExtendedState();
            }
        }

        @Override
        public void run() {
            if (this.win == null) {
                return;
            }
            if (this.isMoved && this.origBounds != null) {
                this.win.setBounds(this.origBounds);
                try {
                    Thread.sleep(150L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.win instanceof Frame) {
                ((Frame)this.win).setExtendedState(this.origState);
            }
        }

        public String toString() {
            if (this.win == null) {
                return super.toString() + " win=null";
            }
            StringBuffer result = new StringBuffer(256);
            result.append(super.toString());
            String title = null;
            if (this.win instanceof Frame) {
                title = ((Frame)this.win).getTitle();
            } else if (this.win instanceof Dialog) {
                title = ((Dialog)this.win).getTitle();
            }
            if (title == null || title.equals("")) {
                title = this.win.getName();
            }
            if (title == null || title.equals("")) {
                title = "N/A";
            }
            result.append(" win=[title=" + title + ",bounds=" + this.win.getBounds() + (this.win.isShowing() ? ",showing" : ",hidden") + "]");
            if (this.isIconified) {
                result.append(",iconified,state=" + this.origState);
            }
            if (this.isMoved) {
                result.append(",moved,orig=" + this.origBounds);
            }
            return result.toString();
        }
    }
}

