/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui;

import com.elluminate.platform.Platform;
import com.elluminate.util.SwingRunnerSupport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class FontUtils {
    public static final String TEXT_FIT_INSTALLED_DOC_PROP = "com.elluminate.gui.keepTextSizedToFit.documentListener";
    public static final String TEXT_FIT_INSTALLED_COMP_PROP = "com.elluminate.gui.keepTextSizedToFit.componentListener";
    private static Set<String> fontSet = null;
    private static Font labelFont = null;
    private static int[] CHAT_DEFAULT_SIZES = new int[]{8, 9, 10, 11, 12, 13, 14, 16, 18, 20, 24, 28, 32, 36, 48, 72};
    private static int sizeOfWindows7FixedFont = 12;
    private static final int DEFAULT_WINDOWS_SYSTEMFIXED_FONT_SIZE = 12;

    public static void initialize() {
        if (!SwingRunnerSupport.getInstance().isEventDispatchThread()) {
            throw new RuntimeException("not event thread");
        }
        labelFont = UIManager.getFont("Label.font");
    }

    public static String encode(Font font) {
        StringBuilder fontID = new StringBuilder();
        fontID.append(font.getFamily());
        fontID.append("-");
        if (font.isBold() && font.isItalic()) {
            fontID.append("BOLDITALIC");
        } else if (font.isBold()) {
            fontID.append("BOLD");
        } else if (font.isItalic()) {
            fontID.append("ITALIC");
        } else {
            fontID.append("PLAIN");
        }
        fontID.append("-");
        fontID.append(font.getSize());
        return fontID.toString();
    }

    public static Font setFontSize(Font font, int size) {
        return FontUtils.getFont(font).deriveFont((float)size);
    }

    public static Font setFontStyle(Font font, int style) {
        return FontUtils.getFont(font).deriveFont(style);
    }

    public static Font setFontStyleAndSize(Font font, int style, int size) {
        Font f = FontUtils.getFont(font);
        f = FontUtils.setFontSize(f, size);
        f = FontUtils.setFontStyle(f, style);
        return f;
    }

    private static Font getFont(Font toCheck) {
        return toCheck == null ? labelFont : toCheck;
    }

    public static String[] getFontNames() {
        String fontList = System.getProperty("com.elluminate.vclass.whiteboard.fontlist");
        if (fontList != null) {
            StringTokenizer parser = new StringTokenizer(fontList, ",");
            ArrayList<String> nameList = new ArrayList<String>(parser.countTokens());
            while (parser.hasMoreTokens()) {
                String name = parser.nextToken();
                if (!FontUtils.hasFont(name)) continue;
                nameList.add(name);
            }
            if (nameList.size() > 0) {
                String[] result = new String[nameList.size()];
                result = nameList.toArray(result);
                return result;
            }
        }
        if (System.getProperty("com.elluminate.vclass.whiteboard.allfonts") != null) {
            return FontUtils.getAllFontNames();
        }
        return FontUtils.getJavaFontNames();
    }

    public static Font getAdjustedFont(String text, Font font, Dimension size, Component component) {
        return FontUtils.getAdjustedFont(text, font, 4, 200, size, component);
    }

    public static Font getAdjustedFont(String text, Font font, int minSize, int maxSize, Dimension size, Component component) {
        boolean tooTall;
        Font f = font;
        float min = minSize;
        float max = maxSize;
        if ((float)f.getSize() < min) {
            f = f.deriveFont(min);
        }
        if ((float)f.getSize() > max) {
            f = f.deriveFont(min);
        }
        if (text == null || text.length() == 0) {
            return f;
        }
        FontMetrics fm = component.getFontMetrics(f);
        int w = fm.stringWidth(text);
        int h = fm.getAscent() + fm.getDescent();
        boolean tooWide = w > size.width;
        boolean bl = tooTall = h > size.height;
        if (tooWide || tooTall) {
            while ((float)f.getSize() > min && (tooWide || tooTall)) {
                Font tempf = f.deriveFont((float)f.getSize() - 1.0f);
                fm = component.getFontMetrics(tempf);
                w = fm.stringWidth(text);
                h = fm.getAscent() + fm.getDescent();
                tooWide = w > size.width;
                tooTall = h > size.height;
                f = tempf;
            }
        } else {
            while ((float)f.getSize() < max && !tooWide && !tooTall) {
                Font tempf = f.deriveFont((float)f.getSize() + 1.0f);
                fm = component.getFontMetrics(tempf);
                w = fm.stringWidth(text);
                h = fm.getAscent() + fm.getDescent();
                tooWide = w > size.width;
                boolean bl2 = tooTall = h > size.height;
                if (tooWide || tooTall) continue;
                f = tempf;
            }
        }
        return f;
    }

    public static void keepTextSizedToFit(final JTextComponent text, final int min, final int max) {
        FontUtils.clearTextSizedToFit(text);
        final Runnable sizeToFit = new Runnable(){
            private JTextComponent textComponent;
            private int minTextSize;
            private int maxTextSize;
            {
                this.textComponent = text;
                this.minTextSize = min;
                this.maxTextSize = max;
            }

            @Override
            public void run() {
                String str = this.findMaxLine(this.textComponent.getText());
                Dimension size = this.textComponent.getSize();
                Font f = this.textComponent.getFont();
                f = FontUtils.getAdjustedFont(str, f, this.minTextSize, this.maxTextSize, size, this.textComponent);
                this.textComponent.setFont(f);
                this.textComponent.repaint();
            }

            private String findMaxLine(String body) {
                String result = "";
                StringTokenizer parser = new StringTokenizer(body, "\n\r");
                while (parser.hasMoreTokens()) {
                    String str = parser.nextToken();
                    if (str.length() <= result.length()) continue;
                    result = str;
                }
                return result;
            }
        };
        DocumentListener docListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent ev) {
                SwingRunnerSupport.invokeOnEventThread((Runnable)sizeToFit);
            }

            @Override
            public void insertUpdate(DocumentEvent ev) {
                SwingRunnerSupport.invokeOnEventThread((Runnable)sizeToFit);
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
                SwingRunnerSupport.invokeOnEventThread((Runnable)sizeToFit);
            }
        };
        ComponentAdapter compListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent ev) {
                SwingRunnerSupport.invokeOnEventThread((Runnable)sizeToFit);
            }
        };
        text.putClientProperty(TEXT_FIT_INSTALLED_DOC_PROP, docListener);
        text.putClientProperty(TEXT_FIT_INSTALLED_COMP_PROP, compListener);
        text.getDocument().addDocumentListener(docListener);
        text.addComponentListener(compListener);
        SwingRunnerSupport.invokeOnEventThread((Runnable)sizeToFit);
    }

    public static void clearTextSizedToFit(JTextComponent text) {
        ComponentListener cl;
        DocumentListener dl = (DocumentListener)text.getClientProperty(TEXT_FIT_INSTALLED_DOC_PROP);
        if (dl != null) {
            text.getDocument().removeDocumentListener(dl);
        }
        if ((cl = (ComponentListener)text.getClientProperty(TEXT_FIT_INSTALLED_COMP_PROP)) != null) {
            text.removeComponentListener(cl);
        }
        text.putClientProperty(TEXT_FIT_INSTALLED_DOC_PROP, null);
        text.putClientProperty(TEXT_FIT_INSTALLED_COMP_PROP, null);
    }

    public static String[] getJavaFontNames() {
        String[] names = new String[]{"Dialog", "SansSerif", "Serif", "Monospaced", "DialogInput"};
        return names;
    }

    public static String[] getAllFontNames() {
        String[] javaFonts = FontUtils.getJavaFontNames();
        String[] result = null;
        try {
            result = FontUtils.getFontFamilyNames(javaFonts);
        }
        catch (Throwable t) {
            result = javaFonts;
        }
        return result;
    }

    public static boolean hasFont(String fontname) {
        if (fontSet == null) {
            FontUtils.loadFontSet();
        }
        return fontSet.contains(fontname);
    }

    private static synchronized void loadFontSet() {
        if (fontSet != null) {
            return;
        }
        GraphicsEnvironment genv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] names = genv.getAvailableFontFamilyNames();
        fontSet = new HashSet<String>((names.length * 4 + 2) / 3);
        for (int ix = 0; ix < names.length; ++ix) {
            fontSet.add(names[ix]);
        }
    }

    private static String[] getFontFamilyNames(String[] ignoring) {
        Font[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        HashMap<String, String> map = new HashMap<String, String>(fonts.length);
        block0: for (int ix = 0; ix < fonts.length; ++ix) {
            String family = fonts[ix].getFamily();
            String name = fonts[ix].getName();
            if (name.startsWith(".")) continue;
            for (int jx = 0; jx < ignoring.length; ++jx) {
                if (name.equalsIgnoreCase(ignoring[jx]) || family.equalsIgnoreCase(ignoring[jx]) || name.startsWith(ignoring[jx].toLowerCase(Locale.ENGLISH) + ".")) continue block0;
            }
            if (map.containsKey(family) || map.containsKey(name)) continue;
            map.put(family, name);
        }
        String[] result = new String[map.size()];
        result = map.values().toArray(result);
        return result;
    }

    static void setsizeOfWindowsFixedFont(int size) {
        sizeOfWindows7FixedFont = size;
    }

    public static int getAcceptableFontSize(int sizeSetInElive) {
        if (sizeOfWindows7FixedFont == 12) {
            return sizeSetInElive;
        }
        int sizeSelected = sizeSetInElive * sizeOfWindows7FixedFont / 12;
        for (int i = 0; i < CHAT_DEFAULT_SIZES.length; ++i) {
            if (sizeSelected > CHAT_DEFAULT_SIZES[i]) continue;
            return CHAT_DEFAULT_SIZES[i];
        }
        return CHAT_DEFAULT_SIZES[CHAT_DEFAULT_SIZES.length - 1];
    }

    static {
        if (Platform.getPlatform() == 1 && Platform.getOS() > 406) {
            try {
                Object value = Toolkit.getDefaultToolkit().getDesktopProperty("win.status.font.height");
                if (value != null) {
                    sizeOfWindows7FixedFont = (Integer)value;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

