/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.timer.module;

import com.elluminate.classroom.client.messaging.ExtraInfo;
import com.elluminate.classroom.client.messaging.MessagePublisher;
import com.elluminate.classroom.client.messaging.MessagePublisherMetadata;
import com.elluminate.classroom.client.messaging.MessageRouter;
import com.elluminate.classroom.client.messaging.MessageType;
import com.elluminate.classroom.client.messaging.ModulePublisherInfo;
import com.elluminate.groupware.timer.module.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

@Singleton
public class TimerPublisher {
    private final String UNIQUE_NAME = "TimerPublisher";
    private final String DISPLAY_NAME;
    private final Icon icon;
    public static final String TIMER_STARTED = "timer-started";
    public static final String TIMER_PAUSED = "timer-paused";
    public static final String TIMER_STOPPED = "timer-stopped";
    public static final String TIMER_RESUMED = "timer-resumed";
    public static final String TIMER_WENT_OFF = "timer-went-off";
    private final MessagePublisher publisher;
    private final MessagePublisherMetadata metadata;
    private final I18n i18n;
    private final MessageRouter router;
    private String modName;
    private String modDisplayName;
    private Map<String, MessageType> msgTypes = new HashMap<String, MessageType>();

    @Inject
    public TimerPublisher(MessagePublisher pub, MessagePublisherMetadata meta, MessageRouter rtr, I18n localization, ModulePublisherInfo mod) {
        this.publisher = pub;
        this.metadata = meta;
        this.router = rtr;
        this.i18n = localization;
        this.DISPLAY_NAME = this.i18n.getString((PropertiesEnum)StringsProperties.TIMERPUBLISHER_DISPLAYNAME);
        this.icon = mod.getModuleIcon();
        this.modName = mod.getNameOfModule();
        this.modDisplayName = mod.getDisplayNameOfModule();
        this.initializePublisher();
    }

    public void sendTimerStartedMessage(boolean isMe) {
        this.sendRouterMsg(this.i18n.getString((PropertiesEnum)StringsProperties.TIMERPUBLISHER_START_MESSAGE), this.msgTypes.get(TIMER_STARTED), isMe);
    }

    public void sendTimerStoppedMessage(boolean isMe) {
        this.sendRouterMsg(this.i18n.getString((PropertiesEnum)StringsProperties.TIMERPUBLISHER_STOPPED_MESSAGE), this.msgTypes.get(TIMER_STOPPED), isMe);
    }

    public void sendTimerPausedMessage(boolean isMe) {
        this.sendRouterMsg(this.i18n.getString((PropertiesEnum)StringsProperties.TIMERPUBLISHER_PAUSED_MESSAGE), this.msgTypes.get(TIMER_PAUSED), isMe);
    }

    public void sendTimerResumedMessage(boolean isMe) {
        this.sendRouterMsg(this.i18n.getString((PropertiesEnum)StringsProperties.TIMERPUBLISHER_RESUMED_MESSAGE), this.msgTypes.get(TIMER_RESUMED), isMe);
    }

    public void sendTimerWentOffMessage(boolean isMe) {
        this.sendRouterMsg(this.i18n.getString((PropertiesEnum)StringsProperties.TIMERPUBLISHER_WENT_OFF_MESSAGE), this.msgTypes.get(TIMER_WENT_OFF), isMe);
    }

    private void sendRouterMsg(String message, MessageType type, String who, boolean isMe) {
        ExtraInfo info = new ExtraInfo();
        info.setHeader(who);
        this.publisher.sendMessageWithExtraInfo(message, info, type, isMe);
    }

    private void sendRouterMsg(String message, MessageType type, boolean isMe) {
        this.publisher.sendTextMessage(message, type, isMe);
    }

    private void initializePublisher() {
        this.initMessageTypes();
        this.setMetadata();
        this.publisher.setPublisherMetadata(this.metadata);
        this.router.registerPublisher(this.publisher);
    }

    private void setMetadata() {
        this.metadata.setPublisherDisplayName(this.DISPLAY_NAME);
        this.metadata.setPublisherUniqueName("TimerPublisher");
        this.metadata.setPublisherIcon(this.icon);
        this.metadata.setModuleName(this.modName);
        this.metadata.setModuleDisplayName(this.modDisplayName);
        this.metadata.setPublisherSupportedMessageTypes(new ArrayList<MessageType>(this.msgTypes.values()));
    }

    private void initMessageTypes() {
        this.msgTypes.put(TIMER_STARTED, new MessageType(TIMER_STARTED, this.i18n.getString((PropertiesEnum)StringsProperties.TIMERPUBLISHER_TYPE_TIMER_STARTED), 5));
        this.msgTypes.put(TIMER_STOPPED, new MessageType(TIMER_STOPPED, this.i18n.getString((PropertiesEnum)StringsProperties.TIMERPUBLISHER_TYPE_TIMER_STOPPED), 5));
        this.msgTypes.put(TIMER_PAUSED, new MessageType(TIMER_PAUSED, this.i18n.getString((PropertiesEnum)StringsProperties.TIMERPUBLISHER_TYPE_TIMER_PAUSED), 5));
        this.msgTypes.put(TIMER_RESUMED, new MessageType(TIMER_RESUMED, this.i18n.getString((PropertiesEnum)StringsProperties.TIMERPUBLISHER_TYPE_TIMER_RESUMED), 5));
        this.msgTypes.put(TIMER_WENT_OFF, new MessageType(TIMER_WENT_OFF, this.i18n.getString((PropertiesEnum)StringsProperties.TIMERPUBLISHER_TYPE_TIMER_WENT_OFF), 5));
    }
}

