/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.timer.module;

import com.elluminate.groupware.timer.module.TimerEvent;
import com.elluminate.groupware.timer.module.TimerListener;
import javax.swing.event.EventListenerList;

public class TimerController {
    private static TimerController instance;
    private byte currentState = (byte)70;
    private TimerEvent event = null;
    private EventListenerList listenerList = new EventListenerList();

    private TimerController() {
    }

    public static TimerController getInstance() {
        if (instance == null) {
            instance = new TimerController();
        }
        return instance;
    }

    public void changeState(byte newState) {
        if (newState == this.currentState) {
            return;
        }
        byte oldState = this.currentState;
        this.currentState = newState;
        this.fireStateChanged(oldState, this.currentState);
    }

    public byte getState() {
        return this.currentState;
    }

    public boolean timerIsShowing() {
        return this.currentState == 83 || this.currentState == 80;
    }

    public boolean isRunning() {
        return this.currentState == 83;
    }

    public boolean isPaused() {
        return this.currentState == 80;
    }

    public void addTimerListener(TimerListener listener) {
        this.listenerList.add(TimerListener.class, listener);
    }

    public void removeTimerListener(TimerListener listener) {
        this.listenerList.remove(TimerListener.class, listener);
    }

    private void fireStateChanged(byte oldState, byte newState) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TimerListener.class) continue;
            if (this.event == null) {
                this.event = new TimerEvent(this, oldState, newState);
            } else {
                this.event.setOldState(oldState);
                this.event.setNewState(newState);
            }
            ((TimerListener)listeners[i + 1]).changedState(this.event);
        }
    }
}

