/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.timer.module;

import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.groupware.Chair;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.module.JinxTerminal;
import com.elluminate.groupware.timer.TimerInfo;
import com.elluminate.groupware.timer.TimerProtocol;
import com.elluminate.groupware.timer.module.StringsProperties;
import com.elluminate.groupware.timer.module.TimerController;
import com.elluminate.groupware.timer.module.TimerDisplayLabel;
import com.elluminate.groupware.timer.module.TimerEvent;
import com.elluminate.groupware.timer.module.TimerListener;
import com.elluminate.groupware.timer.module.TimerModule;
import com.elluminate.groupware.timer.module.TimerPublisher;
import com.elluminate.gui.component.TimerFormattedTextField;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ChannelDataListener;
import com.elluminate.jinx.ChannelEvent;
import com.elluminate.jinx.ChannelListener;
import com.elluminate.jinx.ClientEvent;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.JinxProtocol;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

@Singleton
public class TimerBean
extends JPanel
implements ChannelListener,
ChannelDataListener,
PropertyChangeListener,
TimerListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private I18n i18n = I18n.create((Object)this);
    private static final int FONT_SIZE_WITH_NAME = 9;
    private static final int FONT_SIZE_NO_NAME = 15;
    private static final int FONT_STYLE = 1;
    private static final String DEFAULT_TIMER_TIME = "00:00:00";
    public static final int MESSAGE_MAX_CHARS = 30;
    public static final String TIMEOUT_NOTICE = "/timer/notice/timeout";
    private TimerDisplayLabel timerDisplayLabel;
    private volatile TimerFormattedTextField timerEditField;
    private JLabel timerNameLabel = new JLabel();
    private JButton pauseResumeButton = new JButton();
    private JButton stopButton = new JButton();
    private ImageIcon pauseIcon = this.i18n.getIcon("TimerBean.pauseIcon");
    private ImageIcon pauseRolloverIcon = this.i18n.getIcon("TimerBean.pauseRolloverIcon");
    private ImageIcon runIcon = this.i18n.getIcon("TimerBean.runIcon");
    private ImageIcon runRolloverIcon = this.i18n.getIcon("TimerBean.runRolloverIcon");
    private ImageIcon stopIcon = this.i18n.getIcon("TimerBean.stopIcon");
    private ImageIcon stopRolloverIcon = this.i18n.getIcon("TimerBean.stopRolloverIcon");
    private TimerInfo timer = null;
    private boolean allowedToView = false;
    private TimerPublisher msgPublisher;
    private boolean returnFocusFirstTime = false;
    private boolean focusModule = false;
    private boolean imStartingModule = false;
    private ClientList clients;
    private FeatureBroker broker;
    private TimerModule timerModule = null;
    private JinxTerminal terminal;
    private ClientProvider clientProvider;
    private ChairProtocol chairProtocol;
    private static final Color backgroundColor = new Color(230, 230, 204);
    private static final Color borderColor = new Color(154, 154, 154);
    private WindowAdapter windowListener = new WindowAdapter(){

        @Override
        public void windowDeactivated(WindowEvent e) {
            TimerBean.this.getRootPane().setDefaultButton(null);
        }

        @Override
        public void windowActivated(WindowEvent e) {
            if (TimerBean.this.returnFocusFirstTime && e.getOppositeWindow() != null) {
                e.getOppositeWindow().toFront();
                e.getOppositeWindow().requestFocusInWindow();
                TimerBean.this.returnFocusFirstTime = false;
            }
            if (!TimerBean.this.focusModule) {
                if (e.getOppositeWindow() != null) {
                    e.getOppositeWindow().toFront();
                }
            } else if (TimerBean.this.chairProtocol.fetchChair(TimerBean.this.clients).isMe()) {
                TimerBean.this.getRootPane().setDefaultButton(null);
                TimerBean.this.stopButton.setEnabled(false);
                TimerBean.this.getRootPane().setDefaultButton(TimerBean.this.pauseResumeButton);
                TimerBean.this.stopButton.setEnabled(true);
            }
            TimerBean.this.focusModule = true;
        }
    };

    @Inject
    public TimerBean(TimerModule timerModule, FeatureBroker theBroker, ChairProtocol chairProtocol) {
        this.chairProtocol = chairProtocol;
        this.setBorder(UIManager.getBorder("SideBar.contentBorder"));
        this.setOpaque(false);
        this.setBackground(backgroundColor);
        this.setModule(timerModule);
        this.broker = theBroker;
        this.broker.announceNotification((Object)this, TIMEOUT_NOTICE);
        try {
            this.jbInit();
            TimerController.getInstance().addTimerListener(this);
        }
        catch (Exception e) {
            LogSupport.exception((Object)this, (String)"TimerBean Constructor", (Throwable)e, (boolean)true);
        }
    }

    private void sendNotification(String path, String msg) {
        long ts = this.terminal.getClient().getSessionTime();
        this.broker.sendNotification((Object)this, path, msg, ts);
    }

    @Inject
    public void initClientProvider(ClientProvider clProvider) {
        this.clientProvider = clProvider;
    }

    @Inject
    public void initTerminal(JinxTerminal terminal) {
        this.terminal = terminal;
        this.terminal.setProtocol((JinxProtocol)new TimerProtocol());
        this.terminal.addProtocolPropertyListeners((PropertyChangeListener)this);
        this.terminal.createChannels((ChannelListener)this, (ChannelDataListener)this);
    }

    @Inject
    public void initTimerPublisher(TimerPublisher pub) {
        this.msgPublisher = pub;
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.createButtons();
        this.createTimerComponentPanel();
        this.refreshComponentGridPositions();
    }

    private void createTimerComponentPanel() throws Exception {
        this.timerDisplayLabel = new TimerDisplayLabel(9, 1);
        this.timerDisplayLabel.setFocusable(true);
        this.timerEditField = new TimerFormattedTextField(this.timerDisplayLabel.getFont(), 9, 1);
        this.timerEditField.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.TIMERBEAN_PAUSEDSPINNERTOOLTIP));
    }

    private void createButtons() {
        this.stopButton.setText(null);
        this.stopButton.setIcon(this.stopIcon);
        this.stopButton.setRolloverIcon(this.stopRolloverIcon);
        this.stopButton.setRolloverEnabled(true);
        this.pauseResumeButton.getAccessibleContext().setAccessibleName(this.i18n.getString((PropertiesEnum)StringsProperties.TIMERBEAN_AUXSTOPTIMERMENU));
        this.stopButton.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.TIMERBEAN_STOPBUTTONTOOLTIP));
        Dimension stopDimension = new Dimension(Math.max(this.stopIcon.getIconWidth(), this.stopIcon.getIconWidth()), Math.max(this.stopIcon.getIconHeight(), this.stopIcon.getIconHeight()));
        this.stopButton.setPreferredSize(stopDimension);
        this.stopButton.setMinimumSize(stopDimension);
        this.stopButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.stopButton.setContentAreaFilled(false);
        this.stopButton.addActionListener(this);
        this.pauseResumeButton.setText(null);
        this.pauseResumeButton.setIcon(this.pauseIcon);
        this.pauseResumeButton.setRolloverIcon(this.pauseRolloverIcon);
        this.pauseResumeButton.setRolloverEnabled(true);
        this.pauseResumeButton.getAccessibleContext().setAccessibleName(this.i18n.getString((PropertiesEnum)StringsProperties.TIMERBEAN_AUXPAUSETIMERMENU));
        this.pauseResumeButton.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.TIMERBEAN_PAUSEBUTTONTOOLTIP));
        int iconHeight = Math.max(Math.max(this.pauseIcon.getIconHeight(), this.pauseRolloverIcon.getIconHeight()), Math.max(this.runIcon.getIconHeight(), this.runRolloverIcon.getIconHeight()));
        int iconWidth = Math.max(Math.max(this.pauseIcon.getIconWidth(), this.pauseRolloverIcon.getIconWidth()), Math.max(this.runIcon.getIconWidth(), this.runRolloverIcon.getIconWidth()));
        Dimension pauseResumeDimension = new Dimension(iconWidth, iconHeight);
        this.pauseResumeButton.setPreferredSize(pauseResumeDimension);
        this.pauseResumeButton.setMinimumSize(pauseResumeDimension);
        this.pauseResumeButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.pauseResumeButton.setContentAreaFilled(false);
        this.pauseResumeButton.addActionListener(this);
    }

    private void refreshComponentGridPositions() {
        this.removeComponentPanel();
        int pauseButtonWidth = Math.max(Math.max(this.pauseIcon.getIconWidth(), this.pauseRolloverIcon.getIconWidth()), Math.max(this.runIcon.getIconWidth(), this.runRolloverIcon.getIconWidth()));
        int stopButtonWidth = Math.max(this.stopIcon.getIconWidth(), this.stopRolloverIcon.getIconWidth());
        GridBagConstraints timerNameComponentGridBagConstraints = new GridBagConstraints();
        timerNameComponentGridBagConstraints.anchor = 11;
        timerNameComponentGridBagConstraints.insets = new Insets(0, 50, 0, 50);
        timerNameComponentGridBagConstraints.gridx = 0;
        timerNameComponentGridBagConstraints.gridy = 0;
        if (this.timerNameLabel.getText() != null && this.timerNameLabel.getText().trim().length() > 0) {
            this.add((Component)this.timerNameLabel, timerNameComponentGridBagConstraints);
        }
        GridBagConstraints stopButtonComponentGridBagConstraints = new GridBagConstraints();
        stopButtonComponentGridBagConstraints.anchor = 12;
        GridBagConstraints pauseButtonComponentGridBagConstraints = new GridBagConstraints();
        pauseButtonComponentGridBagConstraints.anchor = 12;
        GridBagConstraints secondRowConstraints = new GridBagConstraints();
        if (this.timerNameLabel.getText() != null && this.timerNameLabel.getText().trim().length() > 0) {
            secondRowConstraints.anchor = 15;
            secondRowConstraints.gridx = 0;
            secondRowConstraints.gridy = 1;
            secondRowConstraints.insets = new Insets(0, 50, 0, 50);
        } else {
            secondRowConstraints.anchor = 10;
            secondRowConstraints.insets = new Insets(5, 50, 5, 50);
        }
        if (TimerController.getInstance().isPaused() && this.chairProtocol.fetchChair(this.clients).isMe()) {
            this.add((Component)this.timerEditField, secondRowConstraints);
        } else {
            this.add((Component)this.timerDisplayLabel, secondRowConstraints);
        }
        if (this.chairProtocol.fetchChair(this.clients).isMe()) {
            this.add((Component)this.pauseResumeButton, pauseButtonComponentGridBagConstraints);
            this.add((Component)this.stopButton, stopButtonComponentGridBagConstraints);
        }
        this.adjustComponentSize();
    }

    private void removeComponentPanel() {
        this.removeAll();
    }

    private void adjustComponentSize() {
        if (this.timerNameLabel.getText() != null && this.timerNameLabel.getText().trim().length() > 0) {
            this.timerDisplayLabel.setFontSize(9);
        } else {
            this.timerDisplayLabel.setFontSize(15);
        }
    }

    public void setClients() {
        this.clients = this.clientProvider.get().getClientList();
        this.clients.addPropertyChangeListener("chair", (PropertyChangeListener)this);
    }

    private void setModule(TimerModule timerModule) {
        this.timerModule = timerModule;
    }

    public void resumeTimer(TimerInfo timerInfo) {
        if (TimerProtocol.DEBUG.show()) {
            System.out.println("Timer: resumeTimer");
        }
        this.sendChannelData((byte)82, timerInfo);
    }

    public void startTimer(TimerInfo timerInfo) {
        if (TimerProtocol.DEBUG.show()) {
            System.out.println("Timer: startTimer");
        }
        this.imStartingModule = true;
        this.sendChannelData((byte)66, timerInfo);
    }

    public void stopTimer() {
        if (TimerProtocol.DEBUG.show()) {
            System.out.println("Timer: stopTimer");
        }
        this.removeTimerDisplay();
        this.sendChannelData((byte)69, null);
        this.timer = null;
    }

    public void pauseTimer(TimerInfo timerInfo) {
        if (TimerProtocol.DEBUG.show()) {
            System.out.println("Timer: pauseTimer");
        }
        this.sendChannelData((byte)80, timerInfo);
    }

    public void setReturnFocusFirstTime(boolean flag) {
        this.returnFocusFirstTime = flag;
    }

    private void sendChannelData(byte command, TimerInfo timerInfo) {
        if (this.terminal.isPlayback()) {
            return;
        }
        ChannelDataEvent dataEvent = ChannelDataEvent.getInstance((Object)this, (short)-1, (byte)command);
        try {
            DataOutputStream str = dataEvent.write();
            if (timerInfo != null) {
                TimerProtocol.encode((byte)command, (DataOutputStream)str, (TimerInfo)timerInfo);
            }
            str.close();
            this.terminal.fireChannelData(dataEvent);
        }
        catch (IOException ex) {
            dataEvent.dispose();
            LogSupport.exception((Object)this, (String)"sendChannelData", (Throwable)ex, (boolean)true);
        }
    }

    private void showTimerDisplay() {
        if (this.timer == null) {
            return;
        }
        if (!this.allowedToView) {
            return;
        }
        this.refreshComponentGridPositions();
        this.adjustComponentSize();
        this.focusModule = this.imStartingModule;
        this.addWindowListener();
        this.timerModule.publishTimerFeature(this.timerModule.isTimerVisible());
        this.repaint();
        this.imStartingModule = false;
        this.timerModule.updateFeatures();
    }

    void removeTimerDisplay() {
        this.timerModule.publishTimerFeature(false);
        this.timerModule.updateFeatures();
    }

    private void updatePauseResumeDisplayComponent() {
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                TimerBean.this.refreshComponentGridPositions();
                TimerBean.this.revalidate();
                TimerBean.this.repaint();
            }
        });
    }

    private void updatePauseResume() {
        if (TimerController.getInstance().isPaused()) {
            this.pauseResumeButton.setIcon(this.runIcon);
            this.pauseResumeButton.setRolloverIcon(this.runRolloverIcon);
            this.pauseResumeButton.getAccessibleContext().setAccessibleName(this.i18n.getString((PropertiesEnum)StringsProperties.TIMERBEAN_AUXRESUMETIMERMENU));
            this.pauseResumeButton.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.TIMERBEAN_RESUMEBUTTONTOOLTIP));
        } else {
            this.pauseResumeButton.setIcon(this.pauseIcon);
            this.pauseResumeButton.setRolloverIcon(this.pauseRolloverIcon);
            this.pauseResumeButton.getAccessibleContext().setAccessibleName(this.i18n.getString((PropertiesEnum)StringsProperties.TIMERBEAN_AUXPAUSETIMERMENU));
            this.pauseResumeButton.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.TIMERBEAN_PAUSEBUTTONTOOLTIP));
        }
        this.updatePauseResumeDisplayComponent();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.pauseResumeButton && this.timer != null) {
            if (TimerController.getInstance().isPaused()) {
                if (this.chairProtocol.fetchChair(this.clients).isMe()) {
                    long seconds = 0L;
                    try {
                        seconds = this.timerEditField.getTotalSeconds();
                    }
                    catch (Exception exception) {
                        LogSupport.exception((Object)this, (String)"onChannelData", (Throwable)exception, (boolean)true);
                    }
                    long milliSeconds = seconds * 1000L;
                    this.timer.setTime(milliSeconds);
                }
                this.resumeTimer(this.timer);
            } else if (TimerController.getInstance().isRunning()) {
                long timeLeft = this.timerDisplayLabel.getTimeLeft();
                this.timer.setTime(timeLeft);
                this.timerEditField.setValue(timeLeft / 1000L);
                this.pauseTimer(this.timer);
                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TimerBean.this.timerEditField.requestFocus();
                        TimerBean.this.timerEditField.validate();
                        TimerBean.this.timerEditField.repaint();
                    }
                });
            }
        } else if (e.getSource() == this.stopButton) {
            this.stopTimer();
        }
    }

    public void onRemoveClient(ClientEvent event) {
        if (event.isMe()) {
            this.timer = null;
            this.allowedToView = false;
            this.timerDisplayLabel.stop();
            this.removeTimerDisplay();
        }
    }

    public void onChannelData(ChannelDataEvent event) {
        if (this.terminal.isPlayback()) {
            return;
        }
        byte command = event.getCommand();
        DataInputStream in = event.read();
        TimerInfo updatedTimerInfo = null;
        try {
            switch (command) {
                case 66: {
                    if (TimerProtocol.DEBUG.show()) {
                        System.out.println("Timer: onChannelData - start");
                    }
                    this.timerModule.abortTimerExpiredNotification();
                    this.timer = TimerProtocol.decode((DataInputStream)in);
                    this.allowedToView = this.timer.getTimerVisibility() == 2 || this.timer.getTimerVisibility() == 1 && this.chairProtocol.fetchChair(this.clients).isMe();
                    this.timerDisplayLabel.start(this.timer.getTimerType(), this.timer.getTime());
                    this.timerEditField.setValue(this.timer.getTime() / 1000L);
                    this.timerNameLabel.setText(this.timer.getConfigurableString());
                    this.showTimerDisplay();
                    this.stopButton.getModel().setRollover(false);
                    if (!this.allowedToView) break;
                    this.msgPublisher.sendTimerStartedMessage(false);
                    break;
                }
                case 74: {
                    if (TimerProtocol.DEBUG.show()) {
                        System.out.println("Timer: onChannelData - joinPause");
                    }
                    this.timer = TimerProtocol.decode((DataInputStream)in);
                    this.allowedToView = this.timer.getTimerVisibility() == 2 || this.timer.getTimerVisibility() == 1 && this.chairProtocol.fetchChair(this.clients).isMe();
                    this.timerDisplayLabel.setTimeLeft(this.timer.getTime());
                    this.timerEditField.setValue(this.timer.getTime() / 1000L);
                    this.timerNameLabel.setText(this.timer.getConfigurableString());
                    this.showTimerDisplay();
                    this.timerDisplayLabel.pause();
                    this.updatePauseResume();
                    if (!this.allowedToView) break;
                    this.msgPublisher.sendTimerPausedMessage(false);
                    break;
                }
                case 82: {
                    TimerInfo t2;
                    if (TimerProtocol.DEBUG.show()) {
                        System.out.println("Timer: onChannelData - resume");
                    }
                    if ((t2 = this.timer) == null) break;
                    updatedTimerInfo = TimerProtocol.decode((DataInputStream)in);
                    t2.setTime(updatedTimerInfo.getTime());
                    this.timerDisplayLabel.resume(t2.getTime());
                    this.updatePauseResume();
                    if (!this.allowedToView) break;
                    this.msgPublisher.sendTimerResumedMessage(false);
                    break;
                }
                case 69: {
                    if (TimerProtocol.DEBUG.show()) {
                        System.out.println("Timer: onChannelData - stop");
                    }
                    this.removeTimerDisplay();
                    this.timerDisplayLabel.stop();
                    if (!this.allowedToView) break;
                    this.msgPublisher.sendTimerStoppedMessage(false);
                    break;
                }
                case 80: {
                    TimerInfo t3;
                    if (TimerProtocol.DEBUG.show()) {
                        System.out.println("Timer: onChannelData - pause");
                    }
                    if ((t3 = this.timer) == null) break;
                    updatedTimerInfo = TimerProtocol.decode((DataInputStream)in);
                    t3.setTime(updatedTimerInfo.getTime());
                    this.timerDisplayLabel.setTimeLeft(t3.getTime());
                    this.timerEditField.setValue(t3.getTime() / 1000L);
                    this.timerDisplayLabel.pause();
                    this.updatePauseResume();
                    if (!this.allowedToView) break;
                    this.msgPublisher.sendTimerPausedMessage(false);
                }
            }
        }
        catch (IOException e) {
            LogSupport.exception((Object)this, (String)"onChannelData", (Throwable)e, (boolean)true);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals("chair")) {
            Chair was = new Chair(this.clients.getConnection(), e.getOldValue());
            Chair now = new Chair(this.clients.getConnection(), e.getNewValue());
            if (was.isMe() && now.isMe()) {
                return;
            }
            boolean iAmChair = this.chairProtocol.fetchChair(this.clients).isMe();
            this.allowedToView = this.timer != null && (this.timer.getTimerVisibility() == 2 || this.timer.getTimerVisibility() == 1 && iAmChair);
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    TimerBean.this.refreshComponentGridPositions();
                }
            });
            if (!this.allowedToView || this.timer == null || !TimerController.getInstance().isRunning() && !TimerController.getInstance().isPaused()) {
                this.removeTimerDisplay();
            } else {
                this.showTimerDisplay();
            }
        }
    }

    @Override
    public void changedState(TimerEvent event) {
        if (this.terminal.isPlayback()) {
            return;
        }
        if (event.getOldState() == event.getNewState()) {
            return;
        }
        switch (event.getNewState()) {
            case 70: {
                this.removeTimerDisplay();
                break;
            }
            case 84: {
                this.removeTimerDisplay();
                if (this.timer == null) {
                    return;
                }
                if (this.allowedToView && this.timer.isAudibleAlert()) {
                    this.sendNotification(TIMEOUT_NOTICE, "Timer expired");
                }
                if (this.allowedToView && this.timer.isVisibleAlert()) {
                    String notification = null;
                    notification = this.timer.getConfigurableString() == null || this.timer.getConfigurableString().trim().equals("") ? this.i18n.getString((PropertiesEnum)StringsProperties.TIMERBEAN_TIMEOUTMSG) : this.i18n.getString((PropertiesEnum)StringsProperties.TIMERBEAN_TIMEOUTMSGWITHINSERT, new Object[]{this.timer.getConfigurableString()});
                    this.timerModule.postTimerExpiredNotification(notification);
                }
                if (!this.allowedToView) break;
                this.msgPublisher.sendTimerWentOffMessage(false);
                break;
            }
            case 83: {
                this.updatePauseResume();
                this.setDefaultPauseResume(event.getOldState(), (short)80);
                break;
            }
            case 80: {
                this.timerEditField.setValue(this.timerDisplayLabel.getTimeLeft() / 1000L);
                this.timerDisplayLabel.correctMillisecondsToFullSecond();
                this.updatePauseResume();
                this.setDefaultPauseResume(event.getOldState(), (short)83);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDefaultPauseResume(short oldState, short waitState) {
        JButton jButton = this.pauseResumeButton;
        synchronized (jButton) {
            try {
                if (this.chairProtocol.fetchChair(this.clients).isMe()) {
                    this.pauseResumeButton.setEnabled(true);
                    this.stopButton.setEnabled(true);
                }
            }
            catch (Exception ee) {
                // empty catch block
            }
        }
    }

    private void addWindowListener() {
        for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof JDialog)) continue;
            ((JDialog)parent).removeWindowListener(this.windowListener);
            ((JDialog)parent).addWindowListener(this.windowListener);
            break;
        }
    }

    boolean isTimerRunning() {
        return TimerController.getInstance().isRunning();
    }

    boolean isTimerPaused() {
        return TimerController.getInstance().isPaused();
    }

    long getCurrentDisplayTime() {
        return this.timerDisplayLabel.getTimeLeft();
    }

    TimerInfo getTimerInfo() {
        return this.timer;
    }

    public JinxTerminal getTerminal() {
        return this.terminal;
    }

    public void channelStateChanged(ChannelEvent event) {
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(backgroundColor);
        g.fillRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
    }
}

