/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.telephony;

import com.elluminate.groupware.telephony.StringsProperties;
import com.elluminate.groupware.telephony.TelephonyProtocol;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.DefaultProtocolResponder;
import com.elluminate.jinx.JinxProtocol;
import com.elluminate.jinx.VCRFile;
import com.elluminate.util.I18n;
import com.elluminate.util.I18nMessage;
import com.elluminate.util.PropertiesEnum;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;

public class TelephonyResponder
extends DefaultProtocolResponder
implements PropertyChangeListener {
    private I18n i18n = I18n.create((Object)this);
    private boolean listening = false;
    private boolean inCall = false;
    private I18nMessage mod = this.i18n.getMessage((PropertiesEnum)StringsProperties.TELEPHONYRESPONDER_INDEXICON);
    private I18nMessage typeJoin = this.i18n.getMessage((PropertiesEnum)StringsProperties.TELEPHONYRESPONDER_INDEXTYPEJOIN);
    private I18nMessage typeLeave = this.i18n.getMessage((PropertiesEnum)StringsProperties.TELEPHONYRESPONDER_INDEXTYPELEAVE);

    TelephonyResponder() {
        super((JinxProtocol)new TelephonyProtocol());
    }

    public void join(Connection connection, String channel) {
        super.join(connection, channel);
        if (!this.listening) {
            ClientList clients = this.getClientList();
            clients.addClientPropertyChangeListener("Telephony.audioMode", (PropertyChangeListener)this);
            boolean haveBridge = false;
            Iterator i = clients.visibleIterator();
            while (!haveBridge && i.hasNext()) {
                ClientInfo ci = (ClientInfo)i.next();
                int mode = ci.getProperty("Telephony.audioMode", 1);
                haveBridge = mode == 3;
            }
            if (this.inCall != haveBridge) {
                this.noteCall(haveBridge);
            }
            this.listening = true;
        }
    }

    public void leave(String channel) {
        if (this.listening) {
            ClientList clients = this.getClientList();
            clients.removeClientPropertyChangeListener("Telephony.audioMode", (PropertyChangeListener)this);
            this.listening = false;
        }
        super.leave(channel);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        boolean to;
        boolean from = this.getValue(e.getOldValue()) == 3;
        boolean bl = to = this.getValue(e.getNewValue()) == 3;
        if (from || to) {
            this.noteCall(to);
        }
    }

    public int getValue(Object o) {
        Integer i = (Integer)o;
        if (i == null) {
            return 1;
        }
        return i;
    }

    private void noteCall(boolean connected) {
        VCRFile.IndexEntry indexEntry = connected ? new VCRFile.IndexEntry(this.mod, this.typeJoin, null) : new VCRFile.IndexEntry(this.mod, this.typeLeave, null);
        this.fireNotableEventListeners("recording.index", indexEntry);
        this.inCall = connected;
    }
}

