/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.telephony;

import com.elluminate.groupware.telephony.TelephonyResponder;
import com.elluminate.jinx.JinxProtocolAdapter;
import com.elluminate.jinx.ProtocolResponder;
import java.io.DataInputStream;

public class TelephonyProtocol
extends JinxProtocolAdapter {
    public static final String TELEPHONY_PROPERTY_PREFIX = "Telephony.";
    public static final String CONNECT_STATE_PROPERTY = "Telephony.connectionState";
    public static final String ACCRUED_TIME_PROPERTY = "Telephony.accruedTime";
    public static final String TIME_LIMIT_PROPERTY = "Telephony.timeLimit";
    public static final String TIME_LIMIT_GRACE_PROPERTY = "Telephony.timeLimitGrace";
    public static final String PARTICIPANT_TELEPHONE_PROPERTY = "Telephony.participantTelephone";
    public static final String PARTICIPANT_PIN_PROPERTY = "Telephony.participantPIN";
    public static final String MODERATOR_TELEPHONE_PROPERTY = "Telephony.moderatorTelephone";
    public static final String MODERATOR_PIN_PROPERTY = "Telephony.moderatorPIN";
    public static final String SESSION_TELEPHONE_PROPERTY = "Telephony.sessionTelephone";
    public static final String SESSION_SIP_PROPERTY = "Telephony.sessionSIP";
    public static final String SESSION_PIN_PROPERTY = "Telephony.sessionPIN";
    public static final String AUDIO_MODE_PROPERTY = "Telephony.audioMode";
    public static final String TELPHONE_NUMBER_VALIDATION = "Telephony.numberValidation";
    public static final String TELEPHONY_MODE_PROPERTY = "Telephony.mode";
    public static final int CONNECT_STATE_DISCONNECTED = 1;
    public static final int CONNECT_STATE_CONNECTING = 2;
    public static final int CONNECT_STATE_CONNECTED = 3;
    public static final int CONNECT_STATE_DISCONNECTING = 4;
    public static final int AUDIO_MODE_VOIP = 1;
    public static final int AUDIO_MODE_TELEPHONE = 2;
    public static final int AUDIO_MODE_BRIDGE = 3;
    public static final int TIME_LIMIT_NONE = -1;
    public static final int TIMELIMIT_WARN_DEFAULT = 5;
    public static final int NUMBER_VALIDATION_NONE = -1;
    public static final int NUMBER_VALIDATION_NORTH_AMERICAN_DIALING = 1;
    public static final int TELEPHONY_MODE_DISABLED = 0;
    public static final int TELEPHONY_MODE_LEGACY = 1;
    public static final int TELEPHONY_MODE_AUTOMATIC = 2;
    public static final String NAME = "telephony";
    public static final String CHANNEL = "telephony";
    public static final byte PRIORITY = 2;
    public static final byte CONNECT_CMD = 1;
    public static final byte CONNECT_ACK_CMD = 2;
    public static final byte DISCONNECT_CMD = 3;
    public static final byte DISCONNECT_ACK_CMD = 4;
    public static final byte REMOTE_DISCONNECT_CMD = 5;
    public static final byte RECONNECT_CMD = 6;
    public static final byte CANCEL_CONNECT_CMD = 7;
    public static final byte CONNECTION_STATUS_CMD = 8;
    public static final byte CONNECTION_SUCCEEDED_CMD = 9;
    public static final byte CONNECTION_FAILED_CMD = 10;
    public static final byte ACCEPT_CONNECTION_CMD = 11;
    public static final byte REJECT_CONNECTION_CMD = 12;
    public static final byte CANCEL_QUERY_CMD = 13;
    public static final byte ANNOUNCE_CMD = 14;
    public static final byte PLACE_CALL_CMD = 33;
    public static final byte CALL_ACK_CMD = 34;
    public static final byte DISCONNECT_CALL_CMD = 35;
    public static final byte OUT_VOLUME_UP_CMD = 36;
    public static final byte OUT_VOLUME_DOWN_CMD = 37;
    public static final int CONNECT_STATUS_INITIALIZING = 1;
    public static final int CONNECT_STATUS_CALLING = 2;
    public static final int CONNECT_STATUS_AUTHENTICATING = 3;
    public static final int CONNECT_STATUS_CONNECTED = 4;
    public static final int CONNECT_STATUS_FAILED = 5;
    public static final int CALL_TYPE_PSTN = 1;
    public static final int CALL_TYPE_PSTN_AUTH = 2;
    public static final int CALL_TYPE_PSTN_GATE = 3;
    public static final int CALL_TYPE_PSTN_GATE_AUTH = 4;
    public static final int CALL_TYPE_SIP = 5;
    public static final int CALL_TYPE_SIP_AUTH = 6;
    public static final int CALL_ACK_OK = 1;
    public static final int CALL_ACK_BAD_REQUEST = 2;
    public static final int CALL_ACK_TOO_MANY_CALLS = 3;
    public static final int CALL_ACK_OTHER = -1;
    private TelephonyResponder responder = null;

    public static String getCommandName(byte cmd) {
        switch (cmd) {
            case 1: {
                return "Connect";
            }
            case 2: {
                return "ConnectAck";
            }
            case 3: {
                return "Disconnect";
            }
            case 4: {
                return "DisconnectAck";
            }
            case 5: {
                return "RemoteDisconnect";
            }
            case 6: {
                return "Reconnect";
            }
            case 7: {
                return "CancelConnect";
            }
            case 11: {
                return "AcceptConnection";
            }
            case 12: {
                return "RejectConnection";
            }
            case 13: {
                return "CancelQuery";
            }
            case 33: {
                return "PlaceCall";
            }
            case 34: {
                return "CallAck";
            }
            case 35: {
                return "DisconnectCall";
            }
            case 8: {
                return "ConnectionStatus";
            }
            case 9: {
                return "ConnectionSucceeded";
            }
            case 10: {
                return "ConnectionFailed";
            }
            case 14: {
                return "Announce";
            }
            case 36: {
                return "OutVolumeUp";
            }
            case 37: {
                return "OutVolumeDown";
            }
        }
        return "Unknown Command 0x" + Integer.toHexString(cmd & 0xFF);
    }

    public TelephonyProtocol() {
        this.defineProperty(TELEPHONY_MODE_PROPERTY, (byte)1, new Integer(0));
        this.defineProperty(CONNECT_STATE_PROPERTY, (byte)1, new Integer(1));
        this.defineProperty(ACCRUED_TIME_PROPERTY, (byte)1, new Integer(0));
        this.defineProperty(TIME_LIMIT_PROPERTY, (byte)1, new Integer(-1));
        this.defineProperty(TIME_LIMIT_GRACE_PROPERTY, (byte)1, new Integer(5));
        this.defineProperty(PARTICIPANT_TELEPHONE_PROPERTY, (byte)1, "");
        this.defineProperty(PARTICIPANT_PIN_PROPERTY, (byte)1, "");
        this.defineProperty(MODERATOR_TELEPHONE_PROPERTY, (byte)1, "");
        this.defineProperty(MODERATOR_PIN_PROPERTY, (byte)1, "");
        this.defineProperty(SESSION_TELEPHONE_PROPERTY, (byte)1, "");
        this.defineProperty(SESSION_SIP_PROPERTY, (byte)1, "");
        this.defineProperty(SESSION_PIN_PROPERTY, (byte)1, "");
        this.defineProperty(AUDIO_MODE_PROPERTY, (byte)0, new Integer(1));
        this.defineProperty(TELPHONE_NUMBER_VALIDATION, (byte)1, new Integer(1));
        this.defineChannel("telephony", (byte)2);
    }

    public String commandToString(byte cmd) {
        return TelephonyProtocol.getCommandName(cmd);
    }

    public String messageToString(byte cmd, DataInputStream strm) {
        StringBuffer result = new StringBuffer();
        result.append(TelephonyProtocol.getCommandName(cmd));
        switch (cmd) {
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 35: 
            case 36: 
            case 37: {
                break;
            }
            default: {
                String nAvailableBytes;
                try {
                    nAvailableBytes = Integer.toString(strm.available());
                }
                catch (Throwable t) {
                    nAvailableBytes = "???";
                }
                result.append(", " + nAvailableBytes + " bytes of data.");
            }
        }
        return result.toString();
    }

    public ProtocolResponder getResponder() {
        if (this.responder == null) {
            this.responder = new TelephonyResponder();
        }
        return this.responder;
    }

    public static String getConnectedStateName(int status) {
        switch (status) {
            case 1: {
                return "Disconnected";
            }
            case 2: {
                return "Connecting";
            }
            case 3: {
                return "Connected";
            }
            case 4: {
                return "Disconnecting";
            }
        }
        return "Unknown state " + status;
    }

    public static String getConnectionStatusName(int status) {
        switch (status) {
            case 1: {
                return "Initializing";
            }
            case 2: {
                return "Calling";
            }
            case 3: {
                return "Authenticating";
            }
            case 4: {
                return "Connected";
            }
            case 5: {
                return "Failed";
            }
        }
        return "Unknown status " + status;
    }
}

