/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.wsfix;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;

public class WSFix
implements Runnable {
    static ArrayList<Object> signerInfo = new ArrayList();
    private boolean verbose = false;
    private Thread cacheReader = null;

    public WSFix(boolean verbose) {
        this.verbose = verbose;
        this.cacheReader = new Thread((Runnable)this, "WebStart cache fix");
        this.cacheReader.start();
    }

    @Override
    public void run() {
        Object[] jarDescs;
        Object resourcesDesc;
        Object launchDesc;
        Object jnlpClassLoader;
        Method cachedJarFile_getManifest;
        Method cachedJarFile_getCodeSourceCache;
        Method cachedJarFile_getSigners;
        Method cachedJarFile_getSignerMap;
        Method jarDesc_getLocation;
        Method resourcesDesc_getEagerOrAllJarDescs;
        Method launchDesc_getResources;
        Method jnlpClassLoader_getJarFile;
        Method jnlpClassLoader_getLaunchDesc;
        Method jnlpClassLoader_getInstance;
        block9: {
            Class<?> jnlpClassLoaderCls = null;
            Class<?> launchDescCls = null;
            Class<?> resourcesDescCls = null;
            Class<?> jarDescCls = null;
            Class<?> cachedJarFileCls = null;
            jnlpClassLoader_getInstance = null;
            jnlpClassLoader_getLaunchDesc = null;
            jnlpClassLoader_getJarFile = null;
            launchDesc_getResources = null;
            resourcesDesc_getEagerOrAllJarDescs = null;
            jarDesc_getLocation = null;
            cachedJarFile_getSignerMap = null;
            cachedJarFile_getSigners = null;
            cachedJarFile_getCodeSourceCache = null;
            cachedJarFile_getManifest = null;
            jnlpClassLoader = null;
            launchDesc = null;
            resourcesDesc = null;
            jarDescs = null;
            try {
                jnlpClassLoaderCls = Class.forName("com.sun.jnlp.JNLPClassLoader");
                launchDescCls = Class.forName("com.sun.javaws.jnl.LaunchDesc");
                resourcesDescCls = Class.forName("com.sun.javaws.jnl.ResourcesDesc");
                jarDescCls = Class.forName("com.sun.javaws.jnl.JARDesc");
                cachedJarFileCls = Class.forName("com.sun.deploy.cache.CachedJarFile");
                jnlpClassLoader_getInstance = jnlpClassLoaderCls.getMethod("getInstance", new Class[0]);
                jnlpClassLoader_getLaunchDesc = jnlpClassLoaderCls.getMethod("getLaunchDesc", new Class[0]);
                jnlpClassLoader_getJarFile = jnlpClassLoaderCls.getMethod("getJarFile", URL.class);
                launchDesc_getResources = launchDescCls.getMethod("getResources", new Class[0]);
                resourcesDesc_getEagerOrAllJarDescs = resourcesDescCls.getMethod("getEagerOrAllJarDescs", Boolean.TYPE);
                jarDesc_getLocation = jarDescCls.getMethod("getLocation", new Class[0]);
                cachedJarFile_getSignerMap = cachedJarFileCls.getDeclaredMethod("getSignerMap", new Class[0]);
                cachedJarFile_getSignerMap.setAccessible(true);
                cachedJarFile_getSigners = cachedJarFileCls.getDeclaredMethod("getSigners", new Class[0]);
                cachedJarFile_getSigners.setAccessible(true);
                cachedJarFile_getManifest = cachedJarFileCls.getMethod("getManifest", new Class[0]);
            }
            catch (Throwable t) {
                if (this.verbose) {
                    t.printStackTrace();
                }
                return;
            }
            try {
                cachedJarFile_getCodeSourceCache = cachedJarFileCls.getDeclaredMethod("getCodeSourceCache", new Class[0]);
                cachedJarFile_getCodeSourceCache.setAccessible(true);
            }
            catch (Throwable t) {
                if (!this.verbose) break block9;
                System.err.println("CachedJarFile.getCodeSourceCache not found in this JRE version.");
            }
        }
        try {
            jnlpClassLoader = jnlpClassLoader_getInstance.invoke(null, new Object[0]);
            launchDesc = jnlpClassLoader_getLaunchDesc.invoke(jnlpClassLoader, new Object[0]);
            resourcesDesc = launchDesc_getResources.invoke(launchDesc, new Object[0]);
            for (Object jarDesc : jarDescs = (Object[])resourcesDesc_getEagerOrAllJarDescs.invoke(resourcesDesc, true)) {
                URL location = (URL)jarDesc_getLocation.invoke(jarDesc, new Object[0]);
                Object cachedJarFile = jnlpClassLoader_getJarFile.invoke(jnlpClassLoader, location);
                StringBuilder msg = this.verbose ? new StringBuilder(location.toString()) : null;
                this.getSignerInfo(cachedJarFile_getSigners, cachedJarFile, msg);
                this.getSignerInfo(cachedJarFile_getSignerMap, cachedJarFile, msg);
                this.getSignerInfo(cachedJarFile_getCodeSourceCache, cachedJarFile, msg);
                this.getSignerInfo(cachedJarFile_getManifest, cachedJarFile, msg);
                if (msg == null) continue;
                System.err.println(msg.toString());
            }
        }
        catch (Throwable t) {
            if (this.verbose) {
                t.printStackTrace();
            }
            return;
        }
    }

    private void getSignerInfo(Method method, Object object, StringBuilder msg) {
        block5: {
            if (method == null) {
                return;
            }
            try {
                Object o = method.invoke(object, new Object[0]);
                if (o != null) {
                    if (msg != null) {
                        msg.append(' ');
                        msg.append(method.getName());
                    }
                    signerInfo.add(o);
                }
            }
            catch (Throwable t) {
                if (msg == null) break block5;
                msg.append(' ');
                msg.append(method.getName());
                msg.append('[');
                msg.append(t);
                msg.append(']');
            }
        }
    }

    public ArrayList<Object> getSignerInfo() {
        return signerInfo;
    }
}

