/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.web.module;

import com.elluminate.browser.BrowserPane;
import com.elluminate.browser.NavigationEvent;
import com.elluminate.browser.NavigationListener;
import com.elluminate.browser.UIListener;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.ActionFeatureEvent;
import com.elluminate.framework.feature.ActionFeatureListener;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.ComponentFeature;
import com.elluminate.framework.feature.ComponentProvider;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.feature.StringFeature;
import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.moduleloading.Module;
import com.elluminate.framework.session.CRPermissionDelegate;
import com.elluminate.framework.session.CRPermissionFactory;
import com.elluminate.framework.session.CRPermissionScope;
import com.elluminate.framework.session.CRSession;
import com.elluminate.groupware.LabelProps;
import com.elluminate.groupware.imps.PublishUrlAPI;
import com.elluminate.groupware.imps.module.PresentationModeAPI;
import com.elluminate.groupware.module.JinxTerminal;
import com.elluminate.groupware.web.BrowserState;
import com.elluminate.groupware.web.BrowserStateListener;
import com.elluminate.groupware.web.WebDebug;
import com.elluminate.groupware.web.WebProtocol;
import com.elluminate.groupware.web.module.PopupSuppressionPrefsPanel;
import com.elluminate.groupware.web.module.StringsProperties;
import com.elluminate.groupware.web.module.WebPublisher;
import com.elluminate.groupware.web.module.WebTourPermissionDelegate;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.ModeSwitchMessagePane;
import com.elluminate.gui.swing.DialogParentProvider;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ChannelDataListener;
import com.elluminate.jinx.ChannelEvent;
import com.elluminate.jinx.ChannelListener;
import com.elluminate.jinx.Client;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.JinxProtocol;
import com.elluminate.jinx.PropertyAccessAPI;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.util.I18n;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.browser.BrowserUtil;
import com.elluminate.util.log.LogSupport;
import com.elluminate.util.log.Logger;
import com.elluminate.util.net.URLString;
import com.elluminate.util.net.VClassURI;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import javax.swing.JPanel;

@Singleton
public class WebBean
extends JPanel
implements ChannelListener,
ChannelDataListener,
NavigationListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    public static final byte INIT_FAILED = -1;
    public static final byte INIT_UNKNOWN = 0;
    public static final byte INIT_OK = 1;
    public static final String TITLE_PROP = "title";
    public static final String STATE_PROP = "state";
    public static final int STATE_CLOSED = 0;
    public static final int STATE_GET_URL = 1;
    public static final int STATE_OPEN = 2;
    public static final int STATE_EXTERN = 3;
    public static final int STATE_BACKFWD = 4;
    private static String SEPARATOR = "://";
    private static String[] PROTOCOLS = new String[]{"http", "https"};
    static String POPUP_SUPPRESS_PREF = ".popupSuppression";
    private I18n i18n = I18n.create((Object)this);
    private Imps imps;
    private Logger logger;
    private Provider<PopupSuppressionPrefsPanel> popupPrefsPanelProvider;
    private FeatureBroker broker;
    private ComponentFeature browserPaneFeature;
    private ActionFeature browserBackFeature;
    private ActionFeature browserFwdFeature;
    private StringFeature browserAddressFeature;
    private ActionFeature browserPublishToChatFeature;
    private BooleanFeature browserTourGuideFeature;
    private ActionFeature browserGotoURLFeature;
    private ComponentFeature popupPrefsFeature;
    private DialogParentProvider parentProv;
    private JinxTerminal terminal = null;
    private Client client = null;
    private ClientList clients = new ClientList(null);
    private boolean webAccess = false;
    private BrowserPane pane = null;
    private JPanel featurePane = null;
    private Component webPane = null;
    private JPanel messagePane = null;
    private ModeSwitchMessagePane waitMsgPane = null;
    private int state = 0;
    private String title = "";
    private volatile boolean nonlinear = false;
    private volatile boolean amTourGuide = false;
    private volatile boolean inSync = true;
    private volatile boolean selfInitiated = false;
    private boolean neverEnteredWeb = true;
    private BrowserState tourNow = new BrowserState();
    private BrowserState tourReq = new BrowserState();
    private String pushNow = null;
    private String pushReq = null;
    private PublishUrlAPI publishAPI = null;
    private WebPublisher msgPublisher;
    private ClientProvider clientProvider;
    private CRSession session;
    private WebTourPermissionDelegate webTourPermissionDelegate;
    private boolean browserAddressFeatureInterlock = false;
    private Object lock = new Object();

    @Inject
    public WebBean(Logger aLogger) {
        this.logger = aLogger;
        try {
            this.pane = new BrowserPane();
            this.pane.addNavigationListener((NavigationListener)this);
            this.pane.addUIListener(new UIListener(){

                public void setPageTitle(String t) {
                    WebBean.this.setTitle(t);
                    if (WebBean.this.webAccess) {
                        WebBean.this.browserPublishToChatFeature.setEnabled(true);
                    }
                }

                public void setCurrentURL(String u) {
                    if (WebDebug.TRACE.show()) {
                        WebBean.this.logger.message((Object)this, "setCurrentURL", "change url from '" + (String)WebBean.this.browserAddressFeature.getValue() + "' to '" + u + "'" + " state=" + WebBean.this.getState());
                    }
                    if (WebBean.this.getState() == 0) {
                        WebBean.this.showWebPane(false);
                        return;
                    }
                    if (u.startsWith("about:")) {
                        if (WebDebug.TRACE.show()) {
                            WebBean.this.logger.message((Object)this, "setCurrentURL", "Ignored '" + u + "'");
                        }
                    } else {
                        WebBean.this.browserAddressFeatureInterlock = true;
                        WebBean.this.browserAddressFeature.setValue((Object)u);
                        WebBean.this.browserAddressFeatureInterlock = false;
                    }
                }

                public void setFwdEnabled(boolean enabled) {
                    if (WebBean.this.getState() == 0) {
                        enabled = false;
                    }
                    if (WebBean.this.browserFwdFeature != null) {
                        WebBean.this.browserFwdFeature.setEnabled(enabled);
                    }
                    if (WebBean.this.getState() == 4) {
                        WebBean.this.setState(2);
                    }
                }

                public void setBackEnabled(boolean enabled) {
                    if (WebBean.this.getState() == 0) {
                        enabled = false;
                    }
                    if (WebBean.this.browserFwdFeature != null) {
                        WebBean.this.browserBackFeature.setEnabled(enabled);
                    }
                    if (WebBean.this.getState() == 4) {
                        WebBean.this.setState(2);
                    }
                }
            });
        }
        catch (InstantiationException ex) {
            this.pane = null;
            this.logger.error((Object)this, "<init>", "Pane construction failed - " + ex);
        }
    }

    @Inject
    protected void initFeatureBroker(FeatureBroker broker) {
        this.broker = broker;
    }

    @Inject
    public void initPopupPrefsPanelProvider(Provider<PopupSuppressionPrefsPanel> popProv) {
        this.popupPrefsPanelProvider = popProv;
    }

    @Inject
    public void initWebPublisher(WebPublisher pub) {
        this.msgPublisher = pub;
    }

    @Inject
    public void initImps(Imps i) {
        this.imps = i;
    }

    @Inject
    public void initParentProvider(DialogParentProvider prov) {
        this.parentProv = prov;
    }

    @Inject
    public void initJinxTerminal(JinxTerminal terminal) {
        this.terminal = terminal;
    }

    @Inject
    protected void initClientProvider(ClientProvider clientProvider) {
        this.clientProvider = clientProvider;
    }

    @Inject
    protected void initSession(CRSession session) {
        this.session = session;
    }

    @Inject
    protected void initWebTourPermissionDelegate(WebTourPermissionDelegate webTourPermissionDelegate) {
        this.webTourPermissionDelegate = webTourPermissionDelegate;
    }

    public void dispose() {
        try {
            if (this.pane != null) {
                this.pane.dispose();
            }
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"dispose", (Throwable)t, (boolean)true);
        }
    }

    public void loadPreferences(String prefix, Preferences prefs) {
        if (this.isPopupSuppressionSupported()) {
            PropertyChangeListener popupSettingListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent ev) {
                    boolean suppress = true;
                    Object val = ev.getNewValue();
                    if (val instanceof Boolean) {
                        suppress = (Boolean)val;
                    } else if (val != null) {
                        suppress = Boolean.parseBoolean(val.toString());
                    }
                    WebBean.this.setPopupSuppression(suppress);
                }
            };
            boolean suppress = true;
            prefs.addSettingChangeListener(prefix + POPUP_SUPPRESS_PREF, popupSettingListener);
            suppress = prefs.getBooleanSetting(prefix + POPUP_SUPPRESS_PREF, true);
            this.setPopupSuppression(suppress);
        }
    }

    protected void handleModeSwitch(boolean modeIsWeb, boolean selfInitiated) {
        this.selfInitiated = selfInitiated;
        if (WebDebug.TRACE.show()) {
            this.logger.message((Object)this, "handleModeSwitch", "entered");
        }
        if (!modeIsWeb) {
            if (selfInitiated) {
                this.tourClose();
            }
        } else {
            this.browserBackFeature.setEnabled(false);
            this.browserFwdFeature.setEnabled(false);
            this.browserAddressFeature.setEnabled(false);
            this.browserAddressFeature.setEnabled(this.webAccess);
            this.getModeSwitchMessagePane().setText(this.getWaitingMessage());
            if (this.isWebModeratorCheck()) {
                if (WebDebug.TRACE.show()) {
                    this.logger.message((Object)this, "handleModeSwitch", "FYI: we have web permissions");
                }
                boolean tgVal = (Boolean)this.browserTourGuideFeature.getValue();
                if (WebDebug.TRACE.show()) {
                    this.logger.message((Object)this, "handleModeSwitch", "state = " + this.getState() + " tgVal = " + tgVal + " amTourGuide = " + this.amTourGuide + " neverEnteredWeb = " + this.neverEnteredWeb);
                }
                if (selfInitiated && !tgVal && !this.amTourGuide && this.neverEnteredWeb) {
                    if (WebDebug.TRACE.show()) {
                        this.logger.message((Object)this, "handleModeSwitch", "Setting self as tourguide (first time here, and self-initiated)");
                    }
                    this.handleTourGuideValue(true);
                } else if (tgVal && this.amTourGuide) {
                    if (WebDebug.TRACE.show()) {
                        this.logger.message((Object)this, "handleModeSwitch", "We're tour guide, so forcing sync");
                    }
                    this.syncUp();
                } else {
                    this.setState(0);
                    this.browserTourGuideFeature.setValue((Object)(selfInitiated && this.webAccess ? 1 : 0));
                }
            } else if (this.amTourGuide) {
                if (WebDebug.TRACE.show()) {
                    this.logger.message((Object)this, "handleModeSwitch", "returned without web permissions. relinquishing tour guide");
                }
                this.handleTourGuideValue(false);
            }
            if (modeIsWeb) {
                this.neverEnteredWeb = false;
            }
        }
    }

    private Component getBrowserPane() {
        if (this.featurePane == null) {
            String msgText = this.getWaitingMessage();
            this.featurePane = new JPanel(new BorderLayout());
            this.featurePane.setOpaque(false);
            this.waitMsgPane = new ModeSwitchMessagePane(msgText);
            this.messagePane = this.waitMsgPane.createContainer();
            this.featurePane.add((Component)this.messagePane, "North");
            if (this.pane != null) {
                this.webPane = this.pane.getComponent();
                this.webPane.setVisible(false);
                this.featurePane.add(this.webPane, "Center");
            }
        }
        return this.featurePane;
    }

    private ModeSwitchMessagePane getModeSwitchMessagePane() {
        if (this.waitMsgPane == null) {
            this.getBrowserPane();
        }
        return this.waitMsgPane;
    }

    private void setupBrowserFeature() {
        if (WebDebug.TRACE.show()) {
            this.logger.message((Object)this, "setupBrowserFeature", "entered");
        }
        this.browserPaneFeature = this.broker.createComponentFeature((Object)this, "/web/browser", new ComponentProvider(){

            public Component get(ComponentFeature feature) {
                return WebBean.this.getBrowserPane();
            }
        }, "No name yet", "No description yet");
        this.browserPaneFeature.setEnabled(false);
    }

    private void setupBackFwdFeatures() {
        if (WebDebug.TRACE.show()) {
            this.logger.message((Object)this, "setupBackFwdFeatures", "entered");
        }
        this.browserBackFeature = this.broker.createActionFeature((Object)this, "/web/back", "", this.i18n.getString((PropertiesEnum)StringsProperties.WEBBEAN_BACKTIP));
        this.browserBackFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                if (WebDebug.TRACE.show()) {
                    WebBean.this.logger.message((Object)this, "actionPerformed", "back feature fired");
                }
                WebBean.this.setState(4);
                WebBean.this.pane.goBack();
            }
        });
        this.browserFwdFeature = this.broker.createActionFeature((Object)this, "/web/fwd", "", this.i18n.getString((PropertiesEnum)StringsProperties.WEBBEAN_FWDTIP));
        this.browserFwdFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                if (WebDebug.TRACE.show()) {
                    WebBean.this.logger.message((Object)this, "actionPerformed", "fwd feature fired");
                }
                WebBean.this.setState(4);
                WebBean.this.pane.goForward();
            }
        });
        this.browserBackFeature.setDefaultIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.WEBBEAN_BACKICON));
        this.browserBackFeature.setRolloverIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.WEBBEAN_BACKICON_ROLLOVER));
        this.browserBackFeature.setPressedIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.WEBBEAN_BACKICON_PRESSED));
        this.browserBackFeature.setDisabledIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.WEBBEAN_BACKICON_DISABLED));
        this.browserFwdFeature.setDefaultIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.WEBBEAN_FWDICON));
        this.browserFwdFeature.setRolloverIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.WEBBEAN_FWDICON_ROLLOVER));
        this.browserFwdFeature.setPressedIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.WEBBEAN_FWDICON_PRESSED));
        this.browserFwdFeature.setDisabledIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.WEBBEAN_FWDICON_DISABLED));
        this.browserBackFeature.setEnabled(false);
        this.browserFwdFeature.setEnabled(false);
    }

    private void setupAddressFeature() {
        if (WebDebug.TRACE.show()) {
            this.logger.message((Object)this, "setupBackAddressFeature", "entered");
        }
        this.browserAddressFeature = this.broker.createStringFeature((Object)this, "/web/address", true, "", "", this.i18n.getString((PropertiesEnum)StringsProperties.WEBBEAN_ADDRESSBARTIP));
        this.browserAddressFeature.setAccessibleDescription(this.i18n.getString((PropertiesEnum)StringsProperties.WEBBEAN_ADDRESSBARNAME));
        this.browserAddressFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent event) {
                if (WebBean.this.browserAddressFeatureInterlock) {
                    return;
                }
                if (WebBean.this.messagePane != null && WebBean.this.messagePane.isVisible()) {
                    WebBean.this.showWebPane(true);
                }
                String url = (String)WebBean.this.browserAddressFeature.getValue();
                if (WebDebug.TRACE.show()) {
                    WebBean.this.logger.message((Object)this, "metaDataChanged", "address value changed to '" + url + "' (old = " + event.getOldValue() + " )");
                }
                if (WebBean.this.getState() != 4) {
                    if (WebBean.this.getState() != 2 && WebBean.this.getState() != 3) {
                        WebBean.this.openURL();
                    } else {
                        WebBean.this.urlSpecified(url);
                    }
                }
            }
        });
        this.browserAddressFeature.addMetaDataListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent event) {
                if (event.getID().equals("DocumentUpdated")) {
                    if (WebDebug.TRACE.show()) {
                        WebBean.this.logger.message((Object)this, "metaDataChanged", "Disabling publish due to URL text modification.");
                    }
                    WebBean.this.browserPublishToChatFeature.setEnabled(false);
                }
            }
        });
        this.browserAddressFeature.setEnabled(false);
    }

    private void setupPublishToChatFeature() {
        if (WebDebug.TRACE.show()) {
            this.logger.message((Object)this, "setupPublishToChatFeature", "entered");
        }
        this.browserPublishToChatFeature = this.broker.createActionFeature((Object)this, "/web/publishToChat", this.i18n.getString((PropertiesEnum)StringsProperties.WEBBEAN_PUBLISHURL), this.i18n.getString((PropertiesEnum)StringsProperties.WEBBEAN_PUBLISHURLTIP));
        this.browserPublishToChatFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                if (WebDebug.TRACE.show()) {
                    WebBean.this.logger.message((Object)this, "actionPerformed", "publish to chat action fired");
                }
                WebBean.this.doPublishURL();
            }
        });
        this.browserPublishToChatFeature.setDefaultIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.WEBBEAN_PUBLISHURLICON));
        this.browserPublishToChatFeature.setEnabled(false);
    }

    private void setupTourGuideFeature() {
        if (WebDebug.TRACE.show()) {
            this.logger.message((Object)this, "setupTourGuideFeature", "entered");
        }
        String parts = LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.participants");
        this.browserTourGuideFeature = this.broker.createBooleanFeature((Object)this, "/web/tourGuide", true, false, this.i18n.getString((PropertiesEnum)StringsProperties.WEBBEAN_STARTTOUR), this.i18n.getString((PropertiesEnum)StringsProperties.WEBBEAN_STARTTOURTIP, new Object[]{parts}));
        this.browserTourGuideFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent event) {
                boolean tgVal = (Boolean)WebBean.this.browserTourGuideFeature.getValue();
                WebBean.this.handleTourGuideValue(tgVal);
            }
        });
        this.browserTourGuideFeature.setEnabled(false);
    }

    boolean amTourGuide() {
        return this.amTourGuide;
    }

    private void handleTourGuideValue(boolean tgVal) {
        if (this.amTourGuide != tgVal) {
            if (WebDebug.TRACE.show()) {
                this.logger.message((Object)this, "metaDataChanged", "TourGuide set to " + tgVal + " in state " + this.getState() + " by user");
            }
            this.amTourGuide = tgVal;
            this.getModeSwitchMessagePane().setText(this.getWaitingMessage());
            ChannelDataEvent cde = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)5);
            try {
                DataOutputStream ostr = cde.write();
                if (!this.amTourGuide) {
                    ostr.writeShort(-32767);
                } else {
                    ostr.writeShort(this.client.getAddress());
                }
                ostr.close();
            }
            catch (IOException iox) {
                LogSupport.exception((Object)this, (String)"tourGuide actionPerformed", (Throwable)iox, (boolean)true);
                return;
            }
            this.fireChannelData(cde);
        } else if (WebDebug.TRACE.show()) {
            this.logger.message((Object)this, "metaDataChanged", "TourGuide set to " + tgVal + " programmatically in state " + this.getState());
        }
    }

    private void setupGotoURLFeature() {
        if (WebDebug.TRACE.show()) {
            this.logger.message((Object)this, "setupGotoURLFeature", "entered");
        }
        this.browserGotoURLFeature = this.broker.createActionFeature((Object)this, "/web/gotoURL", this.i18n.getString((PropertiesEnum)StringsProperties.WEBBEAN_SENDTOURL), this.i18n.getString((PropertiesEnum)StringsProperties.WEBBEAN_SENDTOURLTIP));
        this.browserGotoURLFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                if (WebDebug.TRACE.show()) {
                    WebBean.this.logger.message((Object)this, "actionPerformed", "goToURL action fired");
                }
                WebBean.this.pushURL();
            }
        });
        this.browserGotoURLFeature.setEnabled(false);
    }

    private void setupPopupPrefsFeature() {
        if (WebDebug.TRACE.show()) {
            this.logger.message((Object)this, "setupPopupFeature", "entered");
        }
        this.popupPrefsFeature = this.broker.createComponentFeature((Object)this, "/web/popupPrefs", new ComponentProvider(){

            public Component get(ComponentFeature feature) {
                return (Component)WebBean.this.popupPrefsPanelProvider.get();
            }
        }, "No name", "No description");
        if (this.isPopupSuppressionSupported()) {
            this.broker.setFeaturePublished((Feature)this.popupPrefsFeature, true);
        }
    }

    public void cleanupFeatures() {
        this.browserPaneFeature = null;
        this.browserBackFeature = null;
        this.browserFwdFeature = null;
        this.browserAddressFeature = null;
        this.browserPublishToChatFeature = null;
        this.browserTourGuideFeature = null;
        this.browserGotoURLFeature = null;
        this.broker.setFeaturePublished((Feature)this.popupPrefsFeature, false);
        this.popupPrefsFeature = null;
    }

    public void enableSomeBrowserControlFeatures(boolean enable) {
        if (WebDebug.TRACE.show()) {
            this.logger.message((Object)this, "enableSomeBrowserControlFeatures", "enable = " + enable);
        }
        this.browserAddressFeature.setEnabled(enable && !this.isPlayback());
        this.browserGotoURLFeature.setEnabled(enable);
    }

    public void publishBrowserControlFeatures(boolean publish) {
        if (WebDebug.TRACE.show()) {
            this.logger.message((Object)this, "publishBrowserControlFeatures", "publish = " + publish);
        }
        if (this.pane != null) {
            this.broker.setFeaturePublished((Feature)this.browserPaneFeature, publish);
            this.broker.setFeaturePublished((Feature)this.browserBackFeature, publish);
            this.broker.setFeaturePublished((Feature)this.browserFwdFeature, publish);
            this.broker.setFeaturePublished((Feature)this.browserAddressFeature, publish);
            this.broker.setFeaturePublished((Feature)this.browserPublishToChatFeature, publish);
            this.broker.setFeaturePublished((Feature)this.browserTourGuideFeature, publish);
        }
        this.broker.setFeaturePublished((Feature)this.browserGotoURLFeature, publish);
    }

    public void setupFeatures() {
        this.setupBrowserFeature();
        this.setupBackFwdFeatures();
        this.setupAddressFeature();
        this.setupPublishToChatFeature();
        this.setupTourGuideFeature();
        this.setupGotoURLFeature();
        this.setupPopupPrefsFeature();
    }

    public void onNavigate(NavigationEvent e) {
        String tourNxt = e.getURL();
        String frm = e.getFrame();
        if (WebDebug.NAVIGATE.show()) {
            this.logger.message((Object)this, "onNavigate", "navigate to '" + tourNxt + (frm == null ? "'" : "' in frame '" + frm + "'") + " state=" + this.getState());
        }
        if (this.getState() == 0) {
            return;
        }
        if (tourNxt.startsWith("about:")) {
            return;
        }
        if (frm == null) {
            frm = "";
        }
        if (frm.equals("")) {
            if (!tourNxt.equals(this.tourNow.get())) {
                if (this.webAccess && this.amTourGuide) {
                    this.tourMove(tourNxt);
                } else {
                    if (WebDebug.NAVIGATE.show()) {
                        this.logger.message((Object)this, "onNavigate", "Now out of sync");
                    }
                    this.inSync = false;
                }
                this.tourNow.navigate(tourNxt);
            }
        } else {
            if (this.webAccess && this.amTourGuide) {
                this.pushFrame(frm, tourNxt);
            } else {
                if (WebDebug.NAVIGATE.show()) {
                    this.logger.message((Object)this, "onNavigate", "Now out of sync");
                }
                this.inSync = false;
            }
            this.tourNow.navigate(frm, tourNxt);
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (WebBean.this.webPane != null) {
                    WebBean.this.webPane.setVisible(true);
                }
                WebBean.this.messagePane.setVisible(false);
            }
        };
        SwingRunnerSupport.invokeOnEventThread((Runnable)r);
    }

    public void onStop() {
        if (WebDebug.TRACE.show()) {
            this.logger.message((Object)this, "onStop", "entered");
        }
    }

    public void setTitle(String newTitle) {
        String oldTitle = this.title;
        this.title = newTitle;
        this.firePropertyChange(TITLE_PROP, oldTitle, newTitle);
    }

    public String getTitle() {
        return this.title;
    }

    public void setNonLinear(boolean nl) {
        this.nonlinear = nl;
        if (!this.nonlinear) {
            this.tourReq.update(this.tourNow, new BrowserStateListener(){

                public void onNavigate(String url) {
                    WebBean.this.doOpen(null, url, true);
                }

                public void onFrameNavigate(String frm, String url) {
                    WebBean.this.doOpen(frm, url, true);
                }

                public void onStop() {
                    WebBean.this.doClose(true);
                }
            });
            if (this.pushReq != null) {
                this.doPush(this.pushReq);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(int newState) {
        Object object = this.lock;
        synchronized (object) {
            int oldState = this.state;
            this.state = newState;
            this.firePropertyChange(STATE_PROP, oldState, newState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getState() {
        Object object = this.lock;
        synchronized (object) {
            return this.state;
        }
    }

    private void changeClient(Client theClient) {
        if (this.client == theClient) {
            return;
        }
        this.client = theClient;
        this.clients = this.client == null ? null : this.client.getClientList();
        this.terminal.setClient(theClient);
    }

    public void setClient(Client theClient) {
        WebProtocol proto = new WebProtocol();
        this.terminal.setProtocol((JinxProtocol)proto);
        this.terminal.addProtocolPropertyListeners((PropertyChangeListener)this);
        this.terminal.createChannels((ChannelListener)this, (ChannelDataListener)this);
        this.changeClient(theClient);
        this.clients.addPropertyChangeListener((byte)0, (PropertyChangeListener)new WebTourAnnotationProvider());
        if (this.webTourPermissionDelegate != null) {
            this.webTourPermissionDelegate.setClientProvider(this.clientProvider);
            this.webTourPermissionDelegate.setSession(this.session);
            CRPermissionFactory permissionFactory = new CRPermissionFactory("WebTourPermission", "WebTourPermission", CRPermissionScope.PARTICIPANT, (CRPermissionDelegate)this.webTourPermissionDelegate);
            this.session.registerPermission(permissionFactory);
            this.clients.addPropertyChangeListener(this.webTourPermissionDelegate.getPropertyName(), (byte)0, (PropertyChangeListener)((Object)this.webTourPermissionDelegate));
            this.clients.addDefaultPropertyChangeListener(this.webTourPermissionDelegate.getPropertyName(), (byte)0, (PropertyChangeListener)((Object)this.webTourPermissionDelegate));
        }
    }

    public byte getInitState() {
        if (this.pane == null) {
            return -1;
        }
        return this.pane.getInitState();
    }

    public void channelStateChanged(ChannelEvent e) {
        switch (e.getState()) {
            case 2: {
                if (WebDebug.TRACE.show()) {
                    this.logger.message((Object)this, "channelStateChanged", "Channel down");
                }
                this.setState(0);
                this.tourNow.stop();
                this.tourReq.stop();
                this.pushNow = null;
                this.pushReq = null;
                this.amTourGuide = false;
                this.browserTourGuideFeature.setValue((Object)false);
                this.browserPaneFeature.setEnabled(false);
                break;
            }
        }
    }

    public void onChannelData(ChannelDataEvent e) {
        if (e.getSourceAddress() != 0) {
            this.logger.error((Object)this, "onChannelData", "Web message from source other than server:" + e.getSourceAddress());
            return;
        }
        if (WebDebug.TRACE.show()) {
            this.logger.message((Object)this, "onChannelData", "getCommand = " + e.getCommand());
        }
        switch (e.getCommand()) {
            case 1: {
                try {
                    DataInputStream str = e.read();
                    this.pushReq = str.readUTF();
                    str.close();
                    if (this.nonlinear) break;
                    this.doPush(this.pushReq);
                }
                catch (IOException ex) {
                    LogSupport.exception((Object)this, (String)"onChannelData", (Throwable)ex, (boolean)true);
                }
                break;
            }
            case 2: {
                try {
                    DataInputStream str = e.read();
                    String url = str.readUTF();
                    str.close();
                    this.doLocalOpen(url);
                }
                catch (IOException ex) {
                    LogSupport.exception((Object)this, (String)"onChannelData", (Throwable)ex, (boolean)true);
                }
                break;
            }
            case 3: {
                this.tourReq.stop();
                if (this.nonlinear) break;
                this.doClose(false);
                break;
            }
            case 4: {
                try {
                    DataInputStream str = e.read();
                    String frm = str.readUTF();
                    String url = str.readUTF();
                    str.close();
                    this.tourReq.navigate(frm, url);
                    if (this.nonlinear) break;
                    this.doOpen(frm, url, true);
                }
                catch (Exception ex) {
                    LogSupport.exception((Object)this, (String)"onChannelData", (Throwable)ex, (boolean)true);
                }
                break;
            }
            case 5: {
                try {
                    DataInputStream str = e.read();
                    short addr = str.readShort();
                    str.close();
                    boolean reactivate = false;
                    if (!this.tourReq.isStopped()) {
                        reactivate = true;
                    }
                    this.amTourGuide = addr == this.client.getAddress();
                    this.browserTourGuideFeature.setValue((Object)this.amTourGuide);
                    if (!this.amTourGuide || this.inSync && !reactivate) break;
                    this.syncUp();
                }
                catch (Exception ex) {
                    LogSupport.exception((Object)this, (String)"onChannelData", (Throwable)ex, (boolean)true);
                }
                break;
            }
        }
    }

    private void doLocalOpen(String url) {
        this.pushReq = null;
        this.tourReq.navigate(url);
        if (!this.nonlinear) {
            this.doOpen(null, url, true);
        }
    }

    private void syncUp() {
        this.tourNow.update(null, new BrowserStateListener(){

            public void onStop() {
            }

            public void onFrameNavigate(String frm, String url) {
                if (WebDebug.TRACE.show()) {
                    WebBean.this.logger.message((Object)this, "onFrameNavigate", "out of sync. pushFrame " + url);
                }
                WebBean.this.pushFrame(frm, url);
            }

            public void onNavigate(String url) {
                if (WebDebug.TRACE.show()) {
                    WebBean.this.logger.message((Object)this, "onFrameNavigate", "out of sync. tourMove " + url);
                }
                WebBean.this.tourMove(url);
            }
        });
    }

    private void doPush(String url) {
        if (WebDebug.NAVIGATE.show()) {
            this.logger.message((Object)this, " doPush", "push to URL '" + url + "'");
        }
        this.pushNow = url;
        class PushThread
        extends WorkerThread {
            private String url;

            public PushThread(String URL) {
                super("WebTour PushThread");
                this.url = URL;
            }

            public void run() {
                try {
                    this.url = WebBean.this.checkURL(this.url);
                    BrowserUtil.gotoURL((String)this.url);
                    WebBean.this.msgPublisher.sendLaunchWebsiteMessage(this.url);
                }
                catch (Exception ex) {
                    ModalDialog.showMessageDialog((Component)WebBean.this.parentProv.getDialogParent(), (Object)WebBean.this.i18n.getString((PropertiesEnum)StringsProperties.WEBBEAN_CANTLAUNCHBROWSERMSG, new Object[]{this.url, ex.getMessage()}), (String)WebBean.this.i18n.getString((PropertiesEnum)StringsProperties.WEBBEAN_CANTLAUNCHBROWSERTITLE), (int)0);
                }
            }
        }
        new PushThread(this.pushNow).start();
    }

    private void doOpen(String frm, String url, boolean save) {
        if (WebDebug.NAVIGATE.show()) {
            this.logger.message((Object)this, "doOpen", "open '" + url + (frm == null ? "" : "' in frame '" + frm + "'"));
        }
        if (!url.equals(this.tourNow.get(frm))) {
            this.inSync = true;
            if (save) {
                this.tourNow.navigate(frm, url);
            }
            class TourThread
            extends WorkerThread {
                String frm;
                String url;

                public TourThread(String frame, String URL) {
                    super("WebTour TourThread");
                    this.frm = frame;
                    this.url = URL;
                }

                public void run() {
                    block15: {
                        try {
                            long now;
                            long delay;
                            byte initState = WebBean.this.getInitState();
                            if (this.frm == null) {
                                if (!this.url.startsWith("about:")) {
                                    this.url = WebBean.this.checkURL(this.url);
                                }
                                if (WebBean.this.webPane != null && !WebBean.this.webPane.isVisible()) {
                                    WebBean.this.showWebPane(true);
                                }
                                if (initState != -1) {
                                    WebBean.this.pane.openURL(this.url);
                                    WebBean.this.setState(2);
                                } else {
                                    BrowserUtil.gotoURL((String)this.url);
                                    WebBean.this.setState(3);
                                    WebBean.this.onNavigate(new NavigationEvent((Object)this, this.url));
                                }
                                WebBean.this.msgPublisher.sendStartWebTourMessage(this.url);
                            } else if (initState != -1) {
                                WebBean.this.pane.openURL(this.frm, this.url);
                            }
                            if (initState != 0) break block15;
                            long limit = System.currentTimeMillis() + 10000L;
                            while ((delay = limit - (now = System.currentTimeMillis())) > 0L) {
                                try {
                                    Thread.sleep(Math.min(1000L, delay));
                                }
                                catch (InterruptedException ex) {
                                    // empty catch block
                                }
                                if (WebBean.this.getInitState() == 0) continue;
                            }
                            if (WebBean.this.getInitState() == -1) {
                                if (WebBean.this.amTourGuide) {
                                    WebBean.this.pushURL(this.url);
                                    WebBean.this.amTourGuide = false;
                                    WebBean.this.browserTourGuideFeature.setValue((Object)false);
                                } else {
                                    WebBean.this.setState(3);
                                    BrowserUtil.gotoURL((String)this.url);
                                }
                            }
                        }
                        catch (Exception ex) {
                            ModalDialog.showMessageDialog((Component)WebBean.this.parentProv.getDialogParent(), (Object)WebBean.this.i18n.getString((PropertiesEnum)StringsProperties.WEBBEAN_CANTLAUNCHBROWSERMSG, new Object[]{this.url, ex.getMessage()}), (String)WebBean.this.i18n.getString((PropertiesEnum)StringsProperties.WEBBEAN_CANTLAUNCHBROWSERTITLE), (int)0);
                            WebBean.this.setState(0);
                        }
                    }
                }
            }
            new TourThread(frm, url).start();
        }
    }

    private void doClose(boolean callTourClose) {
        if (WebDebug.TRACE.show()) {
            this.logger.message((Object)this, "doClose", "entered");
        }
        this.browserTourGuideFeature.setValue((Object)false);
        if (this.state != 0 && this.pane != null) {
            this.pane.stop();
        }
        this.amTourGuide = false;
        this.browserPaneFeature.setEnabled(true);
        this.tourReq.stop();
        this.tourNow.stop();
        this.pushReq = null;
        this.pushNow = null;
        if (callTourClose) {
            this.tourClose();
        }
        this.setState(0);
        this.browserAddressFeatureInterlock = true;
        this.browserAddressFeature.setValue((Object)"");
        this.browserAddressFeatureInterlock = false;
        this.browserFwdFeature.setEnabled(false);
        this.browserBackFeature.setEnabled(false);
        this.msgPublisher.sendStopWebTourMessage();
    }

    public void pushURL() {
        Module pm;
        PresentationModeAPI presentationAPI;
        if (WebDebug.TRACE.show()) {
            this.logger.message((Object)this, "pushURL", "entered");
        }
        if ((presentationAPI = (PresentationModeAPI)this.imps.findBest(PresentationModeAPI.class)) != null && presentationAPI.isPresenting() && (pm = (Module)presentationAPI.getPresentedModule()) != null) {
            String msg = this.i18n.getStringLegacy("WebBean.noGoToUrlWhilePresentingMsg", new Object[]{this.getPresentedModuleTitle(pm)});
            String title = this.i18n.getStringLegacy("WebBean.noGoToUrlWhilePresentingTitle");
            ModalDialog.showMessageDialogAsync((int)15, (Component)this.parentProv.getDialogParent(), (Object)msg, (String)title, (int)0);
            return;
        }
        String url = ModalDialog.showInputDialog((Component)this.parentProv.getDialogParent(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.WEBBEAN_ENTERURLPLEASE), (String)this.i18n.getString((PropertiesEnum)StringsProperties.WEBBEAN_ENTERGOTOURLTITLE), (int)3);
        if (url == null || url.trim().equals("")) {
            return;
        }
        this.pushURL(url);
    }

    private String getPresentedModuleTitle(Module pm) {
        Object value = this.getMethodValue(pm, "getTitle", new Class[0], new Object[0]);
        return value != null ? value.toString() : "N/A";
    }

    private Object getMethodValue(Object owner, String methodName, Class<?>[] params, Object[] args) {
        if (owner != null) {
            Method method = this.getMethod(owner.getClass(), methodName, params);
            try {
                return method.invoke(owner, args);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    private Method getMethod(Class<?> clazz, String methodName, Class<?>[] params) {
        Method method = null;
        try {
            method = clazz.getMethod(methodName, params);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openURL() {
        Module pm;
        PresentationModeAPI presentationAPI;
        if (WebDebug.TRACE.show()) {
            this.logger.message((Object)this, "openURL", "entered");
        }
        if ((presentationAPI = (PresentationModeAPI)this.imps.findBest(PresentationModeAPI.class)) != null && presentationAPI.isPresenting() && (pm = (Module)presentationAPI.getPresentedModule()) != null) {
            this.setState(1);
            try {
                String msg = this.i18n.getString((PropertiesEnum)StringsProperties.WEBBEAN_NOTWHILEPRESENTINGMSG, new Object[]{this.getPresentedModuleTitle(pm)});
                String title = this.i18n.getString((PropertiesEnum)StringsProperties.WEBBEAN_NOTWHILEPRESENTINGTITLE);
                ModalDialog.showMessageDialogAsync((int)15, (Component)this.parentProv.getDialogParent(), (Object)msg, (String)title, (int)0);
            }
            finally {
                this.setState(0);
            }
            return;
        }
        this.setState(1);
        String url = (String)this.browserAddressFeature.getValue();
        if (url == null || url.trim().equals("")) {
            this.setState(0);
            return;
        }
        if (this.pane == null) {
            this.setState(0);
            this.pushURL(url);
        } else if (this.pane.getInitState() == -1) {
            this.setState(0);
            this.pushURL(url);
        } else {
            this.openURL(url);
        }
    }

    private void fireChannelData(ChannelDataEvent evt) {
        this.terminal.fireChannelData(0, evt, true, (byte)0);
    }

    void openURL(String url) {
        if (WebDebug.NAVIGATE.show()) {
            this.logger.message((Object)this, "openURL", "open '" + url + "'");
        }
        if (!this.isWebModeratorCheck()) {
            this.displayNotModerator();
            this.setState(0);
            return;
        }
        try {
            url = this.checkURL(url);
        }
        catch (MalformedURLException ex) {
            ModalDialog.showMessageDialog((Component)this.parentProv.getDialogParent(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.WEBBEAN_BADURLMSG, new Object[]{url, ex.getMessage()}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.WEBBEAN_BADURLTITLE), (int)0);
            this.setState(0);
            return;
        }
        if (!this.amTourGuide) {
            this.doLocalOpen(url);
            return;
        }
        this.amTourGuide = true;
        this.browserTourGuideFeature.setValue((Object)true);
        ChannelDataEvent event = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)2);
        DataOutputStream str = event.write();
        try {
            str.writeUTF(url);
            str.close();
            this.fireChannelData(event);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"openURL(String)", (Throwable)ex, (boolean)true);
        }
    }

    void goToURL(String url) {
        if (WebDebug.NAVIGATE.show()) {
            this.logger.message((Object)this, "goToURL", "go to '" + url + "'");
        }
        if (this.pane != null) {
            this.pane.openURL(url);
        }
    }

    public void pushURL(String url) {
        if (WebDebug.NAVIGATE.show()) {
            this.logger.message((Object)this, "pushURL", "push '" + url + "'");
        }
        if (!this.isWebModeratorCheck()) {
            this.displayNotModerator();
            return;
        }
        try {
            url = this.checkURL(url);
        }
        catch (MalformedURLException ex) {
            ModalDialog.showMessageDialog((Component)this.parentProv.getDialogParent(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.WEBBEAN_BADURLMSG, new Object[]{url, ex.getMessage()}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.WEBBEAN_BADURLTITLE), (int)0);
            return;
        }
        ChannelDataEvent event = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)1);
        DataOutputStream str = event.write();
        try {
            str.writeUTF(url);
            str.close();
            this.fireChannelData(event);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"pushURL(String)", (Throwable)ex, (boolean)true);
        }
    }

    private void tourMove(String url) {
        if (WebDebug.NAVIGATE.show()) {
            this.logger.message((Object)this, "tourMove", "move to '" + url + "'");
        }
        ChannelDataEvent event = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)2);
        DataOutputStream str = event.write();
        try {
            str.writeUTF(url);
            str.close();
            this.fireChannelData(event);
            this.msgPublisher.sendStartWebTourMessage(url);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"push", (Throwable)ex, (boolean)true);
        }
    }

    private void pushFrame(String frm, String url) {
        if (WebDebug.NAVIGATE.show()) {
            this.logger.message((Object)this, "pushFrame", "push '" + url + "' in frame '" + frm + "'");
        }
        ChannelDataEvent event = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)4);
        DataOutputStream str = event.write();
        try {
            str.writeUTF(frm);
            str.writeUTF(url);
            str.close();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"pushFrame", (Throwable)ex, (boolean)true);
        }
        this.fireChannelData(event);
    }

    public void tourClose() {
        if (WebDebug.TRACE.show()) {
            this.logger.message((Object)this, "tourClose", "entered");
        }
        if (this.isWebModeratorCheck()) {
            ChannelDataEvent event = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)3);
            this.fireChannelData(event);
        }
    }

    String checkURL(String str) throws MalformedURLException {
        URLString url;
        int sep = str.indexOf(SEPARATOR);
        if (sep < 0) {
            str = PROTOCOLS[0] + SEPARATOR + str;
        }
        if ((url = new URLString(str)).getPath() == null || url.getPath().length() < 1) {
            url.setPath("/");
        }
        String protocol = url.getProtocol();
        for (int i = 0; i < PROTOCOLS.length; ++i) {
            if (!protocol.equalsIgnoreCase(PROTOCOLS[i])) continue;
            return url.toString();
        }
        throw new MalformedURLException(this.i18n.getString((PropertiesEnum)StringsProperties.WEBBEAN_INVALIDPROTOCOL, new Object[]{protocol}));
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        ClientInfo srcClientInfo;
        short srcAddress;
        String prop = e.getPropertyName();
        if (!prop.equals("webTourFloor")) {
            return;
        }
        if (e.getNewValue() == null) {
            return;
        }
        boolean newWebAccess = (Boolean)e.getNewValue();
        short myAddress = this.client.getAddress();
        if (myAddress != (srcAddress = (srcClientInfo = (ClientInfo)e.getSource()).getAddress())) {
            return;
        }
        if (e.getOldValue() != null && (Boolean)e.getOldValue() == newWebAccess) {
            return;
        }
        this.webAccess = newWebAccess;
        this.enableSomeBrowserControlFeatures(this.webAccess);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (WebBean.this.pane != null) {
                    WebBean.this.pane.repaintContent();
                }
            }
        };
        LightweightTimer timer = new LightweightTimer(2, r);
        timer.scheduleIn(200L);
        if (!this.webAccess) {
            this.amTourGuide = false;
            this.browserTourGuideFeature.setValue((Object)false);
            this.browserTourGuideFeature.setEnabled(false);
            this.broker.setFeaturePublished((Feature)this.browserTourGuideFeature, false);
        } else {
            this.browserTourGuideFeature.setEnabled(true);
            this.broker.setFeaturePublished((Feature)this.browserTourGuideFeature, true);
        }
    }

    public void urlSpecified(String url) {
        try {
            String checkedURL = this.checkURL(url);
            if (this.pane != null) {
                this.pane.openURL(checkedURL);
            } else {
                this.openURL(checkedURL);
            }
        }
        catch (MalformedURLException ex) {
            String title = this.i18n.getString((PropertiesEnum)StringsProperties.WEBBEAN_BADURLTITLE);
            String msg = this.i18n.getString((PropertiesEnum)StringsProperties.WEBBEAN_BADURLMSG, new Object[]{url, ex.getMessage()});
            ModalDialog.showMessageDialogAsync((int)-1, (Component)this, (Object)msg, (String)title, (int)0);
        }
    }

    protected boolean isWebModeratorCheck() {
        return this.webAccess;
    }

    private void displayNotModerator() {
        ModalDialog.showMessageDialogAsync((int)-1, (Component)this.parentProv.getDialogParent(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.WEBBEAN_NOTMODERATORMESSAGE), (String)this.i18n.getString((PropertiesEnum)StringsProperties.WEBBEAN_NOTMODERATORTITLE), (int)0);
    }

    public void doPublishURL() {
        if (!this.isWebModeratorCheck()) {
            this.displayNotModerator();
            return;
        }
        if (this.publishAPI == null) {
            this.publishAPI = (PublishUrlAPI)this.imps.findBest(PublishUrlAPI.class);
        }
        String addressBarString = (String)this.browserAddressFeature.getValue();
        if (this.publishAPI != null && addressBarString != null) {
            try {
                VClassURI uri = new VClassURI(this.checkURL(addressBarString));
                String urlText = uri.toString();
                if (WebDebug.TRACE.show()) {
                    this.logger.message((Object)this, "doPublishURL", "published '" + urlText + "' to chat");
                }
                this.publishAPI.publishURL(urlText);
            }
            catch (Exception ex) {
                LogSupport.log((String)("Attempted to publish invalid URI: " + addressBarString));
            }
        }
    }

    boolean isPopupSuppressionSupported() {
        if (this.pane == null) {
            return false;
        }
        return this.pane.isPropertySupported("browser.popups");
    }

    private void setPopupSuppression(boolean suppress) {
        if (this.pane == null) {
            return;
        }
        if (this.pane.isPropertySupported("browser.popups")) {
            this.pane.setProperty("browser.popups", (Object)suppress);
        }
    }

    public boolean isPlayback() {
        return this.clientProvider != null && this.clientProvider.get() != null ? this.clientProvider.get().getConnectionType().equals((Object)Connection.Type.PLAYBACK_CLIENT) : false;
    }

    private void showWebPane(final boolean showWebPane) {
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = WebBean.this.lock;
                synchronized (object) {
                    if (showWebPane) {
                        if (WebBean.this.featurePane.getComponentZOrder(WebBean.this.messagePane) > -1) {
                            WebBean.this.featurePane.remove(WebBean.this.messagePane);
                            WebBean.this.featurePane.add(WebBean.this.webPane, "Center");
                        }
                    } else if (WebBean.this.featurePane.getComponentZOrder(WebBean.this.webPane) > -1) {
                        WebBean.this.featurePane.remove(WebBean.this.webPane);
                        WebBean.this.featurePane.add((Component)WebBean.this.messagePane, "North");
                        WebBean.this.enableSomeBrowserControlFeatures(WebBean.this.webAccess);
                    }
                    WebBean.this.messagePane.setVisible(!showWebPane);
                    WebBean.this.webPane.setVisible(showWebPane);
                    WebBean.this.featurePane.revalidate();
                    WebBean.this.featurePane.repaint();
                    if (WebDebug.TRACE.show()) {
                        WebBean.this.logger.message((Object)this, "showWebPane", showWebPane + " " + WebBean.this.webPane.isVisible() + " " + WebBean.this.messagePane.isVisible());
                    }
                }
            }
        };
        LightweightTimer timer = new LightweightTimer(2, r);
        timer.scheduleIn(10L);
    }

    private String getWaitingMessage() {
        String waitingMessage = this.i18n.getString((PropertiesEnum)StringsProperties.WEBBEAN_WAITMSG);
        if (this.selfInitiated || !this.selfInitiated && this.amTourGuide) {
            waitingMessage = this.i18n.getString((PropertiesEnum)StringsProperties.WEBBEAN_WAITMSG_TOURGUIDE);
        }
        return waitingMessage;
    }

    private class WebTourAnnotationProvider
    implements PropertyChangeListener {
        private WebTourAnnotationProvider() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (WebBean.this.clients == null) {
                return;
            }
            String propertyName = evt.getPropertyName();
            short ownerId = WebBean.this.clients.getPropertyOwner(evt.getSource());
            ClientInfo ci = WebBean.this.clients.get(ownerId);
            if (ci == null) {
                return;
            }
            if (propertyName.equals("webTourActive")) {
                boolean active = ci.getProperty("webTourActive", false);
                if (active) {
                    WebBean.this.session.setAnnotationValue(ownerId, "WebTourActivityAnnotation", (Object)1);
                } else {
                    WebBean.this.session.setAnnotationValue(ownerId, "WebTourActivityAnnotation", (Object)0);
                }
            }
        }
    }
}

