/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.web.module;

import com.elluminate.groupware.web.module.StringsProperties;
import com.elluminate.groupware.web.module.WebBean;
import com.elluminate.gui.component.AbstractPreferencesPanel;
import com.elluminate.gui.component.MultilineLabel;
import com.elluminate.gui.component.PreferencesPanelOwner;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

@Singleton
public class PopupSuppressionPrefsPanel
extends AbstractPreferencesPanel {
    private static final long serialVersionUID = 1L;
    private I18n i18n;
    private JCheckBox popupSuppressChkBox;

    @Inject
    public PopupSuppressionPrefsPanel(PreferencesPanelOwner owner, I18n i18n) {
        super(owner, i18n.getString((PropertiesEnum)StringsProperties.POPUPSUPPRESSPREFS_TITLE));
        this.i18n = i18n;
    }

    protected void createContent() {
        this.setLayout(new BorderLayout());
        JPanel p = new JPanel(new BorderLayout(0, 10));
        this.add(p, "North");
        MultilineLabel exposition = new MultilineLabel();
        exposition.setText(this.i18n.getString((PropertiesEnum)StringsProperties.POPUPSUPPRESSPREFS_EXPOSITION));
        p.add((Component)exposition, "North");
        JPanel center = new JPanel(new GridBagLayout());
        p.add((Component)center, "Center");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        String name = this.i18n.getString((PropertiesEnum)StringsProperties.POPUPSUPPRESSPREFS_CHKBOXTITLE);
        this.popupSuppressChkBox = new JCheckBox(name);
        String toolTip = this.i18n.getString((PropertiesEnum)StringsProperties.POPUPSUPPRESSPREFS_CHKBOXTIP);
        this.popupSuppressChkBox.setToolTipText(toolTip);
        this.popupSuppressChkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupSuppressionPrefsPanel.this.setModified(true);
            }
        });
        center.add((Component)this.popupSuppressChkBox, gbc);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets.left = 0;
        center.add(Box.createHorizontalGlue(), gbc);
    }

    protected void populate(Preferences prefs) {
        String prop = this.getOwnerPrefix() + WebBean.POPUP_SUPPRESS_PREF;
        boolean suppress = prefs.getBooleanSetting(prop, true);
        this.popupSuppressChkBox.setSelected(suppress);
    }

    protected void apply(Preferences prefs) {
        String prop = this.getOwnerPrefix() + WebBean.POPUP_SUPPRESS_PREF;
        boolean suppress = this.popupSuppressChkBox.isSelected();
        prefs.setSetting(prop, suppress);
    }

    protected void reset(Preferences prefs) {
        String prop = this.getOwnerPrefix() + WebBean.POPUP_SUPPRESS_PREF;
        boolean suppress = true;
        prefs.setSetting(prop, suppress);
    }
}

