/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.online.module;

import com.elluminate.classroom.client.app.Application;
import com.elluminate.classroom.moduleloading.LoadingStatus;
import com.elluminate.classroom.moduleloading.LoadingStatusListener;
import com.elluminate.contentcapture.ContentCapture;
import com.elluminate.contentcapture.ContentCaptureProvider;
import com.elluminate.engine.ConferencingEngine;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.ActionFeatureEvent;
import com.elluminate.framework.feature.ActionFeatureListener;
import com.elluminate.framework.feature.ActionFeatureStatus;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.ComponentFeature;
import com.elluminate.framework.feature.ComponentProvider;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.feature.StringFeature;
import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.imps.ImpsAPI;
import com.elluminate.groupware.LabelProps;
import com.elluminate.groupware.imps.DisconnectQueryAPI;
import com.elluminate.groupware.imps.QuitQueryAPI;
import com.elluminate.groupware.module.ClientModule;
import com.elluminate.groupware.online.module.CallStatus;
import com.elluminate.groupware.online.module.Callers;
import com.elluminate.groupware.online.module.ConnectToSessionCmd;
import com.elluminate.groupware.online.module.ConnectionMonitor;
import com.elluminate.groupware.online.module.ConnectionPrefsPanel;
import com.elluminate.groupware.online.module.DisconnectFromSessionCmd;
import com.elluminate.groupware.online.module.LeavingPrefsPanel;
import com.elluminate.groupware.online.module.ProxyPrefsPanel;
import com.elluminate.groupware.online.module.StringsProperties;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.PreferencesPanelOwner;
import com.elluminate.gui.net.DlgProxyAuthDataProvider;
import com.elluminate.gui.net.SSLTargetQueryDlg;
import com.elluminate.gui.swing.DialogParentProvider;
import com.elluminate.jinx.Client;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.ConferenceName;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.ConnectionClass;
import com.elluminate.jinx.ConnectionEvent;
import com.elluminate.jinx.ConnectionListener;
import com.elluminate.jinx.Transceiver;
import com.elluminate.jinx.client.CallStatusEvent;
import com.elluminate.jinx.client.CallStatusListener;
import com.elluminate.jinx.client.Caller;
import com.elluminate.jinx.client.ClientAuthenticator;
import com.elluminate.jinx.client.OnlineClient;
import com.elluminate.jinx.client.SimpleClientAuthenticator;
import com.elluminate.jinx.provider.ConnectionProviderImpl;
import com.elluminate.net.EndpointCaller;
import com.elluminate.net.ProxyAuthDataProvider;
import com.elluminate.net.SSLTargetQuery;
import com.elluminate.util.ApplicationProperties;
import com.elluminate.util.ComponentRegistrar;
import com.elluminate.util.I18n;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.log.LogSupport;
import com.elluminate.util.log.Logger;
import com.elluminate.util.net.LaunchLink;
import com.elluminate.util.net.ProxyUtils;
import com.elluminate.util.net.URLString;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

@Singleton
public class OnlineModule
implements ClientModule,
ConnectionListener,
PreferencesPanelOwner {
    private String prefix = this.getClass().getName();
    private static final String JOIN_WITH_URI_PATH = "/online/joinWithURI";
    private static final String JOIN_PATH = "/online/join";
    private static final String LEAVE_PATH = "/online/leave";
    private static final String SECURE_PATH = "/online/secure";
    private static final String CONNECTION_TYPE_PATH = "/online/connectionType";
    private static final String MONITOR_PATH = "/online/monitor";
    private static final String SIGNAL_STRENGTH_PATH = "/online/signalStrength";
    private static final String CONNECTION_PREFS_PATH = "/online/connectionPrefs";
    private static final String LEAVING_PREFS_PATH = "/online/leavingPrefs";
    private static final String PROXY_PREFS_PATH = "/online/proxyPrefs";
    static final String PREF_CONNECTION_CLASS = ".connectionClass";
    static final String PREF_CONFIRM_LEAVING = ".confirmLeaving";
    static final String PREF_SPEED_PROMPT = ".speedPrompt";
    private static final String PREF_LAST_IP = ".lastIP";
    static final String ALWAYS_CMD = "always";
    static final String NEVER_CMD = "never";
    static final String IP_CMD = "IP";
    static final ConnectionClass DEFAULT_SPEED = ConnectionClass.BROADBAND;
    static final String DEFAULT_PROMPT = "IP";
    static final boolean DEFAULT_CONFIRM_LEAVING = true;
    private static final long BEST_CALL_TIMEOUT = 10000L;
    private static final long ANY_CALL_TIMEOUT = 30000L;
    private static final int WARN_TIMEOUT = 5000;
    private I18n i18n = I18n.create((Object)this);
    private Application application;
    ConnectionMonitor monitor;
    LightweightTimer signalStrengthTimer;
    volatile boolean recursive = false;
    boolean firstConnection = true;
    byte[] lastIP = null;
    ConferenceName conf = null;
    URLString url = null;
    URLString lastSessionUrl = null;
    OnlineClient client;
    ClientList clients = null;
    Logger logger;
    Caller reconnectCaller = null;
    ClientAuthenticator reconnectAuth = null;
    DlgProxyAuthDataProvider proxyAuthDlg;
    SSLTargetQueryDlg targetQuery;
    private volatile boolean okToJoin = true;
    private String user = null;
    private String auth = null;
    private Callers callerProvider;
    private FeatureBroker broker;
    private ActionFeature joinFeature;
    private ActionFeature leaveFeature;
    private BooleanFeature secureFeature;
    private StringFeature connectionTypeFeature;
    private ComponentFeature monitorFeature;
    private StringFeature signalStrengthFeature;
    private ComponentFeature connectionPrefsFeature;
    private ComponentFeature leavingPrefsFeature;
    private ComponentFeature proxyPrefsFeature;
    private ComponentFeature bandwidthSplashFeature;
    private ActionFeature joinURIFeature;
    private CompProv<ConnectionPrefsPanel> connectionPrefsProvider;
    private CompProv<LeavingPrefsPanel> leavingPrefsProvider;
    private CompProv<ProxyPrefsPanel> proxyPrefsProvider;
    private String sessionDesc;
    private String sessionTitle;
    private String moderatorLabel;
    private boolean dontAskStatus = false;
    private ConnectionProviderImpl connectionProvider;
    private ConferencingEngine confEngine;
    private Provider<ConnectToSessionCmd> connectCmdProvider;
    private Provider<DisconnectFromSessionCmd> disconnectCmdProvider;
    private Preferences preferences;
    private ContentCapture contentCapture;
    private DialogParentProvider parentProv;
    private Imps imps;
    private PropertyChangeListener prefsListener = new PreferenceChangeListener();
    private PropertyChangeListener labelsListener = new LabelChangeListener();
    private LoadingStatus loadingStatus;
    LoadingStatusListener readyStateListener = new OnlineLoadingStatusListener();

    @Inject
    public OnlineModule() {
    }

    @Inject
    protected void initVersionManager(ComponentRegistrar cr) {
        cr.registerComponent((Object)this);
    }

    @Inject
    public void initContentCapture(ContentCaptureProvider contentCaptureProvider) {
        this.contentCapture = contentCaptureProvider.get();
    }

    @Inject
    public void initPreferences(Preferences prefs) {
        this.preferences = prefs;
    }

    @Inject
    public void initConferencingEngine(ConferencingEngine ce) {
        this.confEngine = ce;
    }

    @Inject
    public void initConnectCmdProvider(Provider<ConnectToSessionCmd> cp) {
        this.connectCmdProvider = cp;
    }

    @Inject
    public void initDisconnectCmdProvider(Provider<DisconnectFromSessionCmd> cp) {
        this.disconnectCmdProvider = cp;
    }

    @Inject
    public void initDialogParent(DialogParentProvider prov) {
        this.parentProv = prov;
    }

    @Inject
    public void initFeatureBroker(FeatureBroker broker) {
        this.broker = broker;
    }

    @Inject
    public void initLogger(Logger logger) {
        this.logger = logger;
    }

    @Inject
    public void initLoadingStatus(LoadingStatus loadingStatus) {
        this.loadingStatus = loadingStatus;
    }

    @Inject
    public void initApplication(Application application) {
        this.application = application;
    }

    @Inject
    public void initPrefsPanels(Provider<ConnectionPrefsPanel> connectionPrefs, Provider<LeavingPrefsPanel> leavingPrefs, Provider<ProxyPrefsPanel> proxyPrefs) {
        this.connectionPrefsProvider = new CompProv<ConnectionPrefsPanel>(connectionPrefs);
        this.leavingPrefsProvider = new CompProv<LeavingPrefsPanel>(leavingPrefs);
        this.proxyPrefsProvider = new CompProv<ProxyPrefsPanel>(proxyPrefs);
    }

    @Inject
    public void initConnectionProvider(ConnectionProviderImpl cp) {
        this.connectionProvider = cp;
    }

    @Inject
    public void initApplicationProperties(ApplicationProperties props) {
        if (this.hasUrl(props)) {
            try {
                this.url = new URLString((String)props.get("url").get(0));
            }
            catch (Exception e) {
                throw new RuntimeException("bad url:" + props.get("URL"), e);
            }
        }
        if (props.get("user") != null) {
            this.user = (String)props.get("user").get(0);
            this.auth = (String)props.get("user").get(1);
        }
        if (this.hasLaunchLink(props)) {
            LaunchLink ll = null;
            try {
                String arg = (String)props.get("launchLink").get(0);
                ll = new LaunchLink(arg);
            }
            catch (LaunchLink.LaunchLinkParseException e) {
                LogSupport.exception((Object)this, (String)"initApplicationProperties", (Throwable)e, (boolean)false);
            }
            if (ll != null) {
                this.url = ll.getUrl();
                this.user = ll.getUser();
                this.auth = ll.getAuth();
            }
        }
    }

    private boolean hasUrl(ApplicationProperties props) {
        return props.get("url") != null && props.get("url").size() > 0 && props.get("url").get(0) != null && ((String)props.get("url").get(0)).length() > 0;
    }

    private boolean hasLaunchLink(ApplicationProperties props) {
        return props.get("launchLink") != null && props.get("launchLink").size() > 0 && props.get("launchLink").get(0) != null && ((String)props.get("launchLink").get(0)).length() > 0;
    }

    @Inject
    public void initCallers(Callers callers) {
        this.callerProvider = callers;
    }

    @Inject
    public void initIMPS(Imps imps) {
        this.imps = imps;
    }

    private byte doDisconnectQuery() {
        byte result = 0;
        List stakeholders = this.imps.findAll(DisconnectQueryAPI.class);
        if (stakeholders == null) {
            return result;
        }
        for (DisconnectQueryAPI query : stakeholders) {
            byte current = query.mayDisconnect();
            switch (current) {
                case -1: {
                    return current;
                }
                case 0: {
                    break;
                }
                case 1: {
                    result = current;
                }
            }
        }
        return result;
    }

    public void connectionStatusChanged(ConnectionEvent e) {
        if (e.getAction() == 3) {
            this.logger.message("Online Module: Disconnected.");
            if (e.getReason() == 3 || this.contentCapture.isCapturingData() && this.client.canRedial() && this.reconnectCaller != null) {
                this.rejoin();
            } else {
                this.recursive = true;
                switch (e.getReason()) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        ModalDialog.showMessageDialogAsync((int)-1, (Component)this.parentProv.getDialogParent(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_REMOVEDMSG, new Object[]{this.sessionDesc, this.moderatorLabel}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_REMOVEDTITLE), (int)0);
                        System.err.println("Remote connection hung up");
                        break;
                    }
                    default: {
                        ModalDialog.showMessageDialogAsync((int)-1, (Component)this.parentProv.getDialogParent(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_CONNECTIONLOSTMSG, new Object[]{this.sessionDesc}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_CONNECTIONLOSTTITLE), (int)0);
                    }
                }
                this.joinFeature.setEnabled(true);
                this.leaveFeature.setEnabled(false);
            }
        } else if (e.getAction() == 2) {
            this.joinFeature.setEnabled(false);
            this.leaveFeature.setEnabled(true);
            Transceiver tx = e.getTransceiver();
            if (tx.isSecure()) {
                this.secureFeature.setValue((Object)true);
                this.secureFeature.setDescription(tx.getCipher());
            } else {
                this.secureFeature.setValue((Object)false);
                this.secureFeature.setDescription(null);
            }
        }
    }

    public void start() {
        this.client = new OnlineClient();
        this.clients = this.client.getClientList();
        this.connectionProvider.initConnection((Connection)this.client);
        this.preferences.addSettingChangeListener(this.prefix + PREF_CONNECTION_CLASS, this.prefsListener);
        this.preferences.addSettingChangeListener(this.prefix + PREF_CONFIRM_LEAVING, this.prefsListener);
        this.confEngine.registerCommand(this.connectCmdProvider);
        this.confEngine.registerCommand(this.disconnectCmdProvider);
        this.clients.addPropertyChangeListener("Label.session", this.labelsListener);
        this.clients.addPropertyChangeListener("Label.Session", this.labelsListener);
        this.clients.addPropertyChangeListener("Label.moderator", this.labelsListener);
    }

    public void stop() {
        this.preferences.removeSettingChangeListener(this.prefix + PREF_CONNECTION_CLASS, this.prefsListener);
        this.preferences.removeSettingChangeListener(this.prefix + PREF_CONFIRM_LEAVING, this.prefsListener);
    }

    public void attach() {
        this.loadPreferences(this.prefix, this.preferences);
        this.sessionDesc = LabelProps.get(null, (String)"Label.session");
        this.sessionTitle = LabelProps.get(null, (String)"Label.Session");
        this.moderatorLabel = LabelProps.get(null, (String)"Label.moderator");
        this.monitor = new ConnectionMonitor(this.client);
        this.monitor.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_STATUSTOOLTIP));
        this.monitor.start();
        this.signalStrengthTimer = new LightweightTimer(2, new Runnable(){
            private final long TIMEOUT = 45000L;
            private final long EXCELLENT = 22500L;
            private final long GOOD = 33750L;
            private final long FAIR = 42750L;
            private final long LOW = 45000L;

            @Override
            public void run() {
                if (OnlineModule.this.signalStrengthFeature == null) {
                    return;
                }
                long delta = OnlineModule.this.client.getLastMessageInterval();
                if (!OnlineModule.this.client.isConnected()) {
                    OnlineModule.this.signalStrengthFeature.setValue((Object)OnlineModule.this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_SIGNALDISCONNECTED));
                } else if (delta < 22500L) {
                    OnlineModule.this.signalStrengthFeature.setValue((Object)OnlineModule.this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_SIGNALEXCELLENT));
                } else if (delta < 33750L) {
                    OnlineModule.this.signalStrengthFeature.setValue((Object)OnlineModule.this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_SIGNALGOOD));
                } else if (delta < 42750L) {
                    OnlineModule.this.signalStrengthFeature.setValue((Object)OnlineModule.this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_SIGNALFAIR));
                } else {
                    OnlineModule.this.signalStrengthFeature.setValue((Object)OnlineModule.this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_SIGNALLOW));
                }
            }
        });
        this.signalStrengthTimer.scheduleEvery(2000L);
        this.setQuitQueryAPI();
    }

    public void detach() {
        this.savePreferences(this.prefix, this.preferences);
        this.signalStrengthTimer.cancel();
    }

    public void setupUI() {
        this.proxyAuthDlg = new DlgProxyAuthDataProvider((Component)this.parentProv.getDialogParent());
        this.targetQuery = new SSLTargetQueryDlg((Component)this.parentProv.getDialogParent());
        EndpointCaller.setProxyAuthDataSource((ProxyAuthDataProvider)this.proxyAuthDlg);
        this.joinURIFeature = this.broker.createActionFeature((Object)this, JOIN_WITH_URI_PATH, "", "");
        this.joinURIFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                URI uri = (URI)event.getUserData();
                if (uri == null) {
                    OnlineModule.this.logger.error("null action userdata for joinURIFeature.");
                    return;
                }
                LaunchLink ll = null;
                try {
                    ll = new LaunchLink(uri);
                }
                catch (LaunchLink.LaunchLinkParseException e) {
                    OnlineModule.this.logger.exception((Object)this, "setupUI", (Throwable)e, false);
                    return;
                }
                OnlineModule.this.url = ll.getUrl();
                OnlineModule.this.user = ll.getUser();
                OnlineModule.this.auth = ll.getAuth();
                OnlineModule.this.logger.message("Joining via launch link....");
                OnlineModule.this.checkSpeedAndJoin();
            }
        });
        this.joinFeature = this.broker.createActionFeature((Object)this, JOIN_PATH, this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_JOINMENU, new Object[]{this.sessionTitle}), this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_JOINBTNTIP, new Object[]{this.sessionDesc}));
        this.joinFeature.setInteractive(this.user == null || this.auth == null);
        this.joinFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                OnlineModule.this.checkSpeedAndJoin();
                System.out.println("Joining......");
            }
        });
        this.leaveFeature = this.broker.createActionFeature((Object)this, LEAVE_PATH, this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_LEAVEMENU, new Object[]{this.sessionTitle}), this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_LEAVEBTNTIP, new Object[]{this.sessionDesc}));
        this.leaveFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                if (OnlineModule.this.leave(true)) {
                    event.setComplete(true);
                }
            }
        });
        this.secureFeature = this.broker.createBooleanFeature((Object)this, SECURE_PATH, false, false, "Secure", null);
        this.secureFeature.setFalseIcon(this.i18n.getImage("OnlineModule.nonSecureIcon"));
        this.secureFeature.setTrueIcon(this.i18n.getImage("OnlineModule.secureIcon"));
        this.secureFeature.setFalseText(this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_NOTSECURE));
        this.secureFeature.setTrueText(this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_SECURE));
        this.connectionTypeFeature = this.broker.createStringFeature((Object)this, CONNECTION_TYPE_PATH, false, this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_CONNECTIONTYPE, new Object[]{this.removeAmpersands(this.client.getConnectionClass().getMenuText())}), null, null);
        this.monitorFeature = this.broker.createComponentFeature((Object)this, MONITOR_PATH, (Component)this.monitor, "", "");
        this.signalStrengthFeature = this.broker.createStringFeature((Object)this, SIGNAL_STRENGTH_PATH, false, this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_SIGNALDISCONNECTED), null, null);
        this.connectionPrefsFeature = this.broker.createComponentFeature((Object)this, CONNECTION_PREFS_PATH, this.connectionPrefsProvider, "", "");
        this.leavingPrefsFeature = this.broker.createComponentFeature((Object)this, LEAVING_PREFS_PATH, this.leavingPrefsProvider, "", "");
        this.proxyPrefsFeature = this.broker.createComponentFeature((Object)this, PROXY_PREFS_PATH, this.proxyPrefsProvider, "", "");
        BandwidthPanel bandwithPanel = new BandwidthPanel();
        this.bandwidthSplashFeature = this.broker.createComponentFeature((Object)this, "/online/bandwithPanel", (Component)bandwithPanel, "", "");
        if (this.url != null) {
            this.broker.addFeature((Feature)this.joinFeature);
            this.broker.addFeature((Feature)this.leaveFeature);
        }
        this.broker.addFeature((Feature)this.joinURIFeature);
        this.joinURIFeature.setEnabled(true);
        this.broker.addFeature((Feature)this.secureFeature);
        this.broker.addFeature((Feature)this.connectionTypeFeature);
        this.broker.addFeature((Feature)this.monitorFeature);
        this.broker.addFeature((Feature)this.signalStrengthFeature);
        this.broker.addFeature((Feature)this.connectionPrefsFeature);
        this.broker.addFeature((Feature)this.leavingPrefsFeature);
        this.broker.addFeature((Feature)this.proxyPrefsFeature);
    }

    private String removeAmpersands(String text) {
        return text.replaceAll("&", "");
    }

    public void cleanupUI() {
        this.broker.removeFeature((Feature)this.joinFeature);
        this.broker.removeFeature((Feature)this.leaveFeature);
        this.broker.removeFeature((Feature)this.secureFeature);
        this.broker.removeFeature((Feature)this.connectionTypeFeature);
        this.broker.removeFeature((Feature)this.monitorFeature);
        this.broker.removeFeature((Feature)this.signalStrengthFeature);
        this.broker.removeFeature((Feature)this.connectionPrefsFeature);
        this.broker.removeFeature((Feature)this.leavingPrefsFeature);
        this.broker.removeFeature((Feature)this.proxyPrefsFeature);
    }

    public void sessionStart() {
        if (this.loadingStatus.isReady()) {
            this.joinFeature.setEnabled(true);
            if (this.okToJoin && this.url != null) {
                this.join();
            }
        } else {
            this.checkSpeed();
            this.loadingStatus.addListener(this.readyStateListener);
        }
    }

    public void sessionStop() {
        if (this.client == null) {
            return;
        }
        if (this.client.isConnected()) {
            this.client.removeConnectionListener((ConnectionListener)this);
            this.client.hangup();
        }
    }

    private void rejoin() {
        CallStatus status = null;
        final Caller[] callers = new Caller[1];
        String proto = this.url.getProtocol();
        if (proto.equals("http") || proto.equals("https")) {
            URLString sessionUrl = this.getSessionUrl(this.url);
            if (sessionUrl == null) {
                this.join(this.reconnectAuth, null, true);
                return;
            }
            if (!sessionUrl.equals((Object)this.lastSessionUrl)) {
                this.conf = new ConferenceName(sessionUrl.getName());
                this.join(this.reconnectAuth, sessionUrl, true);
                return;
            }
        }
        if (this.url != null) {
            ProxyUtils.setDestination((String)this.url.getHost(), (int)this.url.getPort());
        }
        callers[0] = (Caller)this.reconnectCaller.clone();
        status = CallStatus.showStatus(this.parentProv.getDialogParent(), this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_RECONNECTTITLE), this.lastSessionUrl, callers, (Client)this.client);
        this.proxyAuthDlg.setParent((Component)((Object)status));
        this.targetQuery.setParent((Component)((Object)status));
        class RedialWorker
        implements Runnable {
            CallStatus status;

            public RedialWorker(CallStatus status) {
                this.status = status;
            }

            @Override
            public void run() {
                OnlineModule.this.logger.message("Online Module: Attempting Reconnect.");
                try {
                    OnlineModule.this.client.redial((CallStatusListener)this.status, callers);
                    OnlineModule.this.logger.message("Online Module: Reconnected.");
                }
                catch (Exception ex) {
                    OnlineModule.this.logger.message("Online Module: Reconnect Failed.");
                    OnlineModule.this.connectionFailed(ex, this.status, true);
                }
            }
        }
        WorkerThread worker = new WorkerThread((Runnable)new RedialWorker(status));
        worker.start();
    }

    private void join() {
        this.join(null, null, true);
    }

    void join(ClientAuthenticator authenticator, URLString sessionUrl, boolean querySpeed) {
        if (this.client.isConnected()) {
            return;
        }
        boolean reconnect = authenticator != null;
        this.joinFeature.setEnabled(false);
        this.leaveFeature.setEnabled(false);
        if (authenticator == null) {
            authenticator = this.getAuthenticator();
        }
        this.client.addConnectionListener((ConnectionListener)this);
        if (sessionUrl == null && this.url != null) {
            String proto = this.url.getProtocol();
            if (proto.equals("http") || proto.equals("https")) {
                sessionUrl = this.getSessionUrl(this.url);
                if (sessionUrl == null) {
                    this.joinFeature.setEnabled(true);
                    return;
                }
                this.conf = new ConferenceName(sessionUrl.getName());
            } else {
                sessionUrl = this.url;
            }
        } else if (this.url == null) {
            this.url = sessionUrl;
        }
        ProxyUtils.setDestination((String)this.url.getHost(), (int)this.url.getPort());
        CallStatus status = new CallStatus();
        status.setClient((Client)this.client);
        Caller[] callers = this.callerProvider.getCallers();
        status = CallStatus.showStatus(this.parentProv.getDialogParent(), this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_CONNECTTITLE), sessionUrl, callers, (Client)this.client);
        this.proxyAuthDlg.setParent((Component)((Object)status));
        this.targetQuery.setParent((Component)((Object)status));
        class CallWorker
        implements Runnable {
            URLString url;
            Caller[] callers;
            CallStatus status;
            ClientAuthenticator auth;
            SSLTargetQuery query;
            boolean reconnect;

            public CallWorker(URLString url, Caller[] callers, CallStatus status, ClientAuthenticator auth, SSLTargetQuery query, boolean reconnect) {
                this.url = url;
                this.callers = callers;
                this.status = status;
                this.auth = auth;
                this.query = query;
                this.reconnect = reconnect;
            }

            @Override
            public void run() {
                try {
                    OnlineModule.this.reconnectCaller = OnlineModule.this.client.call(this.url, this.callers, 10000L, 30000L, (CallStatusListener)this.status, this.auth, this.query);
                    OnlineModule.this.lastSessionUrl = this.url;
                    OnlineModule.this.reconnectAuth = this.auth;
                }
                catch (Exception ex) {
                    OnlineModule.this.connectionFailed(ex, this.status, this.reconnect);
                }
            }
        }
        WorkerThread worker = new WorkerThread((Runnable)new CallWorker(sessionUrl, callers, status, authenticator, (SSLTargetQuery)this.targetQuery, reconnect));
        worker.start();
    }

    private ClientAuthenticator getAuthenticator() {
        if (this.user != null && this.auth != null) {
            return new SimpleClientAuthenticator(this.user, this.auth);
        }
        return new SimpleClientAuthenticator("Gemini", "test");
    }

    void connectionFailed(Exception ex, CallStatus status) {
        this.connectionFailed(ex, status, true);
    }

    void connectionFailed(Exception ex, CallStatus status, boolean reconnect) {
        int answer;
        String query = this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_CONNECTIONFAILEDQUERY, new Object[]{ex.getMessage()});
        this.proxyAuthDlg.abort();
        if (!this.contentCapture.isCapturingData()) {
            String title = reconnect ? this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_RECONNECTIONFAILEDTITLE) : this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_CONNECTIONFAILEDTITLE);
            status.callStatusChanged(new CallStatusEvent((Object)this, -1));
            answer = ModalDialog.showConfirmDialog((Component)this.parentProv.getDialogParent(), (Object)query, (String)title, (int)2, (int)0);
            status.hide();
        } else {
            answer = 0;
        }
        if (answer == 0) {
            if (reconnect) {
                this.rejoin();
            } else {
                this.join();
            }
        } else {
            this.reconnectCaller = null;
            this.joinFeature.setEnabled(true);
            this.leaveFeature.setEnabled(false);
        }
    }

    boolean isConnected() {
        return this.client != null && this.client.isConnected();
    }

    boolean leave(boolean confirmWithUser) {
        if (this.client.isConnected()) {
            if (confirmWithUser) {
                switch (this.doDisconnectQuery()) {
                    case -1: {
                        return false;
                    }
                    case 0: {
                        if (this.userOkaysLeavingConnection()) break;
                        return false;
                    }
                }
            }
            this.client.removeConnectionListener((ConnectionListener)this);
            this.client.hangup();
        }
        this.joinFeature.setEnabled(true);
        this.leaveFeature.setEnabled(false);
        this.secureFeature.setValue((Object)false);
        this.secureFeature.setDescription(null);
        return true;
    }

    private boolean userOkaysLeavingConnection() {
        if (this.dontAskStatus) {
            return true;
        }
        BorderLayout layout = new BorderLayout();
        JPanel panel = new JPanel(layout);
        JCheckBox dontAskAgainCheckBox = new JCheckBox(this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_DONTASKMETHISAGAIN));
        dontAskAgainCheckBox.setSelected(this.dontAskStatus);
        panel.add((Component)dontAskAgainCheckBox, "South");
        dontAskAgainCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                OnlineModule.this.dontAskStatus = true;
                String pName = OnlineModule.this.getPrefix() + OnlineModule.PREF_CONFIRM_LEAVING;
                OnlineModule.this.preferences.setSetting(pName, false);
            }
        });
        JLabel content = new JLabel();
        content.setText(this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_LEAVECONFIRMQUERY, new Object[]{this.sessionDesc}));
        content.setBackground(UIManager.getColor("Label.background"));
        content.setFocusable(false);
        content.setBorder(BorderFactory.createEmptyBorder(12, 6, 12, 64));
        panel.add((Component)content, "Center");
        int answer = ModalDialog.showConfirmDialog((Component)this.parentProv.getDialogParent(), (Object)panel, (String)this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_LEAVECONFIRMTITLE), (int)2, (int)3);
        return answer == 0;
    }

    private void preferenceChange(PropertyChangeEvent e) {
        String which;
        String prop = e.getPropertyName();
        if (prop.equals(this.getPrefix() + PREF_CONNECTION_CLASS) && (which = Preferences.stringValue((Object)e.getNewValue(), null)) != null) {
            ConnectionClass cls = ConnectionClass.getConnectionClass((String)which);
            if (cls == null) {
                try {
                    int bandwidth = Integer.parseInt(which);
                    cls = ConnectionClass.getConnectionClass((int)bandwidth);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (cls != null && this.client != null && cls != this.client.getConnectionClass()) {
                this.client.setConnectionClass(cls);
                if (this.connectionTypeFeature != null) {
                    this.connectionTypeFeature.setValue((Object)this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_CONNECTIONTYPE, new Object[]{this.removeAmpersands(cls.getMenuText())}));
                }
            }
        }
        if (prop.equals(this.getPrefix() + PREF_CONFIRM_LEAVING)) {
            boolean confirmLeavingPreference = Preferences.booleanValue((Object)e.getNewValue(), (boolean)true);
            this.dontAskStatus = !confirmLeavingPreference;
        }
    }

    private void labelChange(PropertyChangeEvent e) {
        Object value;
        String prop = e.getPropertyName();
        if (prop.equals("Label.session")) {
            Object value2 = e.getNewValue();
            if (value2 != null) {
                this.sessionDesc = (String)value2;
                this.joinFeature.setDescription(this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_JOINBTNTIP, new Object[]{this.sessionDesc}));
                this.leaveFeature.setDescription(this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_LEAVEBTNTIP, new Object[]{this.sessionDesc}));
            }
        } else if (prop.equals("Label.Session")) {
            Object value3 = e.getNewValue();
            if (value3 != null) {
                this.sessionTitle = (String)value3;
                this.joinFeature.setName(this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_JOINMENU, new Object[]{this.sessionTitle}));
                this.leaveFeature.setName(this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_LEAVEMENU, new Object[]{this.sessionTitle}));
            }
        } else if (prop.equals("Label.moderator") && (value = e.getNewValue()) != null) {
            this.moderatorLabel = (String)value;
        }
    }

    private void savePreferences(String prefix, Preferences preferences) {
        String pName = prefix + PREF_LAST_IP;
        try {
            InetAddress ip = InetAddress.getLocalHost();
            byte[] addr = ip.getAddress();
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < addr.length; ++i) {
                int comp = addr[i];
                if (buf.length() > 0) {
                    buf.append('.');
                }
                buf.append(comp &= 0xFF);
            }
            preferences.setSetting(pName, buf.toString());
        }
        catch (IOException ex) {
            // empty catch block
        }
        pName = this.getPrefix() + PREF_CONFIRM_LEAVING;
        preferences.setSetting(pName, !this.dontAskStatus);
    }

    private void loadPreferences(String prefix, Preferences preferences) {
        String pName2;
        String pName = prefix + PREF_CONNECTION_CLASS;
        String which = preferences.getSetting(pName);
        ConnectionClass cls = null;
        boolean hasConnectionClass = false;
        if (which == null && (which = preferences.getSetting(pName2 = "vclass.connectionClass")) != null) {
            preferences.clearSetting(pName2);
        }
        if (which != null) {
            hasConnectionClass = true;
            this.firstConnection = false;
            cls = ConnectionClass.getConnectionClass((String)which);
            if (cls == null) {
                try {
                    int bandwidth = Integer.parseInt(which);
                    cls = ConnectionClass.getConnectionClass((int)bandwidth);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        if (cls == null) {
            cls = DEFAULT_SPEED;
            preferences.setSetting(pName, cls.getBaseBandwidth());
        }
        this.client.setConnectionClass(cls);
        pName = prefix + PREF_SPEED_PROMPT;
        which = preferences.getSetting(pName);
        if (which == null) {
            preferences.setSetting(pName, "IP");
        }
        if ((which = preferences.getSetting(pName = prefix + PREF_LAST_IP)) != null) {
            StringTokenizer parser = new StringTokenizer(which, ".");
            byte[] addr = new byte[4];
            int len = 0;
            while (parser.hasMoreTokens()) {
                String token = parser.nextToken();
                int value = Integer.parseInt(token);
                if (len == addr.length) {
                    byte[] newAddr = new byte[len * 2];
                    for (int i = 0; i < len; ++i) {
                        newAddr[i] = addr[i];
                    }
                    addr = newAddr;
                }
                addr[len++] = (byte)value;
            }
            if (len != addr.length) {
                byte[] newAddr = new byte[len];
                for (int i = 0; i < len; ++i) {
                    newAddr[i] = addr[i];
                }
                addr = newAddr;
            }
            this.lastIP = addr;
        } else if (hasConnectionClass) {
            try {
                InetAddress ip = InetAddress.getLocalHost();
                this.lastIP = ip.getAddress();
            }
            catch (IOException ex) {
                this.lastIP = null;
            }
        }
        pName = prefix + PREF_CONFIRM_LEAVING;
        boolean confirmLeavingPreference = preferences.getBooleanSetting(pName, true);
        this.dontAskStatus = !confirmLeavingPreference;
        String proxyOverride = preferences.getSetting("classroom.proxy");
        if (proxyOverride != null) {
            try {
                URLString proxyUrl = new URLString(proxyOverride);
                ProxyUtils.applyProxy((URLString)proxyUrl);
            }
            catch (Throwable t) {
                this.logger.error((Object)this, "loadPreferences", "Invalid proxy preference: '" + proxyOverride + "' - " + t);
            }
        } else {
            ProxyUtils.applyProxy(null);
        }
    }

    private void checkSpeedAndJoin() {
        if (!this.checkSpeed()) {
            this.join();
        }
    }

    private boolean checkSpeed() {
        String cmd = null;
        cmd = this.preferences.getSetting(this.getPrefix() + PREF_SPEED_PROMPT);
        boolean ask = false;
        if (cmd == null) {
            ask = true;
        } else if (cmd.equals(ALWAYS_CMD)) {
            ask = true;
        } else if (cmd.equals("IP")) {
            try {
                InetAddress ip = InetAddress.getLocalHost();
                byte[] curIP = ip.getAddress();
                if (!Arrays.equals(this.lastIP, curIP)) {
                    this.lastIP = curIP;
                    ask = true;
                }
            }
            catch (UnknownHostException ex) {
                ask = true;
            }
        }
        if (ask) {
            this.loadingStatus.increment();
            this.broker.setFeaturePublished((Feature)this.bandwidthSplashFeature, true);
        }
        return ask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URLString getSessionUrl(URLString mgrUrlStr) {
        String warn;
        String fail;
        URLString sessionUrl;
        block25: {
            URL mgrUrl;
            sessionUrl = null;
            try {
                mgrUrl = new URL(mgrUrlStr.toString());
            }
            catch (MalformedURLException mux) {
                this.logger.exception((Object)this, "getSessionUrl", (Throwable)mux, true);
                return null;
            }
            InputStream istr = null;
            fail = null;
            warn = null;
            String line = null;
            try {
                URLConnection connection = mgrUrl.openConnection();
                String enc = connection.getContentEncoding();
                int code = 200;
                String msg = null;
                if (connection instanceof HttpURLConnection) {
                    HttpURLConnection httpConnection = (HttpURLConnection)connection;
                    code = httpConnection.getResponseCode();
                    msg = httpConnection.getResponseMessage();
                }
                if (code == 200) {
                    InputStreamReader reader;
                    istr = connection.getInputStream();
                    try {
                        reader = enc != null ? new InputStreamReader(istr, enc) : new InputStreamReader(istr);
                    }
                    catch (UnsupportedEncodingException uex) {
                        reader = new InputStreamReader(istr);
                    }
                    BufferedReader buf = new BufferedReader(reader);
                    line = buf.readLine();
                    sessionUrl = new URLString(line);
                    break block25;
                }
                String response = code + " " + msg;
                warn = this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_INDIRECTGETFAILEDWARN, new Object[]{response});
                fail = this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_INDIRECTGETFAILEDFAIL, new Object[]{response});
            }
            catch (MalformedURLException mux) {
                warn = this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_INDIRECTRESPONSEBADURLWARN, new Object[]{line});
                fail = this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_INDIRECTRESPONSEBADURLFAIL, new Object[]{line});
            }
            catch (IOException iox) {
                warn = this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_INDIRECTGETFAILEDWARN, new Object[]{iox.toString()});
                fail = this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_INDIRECTGETFAILEDFAIL, new Object[]{iox.toString()});
            }
            finally {
                if (istr != null) {
                    try {
                        istr.close();
                    }
                    catch (Throwable t) {}
                }
            }
        }
        if (sessionUrl == null) {
            String title;
            String msg;
            if (this.lastSessionUrl != null) {
                sessionUrl = this.lastSessionUrl;
                msg = warn;
                title = this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_INDIRECTFALLBACKTITLE);
            } else {
                msg = fail;
                title = this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_INDIRECTERRORTITLE);
            }
            ModalDialog.showMessageDialogTimeout((int)5000, (Component)this.parentProv.getDialogParent(), (Object)msg, (String)title, (int)2);
        }
        return sessionUrl;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getTitle() {
        return this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_TITLE);
    }

    public Icon getIcon() {
        return this.i18n.getIcon((PropertiesEnum)StringsProperties.ONLINEMODULE_ICON);
    }

    private void setQuitQueryAPI() {
        QuitQueryAPI quitQueryAPI = new QuitQueryAPI(){

            public String getProvider() {
                return OnlineModule.this.getTitle();
            }

            public byte getTier() {
                return 32;
            }

            public boolean canQuit() {
                if (!OnlineModule.this.isConnected()) {
                    return true;
                }
                if (OnlineModule.this.leaveFeature != null && OnlineModule.this.leaveFeature.isEnabled()) {
                    ActionFeatureStatus status = OnlineModule.this.leaveFeature.fireActionFeatureListeners();
                    return status.isSuccessful();
                }
                if (OnlineModule.this.joinFeature != null) {
                    return OnlineModule.this.joinFeature.isEnabled();
                }
                return false;
            }
        };
        this.imps.provideAPI(QuitQueryAPI.class, (ImpsAPI)quitQueryAPI);
    }

    private class BandwidthPanel
    extends JPanel {
        public BandwidthPanel() {
            this.setLayout(new GridBagLayout());
            this.setOpaque(false);
            this.setPreferredSize(new Dimension(150, 150));
            this.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
            this.setAlignmentX(0.0f);
            String prompt = OnlineModule.this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_SPEEDPROMPT);
            JLabel label = new JLabel(prompt);
            label.setOpaque(false);
            label.setFont(UIManager.getFont("Splash.fontLabel"));
            label.setForeground(UIManager.getColor("Splash.fontLabel_color"));
            final JComboBox<String> spd = new JComboBox<String>();
            for (int i = 0; i < ConnectionClass.values.length; ++i) {
                ConnectionClass cls = ConnectionClass.values[i];
                String nm = cls.toString();
                spd.addItem(nm);
                if (cls != OnlineModule.this.client.getConnectionClass()) continue;
                spd.setSelectedItem(nm);
            }
            final JCheckBox dontAsk = new JCheckBox();
            dontAsk.setText(OnlineModule.this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_DONTASK));
            dontAsk.setSelected(false);
            dontAsk.setOpaque(false);
            dontAsk.setFont(UIManager.getFont("Splash.fontLabel"));
            dontAsk.setForeground(UIManager.getColor("Splash.fontLabel_color"));
            JPanel buttonPanel = new JPanel();
            buttonPanel.setOpaque(false);
            JButton ok = new JButton(OnlineModule.this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_BANDWIDTHPANEL_OKBUTTON));
            JButton cancel = new JButton(OnlineModule.this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_BANDWIDTHPANEL_CANCELBUTTON));
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String sel = (String)spd.getSelectedItem();
                    ConnectionClass cls = ConnectionClass.getConnectionClass((String)sel);
                    if (cls != OnlineModule.this.client.getConnectionClass()) {
                        OnlineModule.this.preferences.setSetting(OnlineModule.this.getPrefix() + OnlineModule.PREF_CONNECTION_CLASS, Integer.toString(cls.getBaseBandwidth()));
                        OnlineModule.this.client.setConnectionClass(cls);
                    }
                    if (dontAsk.isSelected()) {
                        OnlineModule.this.preferences.setSetting(OnlineModule.this.getPrefix() + OnlineModule.PREF_SPEED_PROMPT, OnlineModule.NEVER_CMD);
                    }
                    OnlineModule.this.broker.setFeaturePublished((Feature)OnlineModule.this.bandwidthSplashFeature, false);
                    OnlineModule.this.loadingStatus.decrement();
                }
            });
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OnlineModule.this.okToJoin = false;
                    OnlineModule.this.broker.setFeaturePublished((Feature)OnlineModule.this.bandwidthSplashFeature, false);
                    OnlineModule.this.loadingStatus.decrement();
                    OnlineModule.this.application.doShutdown();
                }
            });
            buttonPanel.add(cancel);
            buttonPanel.add(ok);
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.gridx = 0;
            c.gridy = 0;
            this.add((Component)label, c);
            c.gridx = 0;
            c.gridy = 1;
            this.add(spd, c);
            c.gridx = 0;
            c.gridy = 2;
            this.add((Component)dontAsk, c);
            c.gridx = 0;
            c.gridy = 3;
            this.add((Component)buttonPanel, c);
        }
    }

    class CompProv<T extends Component>
    implements ComponentProvider {
        Provider<T> provider;

        public CompProv(Provider<T> prov) {
            this.provider = prov;
        }

        public Component get(ComponentFeature f) {
            return (Component)this.provider.get();
        }
    }

    private class LabelChangeListener
    implements PropertyChangeListener {
        private LabelChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            OnlineModule.this.labelChange(e);
        }
    }

    private class OnlineLoadingStatusListener
    implements LoadingStatusListener {
        private OnlineLoadingStatusListener() {
        }

        public void onStatusChange(LoadingStatus statusSource, String entityName) {
            OnlineModule.this.loadingStatus.removeListener((LoadingStatusListener)this);
            OnlineModule.this.joinFeature.setEnabled(true);
            if (OnlineModule.this.okToJoin && OnlineModule.this.url != null) {
                OnlineModule.this.join();
            }
        }
    }

    private class PreferenceChangeListener
    implements PropertyChangeListener {
        private PreferenceChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            OnlineModule.this.preferenceChange(e);
        }
    }
}

