/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.online.module;

import com.elluminate.groupware.online.module.StringsProperties;
import com.elluminate.gui.component.AbstractPreferencesPanel;
import com.elluminate.gui.component.PreferencesPanelOwner;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class LeavingPrefsPanel
extends AbstractPreferencesPanel {
    private I18n i18n;
    private JCheckBox confirmLeavingCheckBox;

    @Inject
    public LeavingPrefsPanel(PreferencesPanelOwner owner, I18n i18n) {
        super(owner, i18n.getString((PropertiesEnum)StringsProperties.LEAVINGPREFSPANEL_TITLE));
        this.i18n = i18n;
    }

    protected void createContent() {
        this.setLayout(new BorderLayout());
        JPanel p = new JPanel(new GridBagLayout());
        this.add(p, "North");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.weightx = 100.0;
        this.confirmLeavingCheckBox = new JCheckBox(this.i18n.getString((PropertiesEnum)StringsProperties.LEAVINGPREFSPANEL_CONFIRMLEAVING));
        this.confirmLeavingCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LeavingPrefsPanel.this.setModified(true);
            }
        });
        p.add((Component)this.confirmLeavingCheckBox, gbc);
    }

    protected void populate(Preferences preferences) {
        String prefix = this.getOwnerPrefix();
        String pName = prefix + ".confirmLeaving";
        boolean confirmLeavingPreference = preferences.getBooleanSetting(pName, true);
        this.confirmLeavingCheckBox.setSelected(confirmLeavingPreference);
    }

    protected void apply(Preferences preferences) {
        String prefix = this.getOwnerPrefix();
        String pName = prefix + ".confirmLeaving";
        boolean confirmLeaving = this.confirmLeavingCheckBox.isSelected();
        preferences.setSetting(pName, confirmLeaving);
    }

    protected void reset(Preferences preferences) {
        String prefix = this.getOwnerPrefix();
        String pName = prefix + ".confirmLeaving";
        boolean confirmLeavingPreference = preferences.getBooleanSetting(pName, true);
        preferences.setSetting(pName, confirmLeavingPreference);
    }
}

