/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.online.module;

import com.elluminate.engine.CommandContextException;
import com.elluminate.engine.CommandExecutionException;
import com.elluminate.engine.CommandParameterException;
import com.elluminate.engine.command.AbstractCommand;
import com.elluminate.engine.command.ConnectToSessionCommand;
import com.elluminate.groupware.online.module.OnlineModule;
import com.elluminate.groupware.online.module.StringsProperties;
import com.elluminate.jinx.ConnectionClass;
import com.elluminate.jinx.client.ClientAuthenticator;
import com.elluminate.jinx.client.SimpleClientAuthenticator;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.net.URLString;
import com.google.inject.Inject;
import java.net.MalformedURLException;
import java.util.HashMap;

public class ConnectToSessionCmd
extends AbstractCommand
implements ConnectToSessionCommand {
    private HashMap<String, ConnectionClass> speeds = new HashMap();
    private String sessionURL;
    private String userName;
    private char[] password;
    private String connectionSpeed;
    @Inject
    private I18n i18n;
    @Inject
    private OnlineModule module;

    public ConnectToSessionCmd() {
        this.speeds.put("dialup28k", ConnectionClass.DIALUP_28K);
        this.speeds.put("dialup33k", ConnectionClass.DIALUP_33K);
        this.speeds.put("dialup56k", ConnectionClass.DIALUP_56K);
        this.speeds.put("isdn", ConnectionClass.ISDN);
        this.speeds.put("broadband", ConnectionClass.BROADBAND);
        this.speeds.put("lan", ConnectionClass.LAN);
    }

    public void setSessionURL(String sessionURL) {
        this.sessionURL = sessionURL;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(char[] password) {
        this.password = password;
    }

    public String[] getAvailableConnectionSpeeds() {
        return new String[]{"dialup28k", "dialup33k", "dialup56k", "isdn", "broadband", "lan"};
    }

    public void setConnectionSpeed(String connectionSpeed) {
        this.connectionSpeed = connectionSpeed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doexecute() throws CommandExecutionException {
        try {
            URLString url;
            if (this.sessionURL == null || this.sessionURL.length() == 0) {
                throw new CommandParameterException("No session URL provided", this.i18n.getString((PropertiesEnum)StringsProperties.CONNECTTOSESSIONCMD_BADPARAMSESSIONURLNOTSET));
            }
            if (this.userName == null || this.userName.length() == 0) {
                throw new CommandParameterException("No user name provided", this.i18n.getString((PropertiesEnum)StringsProperties.CONNECTTOSESSIONCMD_BADPARAMUSERNAMENOTSET));
            }
            if (this.password == null || this.password.length == 0) {
                throw new CommandParameterException("No password provided", this.i18n.getString((PropertiesEnum)StringsProperties.CONNECTTOSESSIONCMD_BADPARAMPASSWORDNOTSET));
            }
            ConnectionClass speed = null;
            if (this.connectionSpeed != null) {
                speed = this.speeds.get(this.connectionSpeed);
            }
            if (speed == null) {
                throw new CommandParameterException("No connection speed provided", this.i18n.getString((PropertiesEnum)StringsProperties.CONNECTTOSESSIONCMD_BADPARAMCONNECTIONSPEEDNOTSET));
            }
            try {
                url = new URLString(this.sessionURL);
            }
            catch (MalformedURLException ex) {
                throw new CommandParameterException(ex.getMessage(), this.i18n.getString((PropertiesEnum)StringsProperties.CONNECTTOSESSIONCMD_BADPARAMINVALIDSESSIONURL, new Object[]{this.sessionURL}));
            }
            OnlineModule mod = this.module;
            if (mod.isConnected()) {
                throw new CommandContextException("The client is already connected to a session", this.i18n.getString((PropertiesEnum)StringsProperties.CONNECTTOSESSIONCMD_BADCONTEXTALREADYCONNECTED));
            }
            mod.client.setConnectionClass(speed);
            SimpleClientAuthenticator auth = new SimpleClientAuthenticator(this.userName, new String(this.password));
            mod.join((ClientAuthenticator)auth, url, false);
            if (this.password == null) return;
        }
        catch (Throwable throwable) {
            if (this.password == null) throw throwable;
            for (int i = 0; i < this.password.length; ++i) {
                this.password[i] = '\u0000';
            }
            throw throwable;
        }
        for (int i = 0; i < this.password.length; ++i) {
            this.password[i] = '\u0000';
        }
        return;
    }
}

