/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.online.module;

import com.elluminate.groupware.online.module.OnlineModule;
import com.elluminate.groupware.online.module.StringsProperties;
import com.elluminate.gui.component.AbstractPreferencesPanel;
import com.elluminate.gui.component.PreferencesPanelOwner;
import com.elluminate.jinx.ConnectionClass;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ConnectionPrefsPanel
extends AbstractPreferencesPanel {
    private I18n i18n;
    private JComboBox speedPopup;
    private JComboBox promptPopup;
    private HashMap<String, String> promptActions = new HashMap();

    @Inject
    public ConnectionPrefsPanel(PreferencesPanelOwner owner, I18n i18n) {
        super(owner, i18n.getString((PropertiesEnum)StringsProperties.CONNECTIONPREFSPANEL_TITLE));
        this.i18n = i18n;
    }

    protected void createContent() {
        this.setLayout(new BorderLayout());
        JPanel p = new JPanel(new GridBagLayout());
        this.add(p, "North");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.gridy = 0;
        gbc.insets.top = 0;
        gbc.insets.left = 0;
        p.add((Component)new JLabel(this.i18n.getString((PropertiesEnum)StringsProperties.CONNECTIONPREFSPANEL_SPEEDLABEL)), gbc);
        gbc.insets.left = 6;
        this.speedPopup = new JComboBox();
        for (int i = 0; i < ConnectionClass.values.length; ++i) {
            ConnectionClass cls = ConnectionClass.values[i];
            this.speedPopup.addItem(cls.toString());
            if (cls != OnlineModule.DEFAULT_SPEED) continue;
            this.speedPopup.setSelectedIndex(i);
        }
        p.add((Component)this.speedPopup, gbc);
        gbc.gridy = 1;
        gbc.insets.top = 6;
        gbc.insets.left = 0;
        p.add((Component)new JLabel(this.i18n.getString((PropertiesEnum)StringsProperties.CONNECTIONPREFSPANEL_PROMPTLABEL)), gbc);
        gbc.insets.left = 6;
        this.promptPopup = new JComboBox();
        String text = this.i18n.getString((PropertiesEnum)StringsProperties.CONNECTIONPREFSPANEL_PROMPTALWAYS);
        this.promptPopup.addItem(text);
        this.promptActions.put(text, "always");
        text = this.i18n.getString((PropertiesEnum)StringsProperties.CONNECTIONPREFSPANEL_PROMPTNEVER);
        this.promptPopup.addItem(text);
        this.promptActions.put(text, "never");
        text = this.i18n.getString((PropertiesEnum)StringsProperties.CONNECTIONPREFSPANEL_PROMPTIP);
        this.promptPopup.addItem(text);
        this.promptActions.put(text, "IP");
        this.promptPopup.setSelectedIndex(this.promptPopup.getItemCount() - 1);
        p.add((Component)this.promptPopup, gbc);
        gbc.fill = 2;
        gbc.weightx = 100.0;
        p.add(Box.createHorizontalGlue(), gbc);
        this.speedPopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectionPrefsPanel.this.doSpeedPopup();
            }
        });
        this.promptPopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectionPrefsPanel.this.doPromptPopup();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populate(Preferences preferences) {
        int i;
        String prefix = this.getOwnerPrefix();
        String pName = prefix + ".connectionClass";
        String which = preferences.getSetting(pName);
        ConnectionClass cls = null;
        if (which != null && (cls = ConnectionClass.getConnectionClass((String)which)) == null) {
            try {
                int bandwidth = Integer.parseInt(which);
                cls = ConnectionClass.getConnectionClass((int)bandwidth);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (cls == null) {
            cls = OnlineModule.DEFAULT_SPEED;
        }
        which = cls.toString();
        JComboBox jComboBox = this.speedPopup;
        synchronized (jComboBox) {
            for (i = 0; i < this.speedPopup.getItemCount(); ++i) {
                if (!which.equals(this.speedPopup.getItemAt(i))) continue;
                this.speedPopup.setSelectedIndex(i);
                break;
            }
        }
        pName = prefix + ".speedPrompt";
        which = preferences.getSetting(pName);
        if (which != null) {
            jComboBox = this.promptPopup;
            synchronized (jComboBox) {
                for (i = 0; i < this.promptPopup.getItemCount(); ++i) {
                    String text = (String)this.promptPopup.getItemAt(i);
                    if (!which.equals(this.promptActions.get(text))) continue;
                    this.promptPopup.setSelectedIndex(i);
                    break;
                }
            }
        }
    }

    protected void apply(Preferences preferences) {
        String prefix = this.getOwnerPrefix();
        String which = (String)this.speedPopup.getSelectedItem();
        ConnectionClass cls = ConnectionClass.getConnectionClass((String)which);
        if (cls == null) {
            cls = OnlineModule.DEFAULT_SPEED;
        }
        preferences.setSetting(prefix + ".connectionClass", Integer.toString(cls.getBaseBandwidth()));
        String text = (String)this.promptPopup.getSelectedItem();
        String action = this.promptActions.get(text);
        preferences.setSetting(prefix + ".speedPrompt", action);
    }

    protected void reset(Preferences preferences) {
        String prefix = this.getOwnerPrefix();
        preferences.setSetting(prefix + ".connectionClass", Integer.toString(OnlineModule.DEFAULT_SPEED.getBaseBandwidth()));
        preferences.setSetting(prefix + ".speedPrompt", "IP");
    }

    private void doSpeedPopup() {
        this.setModified(true);
    }

    private void doPromptPopup() {
        this.setModified(true);
    }
}

