/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.online.module;

import com.elluminate.extra.ExTRA;
import com.elluminate.jinx.client.Caller;
import com.elluminate.util.ApplicationProperties;
import com.elluminate.util.log.Logger;
import com.elluminate.util.net.ProxyUtils;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;

@Singleton
public class Callers {
    public static final String PREFIX = "callers.";
    public static final String SPEC_ARG = "callers";
    public static final String DIRECT_EXP_SPEC = ",80,443,//http:route=direct,80//http:route=direct";
    public static final String DIRECT_IMP_SPEC = ",80,443,//http:route=direct,80//http:route=direct";
    public static final String HTTP_EXP_SPEC = ",80,443";
    public static final String HTTP_IMP_SPEC = "//direct,80//direct,443//direct,//,80,443";
    public static final String HTTPS_EXP_SPEC = ",443";
    public static final String HTTPS_IMP_SPEC = "//direct,80//direct,443//direct,//,443";
    public static final String SOCKS_EXP_SPEC = ",80,443";
    public static final String SOCKS_IMP_SPEC = "//direct,80//direct,443//direct,//,80,443";
    private CallerInfo[] specs = new CallerInfo[]{new CallerInfo("direct", '+', ",80,443,//http:route=direct,80//http:route=direct"), new CallerInfo("direct", '-', ",80,443,//http:route=direct,80//http:route=direct"), new CallerInfo("http", '+', ",80,443"), new CallerInfo("http", '-', "//direct,80//direct,443//direct,//,80,443"), new CallerInfo("https", '+', ",443"), new CallerInfo("https", '-', "//direct,80//direct,443//direct,//,443"), new CallerInfo("socks", '+', ",80,443"), new CallerInfo("socks", '-', "//direct,80//direct,443//direct,//,80,443")};
    private String callerSpec = "*";

    @Inject
    public Callers(ApplicationProperties props, Logger logger) {
        try {
            for (CallerInfo ci : this.specs) {
                ci.check(props);
            }
            if (props.containsKey(SPEC_ARG)) {
                List values = props.get(SPEC_ARG);
                this.callerSpec = (String)values.get(values.size() - 1);
            }
        }
        catch (IllegalArgumentException iax) {
            logger.error(iax.getMessage());
            ExTRA.exit((int)1);
        }
    }

    public String getDefaultSpec() {
        String dftCallerSpec = null;
        String current = ProxyUtils.getCurrentProxyType();
        boolean override = ProxyUtils.isOverride();
        for (CallerInfo ci : this.specs) {
            dftCallerSpec = ci.get(current, override);
            if (dftCallerSpec == null) continue;
            return dftCallerSpec;
        }
        return null;
    }

    public Caller[] getCallers() {
        return Caller.getCallers((String)this.callerSpec, (Caller[])Caller.getCallers((String)this.getDefaultSpec(), null));
    }

    class CallerInfo {
        String proto;
        char mod;
        String spec;
        boolean exp;

        public CallerInfo(String proto, char mod, String spec) {
            this.proto = proto;
            this.mod = mod;
            this.spec = spec;
            this.exp = mod == '+';
        }

        public void check(ApplicationProperties props) {
            List values = null;
            String arg = Callers.PREFIX + this.proto + this.mod;
            values = props.get(arg);
            if (values == null) {
                arg = Callers.PREFIX + this.proto;
                values = props.get(Callers.PREFIX + this.proto);
            }
            if (values != null) {
                if (values.size() != 1) {
                    throw new IllegalArgumentException("Only one instance of -" + arg + " is allowed.");
                }
                this.spec = (String)values.get(0);
            }
        }

        public String get(String forProto, boolean isOverride) {
            if (isOverride == this.exp && this.proto.equals(forProto)) {
                return this.spec;
            }
            return null;
        }
    }
}

