/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.online.module;

import com.elluminate.groupware.online.OnlineDebug;
import com.elluminate.gui.FontUtils;
import com.elluminate.jinx.client.Caller;
import com.elluminate.util.I18n;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class CallerStatus
extends JPanel
implements PropertyChangeListener {
    Caller theCaller = null;
    GridBagLayout layout = new GridBagLayout();
    JLabel icon = new JLabel();
    ImageIcon okIcon;
    ImageIcon failIcon;
    ImageIcon[] working = new ImageIcon[4];
    JProgressBar status = new JProgressBar();
    JLabel target = new JLabel();
    int workAnim = 0;
    long startTime = 0L;
    boolean done = false;

    public CallerStatus(Caller caller) {
        this.theCaller = caller;
        caller.addPropertyChangeListener("state", (PropertyChangeListener)this);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"CallerStatus", (Throwable)ex, (boolean)true);
        }
    }

    private void jbInit() throws Exception {
        I18n i18n = I18n.create((Object)this);
        this.okIcon = i18n.getIcon("CallerStatus.okIcon");
        this.failIcon = i18n.getIcon("CallerStatus.failIcon");
        this.working[0] = i18n.getIcon("CallerStatus.work1Icon");
        this.working[1] = i18n.getIcon("CallerStatus.work2Icon");
        this.working[2] = i18n.getIcon("CallerStatus.work3Icon");
        this.working[3] = this.working[1];
        this.setLayout(this.layout);
        this.icon.setIcon(this.working[this.workAnim]);
        this.target.setFont(FontUtils.setFontStyleAndSize((Font)this.getFont(), (int)0, (int)11));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 15;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.gridheight = 2;
        gbc.weightx = 0.0;
        gbc.insets.right = 6;
        this.add((Component)this.icon, gbc);
        gbc.gridx = 1;
        gbc.gridheight = 1;
        gbc.weightx = 100.0;
        gbc.insets.right = 0;
        this.add((Component)this.target, gbc);
        gbc.gridy = 1;
        this.add((Component)this.status, gbc);
        this.target.setText(this.theCaller.getTarget());
    }

    public void setStart(long start) {
        this.startTime = start;
    }

    public boolean tick() {
        if (this.done) {
            return true;
        }
        if (this.theCaller.isDone()) {
            if (this.theCaller.getEndpoint() == null) {
                this.icon.setIcon(this.failIcon);
            } else {
                this.icon.setIcon(this.okIcon);
            }
            this.status.setMaximum(1);
            this.status.setValue(1);
            this.setToolTipText(this.stringToHTML(this.theCaller.toString()));
            this.theCaller.removePropertyChangeListener("state", (PropertyChangeListener)this);
            this.done = true;
        } else {
            long timeout;
            long value = System.currentTimeMillis() - this.startTime;
            if (value > (timeout = this.theCaller.getTimeout())) {
                value = timeout;
            }
            this.status.setMaximum((int)timeout);
            this.status.setValue((int)value);
            this.workAnim = (this.workAnim + 1) % this.working.length;
            this.icon.setIcon(this.working[this.workAnim]);
        }
        this.target.setText(this.theCaller.getTarget());
        return this.done;
    }

    public Caller getCaller() {
        return this.theCaller;
    }

    public boolean isConnected() {
        return this.theCaller.isDone() && this.theCaller.getEndpoint() != null;
    }

    private String stringToHTML(String txt) {
        int idx;
        StringBuffer buf = new StringBuffer();
        int offset = 0;
        buf.append("<html><head/><body>");
        while ((idx = txt.indexOf(10, offset)) >= 0) {
            buf.append(txt.substring(offset, idx));
            buf.append("<br>");
            offset = idx + 1;
        }
        buf.append(txt.substring(offset));
        buf.append("</body></html>");
        return buf.toString();
    }

    @Override
    public void propertyChange(final PropertyChangeEvent evt) {
        if (OnlineDebug.ONLINE.show()) {
            String state = (String)evt.getNewValue();
            System.out.println(this.theCaller.getTarget() + " -> " + state);
        }
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                String state = (String)evt.getNewValue();
                if (state == "working") {
                    CallerStatus.this.target.setText(CallerStatus.this.theCaller.getTarget());
                }
            }
        });
    }
}

