/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.feature.hints;

import com.elluminate.framework.feature.hints.EnumElement;
import com.elluminate.framework.feature.hints.HintTypeList;
import com.elluminate.framework.feature.hints.TypedElement;
import com.elluminate.framework.feature.hints.XmlElement;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ListElement
extends TypedElement {
    public static final String ELEMENT_NAME = "List";
    private TypedElement parent;

    public ListElement() {
        super(ELEMENT_NAME);
    }

    @Override
    protected void enter(XmlElement parent, Attributes attrs) throws SAXException {
        this.parent = (TypedElement)parent;
        this.parseType(attrs);
    }

    @Override
    protected void leave() throws SAXException {
        if (this.type == null) {
            throw new SAXException("No member type defined for list.");
        }
        this.parent.setType(new HintTypeList(this.type));
    }

    @Override
    public void reset() {
        this.parent = null;
        this.type = null;
        this.setType(null);
    }

    @Override
    public void validateChild(XmlElement child) throws SAXException {
        if (this.getType() != null) {
            throw new SAXException("A List may not have both a type attribute and child elements.");
        }
        if (child instanceof EnumElement) {
            return;
        }
        throw new SAXException("Unsupported element '" + child.getName() + "' in the context of " + ELEMENT_NAME);
    }
}

