/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.feature.hints;

import com.elluminate.framework.feature.hints.Configuration;
import com.elluminate.framework.feature.hints.HintReader;
import com.elluminate.framework.feature.hints.Hintable;
import com.elluminate.framework.feature.hints.Hints;
import com.elluminate.util.I18n;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.SAXException;

@Singleton
public class HintingEngine {
    public static final String HINT_DEFS_NAME = "HintDefs.xml";
    private Map<String, Hints> hintMap = new HashMap<String, Hints>();
    private Map<Package, HintReader> packages = new HashMap<Package, HintReader>();
    private Configuration config;
    private Provider<HintReader> hintReaderProvider;
    private I18n configI18n;

    @Inject
    public void initConfiguration(Configuration cfg) {
        this.config = cfg;
    }

    @Inject
    public void initHintReaderProvider(Provider<HintReader> prov) {
        this.hintReaderProvider = prov;
    }

    public void configure(Class<?> owner) throws SAXException {
        if (owner != null) {
            this.configure(owner.getResourceAsStream(HINT_DEFS_NAME), I18n.create(owner));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(URL configUrl, I18n i18n) throws IOException, SAXException {
        if (configUrl != null) {
            InputStream urlStream = null;
            this.configI18n = i18n;
            try {
                urlStream = configUrl.openStream();
                this.configure(urlStream, i18n);
            }
            finally {
                try {
                    if (urlStream != null) {
                        urlStream.close();
                    }
                }
                catch (Throwable t) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(File configFile, I18n i18n) throws IOException, SAXException {
        if (configFile != null) {
            FileInputStream fis = null;
            this.configI18n = i18n;
            try {
                fis = new FileInputStream(configFile);
                this.configure(fis, i18n);
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Throwable t) {}
            }
        }
    }

    public void configure(InputStream configStream, I18n i18n) throws SAXException {
        InputStreamReader reader = new InputStreamReader(configStream);
        this.configure(reader, i18n);
    }

    public void configure(Reader configReader, I18n i18n) throws SAXException {
        this.config.parse(configReader);
        this.configI18n = i18n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hint(Hintable h) {
        Hints hints;
        if (!this.config.isValid()) {
            return;
        }
        String path = h.getPath();
        HintReader reader = null;
        Object owner = h.getOwner();
        Map<String, Hints> map = this.hintMap;
        synchronized (map) {
            hints = this.hintMap.get(path);
            if (hints == null) {
                if (owner == null) {
                    return;
                }
                Class<?> cls = owner.getClass();
                Package pkg = cls.getPackage();
                if (this.packages.containsKey(pkg)) {
                    reader = this.packages.get(pkg);
                } else {
                    reader = (HintReader)this.hintReaderProvider.get();
                    this.packages.put(pkg, reader);
                }
            }
        }
        if (hints == null && reader != null) {
            reader.initConfigI18n(this.configI18n);
            hints = reader.getHints(owner, path, this.hintMap);
        }
        if (hints != null) {
            hints.apply(h);
        }
    }
}

