/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.feature.hints;

import com.elluminate.framework.feature.hints.HintLocalizer;
import com.elluminate.framework.feature.hints.HintType;
import com.elluminate.framework.feature.hints.LocalizationContext;
import org.xml.sax.SAXException;

public class HintTypeInteger
extends HintType {
    public static final String MIN_ARG = "min";
    public static final String MAX_ARG = "max";
    private int minValue = Integer.MIN_VALUE;
    private int maxValue = Integer.MAX_VALUE;

    public HintTypeInteger setMinValue(int min) {
        this.minValue = min;
        return this;
    }

    public HintTypeInteger setMaxValue(int max) {
        this.maxValue = max;
        return this;
    }

    @Override
    public Object validate(String value, LocalizationContext ctxt, HintLocalizer localizer) {
        int v;
        if (ctxt != LocalizationContext.NONE) {
            return null;
        }
        try {
            v = Integer.parseInt(value);
        }
        catch (Throwable t) {
            return null;
        }
        if (v < this.minValue) {
            return false;
        }
        if (v > this.maxValue) {
            return false;
        }
        return v;
    }

    public String toString() {
        if (this.minValue == Integer.MIN_VALUE && this.maxValue == Integer.MAX_VALUE) {
            return "integer";
        }
        StringBuilder msg = new StringBuilder("integer");
        msg.append("(");
        msg.append(this.minValue);
        msg.append("..");
        msg.append(this.maxValue);
        msg.append(")");
        return msg.toString();
    }

    @Override
    public boolean processTypeArg(String name, String value) throws SAXException {
        if (MIN_ARG.equals(name)) {
            try {
                this.minValue = Integer.parseInt(value);
            }
            catch (Throwable t) {
                throw new SAXException("Invalid value for min attribute '" + value + "'");
            }
            if (this.minValue >= this.maxValue) {
                throw new SAXException("Invalid value for min attribute - min must be less than max");
            }
            return true;
        }
        if (MAX_ARG.equals(name)) {
            try {
                this.maxValue = Integer.parseInt(value);
            }
            catch (Throwable t) {
                throw new SAXException("Invalid value for max attribute '" + value + "'");
            }
            if (this.minValue >= this.maxValue) {
                throw new SAXException("Invalid value for max attribute - min must be less than max");
            }
            return true;
        }
        return false;
    }
}

