/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.feature.hints;

import com.elluminate.framework.feature.hints.FeatureElement;
import com.elluminate.framework.feature.hints.HintDefRegistry;
import com.elluminate.framework.feature.hints.HintElement;
import com.elluminate.framework.feature.hints.HintLocalizer;
import com.elluminate.framework.feature.hints.Hints;
import com.elluminate.framework.feature.hints.HintsElement;
import com.elluminate.framework.feature.hints.XmlParser;
import com.elluminate.util.I18n;
import com.elluminate.util.log.Logger;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.xml.sax.SAXException;

public class HintReader {
    private Map<String, Hints> localMap = null;
    private Map<String, Hints> starMap = null;
    private HintDefRegistry definitionRegistry;
    private Provider<XmlParser> parserProvider;
    private State state = State.IDLE;
    private Logger logger;
    private Object lock = new Object();
    private I18n configI18n;
    private I18n packageI18n;

    @Inject
    public void initDefinitionRegistry(HintDefRegistry reg) {
        this.definitionRegistry = reg;
    }

    @Inject
    public void initParserProvider(Provider<XmlParser> prov) {
        this.parserProvider = prov;
    }

    @Inject
    public void initLogger(Logger logger) {
        this.logger = logger;
    }

    public void initConfigI18n(I18n i18n) {
        this.configI18n = i18n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPackageHints(Class<?> cls, Map<String, Hints> map) throws SAXException {
        String configName = this.definitionRegistry.getConfigurationName();
        if (configName == null) {
            return;
        }
        Package pkg = cls.getPackage();
        String rsrc = "/" + pkg.getName().replace('.', '/') + '/' + configName + "_hints.xml";
        InputStream istr = cls.getResourceAsStream(rsrc);
        if (istr == null) {
            return;
        }
        InputStreamReader reader = new InputStreamReader(istr);
        this.packageI18n = I18n.create(cls);
        this.localMap = this.parseHints(reader);
        Iterator<String> i = this.localMap.keySet().iterator();
        while (i.hasNext()) {
            String path = i.next();
            if (!path.endsWith("*")) continue;
            Hints hints = this.localMap.get(path);
            i.remove();
            path = path.substring(0, path.length() - 1);
            if (this.starMap == null) {
                this.starMap = new TreeMap<String, Hints>();
            }
            this.starMap.put(path, hints);
        }
        if (this.starMap != null) {
            for (String path : this.localMap.keySet()) {
                Hints pathHints = null;
                Hints starHints = null;
                for (String star : this.starMap.keySet()) {
                    if (!path.startsWith(star)) continue;
                    if (starHints == null) {
                        starHints = new Hints();
                    }
                    starHints.add(this.starMap.get(star));
                }
                if (starHints == null) continue;
                pathHints = this.localMap.get(path);
                pathHints.addIfMissing(starHints);
            }
        }
        if (map != null) {
            Map<String, Hints> map2 = map;
            synchronized (map2) {
                map.putAll(this.localMap);
            }
        }
    }

    Map<String, Hints> parseHints(Reader reader) throws SAXException {
        XmlParser parser = (XmlParser)this.parserProvider.get();
        HintsElement hintsElement = new HintsElement();
        HintLocalizer localizer = new HintLocalizer(this.configI18n, this.packageI18n);
        parser.addElementType(hintsElement);
        parser.addElementType(new FeatureElement());
        parser.addElementType(new HintElement(this.definitionRegistry, localizer));
        parser.parse(reader);
        return hintsElement.getHintMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hints getHints(Object owner, String path, Map<String, Hints> hintMap) {
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                case IDLE: {
                    this.state = State.READING;
                    break;
                }
                case READING: {
                    while (this.state == State.READING) {
                        try {
                            this.lock.wait();
                        }
                        catch (InterruptedException ix) {}
                    }
                    return this.getHintsFor(path, hintMap);
                }
                case FINISHED: {
                    return this.getHintsFor(path, hintMap);
                }
            }
        }
        Hints hints = null;
        try {
            this.loadPackageHints(owner.getClass(), hintMap);
        }
        catch (SAXException sx) {
            this.logger.exception((Object)this, "getHints", (Throwable)sx, true);
        }
        finally {
            Object object2 = this.lock;
            synchronized (object2) {
                this.state = State.FINISHED;
                this.lock.notifyAll();
                hints = this.getHintsFor(path, hintMap);
            }
        }
        return hints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hints getHintsFor(String path, Map<String, Hints> map) {
        Hints hints = null;
        if (this.localMap != null) {
            hints = this.localMap.get(path);
        }
        if (hints != null) {
            return hints;
        }
        if (this.starMap != null) {
            for (String star : this.starMap.keySet()) {
                if (!path.startsWith(star)) continue;
                if (hints == null) {
                    hints = new Hints();
                }
                hints.add(this.starMap.get(star));
            }
        }
        if (hints != null) {
            Map<String, Hints> map2 = map;
            synchronized (map2) {
                map.put(path, hints);
            }
        }
        return hints;
    }

    static enum State {
        IDLE,
        READING,
        FINISHED;

    }
}

