/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.feature.hints;

import com.elluminate.framework.feature.hints.HintEnum;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class HintEnumSet {
    private String name;
    private Map<String, HintEnum> byName = new HashMap<String, HintEnum>();
    private Map<Integer, HintEnum> byOrdinal = new TreeMap<Integer, HintEnum>();

    HintEnumSet(String name, List<HintEnum> values) {
        this.name = name;
        HintEnum last = null;
        boolean outOfOrder = false;
        boolean hasOrdinals = true;
        int span = 0;
        int initial = 1;
        for (HintEnum v : values) {
            if (v.hasOrdinal()) {
                if (last == null) {
                    last = v;
                    initial = v.getOrdinal() - span;
                    continue;
                }
                if (last.getOrdinal() + span >= v.getOrdinal()) {
                    outOfOrder = true;
                    continue;
                }
                last = v;
                span = 0;
                continue;
            }
            hasOrdinals = false;
            ++span;
        }
        if (hasOrdinals) {
            for (HintEnum v : values) {
                String vName = v.toString();
                Integer vOrd = v.getOrdinal();
                if (this.byName.containsKey(vName)) {
                    throw new IllegalArgumentException("Duplicate enumeration value name '" + vName + "'");
                }
                if (this.byOrdinal.containsKey(vOrd)) {
                    throw new IllegalArgumentException("Duplicate enumeration value ordinal '" + vOrd + "'");
                }
                this.byName.put(vName, v);
                this.byOrdinal.put(vOrd, v);
                v.setEnumeration(this);
            }
        } else if (outOfOrder) {
            for (HintEnum v : values) {
                if (!v.hasOrdinal()) continue;
                String vName = v.toString();
                Integer vOrd = v.getOrdinal();
                if (this.byName.containsKey(vName)) {
                    throw new IllegalArgumentException("Duplicate enumeration value name '" + vName + "'");
                }
                if (this.byOrdinal.containsKey(vOrd)) {
                    throw new IllegalArgumentException("Duplicate enumeration value ordinal '" + vOrd + "'");
                }
                v.setEnumeration(this);
                this.byName.put(vName, v);
                this.byOrdinal.put(vOrd, v);
            }
            int ordinal = 1;
            for (HintEnum v : values) {
                if (v.hasOrdinal()) continue;
                String vName = v.toString();
                if (this.byName.containsKey(vName)) {
                    throw new IllegalArgumentException("Duplicate enumeration value name '" + vName + "'");
                }
                while (this.byOrdinal.containsKey(ordinal)) {
                    ++ordinal;
                }
                v.setOrdinal(ordinal++);
                v.setEnumeration(this);
                this.byName.put(vName, v);
                this.byOrdinal.put(v.getOrdinal(), v);
            }
        } else {
            int ordinal = initial;
            for (HintEnum v : values) {
                if (v.hasOrdinal()) {
                    ordinal = v.getOrdinal() + 1;
                } else {
                    v.setOrdinal(ordinal++);
                }
                v.setEnumeration(this);
                String vName = v.toString();
                if (this.byName.containsKey(vName)) {
                    throw new IllegalArgumentException("Duplicate enumeration value name '" + vName + "'");
                }
                this.byName.put(vName, v);
                this.byOrdinal.put(v.getOrdinal(), v);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public HintEnum get(String name) {
        return this.byName.get(name);
    }

    public HintEnum get(int ordinal) {
        return this.byOrdinal.get(ordinal);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.name);
        int sep = 91;
        for (HintEnum value : this.byOrdinal.values()) {
            builder.append((char)sep);
            builder.append(value.toString());
            builder.append('(');
            builder.append(value.getOrdinal());
            builder.append(')');
            sep = 44;
        }
        builder.append(']');
        return builder.toString();
    }
}

