/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.feature.hints;

import com.elluminate.framework.feature.hints.FeatureElement;
import com.elluminate.framework.feature.hints.Hint;
import com.elluminate.framework.feature.hints.HintDef;
import com.elluminate.framework.feature.hints.HintDefRegistry;
import com.elluminate.framework.feature.hints.HintLocalizer;
import com.elluminate.framework.feature.hints.LocalizationContext;
import com.elluminate.framework.feature.hints.XmlElement;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class HintElement
extends XmlElement {
    public static final String ELEMENT_NAME = "Hint";
    public static final String NAME_ATTR = "name";
    public static final String VALUE_ATTR = "value";
    public static final String CONFIG_RSRC_ATTR = "configRsrc";
    public static final String FEATURE_RSRC_ATTR = "featureRsrc";
    private HintDefRegistry registry;
    private HintLocalizer localizer;
    private FeatureElement parent = null;
    private String name = null;
    private Object value = null;

    public HintElement(HintDefRegistry reg, HintLocalizer loc) {
        super(ELEMENT_NAME, false);
        this.registry = reg;
        this.localizer = loc;
    }

    @Override
    protected void enter(XmlElement outer, Attributes attrs) throws SAXException {
        String valueString = null;
        String configResource = null;
        String packageResource = null;
        int nValues = 0;
        LocalizationContext lContext = LocalizationContext.NONE;
        this.parent = (FeatureElement)outer;
        for (int i = 0; i < attrs.getLength(); ++i) {
            String nm = attrs.getLocalName(i);
            String val = attrs.getValue(i);
            if (NAME_ATTR.equals(nm)) {
                this.name = val;
                continue;
            }
            if (VALUE_ATTR.equals(nm)) {
                valueString = val;
                lContext = LocalizationContext.NONE;
                ++nValues;
                continue;
            }
            if (CONFIG_RSRC_ATTR.equals(nm)) {
                configResource = val;
                lContext = LocalizationContext.CONFIG;
                ++nValues;
                continue;
            }
            if (FEATURE_RSRC_ATTR.equals(nm)) {
                packageResource = val;
                lContext = LocalizationContext.FEATURE;
                ++nValues;
                continue;
            }
            throw new SAXException("Unknown attribute '" + nm + "' in " + ELEMENT_NAME);
        }
        if (this.name == null) {
            throw new SAXException("One of name attribute on Hint element.");
        }
        HintDef hint = this.registry.getHintDefinition(this.name);
        if (hint == null) {
            throw new SAXException("Undefined hint '" + this.name + "'");
        }
        if (this.parent.getHint(this.name) != null) {
            throw new SAXException("Duplicate hint '" + this.name + "' for feature '" + this.parent.getPath() + "'");
        }
        switch (hint.getType().getLocalization()) {
            case NONE: {
                if (valueString == null) {
                    throw new SAXException("Missing value attribute on Hint element.");
                }
                if (configResource == null && packageResource == null) break;
                throw new SAXException("Localization is not supported for hint " + this.name + " of type " + hint.getType());
            }
            case ALLOWED: {
                if (nValues == 0) {
                    throw new SAXException("One of value, configRsrc, or featureRsrc attributes is required for hint " + this.name);
                }
                if (nValues <= 1) break;
                throw new SAXException("Only one of value, configRsrc, or featureRsrc attributes is allowed for hint " + this.name);
            }
            case REQUIRED: {
                if (valueString != null) {
                    throw new SAXException("Localization is required for hint " + this.name + ".  Use " + CONFIG_RSRC_ATTR + " or " + FEATURE_RSRC_ATTR + " instead of " + VALUE_ATTR);
                }
                if (nValues == 0) {
                    throw new SAXException("One of configRsrc or featureRsrc attributes is required for hint " + this.name);
                }
                if (nValues <= 1) break;
                throw new SAXException("Only one of configRsrc or featureRsrc attributes is allowed for hint " + this.name);
            }
        }
        switch (lContext) {
            case FEATURE: {
                valueString = packageResource;
                break;
            }
            case CONFIG: {
                valueString = configResource;
            }
        }
        this.value = hint.checkValue(valueString, lContext, this.localizer);
        if (this.value == null) {
            throw new SAXException("The value '" + valueString + "' is not valid for hint '" + this.name + "'");
        }
    }

    @Override
    protected void leave() throws SAXException {
        this.parent.addHint(new Hint(this.name, this.value));
    }

    @Override
    public void reset() {
        this.parent = null;
        this.name = null;
        this.value = null;
    }
}

