/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.feature.hints;

import com.elluminate.framework.feature.hints.EnumDefElement;
import com.elluminate.framework.feature.hints.HintDef;
import com.elluminate.framework.feature.hints.HintDefElement;
import com.elluminate.framework.feature.hints.HintEnumRegistry;
import com.elluminate.framework.feature.hints.HintEnumSet;
import com.elluminate.framework.feature.hints.XmlElement;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class HintDefsElement
extends XmlElement
implements HintEnumRegistry {
    public static final String ELEMENT_NAME = "HintDefs";
    public static final String CONFIG_NAME_ATTR = "configurationName";
    private String cfgName = null;
    private Map<String, HintEnumSet> enums = new HashMap<String, HintEnumSet>();
    private Map<String, HintDef> defs = new HashMap<String, HintDef>();

    public HintDefsElement() {
        super(ELEMENT_NAME, true);
    }

    @Override
    protected void enter(XmlElement outer, Attributes attrs) throws SAXException {
        for (int i = 0; i < attrs.getLength(); ++i) {
            String nm = attrs.getLocalName(i);
            String val = attrs.getValue(i);
            if (!CONFIG_NAME_ATTR.equals(nm)) {
                throw new SAXException("Unknown attribute '" + nm + "' on " + ELEMENT_NAME);
            }
            this.cfgName = val;
        }
        if (this.cfgName == null) {
            throw new SAXException("Missing configurationName attribute on HintDefs element.");
        }
    }

    @Override
    protected void leave() throws SAXException {
    }

    @Override
    public void reset() {
        this.cfgName = null;
        this.enums.clear();
        this.defs.clear();
    }

    @Override
    public void validateChild(XmlElement child) throws SAXException {
        if (child instanceof EnumDefElement) {
            return;
        }
        if (child instanceof HintDefElement) {
            return;
        }
        throw new SAXException("Invalid element '" + child.getName() + "' in the context of a <" + this.getName() + ">");
    }

    @Override
    public HintEnumSet getEnum(String name) {
        return this.enums.get(name);
    }

    @Override
    public void addEnum(HintEnumSet enm) {
        this.enums.put(enm.getName(), enm);
    }

    public void addHintDef(HintDef def) {
        this.defs.put(def.getName(), def);
    }

    public String getConfigurationName() {
        return this.cfgName;
    }

    public Map<String, HintDef> getDefinitions() {
        return this.defs;
    }
}

