/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.feature.hints;

import com.elluminate.framework.feature.hints.EnumValueElement;
import com.elluminate.framework.feature.hints.HintEnum;
import com.elluminate.framework.feature.hints.HintEnumRegistry;
import com.elluminate.framework.feature.hints.HintEnumSet;
import com.elluminate.framework.feature.hints.XmlElement;
import java.util.LinkedList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class EnumDefElement
extends XmlElement {
    public static String ELEMENT_NAME = "EnumDef";
    public static String NAME_ATTR = "name";
    private HintEnumRegistry registry;
    private String name = null;
    private List<HintEnum> values = new LinkedList<HintEnum>();

    public EnumDefElement(HintEnumRegistry reg) {
        super(ELEMENT_NAME, false);
        this.registry = reg;
    }

    @Override
    public void validateChild(XmlElement child) throws SAXException {
        if (child instanceof EnumValueElement) {
            return;
        }
        throw new SAXException("Unsupported element '" + child.getName() + "' in the context of " + ELEMENT_NAME);
    }

    @Override
    protected void enter(XmlElement outer, Attributes attrs) throws SAXException {
        for (int i = 0; i < attrs.getLength(); ++i) {
            String nm = attrs.getLocalName(i);
            String val = attrs.getValue(i);
            if (!nm.equals(NAME_ATTR)) {
                throw new SAXException("Unknown attribute '" + nm + "' on " + ELEMENT_NAME);
            }
            this.name = val;
        }
        if (this.name == null) {
            throw new SAXException("Missing " + NAME_ATTR + " attribute on " + ELEMENT_NAME + " element.");
        }
        if (this.registry.getEnum(this.name) != null) {
            throw new SAXException("Duplicate " + ELEMENT_NAME + ": '" + this.name + "'");
        }
    }

    @Override
    protected void leave() throws SAXException {
        if (this.values.isEmpty()) {
            throw new SAXException("No values defined for enum '" + this.name + "'");
        }
        if (this.values.size() == 1) {
            throw new SAXException("Only 1 value defined for enum '" + this.name + "': " + this.values.get(0).getName());
        }
        this.registry.addEnum(new HintEnumSet(this.name, this.values));
    }

    @Override
    public void reset() {
        this.name = null;
        this.values.clear();
    }

    public HintEnum getValue(String name) {
        for (HintEnum value : this.values) {
            if (!name.equals(value.getName())) continue;
            return value;
        }
        return null;
    }

    public HintEnum getValue(int ord) {
        for (HintEnum value : this.values) {
            if (!value.hasOrdinal() || value.getOrdinal() != ord) continue;
            return value;
        }
        return null;
    }

    public void addValue(HintEnum value) {
        this.values.add(value);
    }
}

