/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.feature.hints;

import com.elluminate.framework.feature.hints.EnumDefElement;
import com.elluminate.framework.feature.hints.EnumElement;
import com.elluminate.framework.feature.hints.EnumValueElement;
import com.elluminate.framework.feature.hints.HintDef;
import com.elluminate.framework.feature.hints.HintDefElement;
import com.elluminate.framework.feature.hints.HintDefRegistry;
import com.elluminate.framework.feature.hints.HintDefsElement;
import com.elluminate.framework.feature.hints.ListElement;
import com.elluminate.framework.feature.hints.SetElement;
import com.elluminate.framework.feature.hints.XmlParser;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.SAXException;

@Singleton
public class Configuration
implements HintDefRegistry {
    private String name = null;
    private Map<String, HintDef> defs = new HashMap<String, HintDef>();
    private Object lock = new Object();
    private Provider<XmlParser> parserProvider;

    @Inject
    public void initParserProvider(Provider<XmlParser> prov) {
        this.parserProvider = prov;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(Reader configReader) throws SAXException {
        Object object = this.lock;
        synchronized (object) {
            if (this.name != null) {
                throw new IllegalStateException("Hint definitions are already configured.");
            }
            XmlParser parser = (XmlParser)this.parserProvider.get();
            HintDefsElement defsElement = new HintDefsElement();
            parser.addElementType(defsElement);
            parser.addElementType(new EnumDefElement(defsElement));
            parser.addElementType(new EnumValueElement());
            parser.addElementType(new HintDefElement());
            parser.addElementType(new SetElement());
            parser.addElementType(new ListElement());
            parser.addElementType(new EnumElement(defsElement));
            parser.parse(configReader);
            this.name = defsElement.getConfigurationName();
            this.defs = defsElement.getDefinitions();
        }
    }

    public boolean isValid() {
        return this.name != null;
    }

    @Override
    public String getConfigurationName() {
        return this.name;
    }

    @Override
    public HintDef getHintDefinition(String name) {
        return this.defs.get(name);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("HintDefs(");
        builder.append(this.defs.size());
        builder.append(" definitions)\n");
        for (HintDef def : this.defs.values()) {
            builder.append("  ");
            builder.append(def);
            builder.append("\n");
        }
        return builder.toString();
    }
}

