/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.feature;

import com.elluminate.framework.feature.ValueFeature;
import java.awt.Image;

public class NumericFeature<T extends Comparable<T>>
extends ValueFeature<T> {
    public static final String MINIMUM_VALUE = "NumericFeature.minValue";
    public static final String MAXIMUM_VALUE = "NumericFeature.maxValue";
    public static final String DEFAULT_ICON = "NumericFeature.defaultIcon";

    public NumericFeature() {
        this.initMetaDatumType(DEFAULT_ICON, Image.class);
    }

    public T getMinimumValue() {
        return (T)((Comparable)this.getMetaDatumAs(this.getValueType(), MINIMUM_VALUE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinimumValue(T minVal) {
        Object object = this.lock;
        synchronized (object) {
            this.setMetaDatum(MINIMUM_VALUE, minVal);
            Comparable val = (Comparable)this.getValue();
            if (minVal != null && val != null && minVal.compareTo((Comparable)val) > 0) {
                this.setValue(minVal);
            }
        }
    }

    public T getMaximumValue() {
        return (T)((Comparable)this.getMetaDatumAs(this.getValueType(), MAXIMUM_VALUE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumValue(T maxVal) {
        Object object = this.lock;
        synchronized (object) {
            this.setMetaDatum(MAXIMUM_VALUE, maxVal);
            Comparable val = (Comparable)this.getValue();
            if (maxVal != null && val != null && maxVal.compareTo((Comparable)val) < 0) {
                this.setValue(maxVal);
            }
        }
    }

    public boolean isInRange(T value) {
        if (value == null) {
            return true;
        }
        T min = this.getMinimumValue();
        T max = this.getMaximumValue();
        if (min != null && min.compareTo(value) > 0) {
            return false;
        }
        return max == null || max.compareTo(value) >= 0;
    }

    @Override
    protected void validateMetaDatumAssignment(String key, Object value) {
        Comparable typedValue;
        super.validateMetaDatumAssignment(key, value);
        if ("ValueFeature.value".equals(key) && !this.isInRange(typedValue = (Comparable)value)) {
            throw new IllegalArgumentException("Value is outside range: " + this.getMinimumValue() + " <= " + typedValue + " <= " + this.getMaximumValue());
        }
    }

    public void setDefaultIcon(Image icon) {
        this.setMetaDatum(DEFAULT_ICON, icon);
    }

    public Image getDefaultIcon() {
        return this.getMetaDatumAs(Image.class, DEFAULT_ICON);
    }
}

