/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.feature;

import com.elluminate.util.ApplicationProperties;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

@Singleton
public class LocationWhitelist {
    public static final String WHITELIST_URL_ARG = "whitelistUrl";
    private List<String> rules;

    @Inject
    public void initAppArguments(ApplicationProperties args) throws IOException {
        if (!args.containsKey(WHITELIST_URL_ARG)) {
            return;
        }
        this.loadFromUrl((String)args.get(WHITELIST_URL_ARG).get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadWhiteListFrom(InputStream in) throws IOException {
        try {
            BufferedReader r = null;
            ArrayList<String> rules = new ArrayList<String>();
            r = new BufferedReader(new InputStreamReader(in));
            String line = r.readLine();
            while (line != null) {
                if (!this.isComment(line)) {
                    rules.add(line);
                }
                line = r.readLine();
            }
            r.close();
            this.rules = rules;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {
                throw new RuntimeException("could not close stream", e);
            }
        }
    }

    private boolean isComment(String line) {
        return line.startsWith("#");
    }

    public void setWhileListRules(List<String> rules) {
        this.rules = rules;
    }

    public void loadFromUrl(String url) throws IOException {
        try {
            this.loadWhiteListFrom(new URL(url).openStream());
        }
        catch (IOException ex) {
            throw new RuntimeException("could not load from " + url, ex);
        }
    }

    public boolean checkLocation(String location) {
        if (!this.hasWhiteList()) {
            return true;
        }
        for (String rule : this.rules) {
            if (!this.check(rule, location)) continue;
            return true;
        }
        return false;
    }

    private boolean check(String rule, String location) {
        if (rule.equals(location)) {
            return true;
        }
        if (rule.endsWith("*")) {
            return location.startsWith(rule.substring(0, rule.length() - 1));
        }
        return false;
    }

    private boolean hasWhiteList() {
        return this.rules != null;
    }
}

