/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.feature;

import com.elluminate.contentcapture.ContentCaptureProvider;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.ActionParameterDescriptor;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.ComponentFeature;
import com.elluminate.framework.feature.ComponentProvider;
import com.elluminate.framework.feature.EnumeratedFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureDirectory;
import com.elluminate.framework.feature.FeatureFactory;
import com.elluminate.framework.feature.FeaturePathSupport;
import com.elluminate.framework.feature.FeaturePublicationListener;
import com.elluminate.framework.feature.ListFeature;
import com.elluminate.framework.feature.LoadFeature;
import com.elluminate.framework.feature.Notification;
import com.elluminate.framework.feature.NotificationFactory;
import com.elluminate.framework.feature.NotificationListener;
import com.elluminate.framework.feature.NumericFeature;
import com.elluminate.framework.feature.StringFeature;
import com.elluminate.framework.feature.ValueFeature;
import com.elluminate.util.event.FiringFunctor;
import com.elluminate.util.event.ListenerRegistry;
import com.elluminate.util.event.ThrowableListener;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.Component;
import java.util.Collection;

@Singleton
public class FeatureBroker {
    private FeatureFactory featureFactory;
    private FeatureDirectory root = null;
    private FeaturePathSupport pathSupport;
    private ContentCaptureProvider contentCaptureProvider;
    private NotificationFactory notificationFactory;
    private ListenerRegistry<NotificationListener> notifyListeners;

    @Inject
    public void initRoot(FeatureDirectory root) {
        if (this.root != null) {
            throw new IllegalStateException("ROOT already set");
        }
        root.initPath("/");
        this.root = root;
    }

    @Inject
    public void initFeatureFactory(FeatureFactory featureFactory) {
        if (this.featureFactory != null) {
            throw new IllegalStateException("featureFactory already initialized");
        }
        this.featureFactory = featureFactory;
    }

    @Inject
    public void initNotificationFactory(NotificationFactory notificationFactory) {
        if (this.notificationFactory != null) {
            throw new IllegalStateException("notificationFactory already initialized");
        }
        this.notificationFactory = notificationFactory;
    }

    @Inject
    public void initPathSupport(FeaturePathSupport pathSupport) {
        if (this.pathSupport != null) {
            throw new IllegalStateException("pathSupport already initialized");
        }
        this.pathSupport = pathSupport;
    }

    @Inject
    public void initThrowableListener(ThrowableListener lst) {
        this.notifyListeners = new ListenerRegistry(lst);
    }

    @Inject
    public void initContentCapture(ContentCaptureProvider contentCaptureProvider) {
        this.contentCaptureProvider = contentCaptureProvider;
    }

    public ActionFeature createActionFeature(Object owner, String path, String name, String desc) {
        if (this.pathSupport.isRootPath(path)) {
            throw new IllegalArgumentException("Feature path cannot be ROOT");
        }
        return this.featureFactory.createActionFeature(owner, path, (Collection<ActionParameterDescriptor>)null, name, desc);
    }

    public ActionFeature createActionFeature(Object owner, String path, Collection<ActionParameterDescriptor> paramDesc, String name, String desc) {
        if (this.pathSupport.isRootPath(path)) {
            throw new IllegalArgumentException("Feature path cannot be ROOT");
        }
        return this.featureFactory.createActionFeature(owner, path, paramDesc, name, desc);
    }

    public ActionFeature createActionFeature(Object owner, String path, ActionParameterDescriptor[] paramDesc, String name, String desc) {
        if (this.pathSupport.isRootPath(path)) {
            throw new IllegalArgumentException("Feature path cannot be ROOT");
        }
        return this.featureFactory.createActionFeature(owner, path, paramDesc, name, desc);
    }

    public LoadFeature createLoadFeature(Object owner, String path, String name, String desc) {
        if (this.pathSupport.isRootPath(path)) {
            throw new IllegalArgumentException("Feature path cannot be ROOT");
        }
        return this.featureFactory.createLoadFeature(owner, path, name, desc);
    }

    public BooleanFeature createBooleanFeature(Object owner, String path, boolean mutable, boolean initValue, String name, String desc) {
        if (this.pathSupport.isRootPath(path)) {
            throw new IllegalArgumentException("Feature path cannot be ROOT");
        }
        return this.featureFactory.createBooleanFeature(owner, path, mutable, initValue, name, desc);
    }

    public ComponentFeature createComponentFeature(Object owner, String path, ComponentProvider factory, String name, String desc) {
        if (this.pathSupport.isRootPath(path)) {
            throw new IllegalArgumentException("Feature path cannot be ROOT");
        }
        return this.featureFactory.createComponentFeature(owner, path, factory, name, desc);
    }

    public ComponentFeature createComponentFeature(Object owner, String path, Component component, String name, String desc) {
        if (this.pathSupport.isRootPath(path)) {
            throw new IllegalArgumentException("Feature path cannot be ROOT");
        }
        return this.featureFactory.createComponentFeature(owner, path, component, name, desc);
    }

    public <T> EnumeratedFeature<T> createEnumeratedFeature(Object owner, String path, Class<T> type, boolean mutable, T initValue, T[] allowedValues, String name, String desc) {
        if (this.pathSupport.isRootPath(path)) {
            throw new IllegalArgumentException("Feature path cannot be ROOT");
        }
        return this.featureFactory.createEnumeratedFeature(owner, path, type, mutable, initValue, allowedValues, name, desc);
    }

    public <T> EnumeratedFeature<T> createEnumeratedFeature(Object owner, String path, Class<T> type, boolean mutable, T initValue, T[] allowedValues, String[] valueText, String name, String desc) {
        if (this.pathSupport.isRootPath(path)) {
            throw new IllegalArgumentException("Feature path cannot be ROOT");
        }
        return this.featureFactory.createEnumeratedFeature(owner, path, type, mutable, initValue, allowedValues, valueText, name, desc);
    }

    public <T> EnumeratedFeature<T> createEnumeratedFeature(Object owner, String path, Class<T> type, boolean mutable, T initValue, Collection<T> allowedValues, String name, String desc) {
        if (this.pathSupport.isRootPath(path)) {
            throw new IllegalArgumentException("Feature path cannot be ROOT");
        }
        return this.featureFactory.createEnumeratedFeature(owner, path, type, mutable, initValue, allowedValues, name, desc);
    }

    public <T> EnumeratedFeature<T> createEnumeratedFeature(Object owner, String path, Class<T> type, boolean mutable, T initValue, Collection<T> allowedValues, Collection<String> valueText, String name, String desc) {
        if (this.pathSupport.isRootPath(path)) {
            throw new IllegalArgumentException("Feature path cannot be ROOT");
        }
        return this.featureFactory.createEnumeratedFeature(owner, path, type, mutable, initValue, allowedValues, valueText, name, desc);
    }

    public NumericFeature<Integer> createNumericFeature(Object owner, String path, boolean mutable, int initValue, String name, String desc) {
        if (this.pathSupport.isRootPath(path)) {
            throw new IllegalArgumentException("Feature path cannot be ROOT");
        }
        return this.featureFactory.createNumericFeature(owner, path, mutable, initValue, name, desc);
    }

    public NumericFeature<Integer> createNumericFeature(Object owner, String path, boolean mutable, int initValue, int minValue, int maxValue, String name, String desc) {
        if (this.pathSupport.isRootPath(path)) {
            throw new IllegalArgumentException("Feature path cannot be ROOT");
        }
        return this.featureFactory.createNumericFeature(owner, path, mutable, initValue, minValue, maxValue, name, desc);
    }

    public NumericFeature<Double> createNumericFeature(Object owner, String path, boolean mutable, double initValue, String name, String desc) {
        if (this.pathSupport.isRootPath(path)) {
            throw new IllegalArgumentException("Feature path cannot be ROOT");
        }
        return this.featureFactory.createNumericFeature(owner, path, mutable, initValue, name, desc);
    }

    public StringFeature createStringFeature(Object owner, String path, boolean mutable, String initValue, String name, String desc) {
        if (this.pathSupport.isRootPath(path)) {
            throw new IllegalArgumentException("Feature path cannot be ROOT");
        }
        return this.featureFactory.createStringFeature(owner, path, mutable, initValue, name, desc);
    }

    public <T> ValueFeature<T> createValueFeature(Object owner, String path, boolean mutable, T initalValue, String name, String desc) {
        if (this.pathSupport.isRootPath(path)) {
            throw new IllegalArgumentException("Feature path cannot be ROOT");
        }
        return this.featureFactory.createValueFeature(owner, path, mutable, initalValue, name, desc);
    }

    public StringFeature createStringFeature(Object owner, String path, boolean mutable, String initValue, StringFeature.Validator validator, String name, String desc) {
        if (this.pathSupport.isRootPath(path)) {
            throw new IllegalArgumentException("Feature path cannot be ROOT");
        }
        return this.featureFactory.createStringFeature(owner, path, mutable, initValue, validator, name, desc);
    }

    public <T> ListFeature<T> createListFeature(Object owner, String path, Class<T> type, Collection<T> initalVals, String name, String desc) {
        if (this.pathSupport.isRootPath(path)) {
            throw new IllegalArgumentException("Feature path cannot be ROOT");
        }
        return this.featureFactory.createListFeature(owner, path, type, initalVals, name, desc);
    }

    public boolean hasFeature(String featurePath) {
        return this.getFeature(featurePath) != null;
    }

    public Feature getFeature(String featurePath) {
        if (!this.pathSupport.isAbsolutePath(featurePath)) {
            throw new IllegalArgumentException("Path is not absolute: " + featurePath);
        }
        if (this.pathSupport.isRootPath(featurePath)) {
            return this.root;
        }
        return this.root.getFeature(featurePath);
    }

    public <T extends Feature> T getFeatureAs(Class<T> type, String featurePath) {
        Feature feature = this.getFeature(featurePath);
        if (feature == null) {
            return null;
        }
        if (!type.isAssignableFrom(feature.getClass())) {
            throw new IllegalArgumentException("Cannot coerce " + feature + " to " + type.getName());
        }
        return (T)feature;
    }

    public FeatureDirectory getFeatureDirectory(String featurePath) {
        if (!this.pathSupport.isAbsolutePath(featurePath)) {
            throw new IllegalArgumentException("Path is not absolute: " + featurePath);
        }
        if (this.pathSupport.isRootPath(featurePath)) {
            return this.root;
        }
        return this.root.getFeatureDirectory(featurePath);
    }

    public void announceFeature(Feature feature) {
        if (this.pathSupport.isRootPath(feature.getPath())) {
            throw new IllegalArgumentException("Cannot announce the ROOT");
        }
        this.root.announceFeature(feature);
    }

    public boolean setFeaturePublished(Feature feature, boolean publish) {
        if (this.pathSupport.isRootPath(feature.getPath())) {
            throw new IllegalArgumentException("Cannot add/remove the ROOT");
        }
        return this.root.setFeaturePublished(feature, publish);
    }

    public void addFeature(Feature feature) {
        if (this.pathSupport.isRootPath(feature.getPath())) {
            throw new IllegalArgumentException("Cannot replace the ROOT");
        }
        this.root.addFeature(feature);
    }

    public FeatureDirectory addFeatureDirectory(String featurePath) {
        if (!this.pathSupport.isAbsolutePath(featurePath)) {
            throw new IllegalArgumentException("Path is not absolute: " + featurePath);
        }
        if (this.pathSupport.isRootPath(featurePath)) {
            return this.root;
        }
        return this.root.addFeatureDirectory(featurePath);
    }

    public boolean removeFeature(Feature feature) {
        if (feature == this.root) {
            throw new IllegalArgumentException("Cannot remove the ROOT");
        }
        return this.root.removeFeature(feature);
    }

    public boolean removeFeature(String featurePath) {
        if (!this.pathSupport.isAbsolutePath(featurePath)) {
            throw new IllegalArgumentException("Path is not absolute: " + featurePath);
        }
        if (this.pathSupport.isRootPath(featurePath)) {
            throw new IllegalArgumentException("Cannot remove the ROOT");
        }
        return this.root.removeFeature(featurePath);
    }

    public void addFeaturePublicationListener(FeaturePublicationListener l) {
        this.root.addFeaturePublicationListener(l);
    }

    public void addFeaturePublicationListener(String featurePath, FeaturePublicationListener l) {
        if (!this.pathSupport.isAbsolutePath(featurePath)) {
            throw new IllegalArgumentException("Path is not absolute: " + featurePath);
        }
        FeatureDirectory dir = this.addFeatureDirectory(featurePath);
        dir.addFeaturePublicationListener(l);
    }

    public void removeFeaturePublicationListener(FeaturePublicationListener l) {
        this.root.removeFeaturePublicationListener(l);
    }

    public void removeFeaturePublicationListener(String featurePath, FeaturePublicationListener l) {
        if (!this.pathSupport.isAbsolutePath(featurePath)) {
            throw new IllegalArgumentException("Path is not absolute: " + featurePath);
        }
        FeatureDirectory dir = this.getFeatureDirectory(featurePath);
        if (dir != null) {
            dir.removeFeaturePublicationListener(l);
        }
    }

    private Notification createNotification(Object owner, String path, String message, long timestamp) {
        if (this.pathSupport.isRootPath(path)) {
            throw new IllegalArgumentException("Notification path cannot be ROOT");
        }
        return this.notificationFactory.createNotification(owner, path, message, timestamp);
    }

    public void addNotificationListener(NotificationListener l) {
        this.notifyListeners.add((Object)l);
    }

    public void removeNotificationListener(NotificationListener l) {
        this.notifyListeners.remove((Object)l);
    }

    public void announceNotification(Object owner, String path) {
        final Notification n = this.createNotification(owner, path, "", 0L);
        this.notifyListeners.fire((FiringFunctor)new FiringFunctor<NotificationListener>(){

            public void fire(NotificationListener lst) {
                lst.announceNotification(n);
            }
        });
    }

    public void sendNotification(Object owner, String path) {
        this.sendNotification(owner, path, "", System.currentTimeMillis());
    }

    public void sendNotification(Object owner, String path, String msg) {
        this.sendNotification(owner, path, msg, System.currentTimeMillis());
    }

    public void sendNotification(Object owner, String path, String msg, long timestamp) {
        final Notification n = this.createNotification(owner, path, msg, timestamp);
        if (this.contentCaptureProvider.get().isEchoingData()) {
            this.notifyListeners.fire((FiringFunctor)new FiringFunctor<NotificationListener>(){

                public void fire(NotificationListener lst) {
                    lst.deliverNotification(n);
                }
            });
        }
    }

    public void abortNotification(Object owner, String path) {
        final Notification n = this.createNotification(owner, path, "", 0L);
        this.notifyListeners.fire((FiringFunctor)new FiringFunctor<NotificationListener>(){

            public void fire(NotificationListener lst) {
                lst.abortNotification(n);
            }
        });
    }
}

