/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.feature;

import com.elluminate.util.I18nMessage;
import java.util.ArrayList;
import java.util.List;

public class ActionFeatureStatus {
    private boolean complete = false;
    private boolean successful = true;
    private final List<Issue> issues = new ArrayList<Issue>();

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isSuccessful() {
        return this.complete && this.successful;
    }

    public void setFailed() {
        this.successful = false;
    }

    public void setComplete() {
        this.complete = true;
    }

    public void setComplete(boolean successful) {
        this.successful &= successful;
        this.complete = true;
    }

    public void addIssue(IssueType type, I18nMessage message) {
        if (type == IssueType.ERROR) {
            this.successful = false;
        }
        this.issues.add(new Issue(type, message));
    }

    public Issue[] getIssues() {
        return this.issues.toArray(new Issue[this.issues.size()]);
    }

    public static class Issue {
        private IssueType type;
        private I18nMessage message;

        private Issue(IssueType type, I18nMessage message) {
            this.type = type;
            this.message = message;
        }

        public IssueType getType() {
            return this.type;
        }

        public I18nMessage getMessage() {
            return this.message;
        }

        public String toString() {
            return (Object)((Object)this.type) + ": " + this.message;
        }
    }

    public static enum IssueType {
        MESSAGE,
        WARNING,
        ERROR;

    }
}

