/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.polling.module;

import com.elluminate.groupware.polling.PollingProtocol;
import com.elluminate.groupware.polling.module.PollTypeFactory;
import com.elluminate.groupware.polling.module.PollingStatsListener;
import com.elluminate.groupware.polling.module.PollingTypeAdapter;
import com.elluminate.jinx.ClientGroup;
import com.elluminate.jinx.ClientGroupListener;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.util.event.FiringFunctor;
import com.elluminate.util.event.ListenerRegistry;
import com.elluminate.util.log.Logger;
import com.google.inject.Inject;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedHashMap;
import java.util.Map;

public class StatsModel {
    private static final Object lock = new Object();
    private Map<Character, Integer> currentResults = new LinkedHashMap<Character, Integer>();
    private ClientProvider clientProvider = null;
    private PropertyChangeListener modeListener = null;
    private PropertyChangeListener responseChangeListener = null;
    private PropertyChangeListener chairListener = null;
    private PollTypeFactory factory = null;
    private ListenerRegistry<PollingStatsListener> registry = null;
    private Logger log = null;
    private ClientGroupListener clientGroupListener = null;

    @Inject
    public void initPollTypeFactory(PollTypeFactory f) {
        this.factory = f;
    }

    @Inject
    public void initClientProvider(ClientProvider cp) {
        this.clientProvider = cp;
    }

    @Inject
    public void initListenerRegistry(ListenerRegistry<PollingStatsListener> lr) {
        this.registry = lr;
    }

    @Inject
    public void initLogger(Logger l) {
        this.log = l;
    }

    public void setup() {
        this.registerListeners();
    }

    public void cleanup() {
        this.deRegisterListeners();
    }

    public void addPollingStatsListener(PollingStatsListener listener) {
        this.registry.add((Object)listener);
        this.handleStatsChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = lock;
        synchronized (object) {
            for (Character c : this.currentResults.keySet()) {
                if (c.charValue() == ' ' || this.currentResults.get(c) == 0) continue;
                return false;
            }
        }
        return true;
    }

    private void registerListeners() {
        this.registerResponseChangeListener();
    }

    private void deRegisterListeners() {
        this.clientProvider.get().getClientList().removeClientPropertyChangeListener(this.responseChangeListener);
        this.clientProvider.get().getClientList().removeGroupPropertyChangeListener("pollingMode", this.modeListener);
        this.clientProvider.get().getClientList().removePropertyChangeListener("chair", this.chairListener);
        this.clientProvider.get().removeClientGroupListener(this.clientGroupListener);
        this.registry = null;
    }

    private void registerResponseChangeListener() {
        this.responseChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                StatsModel.this.handleStatsChange();
            }
        };
        this.clientProvider.get().getClientList().addClientPropertyChangeListener("pollingValue", this.responseChangeListener);
    }

    private void updateListeners() {
        this.registry.fire((FiringFunctor)new FiringFunctor<PollingStatsListener>(){

            public void fire(PollingStatsListener listener) {
                LinkedHashMap<Character, Integer> newResults = new LinkedHashMap<Character, Integer>(StatsModel.this.currentResults);
                listener.resultsUpdate(newResults);
            }
        });
    }

    public void requestStatsUpdate() {
        this.handleStatsChange();
    }

    private void handleStatsChange() {
        this.clearResults();
        this.repopulate();
        if (PollingProtocol.DEBUG.show()) {
            this.dumpCurrentResultsToLog();
        }
        this.updateListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpCurrentResultsToLog() {
        Map<Character, Integer> map = this.currentResults;
        synchronized (map) {
            for (Character c : this.currentResults.keySet()) {
                this.log.message(c + "-->" + this.currentResults.get(c));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void repopulate() {
        Object object = lock;
        synchronized (object) {
            block10: {
                try {
                    ClientGroup grp = this.clientProvider.get().getClientList().getMyGroup();
                    if (grp == null) {
                        if (PollingProtocol.DEBUG.show()) {
                            this.log.message("unable to get \"my\" group from the client list at this time");
                        }
                        return;
                    }
                    for (ClientInfo info : grp.getMembers()) {
                        if (!info.isVisible()) continue;
                        Character response = Character.valueOf(info.getProperty("pollingValue", ' '));
                        Integer count = this.currentResults.get(response);
                        if (count == null) {
                            count = 1;
                        } else {
                            Integer n = count;
                            Integer n2 = count = Integer.valueOf(count + 1);
                        }
                        this.currentResults.put(response, count);
                    }
                }
                catch (Exception e) {
                    if (!PollingProtocol.DEBUG.show()) break block10;
                    this.log.message("Problem occurred attempting to repopulate the StatsModel.  No action required: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearResults() {
        Object object = lock;
        synchronized (object) {
            this.currentResults.clear();
            this.primeResults();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void primeResults() {
        Object object = lock;
        synchronized (object) {
            PollingTypeAdapter currentType = this.factory.getCurrentPollingType();
            if (currentType == null) {
                return;
            }
            Map<Character, Image> options = currentType.getResponseOptions();
            for (Character option : options.keySet()) {
                this.currentResults.put(option, 0);
            }
        }
    }
}

