/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.polling.module;

import com.elluminate.groupware.polling.PollingProtocol;
import com.elluminate.groupware.polling.module.PollingGroupUtil;
import com.elluminate.groupware.polling.module.PollingModel;
import com.elluminate.jinx.Client;
import com.elluminate.jinx.ClientGroup;
import com.elluminate.util.log.Logger;
import com.google.inject.Inject;

public class PollingUtils {
    private PollingGroupUtil grpUtil = new PollingGroupUtil();
    private PollingModel model;
    private Logger log;

    @Inject
    public void initPollingModel(PollingModel m) {
        this.model = m;
    }

    @Inject
    public void initLogger(Logger l) {
        this.log = l;
    }

    public boolean isMyGroup(Client c, ClientGroup grp) {
        if (c != null && grp != null) {
            if (PollingProtocol.DEBUG.show()) {
                this.log.message("isMyGroup[" + (c.getGroupID() == grp.getGroupID()) + "]");
            }
            return c.getGroupID() == grp.getGroupID();
        }
        return true;
    }

    public void matchToGroup(ClientGroup grp) {
        this.matchModeToGroup(grp);
        this.matchVisibilityToGroup(grp);
        this.matchLockedToGroup(grp);
        this.clearResponse();
    }

    public void matchModeToGroup(ClientGroup grp) {
        if (grp == null) {
            return;
        }
        this.model.setPollingMode(this.grpUtil.getPollingModeForGroup(grp));
    }

    public void matchVisibilityToGroup(ClientGroup grp) {
        if (grp == null) {
            return;
        }
        this.model.setPollingVisible(this.grpUtil.isPollingVisibleForGroup(grp));
    }

    public void matchLockedToGroup(ClientGroup grp) {
        if (grp == null) {
            return;
        }
        this.model.setPollingLock(this.grpUtil.isPollingLockedForGroup(grp));
    }

    public void clearResponse() {
        this.model.setPollResponse(' ');
    }
}

