/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.polling.module;

import com.elluminate.framework.imps.Imps;
import com.elluminate.groupware.imps.ImageAcceptAPI;
import com.elluminate.groupware.polling.PollingProtocol;
import com.elluminate.jinx.ClientGroup;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.PropertyChangeSet;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.util.log.Logger;
import com.google.inject.Inject;
import java.util.Iterator;

public class PollingModel {
    private ClientProvider clientProvider;
    private Imps imps;
    private Logger log;
    private boolean visible = false;
    private boolean locked = false;
    private short mode = 0;
    private char response = (char)32;
    private boolean publishable = false;
    private boolean playing = false;

    @Inject
    public void initClientProvider(ClientProvider cp) {
        this.clientProvider = cp;
    }

    @Inject
    public void initImps(Imps imps) {
        this.imps = imps;
    }

    @Inject
    public void initLogger(Logger l) {
        this.log = l;
    }

    boolean isPollingVisible() {
        return this.visible;
    }

    void setPollingVisible(boolean visible) {
        if (this.visible != visible) {
            if (PollingProtocol.DEBUG.show()) {
                this.log.message("polling visibility change [" + this.visible + " -> " + visible + "]");
            }
            this.visible = visible;
            try {
                this.getMyGroup().setProperty("pollingVisible", visible);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    boolean isPollingLocked() {
        return this.locked;
    }

    void setPollingLock(boolean locked) {
        if (this.locked != locked) {
            if (PollingProtocol.DEBUG.show()) {
                this.log.message("polling locked change [" + this.locked + " -> " + locked + "]");
            }
            this.locked = locked;
            try {
                this.getMyGroup().setProperty("pollingLocked", locked);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    short getPollingMode() {
        return this.mode;
    }

    void setPollingMode(Short mode) {
        if (mode == null) {
            mode = 0;
        }
        if (this.mode != mode) {
            if (PollingProtocol.DEBUG.show()) {
                this.log.message("polling mode change [" + this.mode + "->" + mode + "]");
            }
            this.mode = mode;
            try {
                this.getMyGroup().setProperty("pollingMode", mode.shortValue());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    void setPollResponse(char response) {
        if (this.response != response) {
            if (PollingProtocol.DEBUG.show()) {
                this.log.message("polling response change [" + this.response + " -> " + response + "]");
            }
            this.response = response;
            this.getClients().getMyClient().setProperty("pollingValue", response);
        }
    }

    char getPollResponse() {
        return this.response;
    }

    void setPlayingStatus(boolean playing) {
        this.playing = playing;
    }

    boolean isPlaying() {
        return this.playing;
    }

    void clearPollingAnswerForClient(ClientInfo ci, boolean chair) {
        if (!chair) {
            return;
        }
        if (ci.isMe()) {
            this.response = (char)32;
        }
        ci.setProperty("pollingValue", ' ');
    }

    void clearPollingAnswersForGroup(ClientGroup cg, boolean isChair) {
        this.clearPollingAnswersForClientInfoIterator(cg.iterator(), isChair);
    }

    void clearAllPollAnswers(boolean isChair) {
        this.clearPollingAnswersForClientInfoIterator(this.getClients().iterator(), isChair);
    }

    private void clearPollingAnswersForClientInfoIterator(Iterator<ClientInfo> i, boolean isChair) {
        if (!isChair) {
            return;
        }
        this.response = (char)32;
        PropertyChangeSet changeSet = this.getClients().getConnection().getPropertyChangeSet();
        while (i.hasNext()) {
            ClientInfo ci = i.next();
            ci.setProperty(changeSet, "pollingValue", ' ');
        }
        changeSet.commit();
    }

    private ClientGroup getMyGroup() {
        return this.getClients().getMyGroup();
    }

    private ClientList getClients() {
        return this.clientProvider.get().getClientList();
    }

    boolean canPublish() {
        ImageAcceptAPI api = (ImageAcceptAPI)this.imps.findBest(ImageAcceptAPI.class);
        if (api != null) {
            return api.isAccessible(1);
        }
        return false;
    }

    void setPublishable(boolean publishable) {
        this.publishable = publishable;
    }

    boolean isPublishable() {
        return this.publishable;
    }
}

