/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.agenda.module;

import com.elluminate.groupware.agenda.Agenda;
import com.elluminate.groupware.agenda.AgendaFile;
import com.elluminate.groupware.agenda.AgendaItem;
import com.elluminate.groupware.agenda.AgendaLibrary;
import com.elluminate.groupware.agenda.event.AgendaEvent;
import com.elluminate.groupware.agenda.event.AgendaLibraryEvent;
import com.elluminate.groupware.agenda.event.AgendaLibraryListener;
import com.elluminate.groupware.agenda.event.AgendaListener;
import com.elluminate.groupware.agenda.module.Actions;
import com.elluminate.groupware.agenda.module.AgendaBean;
import com.elluminate.groupware.agenda.module.StringsProperties;
import com.elluminate.groupware.agenda.module.action.ActionGroup;
import com.elluminate.groupware.agenda.module.action.ActionInfo;
import com.elluminate.gui.component.AccessibleToolBar;
import com.elluminate.gui.component.CMenuButton;
import com.elluminate.gui.component.CToolBarButton;
import com.elluminate.gui.component.RollOverBehavior;
import com.elluminate.jinx.ClientEvent;
import com.elluminate.jinx.ClientListener;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Singleton;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.border.Border;

@Singleton
public class ToolBar
extends AccessibleToolBar
implements PropertyChangeListener,
AgendaListener,
AgendaLibraryListener,
ClientListener {
    public static final int VIEW_LIBRARY = 1;
    public static final int VIEW_EDITOR = 2;
    public static final int VIEW_CONTROLLER = 3;
    private AgendaBean bean;
    private AgendaLibrary library;
    private I18n i18n;
    private int view = 1;
    private Border normalBorder;
    private CToolBarButton viewerButton;
    private CToolBarButton toolBarButton;
    private JSeparator manageToolsSeparator;
    private CToolBarButton newAgendaButton;
    private CToolBarButton openAgendaButton;
    private CToolBarButton saveAgendaButton;
    private CToolBarButton printAgendaButton;
    private CToolBarButton deleteAgendaButton;
    private CToolBarButton renameAgendaButton;
    private CToolBarButton closeAgendaButton;
    private JSeparator editToolsSeparator;
    private CToolBarButton addFileButton;
    private CToolBarButton addTopicButton;
    private ToolBarMenuButton addActionButton;
    private CToolBarButton addTextButton;
    private CToolBarButton removeItemButton;
    private CToolBarButton saveFileButton;
    private JSeparator moveToolsSeparator;
    private CToolBarButton moveItemUpButton;
    private CToolBarButton moveItemDownButton;
    private CToolBarButton moveItemLeftButton;
    private CToolBarButton moveItemRightButton;
    private JSeparator actionToolsSeparator;
    private CToolBarButton viewAgendaButton;
    private CToolBarButton editAgendaButton;
    private CToolBarButton activeAgendaButton;
    private CToolBarButton previousItemButton;
    private CToolBarButton nextItemButton;

    public ToolBar(AgendaBean bean, AgendaLibrary library, I18n i18n) {
        this.setFloatable(false);
        this.bean = bean;
        this.library = library;
        this.i18n = i18n;
        bean.getClientList().addPropertyChangeListener("agenda.protected", (PropertyChangeListener)this);
        bean.getClientList().addClientListener((ClientListener)this);
        library.addAgendaLibraryListener((AgendaLibraryListener)this);
        bean.addPropertyChangeListener("targetedAgendas", this);
        bean.addPropertyChangeListener("targetedItems", this);
        bean.addPropertyChangeListener("moderator", this);
        this.normalBorder = this.getBorder();
        this.viewerButton = new CToolBarButton((Icon)i18n.getIcon("AgendaToolBar.viewerViewIcon"));
        this.viewerButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.AGENDATOOLBAR_VIEWERVIEWTIP));
        this.viewerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolBar.this.bean.setView(2);
            }
        });
        this.add((Component)this.viewerButton);
        this.toolBarButton = new CToolBarButton((Icon)i18n.getIcon("AgendaToolBar.toolBarViewIcon"));
        this.toolBarButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.AGENDATOOLBAR_TOOLBARVIEWTIP));
        this.toolBarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolBar.this.bean.setView(3);
            }
        });
        this.add((Component)this.toolBarButton);
        this.manageToolsSeparator = new JToolBar.Separator(null);
        this.add(this.manageToolsSeparator);
        this.newAgendaButton = new CToolBarButton((Icon)i18n.getIcon("AgendaToolBar.newAgendaIcon"));
        this.newAgendaButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.AGENDATOOLBAR_NEWAGENDATIP));
        this.newAgendaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolBar.this.bean.doNewAgenda();
            }
        });
        this.add((Component)this.newAgendaButton);
        this.openAgendaButton = new CToolBarButton((Icon)i18n.getIcon("AgendaToolBar.openAgendaIcon"));
        this.openAgendaButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.AGENDATOOLBAR_OPENAGENDATIP));
        this.openAgendaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolBar.this.bean.doOpenAgenda();
            }
        });
        this.add((Component)this.openAgendaButton);
        this.saveAgendaButton = new CToolBarButton((Icon)i18n.getIcon("AgendaToolBar.saveAgendaIcon"));
        this.saveAgendaButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.AGENDATOOLBAR_SAVEAGENDATIP));
        this.saveAgendaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolBar.this.bean.doSaveAgenda(false);
            }
        });
        this.add((Component)this.saveAgendaButton);
        this.printAgendaButton = new CToolBarButton((Icon)i18n.getIcon("AgendaToolBar.printAgendaIcon"));
        this.printAgendaButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.AGENDATOOLBAR_PRINTAGENDATIP));
        this.printAgendaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolBar.this.bean.doPrintAgenda();
            }
        });
        this.add((Component)this.printAgendaButton);
        this.deleteAgendaButton = new CToolBarButton((Icon)i18n.getIcon("AgendaToolBar.deleteAgendaIcon"));
        this.deleteAgendaButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.AGENDATOOLBAR_DELETEAGENDATIP));
        this.deleteAgendaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolBar.this.bean.doDeleteAgenda();
            }
        });
        this.add((Component)this.deleteAgendaButton);
        this.renameAgendaButton = new CToolBarButton((Icon)i18n.getIcon("AgendaToolBar.renameAgendaIcon"));
        this.renameAgendaButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.AGENDATOOLBAR_RENAMEAGENDATIP));
        this.renameAgendaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolBar.this.bean.doRenameAgenda();
            }
        });
        this.add((Component)this.renameAgendaButton);
        this.closeAgendaButton = new CToolBarButton((Icon)i18n.getIcon("AgendaToolBar.closeAgendaIcon"));
        this.closeAgendaButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.AGENDATOOLBAR_CLOSEAGENDATIP));
        this.closeAgendaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolBar.this.bean.doCloseAgenda(true);
            }
        });
        this.add((Component)this.closeAgendaButton);
        this.editToolsSeparator = new JToolBar.Separator(null);
        this.add(this.editToolsSeparator);
        this.addFileButton = new CToolBarButton((Icon)i18n.getIcon("AgendaToolBar.addFileIcon"));
        this.addFileButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.AGENDATOOLBAR_ADDFILETIP));
        this.addFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolBar.this.bean.doAddFile();
            }
        });
        this.add((Component)this.addFileButton);
        this.addTopicButton = new CToolBarButton((Icon)i18n.getIcon("AgendaToolBar.addTopicIcon"));
        this.addTopicButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.AGENDATOOLBAR_ADDTOPICTIP));
        this.addTopicButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolBar.this.bean.doAddTopic();
            }
        });
        this.add((Component)this.addTopicButton);
        this.addActionButton = new ToolBarMenuButton(i18n.getIcon("AgendaToolBar.addActionIcon"));
        this.addActionButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.AGENDATOOLBAR_ADDACTIONTIP));
        ActionGroup[] grps = Actions.getGroups();
        for (int i = 0; i < grps.length; ++i) {
            ActionGroup grp = grps[i];
            JMenu m = new JMenu(grp.getDisplayName());
            m.setIcon(grp.getIcon());
            this.addActionButton.add(m);
            ActionInfo[] acts = grp.getActions();
            for (int j = 0; j < acts.length; ++j) {
                ActionInfo act = acts[j];
                m.add(new AddActionMenuItem(act));
            }
        }
        this.addActionButton.addSeparator();
        JMenuItem mi = new JMenuItem(i18n.getString((PropertiesEnum)StringsProperties.AGENDATOOLBAR_COMPOUNDACTIONITEM), i18n.getIcon("AgendaBean.compoundActionIcon"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolBar.this.bean.doAddAction((Class)null);
            }
        });
        this.addActionButton.add(mi);
        this.addActionButton.addSeparator();
        mi = new JMenuItem(i18n.getString((PropertiesEnum)StringsProperties.AGENDATOOLBAR_OPENACTIONPALETTEITEM));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolBar.this.bean.setActionPaletteVisible(true);
            }
        });
        this.addActionButton.add(mi);
        this.add((Component)((Object)this.addActionButton));
        this.addTextButton = new CToolBarButton((Icon)i18n.getIcon("AgendaToolBar.addTextIcon"));
        this.addTextButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.AGENDATOOLBAR_ADDTEXTTIP));
        this.addTextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolBar.this.bean.doAddText();
            }
        });
        this.add((Component)this.addTextButton);
        this.removeItemButton = new CToolBarButton((Icon)i18n.getIcon("AgendaToolBar.removeItemIcon"));
        this.removeItemButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.AGENDATOOLBAR_REMOVEITEMTIP));
        this.removeItemButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolBar.this.bean.doRemoveItems();
            }
        });
        this.add((Component)this.removeItemButton);
        this.saveFileButton = new CToolBarButton((Icon)i18n.getIcon("AgendaToolBar.saveFileIcon"));
        this.saveFileButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.AGENDATOOLBAR_SAVEFILETIP));
        this.saveFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolBar.this.bean.doSaveFiles();
            }
        });
        this.add((Component)this.saveFileButton);
        this.moveToolsSeparator = new JToolBar.Separator(null);
        this.add(this.moveToolsSeparator);
        this.moveItemUpButton = new CToolBarButton((Icon)i18n.getIcon("AgendaToolBar.moveItemUpIcon"));
        this.moveItemUpButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.AGENDATOOLBAR_MOVEITEMUPTIP));
        this.moveItemUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolBar.this.bean.doMoveItemUp();
            }
        });
        this.add((Component)this.moveItemUpButton);
        this.moveItemDownButton = new CToolBarButton((Icon)i18n.getIcon("AgendaToolBar.moveItemDownIcon"));
        this.moveItemDownButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.AGENDATOOLBAR_MOVEITEMDOWNTIP));
        this.moveItemDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolBar.this.bean.doMoveItemDown();
            }
        });
        this.add((Component)this.moveItemDownButton);
        this.moveItemLeftButton = new CToolBarButton((Icon)i18n.getIcon("AgendaToolBar.moveItemLeftIcon"));
        this.moveItemLeftButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.AGENDATOOLBAR_MOVEITEMLEFTTIP));
        this.moveItemLeftButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolBar.this.bean.doMoveItemLeft();
            }
        });
        this.add((Component)this.moveItemLeftButton);
        this.moveItemRightButton = new CToolBarButton((Icon)i18n.getIcon("AgendaToolBar.moveItemRightIcon"));
        this.moveItemRightButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.AGENDATOOLBAR_MOVEITEMRIGHTTIP));
        this.moveItemRightButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolBar.this.bean.doMoveItemRight();
            }
        });
        this.add((Component)this.moveItemRightButton);
        this.actionToolsSeparator = new JToolBar.Separator(null);
        this.add(this.actionToolsSeparator);
        this.viewAgendaButton = new CToolBarButton((Icon)i18n.getIcon("AgendaToolBar.viewAgendaIcon"));
        this.viewAgendaButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.AGENDATOOLBAR_VIEWAGENDATIP));
        this.viewAgendaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolBar.this.bean.doViewAgenda();
            }
        });
        this.add((Component)this.viewAgendaButton);
        this.editAgendaButton = new CToolBarButton((Icon)i18n.getIcon("AgendaToolBar.controlAgendaIcon"));
        this.editAgendaButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.AGENDATOOLBAR_REQUESTCONTROLAGENDATIP));
        this.editAgendaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Agenda[] ags = ToolBar.this.bean.getTargetedAgendas();
                if (ags != null && ags.length == 1) {
                    if (ToolBar.this.bean.isMe(ags[0].getEditor())) {
                        ToolBar.this.bean.doUneditAgenda();
                    } else {
                        ToolBar.this.bean.doEditAgenda();
                    }
                }
            }
        });
        this.add((Component)this.editAgendaButton);
        this.activeAgendaButton = new CToolBarButton((Icon)i18n.getIcon("AgendaToolBar.showAgendaIcon"));
        this.activeAgendaButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.AGENDATOOLBAR_ACTIVATEAGENDATIP));
        this.activeAgendaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Agenda[] ags = ToolBar.this.bean.getTargetedAgendas();
                if (ags != null && ags.length == 1) {
                    if (ToolBar.this.library.isActiveAgenda(ags[0])) {
                        ToolBar.this.bean.doDeactivateAgenda();
                    } else {
                        ToolBar.this.bean.doActivateAgenda();
                    }
                }
            }
        });
        this.add((Component)this.activeAgendaButton);
        this.previousItemButton = new CToolBarButton((Icon)i18n.getIcon("AgendaToolBar.goToPreviousIcon"));
        this.previousItemButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.AGENDATOOLBAR_GOTOPREVIOUSTIP));
        this.previousItemButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolBar.this.bean.doPreviousNode();
            }
        });
        this.add((Component)this.previousItemButton);
        this.nextItemButton = new CToolBarButton((Icon)i18n.getIcon("AgendaToolBar.goToNextIcon"));
        this.nextItemButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.AGENDATOOLBAR_GOTONEXTTIP));
        this.nextItemButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolBar.this.bean.doNextNode();
            }
        });
        this.add((Component)this.nextItemButton);
        this.updateBorder();
        this.updateButtonsEnabled();
        this.updateButtonsVisible();
        this.updateButtonsSelected();
    }

    public void setLayout(LayoutManager layout) {
        if (this.getLayout() == null) {
            super.setLayout(layout);
        }
    }

    public int getView() {
        return this.view;
    }

    public void setView(int view) {
        this.view = view;
        this.updateBorder();
        this.updateButtonsVisible();
    }

    private void updateBorder() {
        if (this.view == 3) {
            this.setBorder(this.normalBorder);
        } else {
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.GRAY), this.normalBorder));
        }
    }

    private void updateButtonsEnabled() {
        Agenda[] ags = this.bean.getTargetedAgendas();
        AgendaItem[] its = this.bean.getTargetedItems();
        boolean agendaSelected = ags != null && ags.length == 1;
        boolean agendaActive = ags != null && ags.length == 1 && this.library.isActiveAgenda(ags[0]);
        boolean agendasSelected = ags != null && ags.length != 0;
        boolean itemsSelected = its != null && its.length != 0;
        boolean filesSelected = its != null && its.length != 0 && its[0] instanceof AgendaFile;
        short editorAddress = ags != null && ags.length == 1 ? (short)ags[0].getEditor() : (short)-32767;
        boolean editor = editorAddress != -32767 && this.bean.isMe(editorAddress);
        boolean online = this.bean.isOnline();
        boolean uploading = ags != null && ags.length == 1 && ags[0].isTransferring(1);
        Agenda activeAgenda = this.library.getActiveAgenda();
        boolean otherAgendaActiveAndEdited = activeAgenda != null && activeAgenda.getEditor() != -32767 && !this.bean.isMe(activeAgenda.getEditor());
        boolean moveUp = itemsSelected;
        boolean moveDown = itemsSelected;
        boolean moveLeft = false;
        boolean moveRight = false;
        if (itemsSelected) {
            for (int i = 0; i < its.length; ++i) {
                if (!its[i].canMoveUp()) {
                    moveUp = false;
                }
                if (!its[i].canMoveDown()) {
                    moveDown = false;
                }
                if (its[i].canMoveLeft()) {
                    moveLeft = true;
                }
                if (its[i].canMoveRight()) {
                    moveRight = true;
                }
                if (!moveUp && !moveDown && moveLeft && moveRight) break;
            }
        }
        this.saveAgendaButton.setEnabled(agendaSelected);
        this.printAgendaButton.setEnabled(agendaSelected);
        this.deleteAgendaButton.setEnabled(agendasSelected);
        this.renameAgendaButton.setEnabled(agendaSelected && !uploading);
        this.closeAgendaButton.setEnabled(agendaSelected);
        this.addFileButton.setEnabled(agendaSelected && (!online || editor));
        this.addTopicButton.setEnabled(agendaSelected && (!online || editor));
        this.addActionButton.setEnabled(agendaSelected && (!online || editor));
        this.addTextButton.setEnabled(agendaSelected && (!online || editor));
        this.removeItemButton.setEnabled(itemsSelected);
        this.saveFileButton.setEnabled(filesSelected);
        this.moveItemUpButton.setEnabled(moveUp);
        this.moveItemDownButton.setEnabled(moveDown);
        this.moveItemLeftButton.setEnabled(moveLeft);
        this.moveItemRightButton.setEnabled(moveRight);
        this.viewAgendaButton.setEnabled(agendaSelected && !uploading);
        this.activeAgendaButton.setEnabled(agendaSelected && !uploading && !otherAgendaActiveAndEdited);
        this.editAgendaButton.setEnabled(agendaSelected);
        this.previousItemButton.setEnabled(editor && agendaActive);
        this.nextItemButton.setEnabled(editor && agendaActive);
    }

    private void updateButtonsVisible() {
        Agenda[] ags = this.bean.getTargetedAgendas();
        boolean online = this.bean.isOnline();
        boolean moderator = this.bean.isChair();
        short editorAddress = ags != null && ags.length == 1 ? (short)ags[0].getEditor() : (short)-32767;
        boolean editor = editorAddress != -32767 && this.bean.isMe(editorAddress);
        boolean active = ags != null && ags.length == 1 && this.library.isActiveAgenda(ags[0]);
        boolean protect = this.bean.isProtected();
        switch (this.view) {
            case 1: {
                this.viewerButton.setVisible(false);
                this.toolBarButton.setVisible(false);
                this.manageToolsSeparator.setVisible(false);
                this.newAgendaButton.setVisible(!online);
                this.openAgendaButton.setVisible(true);
                this.saveAgendaButton.setVisible(false);
                this.printAgendaButton.setVisible(false);
                this.deleteAgendaButton.setVisible(true);
                this.renameAgendaButton.setVisible(true);
                this.closeAgendaButton.setVisible(false);
                this.editToolsSeparator.setVisible(false);
                this.addFileButton.setVisible(false);
                this.addTopicButton.setVisible(false);
                this.addActionButton.setVisible(false);
                this.addTextButton.setVisible(false);
                this.removeItemButton.setVisible(false);
                this.saveFileButton.setVisible(false);
                this.moveToolsSeparator.setVisible(false);
                this.moveItemUpButton.setVisible(false);
                this.moveItemDownButton.setVisible(false);
                this.moveItemLeftButton.setVisible(false);
                this.moveItemRightButton.setVisible(false);
                this.actionToolsSeparator.setVisible(true);
                this.viewAgendaButton.setVisible(true);
                this.activeAgendaButton.setVisible(online);
                this.editAgendaButton.setVisible(false);
                this.previousItemButton.setVisible(false);
                this.nextItemButton.setVisible(false);
                break;
            }
            case 2: {
                this.viewerButton.setVisible(false);
                this.toolBarButton.setVisible(online && moderator);
                this.manageToolsSeparator.setVisible(online && moderator);
                this.newAgendaButton.setVisible(!online);
                this.openAgendaButton.setVisible(!online);
                this.saveAgendaButton.setVisible(!protect || editor);
                this.printAgendaButton.setVisible(!protect || editor);
                this.deleteAgendaButton.setVisible(false);
                this.renameAgendaButton.setVisible(false);
                this.closeAgendaButton.setVisible(moderator);
                this.editToolsSeparator.setVisible(!online || moderator);
                this.addFileButton.setVisible(!online);
                this.addTopicButton.setVisible(!online);
                this.addActionButton.setVisible(!online);
                this.addTextButton.setVisible(!online);
                this.removeItemButton.setVisible(!online);
                this.saveFileButton.setVisible(!online || moderator);
                this.moveToolsSeparator.setVisible(!online);
                this.moveItemUpButton.setVisible(!online);
                this.moveItemDownButton.setVisible(!online);
                this.moveItemLeftButton.setVisible(!online);
                this.moveItemRightButton.setVisible(!online);
                this.actionToolsSeparator.setVisible(online && moderator);
                this.viewAgendaButton.setVisible(false);
                this.activeAgendaButton.setVisible(online && moderator);
                this.editAgendaButton.setVisible(online && moderator);
                this.previousItemButton.setVisible(online && moderator);
                this.nextItemButton.setVisible(online && moderator);
                break;
            }
            case 3: {
                this.viewerButton.setVisible(true);
                this.toolBarButton.setVisible(false);
                this.manageToolsSeparator.setVisible(true);
                this.newAgendaButton.setVisible(!online);
                this.openAgendaButton.setVisible(!online);
                this.saveAgendaButton.setVisible(false);
                this.printAgendaButton.setVisible(false);
                this.deleteAgendaButton.setVisible(false);
                this.renameAgendaButton.setVisible(false);
                this.closeAgendaButton.setVisible(false);
                this.editToolsSeparator.setVisible(false);
                this.addFileButton.setVisible(false);
                this.addTopicButton.setVisible(false);
                this.addActionButton.setVisible(false);
                this.addTextButton.setVisible(false);
                this.removeItemButton.setVisible(false);
                this.saveFileButton.setVisible(false);
                this.moveToolsSeparator.setVisible(false);
                this.moveItemUpButton.setVisible(false);
                this.moveItemDownButton.setVisible(false);
                this.moveItemLeftButton.setVisible(false);
                this.moveItemRightButton.setVisible(false);
                this.actionToolsSeparator.setVisible(false);
                this.viewAgendaButton.setVisible(false);
                this.activeAgendaButton.setVisible(online && moderator);
                this.editAgendaButton.setVisible(online && moderator);
                this.previousItemButton.setVisible(online && moderator);
                this.nextItemButton.setVisible(online && moderator);
            }
        }
        this.repaint();
        this.revalidate();
    }

    private void updateButtonsSelected() {
        Agenda[] ags = this.bean.getTargetedAgendas();
        short editorAddress = ags != null && ags.length == 1 ? (short)ags[0].getEditor() : (short)-32767;
        boolean editor = editorAddress != -32767 && this.bean.isMe(editorAddress);
        boolean active = ags != null && ags.length == 1 && this.library.isActiveAgenda(ags[0]);
        this.activeAgendaButton.setSelected(active);
        this.editAgendaButton.setSelected(editor);
        String tip = active ? this.i18n.getString((PropertiesEnum)StringsProperties.AGENDATOOLBAR_DEACTIVATEAGENDATIP) : this.i18n.getString((PropertiesEnum)StringsProperties.AGENDATOOLBAR_ACTIVATEAGENDATIP);
        this.activeAgendaButton.setToolTipText(tip);
        tip = editor ? this.i18n.getString((PropertiesEnum)StringsProperties.AGENDATOOLBAR_RELEASECONTROLAGENDATIP) : this.i18n.getString((PropertiesEnum)StringsProperties.AGENDATOOLBAR_REQUESTCONTROLAGENDATIP);
        this.editAgendaButton.setToolTipText(tip);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals("agenda.protected")) {
            this.updateButtonsVisible();
        } else if (prop.equals("targetedAgendas")) {
            this.updateButtonsEnabled();
            this.updateButtonsSelected();
        } else if (prop.equals("targetedItems")) {
            this.updateButtonsEnabled();
        } else if (prop.equals("moderator")) {
            this.updateButtonsVisible();
        }
    }

    public void editorChanged(AgendaEvent e) {
        this.updateButtonsVisible();
        this.updateButtonsEnabled();
        this.updateButtonsSelected();
    }

    public void transferAdded(AgendaEvent e) {
        this.updateButtonsEnabled();
    }

    public void transferRemoved(AgendaEvent e) {
        this.updateButtonsEnabled();
    }

    public void agendaPropertyChanged(AgendaEvent e) {
    }

    public void itemAdded(AgendaEvent e) {
    }

    public void itemRemoved(AgendaEvent e) {
    }

    public void itemPropertyChanged(AgendaEvent e) {
    }

    public void timerStarted(AgendaEvent e) {
    }

    public void timerStopped(AgendaEvent e) {
    }

    public void agendaActivated(AgendaLibraryEvent e) {
        this.updateButtonsEnabled();
        this.updateButtonsSelected();
    }

    public void agendaDeactivated(AgendaLibraryEvent e) {
        this.updateButtonsEnabled();
        this.updateButtonsSelected();
    }

    public void agendaAdded(AgendaLibraryEvent e) {
        e.getAgenda().addAgendaListener((AgendaListener)this);
        this.updateButtonsEnabled();
    }

    public void agendaRemoved(AgendaLibraryEvent e) {
        e.getAgenda().removeAgendaListener((AgendaListener)this);
        this.updateButtonsEnabled();
    }

    public void agendaAutoloaded(AgendaLibraryEvent e) {
    }

    public void onAddClient(ClientEvent e) {
        if (e.isMe()) {
            this.updateButtonsVisible();
            this.updateButtonsEnabled();
        }
    }

    public void onRemoveClient(ClientEvent e) {
        if (e.isMe()) {
            this.updateButtonsVisible();
            this.updateButtonsEnabled();
        }
    }

    private class AddActionMenuItem
    extends JMenuItem
    implements ActionListener {
        private ActionInfo action;

        public AddActionMenuItem(ActionInfo action) {
            super(action.getDisplayName());
            this.action = action;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ToolBar.this.bean.doAddAction(this.action.getCommandInterface());
        }
    }

    private static class ToolBarMenuButton
    extends CMenuButton {
        public ToolBarMenuButton(Icon icon) {
            super(icon);
            this.setHorizontalTextPosition(0);
            this.setVerticalTextPosition(3);
            RollOverBehavior.install((AbstractButton)((Object)this));
        }
    }
}

