/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.agenda.module;

import com.elluminate.platform.Platform;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

class ScreenRegionPicker
extends JDialog {
    private static final Font PROMPT_FONT;
    private static final Color PROMPT_BACKGROUND;
    private static final Color PROMPT_FOREGROUND;
    private static final Insets PROMPT_INSETS;
    private static final int PROMPT_ARC = 40;
    private static final Color SELECTION_BACKGROUND;
    private static final Color SELECTION_BORDER;
    private String prompt;
    private BufferedImage screenShot;
    private BufferedImage compositedImage;
    private Rectangle selectedRegion;
    private Point mouseDown;
    private Point mouseDrag;
    private boolean showPrompt = true;
    private boolean cancelled = true;

    public ScreenRegionPicker() {
        this((String)null);
    }

    public ScreenRegionPicker(String prompt) {
        super((Frame)null, "", true);
        this.setUndecorated(true);
        this.setDefaultCloseOperation(2);
        this.setCursor(Cursor.getPredefinedCursor(1));
        this.prompt = prompt;
        Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle rect = new Rectangle(0, 0, ss.width, ss.height);
        this.setBounds(rect);
        this.screenShot = ScreenRegionPicker.getScreenShot(rect);
        this.compositedImage = new BufferedImage(this.screenShot.getWidth(null), this.screenShot.getHeight(null), 1);
        this.getContentPane().setFocusable(true);
        JRootPane root = this.getRootPane();
        String cancelPickerAction = "cancel-picker-action";
        root.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "cancel-picker-action");
        root.getActionMap().put("cancel-picker-action", new AbstractAction("cancel-picker-action"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScreenRegionPicker.this.setVisible(false);
                ScreenRegionPicker.this.dispose();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ScreenRegionPicker.this.mouseDown = e.getPoint();
                ScreenRegionPicker.this.showPrompt = false;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                int y2;
                int x2;
                int y1;
                Point mouseUp = e.getPoint();
                int x1 = Math.min(((ScreenRegionPicker)ScreenRegionPicker.this).mouseDown.x, mouseUp.x);
                Rectangle r = new Rectangle(x1, y1 = Math.min(((ScreenRegionPicker)ScreenRegionPicker.this).mouseDown.y, mouseUp.y), (x2 = Math.max(((ScreenRegionPicker)ScreenRegionPicker.this).mouseDown.x, mouseUp.x)) - x1, (y2 = Math.max(((ScreenRegionPicker)ScreenRegionPicker.this).mouseDown.y, mouseUp.y)) - y1);
                if (!r.isEmpty()) {
                    ScreenRegionPicker.this.selectedRegion = r;
                    ScreenRegionPicker.this.cancelled = false;
                }
                ScreenRegionPicker.this.mouseDown = null;
                ScreenRegionPicker.this.mouseDrag = null;
                ScreenRegionPicker.this.compositedImage = null;
                ScreenRegionPicker.this.setVisible(false);
                ScreenRegionPicker.this.dispose();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                ScreenRegionPicker.this.mouseDrag = e.getPoint();
                ScreenRegionPicker.this.repaint();
            }
        });
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
        this.repaint();
    }

    public String getPrompt() {
        return this.prompt;
    }

    @Override
    public void paint(Graphics g) {
        Graphics og = this.compositedImage.getGraphics();
        if (og != null) {
            ((Graphics2D)og).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.screenShot != null) {
                og.drawImage(this.screenShot, 0, 0, this);
            }
            if (this.showPrompt && this.prompt != null) {
                Dimension s = this.getSize();
                og.setFont(PROMPT_FONT);
                FontMetrics fm = og.getFontMetrics();
                int w = fm.stringWidth(this.prompt);
                int h = fm.getHeight();
                int x = (s.width - w) / 2;
                int y = s.height / 2;
                Rectangle b = new Rectangle(x - ScreenRegionPicker.PROMPT_INSETS.left, y - ScreenRegionPicker.PROMPT_INSETS.top - fm.getAscent(), w + ScreenRegionPicker.PROMPT_INSETS.left + ScreenRegionPicker.PROMPT_INSETS.right, h + ScreenRegionPicker.PROMPT_INSETS.top + ScreenRegionPicker.PROMPT_INSETS.bottom);
                og.setColor(PROMPT_BACKGROUND);
                og.fillRoundRect(b.x, b.y, b.width, b.height, 40, 40);
                og.setColor(PROMPT_FOREGROUND);
                og.drawString(this.prompt, x, y);
            }
            if (this.mouseDown != null && this.mouseDrag != null) {
                int x1 = Math.min(this.mouseDown.x, this.mouseDrag.x);
                int y1 = Math.min(this.mouseDown.y, this.mouseDrag.y);
                int x2 = Math.max(this.mouseDown.x, this.mouseDrag.x);
                int y2 = Math.max(this.mouseDown.y, this.mouseDrag.y);
                og.setColor(SELECTION_BACKGROUND);
                og.fillRect(x1, y1, x2 - x1, y2 - y1);
                og.setColor(SELECTION_BORDER);
                og.drawRect(x1, y1, x2 - x1, y2 - y1);
            }
            og.dispose();
        }
        g.drawImage(this.compositedImage, 0, 0, this);
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    public Rectangle getSelectedRegion() {
        return this.selectedRegion;
    }

    public BufferedImage getSelectedImage() {
        if (!this.cancelled && this.screenShot != null) {
            return this.screenShot.getSubimage(this.selectedRegion.x, this.selectedRegion.y, this.selectedRegion.width, this.selectedRegion.height);
        }
        return null;
    }

    private static BufferedImage getScreenShot(Rectangle bounds) {
        try {
            Robot ro = new Robot();
            return ro.createScreenCapture(bounds);
        }
        catch (AWTException ex) {
            return null;
        }
    }

    static {
        PROMPT_BACKGROUND = new Color(96, 96, 96, 128);
        PROMPT_FOREGROUND = Color.WHITE;
        PROMPT_INSETS = new Insets(40, 40, 40, 40);
        SELECTION_BACKGROUND = new Color(128, 128, 128, 64);
        SELECTION_BORDER = Color.WHITE;
        Font f = UIManager.getFont("Label.font");
        PROMPT_FONT = Platform.getLAF() == 503 ? f.deriveFont(0, 32.0f) : f.deriveFont(1, 32.0f);
    }
}

