/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.agenda.module;

import com.elluminate.framework.imps.Imps;
import com.elluminate.groupware.agenda.Agenda;
import com.elluminate.groupware.agenda.AgendaAction;
import com.elluminate.groupware.agenda.AgendaExecutable;
import com.elluminate.groupware.agenda.AgendaFile;
import com.elluminate.groupware.agenda.AgendaItem;
import com.elluminate.groupware.agenda.AgendaText;
import com.elluminate.groupware.agenda.AgendaTopic;
import com.elluminate.groupware.agenda.AgendaUtils;
import com.elluminate.groupware.agenda.event.AgendaAdapter;
import com.elluminate.groupware.agenda.event.AgendaEvent;
import com.elluminate.groupware.agenda.event.AgendaListener;
import com.elluminate.groupware.agenda.module.Actions;
import com.elluminate.groupware.agenda.module.ApplicationFilter;
import com.elluminate.groupware.agenda.module.DurationEditor;
import com.elluminate.groupware.agenda.module.ScreenRegionPicker;
import com.elluminate.groupware.agenda.module.StringsProperties;
import com.elluminate.groupware.agenda.module.action.ActionGroup;
import com.elluminate.groupware.agenda.module.action.ActionInfo;
import com.elluminate.groupware.agenda.module.action.ActionParameter;
import com.elluminate.groupware.agenda.module.action.ActionParameterValue;
import com.elluminate.groupware.imps.QuizModelAPI;
import com.elluminate.groupware.imps.WhiteboardFilePreviewAPI;
import com.elluminate.groupware.imps.quiz.Quiz;
import com.elluminate.groupware.imps.whiteboard.WhiteboardScreenNode;
import com.elluminate.gui.component.EasyDialog;
import com.elluminate.gui.component.MultilineLabel;
import com.elluminate.gui.swing.CFileChooser;
import com.elluminate.gui.swing.CPopupMenu;
import com.elluminate.gui.swing.CTree;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class PropertyEditor
extends JPanel {
    public static final Color BACKGROUND_COLOR;
    private static final String CARD_NONE = "none";
    private static final String CARD_AGENDA = "agenda";
    private static final String CARD_TOPIC = "topic";
    private static final String CARD_ACTION = "action";
    private static final String CARD_TEXT = "text";
    private static final String CARD_FILE = "file";
    private static File lastFileDirectory;
    private static File lastApplicationDirectory;
    private I18n i18n;
    private CardLayout cardLayout = new CardLayout();
    private NoneEditor noneEditor;
    private AgendaEditor agendaEditor;
    private TopicEditor topicEditor;
    private ActionEditor actionEditor;
    private TextEditor textEditor;
    private FileEditor fileEditor;
    private Agenda agenda;
    private AgendaItem item;
    private Imps imps;

    @Inject
    public PropertyEditor(I18n i18n) {
        this.setLayout(this.cardLayout);
        this.i18n = i18n;
        this.noneEditor = new NoneEditor();
        this.add((Component)this.noneEditor, CARD_NONE);
        this.agendaEditor = new AgendaEditor();
        this.add((Component)this.agendaEditor, CARD_AGENDA);
        this.topicEditor = new TopicEditor();
        this.add((Component)this.topicEditor, CARD_TOPIC);
        this.actionEditor = new ActionEditor();
        this.add((Component)this.actionEditor, CARD_ACTION);
        this.textEditor = new TextEditor();
        this.add((Component)this.textEditor, CARD_TEXT);
        this.fileEditor = new FileEditor();
        this.add((Component)this.fileEditor, CARD_FILE);
    }

    @Inject
    public void initImps(Imps imps) {
        this.imps = imps;
    }

    public Agenda getAgenda() {
        return this.agenda;
    }

    public void setAgenda(Agenda agenda) {
        this.agenda = agenda;
        if (agenda == null) {
            this.cardLayout.show(this, CARD_NONE);
        } else {
            this.agendaEditor.setAgenda(agenda);
            this.cardLayout.show(this, CARD_AGENDA);
        }
    }

    public AgendaItem getItem() {
        return this.item;
    }

    public void setItem(AgendaItem item) {
        this.item = item;
        if (item == null) {
            this.cardLayout.show(this, CARD_AGENDA);
        } else if (item instanceof AgendaTopic) {
            this.topicEditor.setItem(item);
            this.cardLayout.show(this, CARD_TOPIC);
        } else if (item instanceof AgendaAction) {
            this.actionEditor.setItem(item);
            this.cardLayout.show(this, CARD_ACTION);
        } else if (item instanceof AgendaText) {
            this.textEditor.setItem(item);
            this.cardLayout.show(this, CARD_TEXT);
        } else if (item instanceof AgendaFile) {
            this.fileEditor.setItem(item);
            this.cardLayout.show(this, CARD_FILE);
        }
    }

    public void startEditing(String text) {
        if (this.topicEditor.isVisible()) {
            this.topicEditor.editName(text);
        } else if (this.actionEditor.isVisible()) {
            this.actionEditor.editDescription(text);
        } else if (this.textEditor.isVisible()) {
            this.textEditor.editText(text);
        } else if (this.fileEditor.isVisible()) {
            this.fileEditor.editName(text);
        }
    }

    static {
        switch (Platform.getLAF()) {
            case 502: {
                BACKGROUND_COLOR = new Color(215, 221, 230);
                break;
            }
            default: {
                BACKGROUND_COLOR = UIManager.getColor("Panel.background");
            }
        }
        switch (Platform.getPlatform()) {
            case 1: {
                lastApplicationDirectory = new File("C:\\Program Files");
                break;
            }
            case 2: {
                lastApplicationDirectory = new File("/Applications");
                break;
            }
            case 3: {
                lastApplicationDirectory = new File("/opt");
            }
        }
    }

    private static abstract class AbstractEditor
    extends JPanel {
        protected static final Font TITLE_FONT;
        protected static final Font SMALL_FONT;
        protected static final int RIGHT_GAP = 10;
        protected static final int SECTION_GAP = 8;
        protected static final int CONTROL_GAP;

        public AbstractEditor(LayoutManager layout) {
            super(layout);
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            this.setBackground(BACKGROUND_COLOR);
        }

        static {
            Font f = UIManager.getFont("Label.font");
            TITLE_FONT = f.deriveFont(1, f.getSize());
            SMALL_FONT = Platform.getLAF() == 502 ? f.deriveFont(0, f.getSize() - 2) : f;
            boolean leopard15 = Platform.checkJavaVersion((String)"1.5+") && Platform.checkOSVersion((int)202, (String)"10.5+");
            CONTROL_GAP = leopard15 ? 0 : 2;
        }
    }

    private class ActionEditor
    extends ExecutableItemEditor {
        private JTextField descriptionField;
        private JLabel notesLabel;
        private JTextArea notesField;
        private JScrollPane notesScroller;
        private JLabel durationLabel;
        private JSpinner durationField;
        private Component filler;
        private AgendaAction action;
        private boolean listening;
        private AgendaListener actionListener;

        public ActionEditor() {
            super(new GridBagLayout());
            this.listening = false;
            this.actionListener = new AgendaAdapter(){

                public void itemPropertyChanged(AgendaEvent e) {
                    if (e.getItem() == ActionEditor.this.action) {
                        String prop = e.getProperty();
                        if (prop.equals("description")) {
                            String desc = ActionEditor.this.action.getDescription();
                            if (!ActionEditor.this.descriptionField.getText().equals(desc)) {
                                ActionEditor.this.descriptionField.setText(desc);
                            }
                        } else if (prop.equals("note")) {
                            String note = ActionEditor.this.action.getNote();
                            if (!ActionEditor.this.notesField.getText().equals(note)) {
                                ActionEditor.this.notesField.setText(note);
                            }
                        }
                    }
                }
            };
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.weightx = 1.0;
            gbc.gridx = 0;
            gbc.fill = 0;
            gbc.weighty = 0.0;
            gbc.insets.top = 8;
            gbc.insets.right = 10;
            JLabel l = new JLabel(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_ACTIONPANELTITLE));
            l.setFont(TITLE_FONT);
            this.add((Component)l, gbc);
            gbc.fill = 0;
            gbc.weighty = 0.0;
            gbc.insets.top = 8;
            gbc.insets.right = 10;
            l = new JLabel(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_ACTIONDESCRIPTIONLABEL));
            l.setToolTipText(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_ACTIONDESCRIPTIONTIP));
            l.setFont(SMALL_FONT);
            this.add((Component)l, gbc);
            gbc.fill = 2;
            gbc.weighty = 0.0;
            gbc.insets.top = CONTROL_GAP;
            gbc.insets.right = 10;
            this.descriptionField = new JTextField();
            this.descriptionField.setToolTipText(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_ACTIONDESCRIPTIONTIP));
            this.descriptionField.setFont(SMALL_FONT);
            this.descriptionField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.descriptionChanged();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.descriptionChanged();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.descriptionChanged();
                }

                private void descriptionChanged() {
                    if (ActionEditor.this.listening && ActionEditor.this.action != null) {
                        String desc = ActionEditor.this.descriptionField.getText();
                        if (!ActionEditor.this.action.getDescription().equals(desc)) {
                            ActionEditor.this.action.setDescription(desc);
                        }
                    }
                }
            });
            this.add((Component)this.descriptionField, gbc);
            gbc.fill = 0;
            gbc.insets.top = 8;
            gbc.weighty = 0.0;
            gbc.insets.right = 10;
            l = new JLabel(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_ACTIONCOMMANDLABEL));
            l.setToolTipText(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_ACTIONCOMMANDTIP));
            l.setFont(SMALL_FONT);
            this.add((Component)l, gbc);
            gbc.fill = 2;
            gbc.weighty = 0.0;
            gbc.insets.top = CONTROL_GAP;
            gbc.insets.right = 10;
            this.commandPopup.setToolTipText(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_ACTIONCOMMANDTIP));
            this.commandPopup.setNoSelectionText(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_ACTIONCOMPOUNDCOMMANDITEM));
            this.commandPopup.addPropertyChangeListener("selectedCommand", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (ActionEditor.this.listening && ActionEditor.this.action != null) {
                        boolean customDesc = false;
                        String cmdName = ActionEditor.this.action.getCommandName();
                        customDesc = cmdName == null ? !ActionEditor.this.commandPopup.getNoSelectionText().equals(ActionEditor.this.action.getDescription()) : Actions.isActionDescriptionCustomized(ActionEditor.this.action);
                        Class cmd = null;
                        String desc = null;
                        cmdName = (String)e.getNewValue();
                        if (cmdName == null) {
                            desc = ActionEditor.this.commandPopup.getNoSelectionText();
                        } else {
                            ActionInfo act = Actions.getAction(cmdName);
                            if (act != null) {
                                cmd = act.getCommandInterface();
                                desc = act.getDefaultDescription();
                            }
                        }
                        Actions.setupExecutable((AgendaExecutable)ActionEditor.this.action, cmd);
                        ActionEditor.this.populateParameters((AgendaExecutable)ActionEditor.this.action);
                        if (!customDesc && desc != null) {
                            ActionEditor.this.descriptionField.setText(desc);
                        }
                    }
                }
            });
            this.add((Component)this.commandPopup, gbc);
            gbc.fill = 2;
            gbc.weighty = 0.0;
            gbc.insets.top = 0;
            gbc.insets.right = 0;
            this.add((Component)this.parameterPanel, gbc);
            gbc.fill = 0;
            gbc.weighty = 0.0;
            gbc.insets.top = 8;
            gbc.insets.right = 10;
            this.notesLabel = new JLabel(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_ACTIONNOTESLABEL));
            this.notesLabel.setToolTipText(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_NOTESTIP));
            this.notesLabel.setFont(SMALL_FONT);
            this.add((Component)this.notesLabel, gbc);
            gbc.fill = 1;
            gbc.weighty = 1.0;
            gbc.insets.top = CONTROL_GAP;
            this.notesField = new JTextArea();
            this.notesField.setToolTipText(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_NOTESTIP));
            this.notesField.setFont(SMALL_FONT);
            this.notesField.setLineWrap(true);
            this.notesField.setWrapStyleWord(true);
            this.notesField.setMargin(new Insets(1, 2, 1, 2));
            this.notesField.setFocusTraversalKeys(0, null);
            this.notesField.setFocusTraversalKeys(1, null);
            this.notesField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.notesChanged();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.notesChanged();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.notesChanged();
                }

                private void notesChanged() {
                    if (ActionEditor.this.listening && ActionEditor.this.action != null) {
                        ActionEditor.this.action.setNote(ActionEditor.this.notesField.getText());
                    }
                }
            });
            this.notesScroller = new JScrollPane(this.notesField, 20, 31);
            gbc.insets.right = -this.notesScroller.getInsets().right;
            this.add((Component)this.notesScroller, gbc);
            gbc.fill = 0;
            gbc.weighty = 0.0;
            gbc.insets.top = 8;
            gbc.insets.right = 10;
            this.durationLabel = new JLabel(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_ACTIONDURATIONLABEL));
            this.durationLabel.setToolTipText(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_DURATIONTIP));
            this.durationLabel.setFont(SMALL_FONT);
            this.add((Component)this.durationLabel, gbc);
            gbc.fill = 2;
            gbc.weighty = 0.0;
            gbc.insets.top = CONTROL_GAP;
            gbc.insets.right = 10;
            this.durationField = new JSpinner(new SpinnerNumberModel(0, 0, 359999, 1));
            this.durationField.setEditor(new DurationEditor(this.durationField));
            this.durationField.setToolTipText(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_DURATIONTIP));
            this.durationField.setFont(SMALL_FONT);
            this.durationField.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (ActionEditor.this.listening && ActionEditor.this.action != null) {
                        Number val = (Number)ActionEditor.this.durationField.getValue();
                        ActionEditor.this.action.setDuration(val.intValue());
                    }
                }
            });
            this.add((Component)this.durationField, gbc);
            gbc.fill = 3;
            gbc.weighty = 1.0;
            gbc.insets.top = 0;
            this.filler = Box.createVerticalGlue();
            this.add(this.filler, gbc);
        }

        @Override
        public void setItem(AgendaItem item) {
            this.setAction((AgendaAction)item);
        }

        private void setAction(AgendaAction action) {
            Agenda ag;
            Agenda ag2;
            this.listening = false;
            if (this.action != null && (ag2 = this.action.getParentAgenda()) != null) {
                ag2.removeAgendaListener(this.actionListener);
            }
            boolean wasNull = this.action == null;
            boolean wasCompound = this.action != null && this.action.isCompoundAction();
            boolean isCompound = action != null && action.isCompoundAction();
            this.action = action;
            if (wasNull || wasCompound != isCompound) {
                this.populateCommands();
            }
            if (action != null) {
                boolean unknownCommand;
                this.descriptionField.setText(action.getDescription());
                this.descriptionField.getCaret().setDot(0);
                ActionInfo act = null;
                String cmd = action.getCommandName();
                if (cmd != null) {
                    act = Actions.getAction(cmd);
                }
                boolean bl = unknownCommand = cmd != null && act == null;
                if (!unknownCommand) {
                    this.commandPopup.setSelectedCommand(cmd);
                } else {
                    this.commandPopup.setSelectedIndex(-1);
                }
                if (!unknownCommand && !action.isCompounded()) {
                    this.notesLabel.setVisible(true);
                    this.notesScroller.setVisible(true);
                    this.notesField.setText(action.getNote());
                    this.durationLabel.setVisible(true);
                    this.durationField.setVisible(true);
                    this.durationField.setValue(new Integer(action.getDuration()));
                    this.filler.setVisible(false);
                } else {
                    this.notesLabel.setVisible(false);
                    this.notesScroller.setVisible(false);
                    this.notesField.setText(null);
                    this.durationLabel.setVisible(false);
                    this.durationField.setVisible(false);
                    this.durationField.setValue(new Integer(0));
                    this.filler.setVisible(true);
                }
            }
            this.populateParameters((AgendaExecutable)action);
            if (action != null && (ag = action.getParentAgenda()) != null) {
                ag.addAgendaListener(this.actionListener);
            }
            this.listening = true;
        }

        @Override
        protected void populateCommands() {
            this.commandPopup.removeAllItems();
            if (this.action != null && this.action.isCompoundAction()) {
                this.commandPopup.addItem(new CommandMenuItem(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_ACTIONCOMPOUNDCOMMANDITEM), null));
            } else {
                ActionGroup[] grps = Actions.getGroups();
                for (int i = 0; i < grps.length; ++i) {
                    ActionGroup grp = grps[i];
                    JMenu m = new JMenu(grp.getDisplayName());
                    this.commandPopup.addItem(m);
                    ActionInfo[] acts = grp.getActions();
                    for (int j = 0; j < acts.length; ++j) {
                        ActionInfo act = acts[j];
                        m.add(new CommandMenuItem(act.getDisplayName(), act.getCommandInterface()));
                    }
                }
            }
        }

        public void editDescription(final String text) {
            this.descriptionField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    ActionEditor.this.descriptionField.removeFocusListener(this);
                    ActionEditor.this.descriptionField.setText(text);
                }
            });
            this.descriptionField.requestFocus();
        }
    }

    private class AgendaEditor
    extends AbstractEditor {
        private JCheckBox trackAutomaticallyBox;
        private JCheckBox showIconsBox;
        private JComboBox labelTypePopup;
        private Agenda agenda;
        private AgendaListener agendaListener;
        private boolean listening;

        public AgendaEditor() {
            super(new GridBagLayout());
            this.agendaListener = new AgendaAdapter(){

                public void agendaPropertyChanged(AgendaEvent e) {
                    AgendaEditor.this.update(e.getProperty());
                }
            };
            this.listening = false;
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.insets.right = 10;
            gbc.gridy = 0;
            gbc.gridx = 0;
            gbc.weightx = 1.0;
            gbc.gridwidth = 2;
            gbc.insets.top = 8;
            gbc.insets.right = 10;
            JLabel l = new JLabel(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_AGENDAPANELTITLE));
            l.setFont(TITLE_FONT);
            this.add((Component)l, gbc);
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.weightx = 1.0;
            gbc.gridwidth = 2;
            gbc.insets.top = 8;
            gbc.insets.right = 10;
            l = new JLabel(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_AGENDADURATIONTRACKINGLABEL));
            l.setFont(SMALL_FONT);
            this.add((Component)l, gbc);
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.weightx = 1.0;
            gbc.gridwidth = 2;
            gbc.insets.top = CONTROL_GAP;
            gbc.insets.right = 10;
            this.trackAutomaticallyBox = new JCheckBox(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_AGENDADURATIONTRACKINGBOX));
            this.trackAutomaticallyBox.setToolTipText(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_AGENDADURATIONTRACKINGTIP));
            this.trackAutomaticallyBox.setFont(SMALL_FONT);
            this.trackAutomaticallyBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AgendaEditor.this.listening && AgendaEditor.this.agenda != null) {
                        boolean auto = AgendaEditor.this.trackAutomaticallyBox.isSelected();
                        if (AgendaEditor.this.agenda.isTimeTrackingAutomatic() != auto) {
                            AgendaEditor.this.agenda.setTimeTrackingAutomatic(auto);
                        }
                    }
                }
            });
            this.add((Component)this.trackAutomaticallyBox, gbc);
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.weightx = 1.0;
            gbc.gridwidth = 2;
            gbc.insets.top = 8;
            gbc.insets.right = 10;
            l = new JLabel(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_AGENDADECORATIONSLABEL));
            l.setFont(SMALL_FONT);
            this.add((Component)l, gbc);
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.weightx = 1.0;
            gbc.gridwidth = 2;
            gbc.insets.top = CONTROL_GAP;
            gbc.insets.right = 10;
            this.showIconsBox = new JCheckBox(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_AGENDASHOWICONSBOX));
            this.showIconsBox.setToolTipText(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_AGENDASHOWICONSTIP));
            this.showIconsBox.setFont(SMALL_FONT);
            this.showIconsBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AgendaEditor.this.listening && AgendaEditor.this.agenda != null) {
                        boolean show = AgendaEditor.this.showIconsBox.isSelected();
                        if (AgendaEditor.this.agenda.isShowingIcons() != show) {
                            AgendaEditor.this.agenda.setShowingIcons(show);
                        }
                    }
                }
            });
            this.add((Component)this.showIconsBox, gbc);
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.weightx = 0.0;
            gbc.gridwidth = 1;
            gbc.insets.top = 8;
            gbc.insets.right = 4;
            l = new JLabel(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_AGENDALABELTYPELABEL));
            l.setFont(SMALL_FONT);
            this.add((Component)l, gbc);
            gbc.gridx = 1;
            gbc.weightx = 1.0;
            gbc.gridwidth = 1;
            gbc.insets.top = 8;
            gbc.insets.right = 10;
            this.labelTypePopup = new JComboBox();
            this.labelTypePopup.setToolTipText(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_AGENDALABELTYPETIP));
            this.labelTypePopup.setFont(SMALL_FONT);
            this.labelTypePopup.addItem(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_LABELTYPENONE));
            this.labelTypePopup.addItem(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_LABELTYPELEADER));
            this.labelTypePopup.addItem(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_LABELTYPEBULLET));
            this.labelTypePopup.addItem(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_LABELTYPENUMBER));
            this.labelTypePopup.addItem(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_LABELTYPELEGAL));
            this.labelTypePopup.addItem(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_LABELTYPELOWERCASELETTER));
            this.labelTypePopup.addItem(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_LABELTYPEUPPERCASELETTER));
            this.labelTypePopup.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AgendaEditor.this.listening && AgendaEditor.this.agenda != null) {
                        int type = AgendaEditor.this.getLabelType();
                        if (AgendaEditor.this.agenda.getLabelType() != type) {
                            AgendaEditor.this.agenda.setLabelType(type);
                        }
                    }
                }
            });
            this.add((Component)this.labelTypePopup, gbc);
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.weightx = 1.0;
            gbc.gridwidth = 2;
            gbc.insets.top = 0;
            gbc.insets.right = 10;
            gbc.weighty = 1.0;
            this.add(Box.createVerticalGlue(), gbc);
        }

        public void setAgenda(Agenda agenda) {
            this.listening = false;
            if (this.agenda != null) {
                this.agenda.removeAgendaListener(this.agendaListener);
            }
            this.agenda = agenda;
            if (agenda != null) {
                this.trackAutomaticallyBox.setSelected(agenda.isTimeTrackingAutomatic());
                this.showIconsBox.setSelected(agenda.isShowingIcons());
                this.setLabelType(agenda.getLabelType());
                agenda.addAgendaListener(this.agendaListener);
            }
            this.listening = true;
        }

        private void update(String property) {
            if (property.equals("autotimetracking")) {
                this.updateTrackAutomatically();
            } else if (property.equals("showicons")) {
                this.updateShowIcons();
            } else if (property.equals("labeltype")) {
                this.updateLabelType();
            }
        }

        private void updateTrackAutomatically() {
            boolean auto = this.agenda.isTimeTrackingAutomatic();
            if (this.trackAutomaticallyBox.isSelected() != auto) {
                this.trackAutomaticallyBox.setSelected(auto);
            }
        }

        private void updateShowIcons() {
            boolean show = this.agenda.isShowingIcons();
            if (this.showIconsBox.isSelected() != show) {
                this.showIconsBox.setSelected(show);
            }
        }

        private void updateLabelType() {
            int type = this.agenda.getLabelType();
            if (this.getLabelType() != type) {
                this.setLabelType(type);
            }
        }

        private int getLabelType() {
            switch (this.labelTypePopup.getSelectedIndex()) {
                case 6: {
                    return 6;
                }
                case 5: {
                    return 5;
                }
                case 4: {
                    return 4;
                }
                case 3: {
                    return 3;
                }
                case 2: {
                    return 2;
                }
                case 1: {
                    return 1;
                }
            }
            return 0;
        }

        private void setLabelType(int labelType) {
            switch (labelType) {
                case 6: {
                    this.labelTypePopup.setSelectedIndex(6);
                    break;
                }
                case 5: {
                    this.labelTypePopup.setSelectedIndex(5);
                    break;
                }
                case 4: {
                    this.labelTypePopup.setSelectedIndex(4);
                    break;
                }
                case 3: {
                    this.labelTypePopup.setSelectedIndex(3);
                    break;
                }
                case 2: {
                    this.labelTypePopup.setSelectedIndex(2);
                    break;
                }
                case 1: {
                    this.labelTypePopup.setSelectedIndex(1);
                    break;
                }
                default: {
                    this.labelTypePopup.setSelectedIndex(0);
                }
            }
        }
    }

    private class ApplicationField
    extends JPanel
    implements DocumentListener,
    ActionListener {
        private JTextField applicationField;
        private JButton browseButton;
        private ActionParameter parameter;
        private AgendaExecutable executable;

        public ApplicationField(ActionParameter parameter, AgendaExecutable executable) {
            super(new GridBagLayout());
            this.setOpaque(false);
            this.parameter = parameter;
            this.executable = executable;
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.applicationField = new JTextField();
            this.applicationField.setToolTipText(parameter.getHelpText());
            this.add((Component)this.applicationField, gbc);
            gbc.weightx = 0.0;
            gbc.insets.left = 2;
            this.browseButton = new BrowseButton();
            this.browseButton.addActionListener(this);
            this.add((Component)this.browseButton, gbc);
            this.applicationField.setText(executable.getStringParameter(parameter.getName()));
            this.applicationField.getCaret().setDot(0);
            this.applicationField.getDocument().addDocumentListener(this);
        }

        @Override
        public void setFont(Font font) {
            super.setFont(font);
            if (this.applicationField != null) {
                this.applicationField.setFont(font);
            }
            if (this.browseButton != null) {
                this.browseButton.setFont(font);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.textChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.textChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.textChanged();
        }

        private void textChanged() {
            this.executable.setCommandParameter(this.parameter.getName(), this.applicationField.getText());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CFileChooser ch = new CFileChooser();
            ch.setMultiSelectionEnabled(false);
            ch.setCurrentDirectory(lastApplicationDirectory);
            ch.setAcceptAllFileFilterUsed(false);
            ch.addChoosableFileFilter((FileFilter)new ApplicationFilter(PropertyEditor.this.i18n));
            Window w = SwingUtilities.getWindowAncestor(this);
            if (ch.showOpenDialog((Component)w) != 0) {
                return;
            }
            lastApplicationDirectory = ch.getCurrentDirectory();
            File f = ch.getSelectedFile();
            this.applicationField.setText(f.getAbsolutePath());
            this.applicationField.getCaret().setDot(0);
        }
    }

    private static class BooleanField
    extends JCheckBox
    implements ActionListener {
        private ActionParameter parameter;
        private AgendaExecutable executable;

        public BooleanField(String text, ActionParameter parameter, AgendaExecutable executable) {
            super(text);
            this.setOpaque(false);
            this.setToolTipText(parameter.getHelpText());
            this.parameter = parameter;
            this.executable = executable;
            Boolean val = executable.getBooleanParameter(parameter.getName());
            if (val != null) {
                this.setSelected(val);
            }
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.executable.setCommandParameter(this.parameter.getName(), this.isSelected() ? "true" : "false");
        }
    }

    private class BoundsField
    extends JPanel
    implements DocumentListener,
    ActionListener {
        private JTextField xField;
        private JTextField yField;
        private JTextField widthField;
        private JTextField heightField;
        private JButton browseButton;
        private ActionParameter parameter;
        private AgendaExecutable executable;

        public BoundsField(ActionParameter parameter, AgendaExecutable executable) {
            super(new GridBagLayout());
            this.setOpaque(false);
            this.parameter = parameter;
            this.executable = executable;
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.gridy = 0;
            int left = Platform.getLAF() == 502 ? -4 : 2;
            gbc.weightx = 100.0;
            gbc.insets.left = 0;
            this.xField = new JTextField(10);
            this.xField.setToolTipText(parameter.getHelpText());
            this.add((Component)this.xField, gbc);
            gbc.weightx = 100.0;
            gbc.insets.left = left;
            this.yField = new JTextField(10);
            this.yField.setToolTipText(parameter.getHelpText());
            this.add((Component)this.yField, gbc);
            gbc.weightx = 100.0;
            gbc.insets.left = left;
            this.widthField = new JTextField(10);
            this.widthField.setToolTipText(parameter.getHelpText());
            this.add((Component)this.widthField, gbc);
            gbc.weightx = 100.0;
            gbc.insets.left = left;
            this.heightField = new JTextField(10);
            this.heightField.setToolTipText(parameter.getHelpText());
            this.add((Component)this.heightField, gbc);
            gbc.weightx = 0.0;
            gbc.insets.left = 2;
            this.browseButton = new BrowseButton();
            this.browseButton.addActionListener(this);
            this.add((Component)this.browseButton, gbc);
            Rectangle b = executable.getRectangleParameter(parameter.getName());
            if (b != null) {
                this.xField.setText(String.valueOf(b.x));
                this.xField.selectAll();
                this.yField.setText(String.valueOf(b.y));
                this.yField.selectAll();
                this.widthField.setText(String.valueOf(b.width));
                this.widthField.selectAll();
                this.heightField.setText(String.valueOf(b.height));
                this.heightField.selectAll();
            }
            this.xField.getDocument().addDocumentListener(this);
            this.yField.getDocument().addDocumentListener(this);
            this.widthField.getDocument().addDocumentListener(this);
            this.heightField.getDocument().addDocumentListener(this);
        }

        @Override
        public void setFont(Font font) {
            super.setFont(font);
            if (this.xField != null) {
                this.xField.setFont(font);
            }
            if (this.yField != null) {
                this.yField.setFont(font);
            }
            if (this.widthField != null) {
                this.widthField.setFont(font);
            }
            if (this.heightField != null) {
                this.heightField.setFont(font);
            }
            if (this.browseButton != null) {
                this.browseButton.setFont(font);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.textChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.textChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.textChanged();
        }

        private void textChanged() {
            try {
                int x = Integer.parseInt(this.xField.getText());
                int y = Integer.parseInt(this.yField.getText());
                int width = Integer.parseInt(this.widthField.getText());
                int height = Integer.parseInt(this.heightField.getText());
                this.executable.setCommandParameter(this.parameter.getName(), x + "," + y + "," + width + "," + height);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ScreenRegionPicker p = new ScreenRegionPicker(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_BOUNDSPICKERPROMPT));
            p.setVisible(true);
            if (!p.wasCancelled()) {
                Rectangle b = p.getSelectedRegion();
                this.xField.setText(String.valueOf(b.x));
                this.xField.selectAll();
                this.yField.setText(String.valueOf(b.y));
                this.yField.selectAll();
                this.widthField.setText(String.valueOf(b.width));
                this.widthField.selectAll();
                this.heightField.setText(String.valueOf(b.height));
                this.heightField.selectAll();
            }
        }
    }

    private static class BrowseButton
    extends JButton {
        public BrowseButton() {
            super("...");
            this.setOpaque(false);
            if (Platform.getLAF() == 502) {
                boolean leopard = Platform.checkOSVersion((int)202, (String)"10.5+");
                boolean java15 = Platform.checkJavaVersion((String)"1.5+");
                boolean java16 = Platform.checkJavaVersion((String)"1.6+");
                if (leopard && java15) {
                    this.putClientProperty("JButton.buttonType", "square");
                } else {
                    this.putClientProperty("JButton.buttonType", "toolbar");
                }
                if (Platform.checkJavaVersion((String)"1.5.0_16+")) {
                    this.setMargin(new Insets(2, 2, 2, 2));
                } else if (leopard && java15) {
                    this.setMargin(new Insets(7, 9, 7, 9));
                } else {
                    this.setMargin(new Insets(4, 6, 4, 6));
                }
            } else {
                this.setMargin(new Insets(0, 2, 0, 2));
            }
        }
    }

    private class ChooseContentDialog
    extends EasyDialog {
        private static final int MODE_FILE = 1;
        private static final int MODE_QUIZ = 2;
        private static final int MODE_SCREEN = 3;
        private int mode;
        private JTree tree;
        private JButton chooseButton;

        public ChooseContentDialog(Component owner, Agenda agenda, AgendaExecutable executable, int mode) {
            super(owner, null);
            this.setResizable(true);
            this.mode = mode;
            ActionInfo act = null;
            String cmdName = executable.getCommandName();
            if (cmdName != null) {
                act = Actions.getAction(cmdName);
            }
            MutableTreeNode root = this.buildTree(agenda, act);
            boolean subContent = false;
            for (int i = 0; i < root.getChildCount(); ++i) {
                TreeNode child = root.getChildAt(i);
                if (child.getChildCount() == 0) continue;
                subContent = true;
                break;
            }
            JPanel p = new JPanel(new BorderLayout(0, 6));
            this.setContent(p);
            MultilineLabel prompt = new MultilineLabel();
            p.add((Component)prompt, "North");
            this.tree = new CTree((TreeNode)root);
            this.tree.setRootVisible(false);
            this.tree.setShowsRootHandles(subContent);
            this.tree.getSelectionModel().setSelectionMode(1);
            this.tree.setCellRenderer(new DefaultTreeCellRenderer(){
                private JFileChooser ch = new CFileChooser();
                private FileView fileView = this.ch.getUI().getFileView(this.ch);

                @Override
                public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean focused) {
                    super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, focused);
                    if (value instanceof DefaultMutableTreeNode) {
                        Object obj = ((DefaultMutableTreeNode)value).getUserObject();
                        if (obj instanceof AgendaFile) {
                            AgendaFile f = (AgendaFile)obj;
                            this.setText(f.getName());
                            this.setIcon(AgendaUtils.getFileIcon((File)new File(f.getPath())));
                        } else if (obj instanceof Quiz) {
                            Quiz q = (Quiz)obj;
                            this.setText(q.getName());
                            this.setIcon(null);
                        } else if (obj instanceof WhiteboardScreenNode) {
                            WhiteboardScreenNode n = (WhiteboardScreenNode)obj;
                            this.setText(n.getName());
                            this.setIcon(null);
                        }
                    }
                    return this;
                }
            });
            this.tree.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        ChooseContentDialog.this.chooseButton.doClick();
                    } else {
                        Rectangle b;
                        Point pt = e.getPoint();
                        int row = ChooseContentDialog.this.tree.getRowForLocation(pt.x, pt.y);
                        if (row != -1 && !(b = ChooseContentDialog.this.tree.getRowBounds(row)).contains(pt)) {
                            ChooseContentDialog.this.tree.clearSelection();
                        }
                    }
                }
            });
            this.tree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    ChooseContentDialog.this.updateChooseButtonEnabled();
                }
            });
            JScrollPane sp = new JScrollPane(this.tree, 22, 31);
            p.add((Component)sp, "Center");
            switch (mode) {
                case 1: {
                    this.setTitle(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_FILECHOOSERTITLE));
                    prompt.setText(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_FILECHOOSERPROMPT));
                    break;
                }
                case 2: {
                    this.setTitle(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_QUIZCHOOSERTITLE));
                    prompt.setText(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_QUIZCHOOSERPROMPT));
                    break;
                }
                case 3: {
                    this.setTitle(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_SCREENCHOOSERTITLE));
                    prompt.setText(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_SCREENCHOOSERPROMPT));
                }
            }
            for (int i = 0; i < root.getChildCount(); ++i) {
                TreeNode n = root.getChildAt(i);
                if (n.getChildCount() == 0 || !(n instanceof DefaultMutableTreeNode)) continue;
                this.tree.expandPath(new TreePath(((DefaultMutableTreeNode)n).getPath()));
            }
            this.chooseButton = this.makeButton(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_CHOOSERCHOOSEBUTTONLABEL));
            this.chooseButton.setEnabled(false);
            this.addActionButton(this.chooseButton, true);
            this.addCancelButton(this.makeButton(0));
            this.setInitialFocus(this.tree);
            this.setSize(300, 300);
        }

        private void updateChooseButtonEnabled() {
            boolean en = false;
            TreePath path = this.tree.getSelectionPath();
            if (path != null) {
                Object obj = null;
                Object val = path.getLastPathComponent();
                if (val instanceof DefaultMutableTreeNode) {
                    obj = ((DefaultMutableTreeNode)val).getUserObject();
                }
                switch (this.mode) {
                    case 1: {
                        if (!(obj instanceof AgendaFile)) break;
                        en = true;
                        break;
                    }
                    case 2: {
                        if (!(obj instanceof Quiz)) break;
                        en = true;
                        break;
                    }
                    case 3: {
                        if (!(obj instanceof WhiteboardScreenNode)) break;
                        en = true;
                    }
                }
            }
            this.chooseButton.setEnabled(en);
        }

        private MutableTreeNode buildTree(Agenda agenda, ActionInfo action) {
            DefaultMutableTreeNode root = new DefaultMutableTreeNode();
            block8: for (int i = 0; i < agenda.getFileCount(); ++i) {
                AgendaFile f = agenda.getFile(i);
                File file = new File(f.getPath());
                String ext = AgendaUtils.parseFileName((File)file)[1];
                if (ext == null || !action.containsExtension(ext) && !action.containsExtension("*")) continue;
                DefaultMutableTreeNode fileNode = new DefaultMutableTreeNode();
                fileNode.setUserObject(f);
                root.add(fileNode);
                switch (this.mode) {
                    case 2: {
                        QuizModelAPI api;
                        try {
                            api = (QuizModelAPI)PropertyEditor.this.imps.findBest(QuizModelAPI.class);
                            if (api == null) continue block8;
                            this.addQuizzes(fileNode, api.readQuizLibrary(file));
                        }
                        catch (IOException ex) {}
                        continue block8;
                    }
                    case 3: {
                        QuizModelAPI api;
                        try {
                            api = (WhiteboardFilePreviewAPI)PropertyEditor.this.imps.findBest(WhiteboardFilePreviewAPI.class);
                            if (api == null) continue block8;
                            this.addScreens(fileNode, api.readWhiteboard(file));
                            continue block8;
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                }
            }
            return root;
        }

        private void addQuizzes(DefaultMutableTreeNode treeNode, Quiz[] quizzes) {
            for (int i = 0; i < quizzes.length; ++i) {
                DefaultMutableTreeNode childNode = new DefaultMutableTreeNode();
                childNode.setUserObject(quizzes[i]);
                treeNode.add(childNode);
            }
        }

        private void addScreens(DefaultMutableTreeNode treeNode, WhiteboardScreenNode screenNode) {
            for (int i = 0; i < screenNode.getChildCount(); ++i) {
                WhiteboardScreenNode child = screenNode.getChild(i);
                DefaultMutableTreeNode childNode = new DefaultMutableTreeNode();
                childNode.setUserObject(child);
                treeNode.add(childNode);
                this.addScreens(childNode, child);
            }
        }

        public Object getSelectedContent() {
            TreePath path = this.tree.getSelectionPath();
            if (path == null) {
                return null;
            }
            Object val = path.getLastPathComponent();
            if (val instanceof DefaultMutableTreeNode) {
                return ((DefaultMutableTreeNode)val).getUserObject();
            }
            return null;
        }
    }

    private static class CommandMenuItem
    extends JMenuItem {
        private Class commandInterface;

        public CommandMenuItem(String text, Class commandInterface) {
            super(text);
            this.commandInterface = commandInterface;
        }

        public Class getCommand() {
            return this.commandInterface;
        }
    }

    private class CommandPopup
    extends JComboBox
    implements ActionListener,
    ContainerListener {
        private JComponent overlay;
        private CPopupMenu menu;
        private String noSelectionText;
        private String selectedCommand;

        public CommandPopup() {
            this.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
            this.menu = new CPopupMenu();
            this.overlay = new JComponent(){

                @Override
                public void addNotify() {
                    super.addNotify();
                    CommandPopup.this.placeOverlay();
                }
            };
            this.overlay.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    CommandPopup.this.handleOverlayPressed(e);
                }
            });
            this.add((Component)this.overlay, 0);
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    CommandPopup.this.placeOverlay();
                }
            });
        }

        private void handleOverlayPressed(MouseEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.requestFocus();
            this.setMenuVisible(!this.menu.isVisible());
        }

        @Override
        public void setPopupVisible(boolean visible) {
            this.setMenuVisible(visible);
        }

        private void setMenuVisible(boolean visible) {
            if (!visible) {
                this.menu.setVisible(false);
            } else {
                int x = 0;
                int y = this.getSize().height;
                if (Platform.getLAF() == 502) {
                    x += 4;
                    y -= 4;
                }
                this.menu.show((Component)this, x, y);
            }
        }

        private void placeOverlay() {
            Dimension s = this.getSize();
            this.overlay.setBounds(0, 0, s.width, s.height);
        }

        private void setText(String text) {
            super.removeAllItems();
            super.addItem(text);
        }

        public String getNoSelectionText() {
            return this.noSelectionText;
        }

        public void setNoSelectionText(String noSelectionText) {
            this.noSelectionText = noSelectionText;
        }

        public String getSelectedCommand() {
            return this.selectedCommand;
        }

        public void setSelectedCommand(String selectedCommand) {
            ActionInfo info;
            String oldCommand = this.selectedCommand;
            this.selectedCommand = selectedCommand;
            String txt = this.noSelectionText;
            if (selectedCommand != null && selectedCommand.length() != 0 && (info = Actions.getAction(selectedCommand)) != null) {
                txt = info.getDisplayName();
            }
            this.setText(txt);
            this.firePropertyChange("selectedCommand", oldCommand, selectedCommand);
        }

        @Override
        public void setSelectedIndex(int index) {
            super.setSelectedIndex(index);
            if (index < 0) {
                this.selectedCommand = null;
            }
        }

        public void addItem(JMenuItem menuItem) {
            this.menu.add(menuItem);
            this.setupItem(menuItem);
        }

        public void addSeparator() {
            this.menu.addSeparator();
        }

        @Override
        public void removeAllItems() {
            this.menu.removeAll();
            this.selectedCommand = null;
            super.removeAllItems();
        }

        public JMenuItem[] getItems() {
            ArrayList<Component> list = new ArrayList<Component>();
            Component[] comps = this.menu.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                if (!(comps[i] instanceof JMenuItem)) continue;
                list.add(comps[i]);
            }
            return list.toArray(new JMenuItem[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setFont(Font font) {
            super.setFont(font);
            if (this.menu != null) {
                CPopupMenu cPopupMenu = this.menu;
                synchronized (cPopupMenu) {
                    for (int i = 0; i < this.menu.getComponentCount(); ++i) {
                        this.setFont(this.menu.getComponent(i), font);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setFont(Component component, Font font) {
            component.setFont(font);
            if (component instanceof JMenu) {
                Component component2 = component;
                synchronized (component2) {
                    JMenu m = (JMenu)component;
                    for (int i = 0; i < m.getItemCount(); ++i) {
                        this.setFont(m.getItem(i), font);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setupItem(JMenuItem menuItem) {
            JMenuItem jMenuItem = menuItem;
            synchronized (jMenuItem) {
                menuItem.setFont(this.getFont());
                if (menuItem instanceof JMenu) {
                    JMenu m = (JMenu)menuItem;
                    m.getPopupMenu().addContainerListener(this);
                    for (int i = 0; i < m.getItemCount(); ++i) {
                        this.setupItem(m.getItem(i));
                    }
                } else if (menuItem instanceof CommandMenuItem) {
                    Class cmd;
                    CommandMenuItem cmi = (CommandMenuItem)menuItem;
                    cmi.addActionListener(this);
                    if (this.selectedCommand == null && (cmd = cmi.getCommand()) != null) {
                        this.setSelectedCommand(cmd.getName());
                    }
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src instanceof CommandMenuItem) {
                Class cmd = ((CommandMenuItem)src).getCommand();
                this.setSelectedCommand(cmd != null ? cmd.getName() : null);
            }
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            Component comp = e.getChild();
            if (comp instanceof JMenuItem) {
                this.setupItem((JMenuItem)comp);
            }
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
        }
    }

    private static class DurationField
    extends JSpinner
    implements ChangeListener {
        private ActionParameter parameter;
        private AgendaExecutable executable;

        public DurationField(ActionParameter parameter, AgendaExecutable executable) {
            super(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
            Integer val;
            int max;
            this.setOpaque(false);
            this.setToolTipText(parameter.getHelpText());
            this.parameter = parameter;
            this.executable = executable;
            int min = parameter.getMinimumValue();
            if (min != -1) {
                ((SpinnerNumberModel)this.getModel()).setMinimum(Integer.valueOf(min));
            }
            if ((max = parameter.getMaximumValue()) != -1) {
                ((SpinnerNumberModel)this.getModel()).setMaximum(Integer.valueOf(max));
            }
            if ((val = executable.getIntegerParameter(parameter.getName())) != null) {
                this.getModel().setValue(val);
            }
            this.addChangeListener(this);
        }

        @Override
        protected JComponent createEditor(SpinnerModel model) {
            return new DurationEditor(this);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.executable.setCommandParameter(this.parameter.getName(), String.valueOf(this.getValue()));
        }
    }

    private class EmbeddedContentField
    extends JPanel
    implements DocumentListener,
    ActionListener {
        private static final int FILE = 1;
        private static final int QUIZ = 2;
        private static final int SCREEN = 3;
        private JTextField contentField;
        private JButton browseButton;
        private ActionParameter parameter;
        private AgendaExecutable executable;
        private int contentType;

        public EmbeddedContentField(ActionParameter parameter, AgendaExecutable executable, int contentType) {
            super(new GridBagLayout());
            this.setOpaque(false);
            this.parameter = parameter;
            this.executable = executable;
            this.contentType = contentType;
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.contentField = new JTextField();
            this.contentField.setToolTipText(parameter.getHelpText());
            this.add((Component)this.contentField, gbc);
            gbc.weightx = 0.0;
            gbc.insets.left = 2;
            this.browseButton = new BrowseButton();
            this.browseButton.addActionListener(this);
            this.add((Component)this.browseButton, gbc);
            this.contentField.setText(executable.getStringParameter(parameter.getName()));
            this.contentField.getCaret().setDot(0);
            this.contentField.getDocument().addDocumentListener(this);
        }

        @Override
        public void setFont(Font font) {
            super.setFont(font);
            if (this.contentField != null) {
                this.contentField.setFont(font);
            }
            if (this.browseButton != null) {
                this.browseButton.setFont(font);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.textChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.textChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.textChanged();
        }

        private void textChanged() {
            AgendaAction action;
            this.executable.setCommandParameter(this.parameter.getName(), this.contentField.getText());
            if (this.executable instanceof AgendaAction && !Actions.isActionDescriptionCustomized(action = (AgendaAction)this.executable)) {
                Actions.setupActionDescription(action, this.contentField.getText());
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int mode;
            Agenda ag = ((AgendaItem)this.executable).getParentAgenda();
            switch (this.contentType) {
                case 3: {
                    mode = 3;
                    break;
                }
                case 2: {
                    mode = 2;
                    break;
                }
                default: {
                    mode = 1;
                }
            }
            Window w = SwingUtilities.getWindowAncestor(this);
            ChooseContentDialog d = new ChooseContentDialog(w, ag, this.executable, mode);
            d.show();
            if (d.wasCanceled()) {
                return;
            }
            String selection = "";
            Object c = d.getSelectedContent();
            if (c instanceof AgendaFile) {
                selection = ((AgendaFile)c).getName();
            } else if (c instanceof Quiz) {
                selection = ((Quiz)c).getName();
            } else if (c instanceof WhiteboardScreenNode) {
                WhiteboardScreenNode screenNode;
                StringBuffer b = new StringBuffer();
                WhiteboardScreenNode n = screenNode = (WhiteboardScreenNode)c;
                do {
                    if (b.length() != 0) {
                        b.insert(0, ':');
                    }
                    b.insert(0, n.getName());
                } while ((n = n.getParent()) != null && n.getParent() != null);
                selection = b.toString();
                if (this.executable instanceof AgendaAction) {
                    AgendaAction act = (AgendaAction)this.executable;
                    String pnote = screenNode.getPresenterNotes();
                    if (pnote != null && pnote.length() != 0) {
                        b = new StringBuffer();
                        String note = act.getNote();
                        if (note != null && note.length() != 0) {
                            b.append(note);
                            b.append("\n\n");
                        }
                        b.append(pnote);
                        act.setNote(b.toString());
                    }
                }
            }
            this.contentField.setText(selection);
            this.contentField.getCaret().setDot(0);
        }
    }

    private class EmbeddedFileOrURLField
    extends JPanel
    implements DocumentListener,
    ActionListener {
        private JTextField fileField;
        private JButton browseButton;
        private ActionParameter parameter;
        private AgendaExecutable executable;

        public EmbeddedFileOrURLField(ActionParameter parameter, AgendaExecutable executable) {
            super(new GridBagLayout());
            this.setOpaque(false);
            this.parameter = parameter;
            this.executable = executable;
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.fileField = new JTextField();
            this.fileField.setToolTipText(parameter.getHelpText());
            this.add((Component)this.fileField, gbc);
            gbc.weightx = 0.0;
            gbc.insets.left = 2;
            this.browseButton = new BrowseButton();
            this.browseButton.addActionListener(this);
            this.add((Component)this.browseButton, gbc);
            this.fileField.setText(executable.getStringParameter(parameter.getName()));
            this.fileField.getCaret().setDot(0);
            this.fileField.getDocument().addDocumentListener(this);
        }

        @Override
        public void setFont(Font font) {
            super.setFont(font);
            if (this.fileField != null) {
                this.fileField.setFont(font);
            }
            if (this.browseButton != null) {
                this.browseButton.setFont(font);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.textChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.textChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.textChanged();
        }

        private void textChanged() {
            AgendaAction action;
            this.executable.setCommandParameter(this.parameter.getName(), this.fileField.getText());
            if (this.executable instanceof AgendaAction && !Actions.isActionDescriptionCustomized(action = (AgendaAction)this.executable)) {
                Actions.setupActionDescription(action, this.fileField.getText());
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Agenda ag = ((AgendaItem)this.executable).getParentAgenda();
            Window w = SwingUtilities.getWindowAncestor(this);
            ChooseContentDialog d = new ChooseContentDialog(w, ag, this.executable, 1);
            d.show();
            if (d.wasCanceled()) {
                return;
            }
            AgendaFile f = (AgendaFile)d.getSelectedContent();
            this.fileField.setText(f.getName());
            this.fileField.getCaret().setDot(0);
            f.setAutoload(false);
            f.setCommandName(null);
        }
    }

    private abstract class ExecutableItemEditor
    extends ItemEditor {
        protected CommandPopup commandPopup;
        protected JPanel parameterPanel;

        public ExecutableItemEditor(LayoutManager layout) {
            super(layout);
            this.commandPopup = new CommandPopup();
            this.commandPopup.setFont(SMALL_FONT);
            this.parameterPanel = new JPanel(new GridBagLayout()){
                private Color darken;
                {
                    super(x0);
                    this.darken = new Color(0, 0, 0, 32);
                }

                @Override
                protected void paintComponent(Graphics g) {
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    Dimension s = this.getSize();
                    g.setColor(this.darken);
                    g.fillRoundRect(0, 0, s.width + 8, s.height, 10, 10);
                    super.paintComponent(g);
                }
            };
            this.parameterPanel.setOpaque(false);
        }

        protected abstract void populateCommands();

        protected void populateParameters(AgendaExecutable executable) {
            ActionInfo act;
            this.parameterPanel.removeAll();
            if (executable == null) {
                this.parameterPanel.setVisible(false);
                return;
            }
            boolean isFile = executable instanceof AgendaFile;
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridy = 0;
            String cmd = this.commandPopup.getSelectedCommand();
            if (cmd != null && cmd.length() != 0 && (act = Actions.getAction(cmd)) != null) {
                ActionParameter[] params = act.getParameters();
                for (int i = 0; i < params.length; ++i) {
                    ActionParameter param = params[i];
                    if (isFile && act.isLoadAction() && param.getName().equals(PropertyEditor.CARD_FILE)) continue;
                    int type = param.getType();
                    JLabel label = null;
                    if (type != 1) {
                        label = new JLabel(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_ACTIONPARAMETERLABEL, new Object[]{param.getDisplayName()}), 4);
                        label.setToolTipText(param.getHelpText());
                    }
                    int fill = 0;
                    if (type != 1) {
                        fill = 2;
                    }
                    JComponent comp = null;
                    switch (type) {
                        case 1: {
                            comp = new BooleanField(param.getDisplayName(), param, executable);
                            break;
                        }
                        case 2: {
                            comp = new IntegerField(param, executable);
                            break;
                        }
                        case 3: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: {
                            comp = new TextField(param, executable);
                            break;
                        }
                        case 4: {
                            comp = new FileField(param, executable);
                            break;
                        }
                        case 5: {
                            comp = new ApplicationField(param, executable);
                            break;
                        }
                        case 6: {
                            comp = new EmbeddedFileOrURLField(param, executable);
                            break;
                        }
                        case 7: {
                            comp = new BoundsField(param, executable);
                            break;
                        }
                        case 8: {
                            comp = new ListField(param, executable, false);
                            break;
                        }
                        case 14: {
                            comp = new ListField(param, executable, true);
                            break;
                        }
                        case 9: 
                        case 10: {
                            comp = new DurationField(param, executable);
                            break;
                        }
                        case 11: {
                            comp = new EmbeddedContentField(param, executable, 1);
                            break;
                        }
                        case 12: {
                            comp = new EmbeddedContentField(param, executable, 2);
                            break;
                        }
                        case 13: {
                            comp = new EmbeddedContentField(param, executable, 3);
                        }
                    }
                    gbc.gridx = 0;
                    gbc.gridwidth = 2;
                    gbc.insets.top = i == 0 ? 4 : CONTROL_GAP;
                    gbc.insets.left = 4;
                    int n = gbc.insets.bottom = i == params.length - 1 ? 4 : 0;
                    if (label != null) {
                        gbc.weightx = 0.0;
                        gbc.insets.right = 0;
                        gbc.anchor = 13;
                        gbc.fill = 0;
                        gbc.gridwidth = 1;
                        label.setFont(SMALL_FONT);
                        this.parameterPanel.add((Component)label, gbc);
                        ++gbc.gridx;
                    }
                    if (comp != null) {
                        gbc.weightx = 100.0;
                        gbc.insets.right = 10;
                        gbc.anchor = 17;
                        gbc.fill = fill;
                        comp.setFont(SMALL_FONT);
                        this.parameterPanel.add((Component)comp, gbc);
                    }
                    ++gbc.gridy;
                }
            }
            this.parameterPanel.setVisible(this.parameterPanel.getComponentCount() != 0);
            if (this.parameterPanel.isVisible()) {
                this.parameterPanel.revalidate();
                this.parameterPanel.repaint();
            }
        }
    }

    private class FileEditor
    extends ExecutableItemEditor {
        private JTextField nameField;
        private JCheckBox loadOnActivateBox;
        private AgendaFile file;
        private boolean listening;

        public FileEditor() {
            super(new GridBagLayout());
            this.listening = false;
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.insets.right = 10;
            gbc.weightx = 1.0;
            gbc.gridx = 0;
            gbc.fill = 0;
            gbc.insets.top = 8;
            JLabel l = new JLabel(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_FILEPANELTITLE));
            l.setFont(TITLE_FONT);
            this.add((Component)l, gbc);
            gbc.fill = 0;
            gbc.insets.top = 8;
            l = new JLabel(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_FILENAMELABEL));
            l.setToolTipText(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_FILENAMETIP));
            l.setFont(SMALL_FONT);
            this.add((Component)l, gbc);
            gbc.fill = 2;
            gbc.insets.top = CONTROL_GAP;
            this.nameField = new JTextField();
            this.nameField.setToolTipText(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_FILENAMETIP));
            this.nameField.setFont(SMALL_FONT);
            this.nameField.setEditable(false);
            this.nameField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (FileEditor.this.listening && FileEditor.this.file != null) {
                        FileEditor.this.checkNameChanged();
                    }
                }
            });
            this.nameField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (FileEditor.this.listening && FileEditor.this.file != null) {
                        FileEditor.this.checkNameChanged();
                    }
                }
            });
            this.add((Component)this.nameField, gbc);
            gbc.fill = 0;
            gbc.insets.top = 8;
            this.loadOnActivateBox = new JCheckBox(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_FILEAUTOMATICLOADBOX));
            this.loadOnActivateBox.setToolTipText(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_FILEAUTOMATICLOADTIP));
            this.loadOnActivateBox.setFont(SMALL_FONT);
            this.loadOnActivateBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (FileEditor.this.listening && FileEditor.this.file != null) {
                        boolean auto = FileEditor.this.loadOnActivateBox.isSelected();
                        if (FileEditor.this.file.isAutoload() != auto) {
                            FileEditor.this.file.setAutoload(auto);
                        }
                        FileEditor.this.commandPopup.setEnabled(auto);
                        if (auto) {
                            String ext = AgendaUtils.parseFileName((String)FileEditor.this.file.getName())[1];
                            ActionInfo act = Actions.getBestLoadAction(ext);
                            FileEditor.this.commandPopup.setSelectedCommand(act.getCommandInterface().getName());
                        } else {
                            FileEditor.this.commandPopup.setSelectedCommand(null);
                        }
                    }
                }
            });
            this.add((Component)this.loadOnActivateBox, gbc);
            gbc.fill = 0;
            gbc.insets.top = 8;
            l = new JLabel(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_FILECOMMANDLABEL));
            l.setToolTipText(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_FILECOMMANDTIP));
            l.setFont(SMALL_FONT);
            this.add((Component)l, gbc);
            gbc.fill = 0;
            gbc.insets.top = CONTROL_GAP;
            this.commandPopup.setToolTipText(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_FILECOMMANDTIP));
            this.commandPopup.setNoSelectionText(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_FILENOCOMMANDITEM));
            this.commandPopup.addPropertyChangeListener("selectedCommand", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (FileEditor.this.listening && FileEditor.this.file != null) {
                        ActionInfo act;
                        Class cmd = null;
                        String cmdName = (String)e.getNewValue();
                        if (cmdName != null && (act = Actions.getAction(cmdName)) != null) {
                            cmd = act.getCommandInterface();
                        }
                        Actions.setupExecutable((AgendaExecutable)FileEditor.this.file, cmd);
                        FileEditor.this.populateParameters((AgendaExecutable)FileEditor.this.file);
                    }
                }
            });
            this.populateCommands();
            this.add((Component)this.commandPopup, gbc);
            gbc.fill = 2;
            gbc.insets.top = 0;
            gbc.insets.right = 0;
            this.add((Component)this.parameterPanel, gbc);
            gbc.insets.top = 0;
            gbc.weighty = 1.0;
            this.add(Box.createVerticalGlue(), gbc);
        }

        @Override
        public void setItem(AgendaItem item) {
            this.listening = false;
            if (this.file != null) {
                this.checkNameChanged();
            }
            this.file = (AgendaFile)item;
            if (this.file != null) {
                this.nameField.setText(this.file.getName());
                this.nameField.getCaret().setDot(0);
                this.loadOnActivateBox.setSelected(this.file.isAutoload());
                String ext = AgendaUtils.parseFileName((String)this.file.getName())[1];
                JMenuItem[] mis = this.commandPopup.getItems();
                for (int i = 0; i < mis.length; ++i) {
                    JMenuItem mi = mis[i];
                    if (!(mi instanceof CommandMenuItem)) continue;
                    Class cmd = ((CommandMenuItem)mi).getCommand();
                    ActionInfo act = null;
                    if (cmd != null) {
                        act = Actions.getAction(cmd.getName());
                    }
                    mi.setEnabled(act == null || act.containsExtension(ext) || act.containsExtension("*"));
                }
                this.commandPopup.setEnabled(this.file.isAutoload());
                this.commandPopup.setSelectedCommand(this.file.getCommandName());
            }
            this.populateParameters((AgendaExecutable)this.file);
            this.listening = true;
        }

        @Override
        protected void populateCommands() {
            ActionInfo[] acts = Actions.getLoadActions();
            for (int i = 0; i < acts.length; ++i) {
                ActionInfo act = acts[i];
                this.commandPopup.addItem(new CommandMenuItem(act.getDisplayName(), act.getCommandInterface()));
            }
        }

        private void checkNameChanged() {
            String name = this.nameField.getText();
            if (!this.file.getName().equals(name)) {
                this.file.setName(name);
            }
        }

        public void editName(final String text) {
            this.nameField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    FileEditor.this.nameField.removeFocusListener(this);
                    FileEditor.this.nameField.setText(text);
                }
            });
            this.nameField.requestFocus();
        }
    }

    private static class FileField
    extends JPanel
    implements DocumentListener,
    ActionListener {
        private JTextField fileField;
        private JButton browseButton;
        private ActionParameter parameter;
        private AgendaExecutable executable;

        public FileField(ActionParameter parameter, AgendaExecutable executable) {
            super(new GridBagLayout());
            this.setOpaque(false);
            this.parameter = parameter;
            this.executable = executable;
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.fileField = new JTextField();
            this.fileField.setToolTipText(parameter.getHelpText());
            this.add((Component)this.fileField, gbc);
            gbc.weightx = 0.0;
            gbc.insets.left = 2;
            this.browseButton = new BrowseButton();
            this.browseButton.addActionListener(this);
            this.add((Component)this.browseButton, gbc);
            this.fileField.setText(executable.getStringParameter(parameter.getName()));
            this.fileField.getCaret().setDot(0);
            this.fileField.getDocument().addDocumentListener(this);
        }

        @Override
        public void setFont(Font font) {
            super.setFont(font);
            if (this.fileField != null) {
                this.fileField.setFont(font);
            }
            if (this.browseButton != null) {
                this.browseButton.setFont(font);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.textChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.textChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.textChanged();
        }

        private void textChanged() {
            this.executable.setCommandParameter(this.parameter.getName(), this.fileField.getText());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CFileChooser ch = new CFileChooser();
            ch.setMultiSelectionEnabled(false);
            ch.setCurrentDirectory(lastFileDirectory);
            Window w = SwingUtilities.getWindowAncestor(this);
            if (ch.showOpenDialog((Component)w) != 0) {
                return;
            }
            lastFileDirectory = ch.getCurrentDirectory();
            File f = ch.getSelectedFile();
            this.fileField.setText(f.getAbsolutePath());
            this.fileField.getCaret().setDot(0);
        }
    }

    private static class IntegerField
    extends JSpinner
    implements ChangeListener,
    PropertyChangeListener {
        private ActionParameter parameter;
        private AgendaExecutable executable;

        public IntegerField(ActionParameter parameter, AgendaExecutable executable) {
            super(new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1));
            Integer val;
            int max;
            this.setOpaque(false);
            this.setToolTipText(parameter.getHelpText());
            this.parameter = parameter;
            this.executable = executable;
            int min = parameter.getMinimumValue();
            if (min != -1) {
                ((SpinnerNumberModel)this.getModel()).setMinimum(Integer.valueOf(min));
            }
            if ((max = parameter.getMaximumValue()) != -1) {
                ((SpinnerNumberModel)this.getModel()).setMaximum(Integer.valueOf(max));
            }
            if ((val = executable.getIntegerParameter(parameter.getName())) != null) {
                this.getModel().setValue(val);
            }
            this.addChangeListener(this);
            JFormattedTextField tf = ((JSpinner.DefaultEditor)this.getEditor()).getTextField();
            DefaultFormatter form = (DefaultFormatter)tf.getFormatter();
            form.setAllowsInvalid(false);
            form.setCommitsOnValidEdit(true);
            parameter.addPropertyChangeListener(this);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.executable.setCommandParameter(this.parameter.getName(), String.valueOf(this.getValue()));
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("maximumValue")) {
                SpinnerNumberModel m = (SpinnerNumberModel)this.getModel();
                int max = this.parameter.getMaximumValue();
                if (max != -1) {
                    m.setMaximum(Integer.valueOf(max));
                } else {
                    m.setMaximum(Integer.valueOf(Integer.MAX_VALUE));
                }
            }
        }
    }

    private abstract class ItemEditor
    extends AbstractEditor {
        public ItemEditor(LayoutManager layout) {
            super(layout);
        }

        public abstract void setItem(AgendaItem var1);
    }

    private static class ListField
    extends JComboBox
    implements ActionListener,
    DocumentListener {
        private ActionParameter parameter;
        private AgendaExecutable executable;
        private HashMap itemValues = new HashMap();

        public ListField(ActionParameter parameter, AgendaExecutable executable, boolean editable) {
            this.setOpaque(false);
            this.setEditable(editable);
            this.setToolTipText(parameter.getHelpText());
            this.parameter = parameter;
            this.executable = executable;
            String sel = null;
            String val = executable.getStringParameter(parameter.getName());
            if (val == null) {
                val = "";
            }
            ActionParameterValue[] vals = parameter.getPossibleValues();
            for (int i = 0; i < vals.length; ++i) {
                ActionParameterValue pval = vals[i];
                String it = pval.getDisplayName();
                this.itemValues.put(it, pval.getName());
                if (val.equalsIgnoreCase(pval.getName())) {
                    sel = it;
                }
                this.addItem(it);
            }
            if (sel != null) {
                this.setSelectedItem(sel);
            } else if (editable) {
                this.setSelectedItem(val);
            }
            this.addActionListener(this);
            if (editable) {
                JTextField tf = (JTextField)this.getEditor().getEditorComponent();
                tf.getDocument().addDocumentListener(this);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEditable()) {
                String sel = (String)this.getSelectedItem();
                this.executable.setCommandParameter(this.parameter.getName(), (String)this.itemValues.get(sel));
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.textChanged(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.textChanged(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.textChanged(e);
        }

        private void textChanged(DocumentEvent e) {
            try {
                Document doc = e.getDocument();
                String sel = doc.getText(0, doc.getLength());
                if (this.itemValues.containsKey(sel)) {
                    sel = (String)this.itemValues.get(sel);
                }
                this.executable.setCommandParameter(this.parameter.getName(), sel);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    private class NoneEditor
    extends AbstractEditor {
        public NoneEditor() {
            super(null);
        }
    }

    private class TextEditor
    extends ItemEditor {
        private JTextArea textField;
        private JSpinner durationField;
        private AgendaText text;
        private boolean listening;

        public TextEditor() {
            super(new GridBagLayout());
            this.listening = false;
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.weightx = 1.0;
            gbc.gridx = 0;
            gbc.fill = 0;
            gbc.weighty = 0.0;
            gbc.insets.top = 8;
            gbc.insets.right = 10;
            JLabel l = new JLabel(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_TEXTPANELTITLE));
            l.setFont(TITLE_FONT);
            this.add((Component)l, gbc);
            gbc.fill = 1;
            gbc.weighty = 1.0;
            gbc.insets.top = 8;
            this.textField = new JTextArea();
            this.textField.setToolTipText(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_TEXTTIP));
            this.textField.setFont(SMALL_FONT);
            this.textField.setLineWrap(true);
            this.textField.setWrapStyleWord(true);
            this.textField.setMargin(new Insets(1, 2, 1, 2));
            this.textField.setFocusTraversalKeys(0, null);
            this.textField.setFocusTraversalKeys(1, null);
            String enterAction = "enter-action";
            this.textField.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "enter-action");
            this.textField.getActionMap().put("enter-action", new AbstractAction("enter-action"){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
            this.textField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.textChanged();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.textChanged();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.textChanged();
                }

                private void textChanged() {
                    if (TextEditor.this.listening && TextEditor.this.text != null) {
                        TextEditor.this.text.setText(TextEditor.this.textField.getText());
                    }
                }
            });
            JScrollPane sp = new JScrollPane(this.textField, 20, 31);
            gbc.insets.right = -sp.getInsets().right;
            this.add((Component)sp, gbc);
            gbc.fill = 0;
            gbc.weighty = 0.0;
            gbc.insets.top = 8;
            gbc.insets.right = 10;
            l = new JLabel(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_TEXTDURATIONLABEL));
            l.setToolTipText(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_DURATIONTIP));
            l.setFont(SMALL_FONT);
            this.add((Component)l, gbc);
            gbc.fill = 2;
            gbc.weighty = 0.0;
            gbc.insets.top = CONTROL_GAP;
            gbc.insets.right = 10;
            this.durationField = new JSpinner(new SpinnerNumberModel(0, 0, 359999, 1));
            this.durationField.setEditor(new DurationEditor(this.durationField));
            this.durationField.setToolTipText(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_DURATIONTIP));
            this.durationField.setFont(SMALL_FONT);
            this.durationField.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (TextEditor.this.listening && TextEditor.this.text != null) {
                        Number val = (Number)TextEditor.this.durationField.getValue();
                        TextEditor.this.text.setDuration(val.intValue());
                    }
                }
            });
            this.add((Component)this.durationField, gbc);
        }

        @Override
        public void setItem(AgendaItem item) {
            this.listening = false;
            this.text = (AgendaText)item;
            if (this.text != null) {
                this.textField.setText(this.text.getText());
                this.textField.getCaret().setDot(0);
                this.durationField.setValue(new Integer(this.text.getDuration()));
            }
            this.listening = true;
        }

        public void editText(final String text) {
            this.textField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    TextEditor.this.textField.removeFocusListener(this);
                    TextEditor.this.textField.setText(text);
                }
            });
            this.textField.requestFocus();
        }
    }

    private static class TextField
    extends JTextField
    implements DocumentListener {
        private ActionParameter parameter;
        private AgendaExecutable executable;

        public TextField(ActionParameter parameter, AgendaExecutable executable) {
            this.setToolTipText(parameter.getHelpText());
            this.parameter = parameter;
            this.executable = executable;
            this.setText(executable.getStringParameter(parameter.getName()));
            this.getCaret().setDot(0);
            this.getDocument().addDocumentListener(this);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.textChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.textChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.textChanged();
        }

        private void textChanged() {
            AgendaAction action;
            this.executable.setCommandParameter(this.parameter.getName(), this.getText());
            if (this.executable instanceof AgendaAction && !Actions.isActionDescriptionCustomized(action = (AgendaAction)this.executable)) {
                Actions.setupActionDescription(action, this.getText());
            }
        }
    }

    private class TopicEditor
    extends ItemEditor {
        private JTextField nameField;
        private JTextArea notesField;
        private JSpinner durationField;
        private AgendaTopic topic;
        private boolean listening;

        public TopicEditor() {
            super(new GridBagLayout());
            this.listening = false;
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.weightx = 1.0;
            gbc.gridx = 0;
            gbc.fill = 0;
            gbc.weighty = 0.0;
            gbc.insets.top = 8;
            gbc.insets.right = 10;
            JLabel l = new JLabel(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_TOPICPANELTITLE));
            l.setFont(TITLE_FONT);
            this.add((Component)l, gbc);
            gbc.fill = 0;
            gbc.weighty = 0.0;
            gbc.insets.top = 8;
            gbc.insets.right = 10;
            l = new JLabel(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_TOPICNAMELABEL));
            l.setToolTipText(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_TOPICNAMETIP));
            l.setFont(SMALL_FONT);
            this.add((Component)l, gbc);
            gbc.fill = 2;
            gbc.weighty = 0.0;
            gbc.insets.top = CONTROL_GAP;
            gbc.insets.right = 10;
            this.nameField = new JTextField();
            this.nameField.setToolTipText(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_TOPICNAMETIP));
            this.nameField.setFont(SMALL_FONT);
            this.nameField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.nameChanged();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.nameChanged();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.nameChanged();
                }

                private void nameChanged() {
                    if (TopicEditor.this.listening && TopicEditor.this.topic != null) {
                        TopicEditor.this.topic.setName(TopicEditor.this.nameField.getText());
                    }
                }
            });
            this.add((Component)this.nameField, gbc);
            gbc.fill = 0;
            gbc.weighty = 0.0;
            gbc.insets.top = 8;
            gbc.insets.right = 10;
            l = new JLabel(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_TOPICNOTESLABEL));
            l.setToolTipText(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_NOTESTIP));
            l.setFont(SMALL_FONT);
            this.add((Component)l, gbc);
            gbc.fill = 1;
            gbc.weighty = 1.0;
            gbc.insets.top = CONTROL_GAP;
            this.notesField = new JTextArea();
            this.notesField.setToolTipText(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_NOTESTIP));
            this.notesField.setFont(SMALL_FONT);
            this.notesField.setLineWrap(true);
            this.notesField.setWrapStyleWord(true);
            this.notesField.setMargin(new Insets(1, 2, 1, 2));
            this.notesField.setFocusTraversalKeys(0, null);
            this.notesField.setFocusTraversalKeys(1, null);
            this.notesField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.notesChanged();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.notesChanged();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.notesChanged();
                }

                private void notesChanged() {
                    if (TopicEditor.this.listening && TopicEditor.this.topic != null) {
                        TopicEditor.this.topic.setNote(TopicEditor.this.notesField.getText());
                    }
                }
            });
            JScrollPane sp = new JScrollPane(this.notesField, 20, 31);
            gbc.insets.right = -sp.getInsets().right;
            this.add((Component)sp, gbc);
            gbc.fill = 0;
            gbc.weighty = 0.0;
            gbc.insets.top = 8;
            gbc.insets.right = 10;
            l = new JLabel(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_TOPICDURATIONLABEL));
            l.setToolTipText(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_DURATIONTIP));
            l.setFont(SMALL_FONT);
            this.add((Component)l, gbc);
            gbc.fill = 2;
            gbc.weighty = 0.0;
            gbc.insets.top = CONTROL_GAP;
            gbc.insets.right = 10;
            this.durationField = new JSpinner(new SpinnerNumberModel(0, 0, 359999, 1));
            this.durationField.setEditor(new DurationEditor(this.durationField));
            this.durationField.setToolTipText(PropertyEditor.this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYEDITOR_DURATIONTIP));
            this.durationField.setFont(SMALL_FONT);
            this.durationField.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (TopicEditor.this.listening && TopicEditor.this.topic != null) {
                        Number val = (Number)TopicEditor.this.durationField.getValue();
                        TopicEditor.this.topic.setDuration(val.intValue());
                    }
                }
            });
            this.add((Component)this.durationField, gbc);
        }

        @Override
        public void setItem(AgendaItem item) {
            this.listening = false;
            this.topic = (AgendaTopic)item;
            if (this.topic != null) {
                this.nameField.setText(this.topic.getName());
                this.nameField.getCaret().setDot(0);
                this.notesField.setText(this.topic.getNote());
                this.durationField.setValue(new Integer(this.topic.getDuration()));
            }
            this.listening = true;
        }

        public void editName(final String text) {
            this.nameField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    TopicEditor.this.nameField.removeFocusListener(this);
                    TopicEditor.this.nameField.setText(text);
                }
            });
            this.nameField.requestFocus();
        }
    }
}

