/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.agenda.module;

import com.elluminate.groupware.agenda.AgendaFile;
import com.elluminate.groupware.agenda.AgendaItem;
import com.elluminate.groupware.agenda.AgendaNode;
import com.elluminate.groupware.agenda.module.AgendaBean;
import com.elluminate.groupware.agenda.module.AgendaEditor;
import com.elluminate.groupware.agenda.module.FilesEditor;
import com.elluminate.groupware.agenda.module.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.TransferHandler;

class PopupMenu
extends JPopupMenu {
    private AgendaBean bean;
    private JMenuItem editItem;
    private JMenuItem saveItem;
    private JSeparator clipboardSeparator;
    private JMenuItem cutItem;
    private JMenuItem copyItem;
    private JMenuItem pasteItem;
    private JSeparator editingSeparator;
    private JMenuItem addFileItem;
    private JMenuItem addTopicItem;
    private JMenuItem addActionItem;
    private JMenuItem addTextItem;
    private JMenuItem removeItem;
    private JSeparator movingSeparator;
    private JMenuItem moveUpItem;
    private JMenuItem moveDownItem;
    private JMenuItem moveLeftItem;
    private JMenuItem moveRightItem;

    public PopupMenu(AgendaBean bean, I18n i18n) {
        this.bean = bean;
        this.editItem = new JMenuItem(i18n.getString((PropertiesEnum)StringsProperties.AGENDAPOPUPMENU_EDIT));
        this.editItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.bean.doEditFiles();
            }
        });
        this.add(this.editItem);
        this.saveItem = new JMenuItem(i18n.getString((PropertiesEnum)StringsProperties.AGENDAPOPUPMENU_SAVE));
        this.saveItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.bean.doSaveFiles();
            }
        });
        this.add(this.saveItem);
        this.clipboardSeparator = new JPopupMenu.Separator();
        this.add(this.clipboardSeparator);
        this.cutItem = new JMenuItem(i18n.getString((PropertiesEnum)StringsProperties.AGENDAPOPUPMENU_CUT));
        this.cutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComponent jcomp;
                TransferHandler h;
                Component comp = PopupMenu.this.getInvoker();
                if (comp instanceof JComponent && (h = (jcomp = (JComponent)comp).getTransferHandler()) != null) {
                    h.exportToClipboard(jcomp, Toolkit.getDefaultToolkit().getSystemClipboard(), 2);
                }
            }
        });
        this.add(this.cutItem);
        this.copyItem = new JMenuItem(i18n.getString((PropertiesEnum)StringsProperties.AGENDAPOPUPMENU_COPY));
        this.copyItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComponent jcomp;
                TransferHandler h;
                Component comp = PopupMenu.this.getInvoker();
                if (comp instanceof JComponent && (h = (jcomp = (JComponent)comp).getTransferHandler()) != null) {
                    h.exportToClipboard(jcomp, Toolkit.getDefaultToolkit().getSystemClipboard(), 1);
                }
            }
        });
        this.add(this.copyItem);
        this.pasteItem = new JMenuItem(i18n.getString((PropertiesEnum)StringsProperties.AGENDAPOPUPMENU_PASTE));
        this.pasteItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComponent jcomp;
                TransferHandler h;
                Component comp = PopupMenu.this.getInvoker();
                if (comp instanceof JComponent && (h = (jcomp = (JComponent)comp).getTransferHandler()) != null) {
                    Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                    h.importData(jcomp, cb.getContents(this));
                }
            }
        });
        this.add(this.pasteItem);
        this.editingSeparator = new JPopupMenu.Separator();
        this.add(this.editingSeparator);
        this.addFileItem = new JMenuItem(i18n.getString((PropertiesEnum)StringsProperties.AGENDAPOPUPMENU_ADDFILE));
        this.addFileItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.bean.doAddFile();
            }
        });
        this.add(this.addFileItem);
        this.addTopicItem = new JMenuItem(i18n.getString((PropertiesEnum)StringsProperties.AGENDAPOPUPMENU_ADDTOPIC));
        this.addTopicItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.bean.doAddTopic();
            }
        });
        this.add(this.addTopicItem);
        this.addActionItem = new JMenuItem(i18n.getString((PropertiesEnum)StringsProperties.AGENDAPOPUPMENU_ADDACTION));
        this.addActionItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.bean.doAddAction();
            }
        });
        this.add(this.addActionItem);
        this.addTextItem = new JMenuItem(i18n.getString((PropertiesEnum)StringsProperties.AGENDAPOPUPMENU_ADDTEXT));
        this.addTextItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.bean.doAddText();
            }
        });
        this.add(this.addTextItem);
        this.removeItem = new JMenuItem(i18n.getString((PropertiesEnum)StringsProperties.AGENDAPOPUPMENU_REMOVE));
        this.removeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.bean.doRemoveItems();
            }
        });
        this.add(this.removeItem);
        this.movingSeparator = new JPopupMenu.Separator();
        this.add(this.movingSeparator);
        this.moveUpItem = new JMenuItem(i18n.getString((PropertiesEnum)StringsProperties.AGENDAPOPUPMENU_MOVEUP));
        this.moveUpItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.bean.doMoveItemUp();
            }
        });
        this.add(this.moveUpItem);
        this.moveDownItem = new JMenuItem(i18n.getString((PropertiesEnum)StringsProperties.AGENDAPOPUPMENU_MOVEDOWN));
        this.moveDownItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.bean.doMoveItemDown();
            }
        });
        this.add(this.moveDownItem);
        this.moveLeftItem = new JMenuItem(i18n.getString((PropertiesEnum)StringsProperties.AGENDAPOPUPMENU_MOVELEFT));
        this.moveLeftItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.bean.doMoveItemLeft();
            }
        });
        this.add(this.moveLeftItem);
        this.moveRightItem = new JMenuItem(i18n.getString((PropertiesEnum)StringsProperties.AGENDAPOPUPMENU_MOVERIGHT));
        this.moveRightItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenu.this.bean.doMoveItemRight();
            }
        });
        this.add(this.moveRightItem);
    }

    public void show(AgendaItem[] selectedItems, Component invoker, int x, int y) {
        JComponent jcomp;
        TransferHandler h;
        boolean canAddFiles = invoker instanceof FilesEditor;
        boolean canAddNodes = invoker instanceof AgendaEditor;
        boolean itemsSelected = false;
        boolean filesSelected = false;
        boolean nodesSelected = false;
        if (selectedItems != null && selectedItems.length != 0) {
            itemsSelected = true;
            filesSelected = true;
            nodesSelected = true;
            for (int i = 0; i < selectedItems.length; ++i) {
                AgendaItem it = selectedItems[0];
                if (!(it instanceof AgendaFile)) {
                    filesSelected = false;
                    continue;
                }
                if (it instanceof AgendaNode) continue;
                nodesSelected = false;
            }
        }
        boolean moveUp = itemsSelected;
        boolean moveDown = itemsSelected;
        boolean moveLeft = false;
        boolean moveRight = false;
        if (itemsSelected) {
            for (int i = 0; i < selectedItems.length; ++i) {
                if (!selectedItems[i].canMoveUp()) {
                    moveUp = false;
                }
                if (!selectedItems[i].canMoveDown()) {
                    moveDown = false;
                }
                if (selectedItems[i].canMoveLeft()) {
                    moveLeft = true;
                }
                if (selectedItems[i].canMoveRight()) {
                    moveRight = true;
                }
                if (!moveUp && !moveDown && moveLeft && moveRight) break;
            }
        }
        boolean canCut = false;
        boolean canCopy = false;
        boolean canPaste = false;
        if (invoker instanceof JComponent && (h = (jcomp = (JComponent)invoker).getTransferHandler()) != null) {
            canCut = (h.getSourceActions(jcomp) & 2) != 0;
            canCopy = (h.getSourceActions(jcomp) & 1) != 0;
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable t = cb.getContents(invoker);
            if (t != null) {
                canPaste = h.canImport(jcomp, t.getTransferDataFlavors());
            }
        }
        this.editItem.setVisible(filesSelected);
        this.saveItem.setVisible(filesSelected);
        this.clipboardSeparator.setVisible(filesSelected);
        this.cutItem.setVisible((filesSelected || nodesSelected) && canCut);
        this.copyItem.setVisible((filesSelected || nodesSelected) && canCopy);
        this.pasteItem.setVisible(canPaste);
        this.editingSeparator.setVisible(filesSelected || nodesSelected || canPaste);
        this.addFileItem.setVisible(canAddFiles);
        this.addTopicItem.setVisible(canAddNodes);
        this.addActionItem.setVisible(canAddNodes);
        this.addTextItem.setVisible(canAddNodes);
        this.removeItem.setVisible(filesSelected || nodesSelected);
        this.movingSeparator.setVisible(moveUp || moveDown || moveLeft || moveRight);
        this.moveUpItem.setVisible(moveUp);
        this.moveDownItem.setVisible(moveDown);
        this.moveLeftItem.setVisible(moveLeft);
        this.moveRightItem.setVisible(moveRight);
        this.show(invoker, x, y);
    }
}

