/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.agenda.module;

import com.elluminate.groupware.agenda.Agenda;
import com.elluminate.groupware.agenda.AgendaLibrary;
import com.elluminate.groupware.agenda.Transfer;
import com.elluminate.groupware.agenda.event.AgendaEvent;
import com.elluminate.groupware.agenda.event.AgendaLibraryEvent;
import com.elluminate.groupware.agenda.event.AgendaLibraryListener;
import com.elluminate.groupware.agenda.event.AgendaListener;
import com.elluminate.groupware.agenda.module.AgendaBean;
import com.elluminate.groupware.agenda.module.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Singleton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

@Singleton
public class LibraryPanel
extends JPanel
implements AgendaLibraryListener,
AgendaListener {
    public static final String PROP_SELECTED_AGENDAS = "selectedAgendas";
    private static final Color ALTERNATE_ROW_COLOR = new Color(237, 243, 254);
    private AgendaBean bean;
    private AgendaLibrary library;
    private I18n i18n;
    private JList agendaList;
    private AgendaListModel agendaListModel;
    private LightweightTimer updateTimer;

    public LibraryPanel(AgendaBean bean, AgendaLibrary library, I18n i18n) {
        this.setLayout(new BorderLayout());
        this.bean = bean;
        this.library = library;
        library.addAgendaLibraryListener((AgendaLibraryListener)this);
        this.i18n = i18n;
        this.agendaListModel = new AgendaListModel();
        this.agendaList = new JList(this.agendaListModel){

            @Override
            protected void paintComponent(Graphics g) {
                g.setColor(ALTERNATE_ROW_COLOR);
                Dimension s = this.getSize();
                int rh = this.getFixedCellHeight();
                for (int y = 0; y < s.height; y += 2 * rh) {
                    g.fillRect(0, y, s.width, rh);
                }
                super.paintComponent(g);
            }
        };
        this.agendaList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Point pt = e.getPoint();
                int row = LibraryPanel.this.agendaList.locationToIndex(pt);
                if (row != -1) {
                    Rectangle b = LibraryPanel.this.agendaList.getCellBounds(row, row);
                    if (b.contains(pt)) {
                        if (e.getClickCount() == 2) {
                            LibraryPanel.this.bean.doViewAgenda();
                        }
                    } else {
                        LibraryPanel.this.agendaList.clearSelection();
                        LibraryPanel.this.agendaList.requestFocus();
                    }
                }
            }
        });
        this.agendaList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    LibraryPanel.this.firePropertyChange(LibraryPanel.PROP_SELECTED_AGENDAS, null, LibraryPanel.this.getSelectedAgendas());
                }
            }
        });
        this.agendaList.setOpaque(false);
        AgendaRenderer r = new AgendaRenderer();
        this.agendaList.setCellRenderer(r);
        this.agendaList.setFixedCellHeight(r.getPreferredHeight());
        String removeAgendaAction = "remove-agenda";
        InputMap imap = this.agendaList.getInputMap(0);
        imap.put(KeyStroke.getKeyStroke(127, 0), "remove-agenda");
        imap.put(KeyStroke.getKeyStroke(8, 0), "remove-agenda");
        this.agendaList.getActionMap().put("remove-agenda", new AbstractAction("remove-agenda"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryPanel.this.bean.doDeleteAgenda();
            }
        });
        JScrollPane sp = new JScrollPane(this.agendaList, 22, 31);
        sp.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        sp.getViewport().setBackground(this.agendaList.getBackground());
        this.add((Component)sp, "Center");
        this.updateTimer = new LightweightTimer(2, new Runnable(){

            @Override
            public void run() {
                LibraryPanel.this.agendaList.repaint();
            }
        });
    }

    public Agenda[] getSelectedAgendas() {
        Object[] a = this.agendaList.getSelectedValues();
        Agenda[] a2 = new Agenda[a.length];
        System.arraycopy(a, 0, a2, 0, a.length);
        return a2;
    }

    private void checkUpdateTimerStart() {
        if (!this.updateTimer.isScheduled()) {
            this.updateTimer.scheduleEvery(250L);
        }
    }

    private void checkUpdateTimerStop() {
        boolean transfersInProgress = false;
        Agenda[] ags = this.library.getAllAgendas();
        for (int i = 0; i < ags.length; ++i) {
            Agenda ag = ags[i];
            if (!ag.isTransferring(1)) continue;
            transfersInProgress = true;
            break;
        }
        if (!transfersInProgress) {
            this.updateTimer.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void agendaAdded(AgendaLibraryEvent e) {
        Agenda ag = e.getAgenda();
        if (ag.isTransferring(1)) {
            this.checkUpdateTimerStart();
        }
        ag.addAgendaListener((AgendaListener)this);
        AgendaListModel agendaListModel = this.agendaListModel;
        synchronized (agendaListModel) {
            this.agendaListModel.addElement(ag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void agendaRemoved(AgendaLibraryEvent e) {
        Agenda ag = e.getAgenda();
        this.checkUpdateTimerStop();
        ag.removeAgendaListener((AgendaListener)this);
        AgendaListModel agendaListModel = this.agendaListModel;
        synchronized (agendaListModel) {
            this.agendaListModel.removeElement(ag);
        }
    }

    public void agendaActivated(AgendaLibraryEvent e) {
        this.agendaListModel.updateRow(e.getAgenda());
    }

    public void agendaDeactivated(AgendaLibraryEvent e) {
        this.agendaListModel.updateRow(e.getAgenda());
    }

    public void agendaAutoloaded(AgendaLibraryEvent e) {
    }

    public void editorChanged(AgendaEvent e) {
        this.agendaListModel.updateRow(e.getAgenda());
    }

    public void agendaPropertyChanged(AgendaEvent e) {
        if (e.getProperty().equals("filename")) {
            this.agendaListModel.updateRow(e.getAgenda());
        }
    }

    public void transferAdded(AgendaEvent e) {
        this.agendaListModel.updateRow(e.getAgenda());
        this.checkUpdateTimerStart();
    }

    public void transferRemoved(AgendaEvent e) {
        this.agendaListModel.updateRow(e.getAgenda());
        this.checkUpdateTimerStop();
    }

    public void itemAdded(AgendaEvent e) {
    }

    public void itemRemoved(AgendaEvent e) {
    }

    public void itemPropertyChanged(AgendaEvent e) {
    }

    public void timerStarted(AgendaEvent e) {
    }

    public void timerStopped(AgendaEvent e) {
    }

    private static class AgendaListModel
    extends DefaultListModel {
        private AgendaListModel() {
        }

        public synchronized void updateRow(Agenda agenda) {
            for (int row = 0; row < this.getSize(); ++row) {
                Agenda ag = (Agenda)this.getElementAt(row);
                if (ag != agenda) continue;
                this.fireContentsChanged(this, row, row);
                break;
            }
        }

        @Override
        public Object getElementAt(int index) {
            if (index < this.getSize()) {
                return super.getElementAt(index);
            }
            return null;
        }
    }

    private class AgendaRenderer
    extends DefaultListCellRenderer {
        private final double KB = 1024.0;
        private final double MB = 1048576.0;
        private final double GB = 1.073741824E9;
        private NumberFormat sizeFormat = NumberFormat.getNumberInstance();

        public AgendaRenderer() {
            this.setBorder(BorderFactory.createEmptyBorder(4, 6, 4, 0));
        }

        public int getPreferredHeight() {
            this.setText("Some text");
            this.setIcon(LibraryPanel.this.i18n.getIcon("LibraryPanel.elpxDocumentIcon32"));
            return this.getPreferredSize().height;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean focused) {
            this.setComponentOrientation(list.getComponentOrientation());
            if (selected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                if (index % 2 == 0) {
                    this.setBackground(ALTERNATE_ROW_COLOR);
                } else {
                    this.setBackground(list.getBackground());
                }
                this.setForeground(list.getForeground());
            }
            if (value instanceof Agenda) {
                Transfer[] tfrs;
                String name;
                Agenda ag = (Agenda)value;
                StringBuffer b = new StringBuffer();
                b.append(ag.getName());
                if (LibraryPanel.this.library.isActiveAgenda(ag)) {
                    b.append(" - ");
                    b.append(LibraryPanel.this.i18n.getString((PropertiesEnum)StringsProperties.LIBRARYPANEL_ACTIVEDESCRIPTION));
                }
                if ((name = LibraryPanel.this.bean.getClientName(ag.getEditor())) != null) {
                    b.append(" - ");
                    b.append(LibraryPanel.this.i18n.getString((PropertiesEnum)StringsProperties.LIBRARYPANEL_EDITORDESCRIPTION, new Object[]{name}));
                }
                if ((tfrs = ag.getTransfers(1)) != null && tfrs.length != 0) {
                    Transfer tfr = tfrs[0];
                    b.append(" - ");
                    b.append(LibraryPanel.this.i18n.getString((PropertiesEnum)StringsProperties.LIBRARYPANEL_UPLOADINGDESCRIPTION, new Object[]{this.formatSize(tfr.getBytesTransfered()), this.formatSize(tfr.getTransferSize())}));
                }
                this.setText(b.toString());
                this.setIcon(LibraryPanel.this.i18n.getIcon("LibraryPanel.elpxDocumentIcon32"));
            } else {
                this.setText(value == null ? "" : value.toString());
                this.setIcon(null);
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            return this;
        }

        private String formatSize(long size) {
            if ((double)size >= 1.073741824E9) {
                this.sizeFormat.setMaximumFractionDigits(1);
                return LibraryPanel.this.i18n.getString((PropertiesEnum)StringsProperties.FILESEDITOR_FILESIZEGIGABYTES, new Object[]{this.sizeFormat.format((double)size / 1.073741824E9)});
            }
            if ((double)size >= 1048576.0) {
                this.sizeFormat.setMaximumFractionDigits(1);
                return LibraryPanel.this.i18n.getString((PropertiesEnum)StringsProperties.FILESEDITOR_FILESIZEMEGABYTES, new Object[]{this.sizeFormat.format((double)size / 1048576.0)});
            }
            if ((double)size >= 1024.0) {
                this.sizeFormat.setMaximumFractionDigits(0);
                return LibraryPanel.this.i18n.getString((PropertiesEnum)StringsProperties.FILESEDITOR_FILESIZEKILOBYTES, new Object[]{this.sizeFormat.format((double)size / 1024.0)});
            }
            this.sizeFormat.setMaximumFractionDigits(0);
            return LibraryPanel.this.i18n.getString((PropertiesEnum)StringsProperties.FILESEDITOR_FILESIZEBYTES, new Object[]{this.sizeFormat.format(size)});
        }
    }
}

