/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.agenda.module;

import com.elluminate.groupware.agenda.module.StringsProperties;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.io.FileSysUtils;
import java.io.File;
import java.util.Locale;
import javax.swing.filechooser.FileFilter;

class ApplicationFilter
extends FileFilter {
    private String description;

    public ApplicationFilter(I18n i18n) {
        switch (Platform.getPlatform()) {
            case 1: {
                this.description = i18n.getString((PropertiesEnum)StringsProperties.EXECUTABLETASK_WINDOWSAPPLICATIONFILTERDESCRIPTION);
                break;
            }
            case 2: {
                this.description = i18n.getString((PropertiesEnum)StringsProperties.EXECUTABLETASK_MACAPPLICATIONFILTERDESCRIPTION);
                break;
            }
            default: {
                this.description = i18n.getString((PropertiesEnum)StringsProperties.EXECUTABLETASK_UNIXAPPLICATIONFILTERDESCRIPTION);
            }
        }
    }

    @Override
    public boolean accept(File file) {
        if (FileSysUtils.isTraversableDirectory((File)file)) {
            return true;
        }
        String name = file.getName().toLowerCase(Locale.ENGLISH);
        switch (Platform.getPlatform()) {
            case 1: {
                return name.endsWith(".exe") || name.endsWith(".com");
            }
            case 2: {
                return name.indexOf(46) == -1 || name.endsWith(".app");
            }
        }
        return name.indexOf(46) == -1 || name.endsWith(".sh") || name.endsWith(".csh") || name.endsWith(".ksh") || name.endsWith(".tcsh");
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

