/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.agenda.module;

import com.elluminate.classroom.client.messaging.ModulePublisherInfo;
import com.elluminate.engine.ConferencingEngine;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.ComponentFeature;
import com.elluminate.framework.feature.ComponentProvider;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.imps.ImpsAPI;
import com.elluminate.groupware.agenda.AgendaLibrary;
import com.elluminate.groupware.agenda.agenda.Handler;
import com.elluminate.groupware.agenda.module.AgendaBean;
import com.elluminate.groupware.agenda.module.DisplaySettingsPrefsPanel;
import com.elluminate.groupware.agenda.module.EditorOptionsPrefsPanel;
import com.elluminate.groupware.agenda.module.MenuBar;
import com.elluminate.groupware.agenda.module.StringsProperties;
import com.elluminate.groupware.agenda.module.ViewerOptionsPrefsPanel;
import com.elluminate.groupware.imps.DocumentHandlingAPI;
import com.elluminate.groupware.module.AbstractClientModule;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.PreferencesPanelOwner;
import com.elluminate.gui.swing.DialogParentProvider;
import com.elluminate.jinx.Client;
import com.elluminate.util.ComponentRegistrar;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.net.URLProtocolMgr;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.net.URLStreamHandler;
import javax.swing.Icon;

@Singleton
public class AgendaModule
extends AbstractClientModule
implements ModulePublisherInfo,
PreferencesPanelOwner {
    public static final String MODULE_NAME = "Agenda";
    static final boolean ALLOW_EDITING_ONLINE = false;
    private final String prefix = ((Object)((Object)this)).getClass().getName();
    private DialogParentProvider parentProvider;
    private Provider<AgendaBean> beanProvider;
    private Provider<DisplaySettingsPrefsPanel> displaySettingsPrefsProvider;
    private Provider<EditorOptionsPrefsPanel> editorOptionsPrefsProvider;
    private Provider<ViewerOptionsPrefsPanel> viewerOptionsPrefsProvider;
    private ComponentFeature displaySettingsPrefsPanel;
    private ComponentFeature editorOptionsPrefsPanel;
    private ComponentFeature viewerOptionsPrefsPanel;
    private MenuBar menuBar;
    private I18n i18n = I18n.create((Object)((Object)this));
    private Imps imps;
    private Preferences preferences;
    private ConferencingEngine confEngine;
    private boolean visible;
    private FeatureBroker broker;
    private AgendaLibrary library;
    private ActionFeature newAgendaFeature;
    private AgendaBean bean;
    private DocumentHandler documentHandler;

    public FeatureBroker getBroker() {
        return this.broker;
    }

    @Inject
    protected void initVersionManager(ComponentRegistrar cr) {
        cr.registerComponent((Object)this);
    }

    @Inject
    public void initCalculatorBeanProvider(Provider<AgendaBean> provider) {
        this.beanProvider = provider;
    }

    @Inject
    protected void initParentProvider(DialogParentProvider dpp) {
        this.parentProvider = dpp;
    }

    @Inject
    public void initImps(Imps imps) {
        this.imps = imps;
    }

    @Inject
    protected void initPreferences(Preferences prefs) {
        this.preferences = prefs;
    }

    @Inject
    public void initConferencingEngine(ConferencingEngine ce) {
        this.confEngine = ce;
    }

    @Inject
    public void initFeatureBroker(FeatureBroker broker) {
        this.broker = broker;
    }

    @Inject
    public void initmenuBar(MenuBar menuBar) {
        this.menuBar = menuBar;
    }

    @Inject
    public void initDisplaySettingsPrefsProvider(Provider<DisplaySettingsPrefsPanel> displayProvider) {
        this.displaySettingsPrefsProvider = displayProvider;
    }

    @Inject
    public void initEditorOptionsPrefsProvider(Provider<EditorOptionsPrefsPanel> editorPovider) {
        this.editorOptionsPrefsProvider = editorPovider;
    }

    @Inject
    public void initViewerOptionsPrefsProvider(Provider<ViewerOptionsPrefsPanel> viewingProvider) {
        this.viewerOptionsPrefsProvider = viewingProvider;
    }

    public String getNameOfModule() {
        return MODULE_NAME;
    }

    public String getDisplayNameOfModule() {
        return this.i18n.getString((PropertiesEnum)StringsProperties.AGENDAMODULE_NAME);
    }

    public Icon getModuleIcon() {
        return this.i18n.getIcon("AgendaModule.icon");
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getTitle() {
        return this.i18n.getString((PropertiesEnum)StringsProperties.AGENDAMODULE_NAME);
    }

    public Icon getIcon() {
        return this.i18n.getIcon("AgendaModule.icon");
    }

    public AgendaBean getBean() {
        return this.bean;
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public ConferencingEngine getConfEngine() {
        return this.confEngine;
    }

    public void configure() {
    }

    public void configure(Client client, Frame mainFrame) {
    }

    public boolean requestClose() {
        return true;
    }

    boolean isStandalone() {
        String prop = System.getProperty("com.elluminate.groupware.agenda.standalone");
        return prop != null && prop.equalsIgnoreCase("true");
    }

    public void setupUI() {
        this.menuBar.initListener();
        this.menuBar.createFeatures();
        this.viewerOptionsPrefsPanel = this.broker.createComponentFeature((Object)this, "/agenda/prefs/viewerOptions", new ComponentProvider(){

            public Component get(ComponentFeature feature) {
                return (Component)AgendaModule.this.viewerOptionsPrefsProvider.get();
            }
        }, this.i18n.getString((PropertiesEnum)StringsProperties.VIEWEROPTIONS_TITLE), this.i18n.getString((PropertiesEnum)StringsProperties.VIEWEROPTIONS_TITLE));
        this.displaySettingsPrefsPanel = this.broker.createComponentFeature((Object)this, "/agenda/prefs/displaySettings", new ComponentProvider(){

            public Component get(ComponentFeature feature) {
                return (Component)AgendaModule.this.displaySettingsPrefsProvider.get();
            }
        }, this.i18n.getString((PropertiesEnum)StringsProperties.DISPLAYSETTINGS_TITLE), this.i18n.getString((PropertiesEnum)StringsProperties.DISPLAYSETTINGS_TITLE));
        this.editorOptionsPrefsPanel = this.broker.createComponentFeature((Object)this, "/agenda/prefs/editorOtpions", new ComponentProvider(){

            public Component get(ComponentFeature feature) {
                return (Component)AgendaModule.this.editorOptionsPrefsProvider.get();
            }
        }, this.i18n.getString((PropertiesEnum)StringsProperties.EDITOROPTIONS_TITLE), this.i18n.getString((PropertiesEnum)StringsProperties.EDITOROPTIONS_TITLE));
        this.broker.setFeaturePublished((Feature)this.editorOptionsPrefsPanel, this.isStandalone());
        this.broker.setFeaturePublished((Feature)this.displaySettingsPrefsPanel, true);
        this.broker.setFeaturePublished((Feature)this.viewerOptionsPrefsPanel, !this.isStandalone());
    }

    public void cleanupUI() {
    }

    public void start() {
    }

    public void attach() {
        this.bean = (AgendaBean)this.beanProvider.get();
        this.bean.loadPreferences(this.prefix, this.preferences);
        this.documentHandler = new DocumentHandler();
        this.imps.provideAPI(DocumentHandlingAPI.class, (ImpsAPI)this.documentHandler);
    }

    public void detach() {
        this.imps.revokeAPI(DocumentHandlingAPI.class, (ImpsAPI)this.documentHandler);
    }

    public void stop() {
    }

    public boolean isVisible() {
        return this.visible;
    }

    static {
        URLProtocolMgr.getInstance().addHandler("agenda", (URLStreamHandler)new Handler());
    }

    private class DocumentHandler
    implements DocumentHandlingAPI {
        private DocumentHandler() {
        }

        public String getProvider() {
            return AgendaModule.MODULE_NAME;
        }

        public byte getTier() {
            return 32;
        }

        public void newDocument() {
            ((AgendaBean)AgendaModule.this.beanProvider.get()).doNewAgenda();
        }

        public boolean openDocument(File file) {
            try {
                if (!AgendaModule.this.bean.doCloseAgenda(true)) {
                    return false;
                }
                AgendaModule.this.bean.openAgenda(file, false);
                return true;
            }
            catch (IOException ex) {
                ModalDialog.showMessageDialog((Component)((Component)AgendaModule.this.beanProvider.get()), (Object)AgendaModule.this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_OPENAGENDAFAILEDMESSAGE), (String)AgendaModule.this.i18n.getString((PropertiesEnum)StringsProperties.AGENDABEAN_OPENAGENDAFAILEDTITLE), (int)0);
                return false;
            }
        }

        public boolean closeDocuments() {
            return AgendaModule.this.bean.doCloseAgenda(false);
        }
    }
}

