/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.mediastream.imageprocessing;

import com.elluminate.mediastream.imageprocessing.Tile;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class TileCache {
    private Hashtable tileToCRCMap = new Hashtable();
    private Hashtable crcTileMap = new Hashtable();

    public Tile getTile(Integer tileNumber) {
        CRCMapEntry entry;
        Integer crc = (Integer)this.tileToCRCMap.get(tileNumber);
        if (crc != null && (entry = (CRCMapEntry)this.crcTileMap.get(crc)) != null) {
            return entry.getTile();
        }
        return null;
    }

    public boolean contains(Integer tileNumber) {
        Integer crc = (Integer)this.tileToCRCMap.get(tileNumber);
        return crc != null;
    }

    public void addTile(Tile tile) {
        CRCMapEntry entry;
        Integer oldCRC = (Integer)this.tileToCRCMap.get(tile.getTileNumber());
        boolean updateCRC = true;
        if (oldCRC != null) {
            boolean bl = updateCRC = !oldCRC.equals(tile.getTileCRC());
            if (updateCRC) {
                this.removeCRCEntry(oldCRC, tile.getTileNumber());
            } else {
                return;
            }
        }
        if ((entry = (CRCMapEntry)this.crcTileMap.get(tile.getTileCRC())) == null) {
            entry = new CRCMapEntry(tile);
            tile.getCompressedTile();
            this.crcTileMap.put(tile.getTileCRC(), entry);
        } else {
            entry.addTile(tile);
        }
        this.tileToCRCMap.put(tile.getTileNumber(), tile.getTileCRC());
    }

    public void removeTile(Integer tileNumber) {
        Integer crc = (Integer)this.tileToCRCMap.get(tileNumber);
        if (crc == null) {
            return;
        }
        this.removeCRCEntry(crc, tileNumber);
    }

    private void removeCRCEntry(Integer crc, Integer tileNumber) {
        CRCMapEntry entry = (CRCMapEntry)this.crcTileMap.get(crc);
        if (entry != null) {
            entry.removeTile(tileNumber);
            if (entry.isEmpty()) {
                this.crcTileMap.remove(crc);
            }
        }
    }

    public Set getTileSet(Integer crc) {
        CRCMapEntry entry = (CRCMapEntry)this.crcTileMap.get(crc);
        if (entry == null) {
            return null;
        }
        return entry.tileNumberSet;
    }

    public Iterator iterator() {
        return new TileNumberIterator();
    }

    class CRCMapEntry {
        private static final int INITIAL_CAPACITY = 10;
        private static final float LOAD_FACTOR = 0.75f;
        Tile tileTemplate;
        HashSet tileNumberSet = new HashSet(10, 0.75f);
        float peakEntries = 0.0f;

        public CRCMapEntry(Tile tileTemplate) {
            this.tileTemplate = tileTemplate;
            this.tileNumberSet.add(tileTemplate.getTileNumber());
        }

        public Tile getTile() {
            return this.tileTemplate;
        }

        public boolean contains(Integer tileNumber) {
            return this.tileNumberSet.contains(tileNumber);
        }

        public boolean isEmpty() {
            return this.tileNumberSet.isEmpty();
        }

        public boolean addTile(Tile tile) {
            boolean added = this.tileNumberSet.add(tile.getTileNumber());
            if ((float)this.tileNumberSet.size() > this.peakEntries) {
                this.peakEntries = this.tileNumberSet.size();
            }
            return added;
        }

        public boolean removeTile(Integer tileNumber) {
            boolean removed = this.tileNumberSet.remove(tileNumber);
            if ((float)Math.max(this.tileNumberSet.size(), 10) < 0.75f * this.peakEntries) {
                this.tileNumberSet = new HashSet(this.tileNumberSet);
                this.peakEntries = this.tileNumberSet.size();
            }
            return removed;
        }
    }

    class TileNumberIterator
    implements Iterator {
        Iterator crcIterator;
        Iterator tileNumberIterator = null;
        CRCMapEntry crcEntry = null;
        Integer tileNumber = null;

        public TileNumberIterator() {
            this.crcIterator = TileCache.this.crcTileMap.values().iterator();
            if (this.crcIterator.hasNext()) {
                this.crcEntry = (CRCMapEntry)this.crcIterator.next();
                this.tileNumberIterator = this.crcEntry.tileNumberSet.iterator();
            } else {
                this.tileNumberIterator = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.tileNumberIterator != null && this.tileNumberIterator.hasNext();
        }

        public Object next() {
            this.tileNumber = (Integer)this.tileNumberIterator.next();
            if (!this.tileNumberIterator.hasNext()) {
                if (this.crcIterator.hasNext()) {
                    this.crcEntry = (CRCMapEntry)this.crcIterator.next();
                    this.tileNumberIterator = this.crcEntry.tileNumberSet.iterator();
                } else {
                    this.tileNumberIterator = null;
                }
            }
            return this.tileNumber;
        }

        @Override
        public void remove() {
            if (this.crcEntry == null || this.tileNumber == null) {
                throw new IllegalStateException("Cannot remove with TileNumberIterator");
            }
            this.tileNumberIterator.remove();
            if (this.crcEntry.tileNumberSet.isEmpty()) {
                this.crcIterator.remove();
            }
            TileCache.this.tileToCRCMap.remove(this.tileNumber);
        }
    }
}

