/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.mediastream;

import com.elluminate.mediastream.FeedPacket;
import com.elluminate.mediastream.MRFPacket;
import com.elluminate.mediastream.TimedPacket;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MRFImageControl
extends MRFPacket
implements FeedPacket,
TimedPacket {
    public static final byte IMAGE_CONTROL_RESIZE = 1;
    public static final byte IMAGE_CONTROL_REPAINT = 2;
    public static final String[] TYPES = new String[]{"dummy", "resize", "repaint"};
    private short feedIdx;
    private short height;
    private long time;
    private byte type = 1;
    private short width;

    public MRFImageControl(short feedIdx, short width, short height, byte type, long time) {
        super((byte)10);
        this.feedIdx = feedIdx;
        this.width = width;
        this.height = height;
        this.type = type;
        this.time = time;
    }

    public MRFImageControl(byte[] packetData) throws IOException {
        super((byte)10);
        ByteArrayInputStream bistr = new ByteArrayInputStream(packetData);
        DataInputStream istr = new DataInputStream(bistr);
        this.feedIdx = istr.readShort();
        this.type = istr.readByte();
        this.width = istr.readShort();
        this.height = istr.readShort();
        this.time = istr.readLong();
    }

    @Override
    public short getFeedIdx() {
        return this.feedIdx;
    }

    public short getHeight() {
        return this.height;
    }

    @Override
    public long getTime() {
        return this.time;
    }

    public byte getType() {
        return this.type;
    }

    public short getWidth() {
        return this.width;
    }

    @Override
    public void setFeedIdx(short feedIdx) {
        this.feedIdx = feedIdx;
    }

    public void setHeight(short height) {
        this.height = height;
    }

    @Override
    public void setTime(long time) {
        this.time = time;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public void setWidth(short width) {
        this.width = width;
    }

    @Override
    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream bostr = new ByteArrayOutputStream();
        DataOutputStream ostr = new DataOutputStream(bostr);
        ostr.writeShort(this.feedIdx);
        ostr.writeByte(this.type);
        ostr.writeShort(this.width);
        ostr.writeShort(this.height);
        ostr.writeLong(this.time);
        return bostr.toByteArray();
    }

    @Override
    public String toString() {
        return "MRFImageControl: feed: " + this.feedIdx + ", width: " + this.width + ", height: " + this.height + ", type: " + TYPES[this.type] + ", time: " + MRFImageControl.decodeTime(this.time);
    }
}

