/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.hand.module;

import com.elluminate.engine.CommandExecutionException;
import com.elluminate.engine.CommandParameterException;
import com.elluminate.engine.command.AbstractCommand;
import com.elluminate.engine.command.ShowEmotionCommand;
import com.elluminate.groupware.hand.module.HandModule;
import com.elluminate.groupware.hand.module.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ShowEmotionCmd
extends AbstractCommand
implements ShowEmotionCommand {
    private static final long serialVersionUID = 1L;
    private HandModule module;
    private String type = null;
    private Map<String, Integer> availableTypes = new HashMap<String, Integer>();
    private I18n i18n = I18n.create((Object)((Object)this));

    @Inject
    public ShowEmotionCmd(HandModule module) {
        this.module = module;
        this.availableTypes.put("none", 0);
        this.availableTypes.put("smiling", 1);
        this.availableTypes.put("laughter", 2);
        this.availableTypes.put("applause", 3);
        this.availableTypes.put("confusion", 4);
        this.availableTypes.put("disapproval", 6);
        this.availableTypes.put("approval", 5);
        this.availableTypes.put("faster", 8);
        this.availableTypes.put("slower", 7);
    }

    public String[] getAvailableTypes() {
        return (String[])this.availableTypes.keySet().toArray();
    }

    public void setType(String type) {
        this.type = type;
    }

    protected void doexecute() throws CommandExecutionException {
        this.validateIsOnline();
        if (this.type == null || this.type.length() == 0) {
            throw new CommandParameterException("Type not set", this.i18n.getString((PropertiesEnum)StringsProperties.SHOWEMOTIONCMD_BADPARAMTYPENOTSET));
        }
        Integer emotion = this.availableTypes.get(this.type.toLowerCase(Locale.ENGLISH));
        if (emotion == null) {
            throw new CommandParameterException("Invalid type: " + this.type, this.i18n.getString((PropertiesEnum)StringsProperties.SHOWEMOTIONCMD_BADPARAMTYPEINVALID, new Object[]{this.type}));
        }
        this.module.getHandBean().setEmotion(emotion);
    }
}

