/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.hand.module;

import com.elluminate.classroom.client.messaging.MessagePublisher;
import com.elluminate.classroom.client.messaging.MessagePublisherMetadata;
import com.elluminate.classroom.client.messaging.MessageRouter;
import com.elluminate.classroom.client.messaging.MessageType;
import com.elluminate.classroom.client.messaging.ModulePublisherInfo;
import com.elluminate.groupware.hand.module.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

@Singleton
public class HandPublisher {
    private final String UNIQUE_NAME = "HandPublisher";
    private final String DISPLAY_NAME;
    private final Icon icon;
    public static final String HAND_UP = "hand-up";
    public static final String HAND_DOWN = "hand-down";
    public static final String HAND_EMOT_SMILE = "hand-emot-smile";
    public static final String HAND_EMOT_LAUGH = "hand-emot-laugh";
    public static final String HAND_EMOT_CONFUSED = "hand-emot-confused";
    public static final String HAND_EMOT_CLAP = "hand-emot-clap";
    public static final String HAND_EMOT_ANGRY = "hand-emot-angry";
    public static final String HAND_EMOT_SPEEDUP = "hand-emot-speed-up";
    private final MessagePublisher publisher;
    private final MessagePublisherMetadata metadata;
    private final I18n i18n;
    private final MessageRouter router;
    private String modName;
    private String modDisplayName;
    private Map<String, MessageType> msgTypes = new HashMap<String, MessageType>();

    @Inject
    public HandPublisher(MessagePublisher pub, MessagePublisherMetadata meta, MessageRouter rtr, I18n localization, ModulePublisherInfo mod) {
        this.publisher = pub;
        this.metadata = meta;
        this.router = rtr;
        this.i18n = localization;
        this.DISPLAY_NAME = this.i18n.getString((PropertiesEnum)StringsProperties.HANDPUBLISHER_DISPLAYNAME);
        this.icon = mod.getModuleIcon();
        this.modName = mod.getNameOfModule();
        this.modDisplayName = mod.getDisplayNameOfModule();
        this.initializePublisher();
    }

    public void sendHandUpMessage(String user, boolean isMe) {
        String message = isMe ? this.i18n.getString((PropertiesEnum)StringsProperties.HANDPUBLISHER_HAND_UP_MESSAGE_SELF) : this.i18n.getString((PropertiesEnum)StringsProperties.HANDPUBLISHER_HAND_UP_MESSAGE, new Object[]{user});
        this.sendRouterMsg(message, this.msgTypes.get(HAND_UP), isMe);
    }

    public void sendHandDownMessage(String user, boolean isMe) {
        String message = isMe ? this.i18n.getString((PropertiesEnum)StringsProperties.HANDPUBLISHER_HAND_DOWN_MESSAGE_SELF) : this.i18n.getString((PropertiesEnum)StringsProperties.HANDPUBLISHER_HAND_DOWN_MESSAGE, new Object[]{user});
        this.sendRouterMsg(message, this.msgTypes.get(HAND_DOWN), isMe);
    }

    public void sendSmileMessage(String user, boolean isMe) {
        String message = isMe ? this.i18n.getString((PropertiesEnum)StringsProperties.HANDPUBLISHER_EMOT_SMILE_MESSAGE_SELF) : this.i18n.getString((PropertiesEnum)StringsProperties.HANDPUBLISHER_EMOT_SMILE_MESSAGE, new Object[]{user});
        this.sendRouterMsg(message, this.msgTypes.get(HAND_EMOT_SMILE), isMe);
    }

    public void sendLaughMessage(String user, boolean isMe) {
        String message = isMe ? this.i18n.getString((PropertiesEnum)StringsProperties.HANDPUBLISHER_EMOT_LAUGH_MESSAGE_SELF) : this.i18n.getString((PropertiesEnum)StringsProperties.HANDPUBLISHER_EMOT_LAUGH_MESSAGE, new Object[]{user});
        this.sendRouterMsg(message, this.msgTypes.get(HAND_EMOT_LAUGH), isMe);
    }

    public void sendConfusedMessage(String user, boolean isMe) {
        String message = isMe ? this.i18n.getString((PropertiesEnum)StringsProperties.HANDPUBLISHER_EMOT_CONFUSED_MESSAGE_SELF) : this.i18n.getString((PropertiesEnum)StringsProperties.HANDPUBLISHER_EMOT_CONFUSED_MESSAGE, new Object[]{user});
        this.sendRouterMsg(message, this.msgTypes.get(HAND_EMOT_CONFUSED), isMe);
    }

    public void sendAngryDisapprovalMessage(String user, boolean isMe) {
        String message = isMe ? this.i18n.getString((PropertiesEnum)StringsProperties.HANDPUBLISHER_EMOTANGRY_DISAPPROVALMESSAGE_SELF) : this.i18n.getString((PropertiesEnum)StringsProperties.HANDPUBLISHER_EMOTANGRY_DISAPPROVALMESSAGE, new Object[]{user});
        this.sendRouterMsg(message, this.msgTypes.get(HAND_EMOT_ANGRY), isMe);
    }

    public void sendAngryApprovalMessage(String user, boolean isMe) {
        String message = isMe ? this.i18n.getString((PropertiesEnum)StringsProperties.HANDPUBLISHER_EMOTANGRY_APPROVALMESSAGE_SELF) : this.i18n.getString((PropertiesEnum)StringsProperties.HANDPUBLISHER_EMOTANGRY_APPROVALMESSAGE, new Object[]{user});
        this.sendRouterMsg(message, this.msgTypes.get(HAND_EMOT_ANGRY), isMe);
    }

    public void sendClapMessage(String user, boolean isMe) {
        String message = isMe ? this.i18n.getString((PropertiesEnum)StringsProperties.HANDPUBLISHER_EMOT_CLAP_MESSAGE_SELF) : this.i18n.getString((PropertiesEnum)StringsProperties.HANDPUBLISHER_EMOT_CLAP_MESSAGE, new Object[]{user});
        this.sendRouterMsg(message, this.msgTypes.get(HAND_EMOT_CLAP), isMe);
    }

    public void sendFasterMessage(String user, boolean isMe) {
        String message = isMe ? this.i18n.getString((PropertiesEnum)StringsProperties.HANDPUBLISHER_EMOT_FASTERMESSAGESELF) : this.i18n.getString((PropertiesEnum)StringsProperties.HANDPUBLISHER_EMOT_FASTERMESSAGE, new Object[]{user});
        this.sendRouterMsg(message, this.msgTypes.get(HAND_EMOT_SPEEDUP), isMe);
    }

    public void sendSlowerMessage(String user, boolean isMe) {
        String message = isMe ? this.i18n.getString((PropertiesEnum)StringsProperties.HANDPUBLISHER_EMOT_SLOWERMESSAGESELF) : this.i18n.getString((PropertiesEnum)StringsProperties.HANDPUBLISHER_EMOT_SLOWERMESSAGE, new Object[]{user});
        this.sendRouterMsg(message, this.msgTypes.get(HAND_EMOT_SPEEDUP), isMe);
    }

    private void sendRouterMsg(String message, MessageType type, boolean isMe) {
        this.publisher.sendTextMessage(message, type, isMe);
    }

    private void initializePublisher() {
        this.initMessageTypes();
        this.setMetadata();
        this.publisher.setPublisherMetadata(this.metadata);
        this.router.registerPublisher(this.publisher);
    }

    private void setMetadata() {
        this.metadata.setPublisherDisplayName(this.DISPLAY_NAME);
        this.metadata.setPublisherUniqueName("HandPublisher");
        this.metadata.setPublisherIcon(this.icon);
        this.metadata.setModuleName(this.modName);
        this.metadata.setModuleDisplayName(this.modDisplayName);
        this.metadata.setPublisherSupportedMessageTypes(new ArrayList<MessageType>(this.msgTypes.values()));
    }

    private void initMessageTypes() {
        this.msgTypes.put(HAND_UP, new MessageType(HAND_UP, this.i18n.getString((PropertiesEnum)StringsProperties.HANDPUBLISHER_TYPE_HAND_UP), 7));
        this.msgTypes.put(HAND_DOWN, new MessageType(HAND_DOWN, this.i18n.getString((PropertiesEnum)StringsProperties.HANDPUBLISHER_TYPE_HAND_DOWN), 3));
        this.msgTypes.put(HAND_EMOT_ANGRY, new MessageType(HAND_EMOT_ANGRY, this.i18n.getString((PropertiesEnum)StringsProperties.HANDPUBLISHER_TYPE_EMOT_ANGRY), 3));
        this.msgTypes.put(HAND_EMOT_CLAP, new MessageType(HAND_EMOT_CLAP, this.i18n.getString((PropertiesEnum)StringsProperties.HANDPUBLISHER_TYPE_EMOT_CLAP), 3));
        this.msgTypes.put(HAND_EMOT_CONFUSED, new MessageType(HAND_EMOT_CONFUSED, this.i18n.getString((PropertiesEnum)StringsProperties.HANDPUBLISHER_TYPE_EMOT_CONFUSED), 3));
        this.msgTypes.put(HAND_EMOT_SMILE, new MessageType(HAND_EMOT_SMILE, this.i18n.getString((PropertiesEnum)StringsProperties.HANDPUBLISHER_TYPE_EMOT_SMILE), 3));
        this.msgTypes.put(HAND_EMOT_LAUGH, new MessageType(HAND_EMOT_LAUGH, this.i18n.getString((PropertiesEnum)StringsProperties.HANDPUBLISHER_TYPE_EMOT_LAUGH), 3));
        this.msgTypes.put(HAND_EMOT_SPEEDUP, new MessageType(HAND_EMOT_SPEEDUP, this.i18n.getString((PropertiesEnum)StringsProperties.HANDPUBLISHER_TYPE_EMOTSPEEDUP), 3));
    }
}

