/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.hand.module;

import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.groupware.Chair;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.GroupwareDebug;
import com.elluminate.groupware.hand.HandDebug;
import com.elluminate.groupware.hand.HandProtocol;
import com.elluminate.groupware.hand.module.HandModule;
import com.elluminate.groupware.hand.module.HandPublisher;
import com.elluminate.groupware.module.JinxTerminal;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ChannelDataListener;
import com.elluminate.jinx.ChannelEvent;
import com.elluminate.jinx.ChannelListener;
import com.elluminate.jinx.ClientEvent;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.ClientListener;
import com.elluminate.jinx.JinxProtocol;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.DataOutputStream;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.UIManager;

@Singleton
public class HandBean
extends JPanel
implements PropertyChangeListener,
ClientListener,
ChannelListener,
ChannelDataListener {
    private static final long serialVersionUID = 1L;
    public static final String ALARM_NOTICE = "/hand/notice/alarm";
    public static final String MY_HAND_UP_NOTICE = "/hand/notice/myHandUp";
    public static final String MY_HAND_DOWN_NOTICE = "/hand/notice/myHandDown";
    static final Integer ZERO = new Integer(0);
    private HandModule handModule = null;
    private JinxTerminal terminal;
    private ClientList clients;
    private boolean handRaised = false;
    Timer hStatusTimer = null;
    Color[] flashBG = new Color[2];
    Color[] flashFG = new Color[2];
    int flashState = 0;
    LightweightTimer emotionTimer = null;
    String handsRaisedStr = null;
    String participantCountStr = null;
    String participantsCountStr = null;
    private boolean raiseOnJoin = false;
    private FeatureBroker broker;
    private ChairProtocol chairProtocol;
    private HandPublisher msgPublisher;

    @Inject
    public HandBean(HandModule handModule, JinxTerminal terminal, FeatureBroker broker) {
        this.handModule = handModule;
        terminal.setProtocol((JinxProtocol)new HandProtocol());
        terminal.addProtocolPropertyListeners((PropertyChangeListener)this);
        terminal.createChannels((ChannelListener)this, (ChannelDataListener)this);
        this.terminal = terminal;
        this.broker = broker;
        this.clients = this.terminal.getClientList();
        this.clients.addClientListener((ClientListener)this);
        this.clients.addPropertyChangeListener("chair", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("Label.session", (PropertyChangeListener)this);
        this.handsRaisedStr = "HandBean.nHandsRaised2";
        this.participantCountStr = "HandBean.participantCount2";
        this.participantsCountStr = "HandBean.participantsCount2";
        this.setUpNotifications();
    }

    @Inject
    public void initChairProtocol(ChairProtocol chairProtocol) {
        this.chairProtocol = chairProtocol;
    }

    @Inject
    public void initHandPublisher(HandPublisher msgPublisher) {
        this.msgPublisher = msgPublisher;
    }

    public void dispose() {
        this.terminal.removeProtocolPropertyListeners((PropertyChangeListener)this);
        this.clients.removePropertyChangeListener("chair", (PropertyChangeListener)this);
        this.clients.removePropertyChangeListener("Label.session", (PropertyChangeListener)this);
        this.clients.removeClientListener((ClientListener)this);
        this.clients = null;
    }

    private void setUpNotifications() {
        this.broker.announceNotification((Object)this, ALARM_NOTICE);
        this.broker.announceNotification((Object)this, MY_HAND_UP_NOTICE);
        this.broker.announceNotification((Object)this, MY_HAND_DOWN_NOTICE);
    }

    private void fireNotification(String path, String msg) {
        long ts = this.terminal.getClient().getSessionTime();
        this.broker.sendNotification((Object)this, path, msg, ts);
    }

    void raiseHand_actionPerformed(ActionEvent e) {
        ClientInfo me = this.clients.getMyClient();
        if (me == null) {
            return;
        }
        if (HandProtocol.isHandRaised((ClientInfo)me)) {
            this.lowerHand(me);
        } else {
            this.raiseHand();
        }
    }

    void raiseHand() {
        this.sendRaiseHandMessage();
        if (HandProtocol.DEBUG.show()) {
            System.out.println("Hand: Raising Hand");
        }
    }

    void lowerHand(ClientInfo whom) {
        if (whom == null) {
            return;
        }
        ChannelDataEvent msg = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)2);
        try {
            DataOutputStream str = msg.write();
            str.writeShort(whom.getAddress());
            str.close();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"lowerHand", (Throwable)ex, (boolean)true);
            msg.dispose();
            return;
        }
        this.terminal.fireChannelData(msg);
        this.handRaised = false;
        if (HandProtocol.DEBUG.show()) {
            System.out.println("Hand: Lower Hand Button Pressed");
        }
    }

    void lowerAllHands() {
        if (!this.chairProtocol.fetchChair(this.clients).isMe()) {
            return;
        }
        ChannelDataEvent msg = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)3);
        this.terminal.fireChannelData(msg);
        this.handRaised = false;
        if (HandProtocol.DEBUG.show()) {
            System.out.println("Hand: All Hands Lowered");
        }
    }

    void setEmotion(int request) {
        ClientInfo me = this.clients.getMyClient();
        if (me == null) {
            return;
        }
        char which = ' ';
        switch (request) {
            case 0: {
                which = ' ';
                break;
            }
            case 1: {
                which = ')';
                break;
            }
            case 2: {
                which = 'l';
                break;
            }
            case 3: {
                which = 'c';
                break;
            }
            case 4: {
                which = '?';
                break;
            }
            case 5: {
                which = 'p';
                break;
            }
            case 6: {
                which = 'a';
                break;
            }
            case 7: {
                which = 's';
                break;
            }
            case 8: {
                which = 'f';
            }
        }
        me.setProperty("hand.emotion", which);
        if (this.emotionTimer == null) {
            this.emotionTimer = new LightweightTimer(new Runnable(){

                @Override
                public void run() {
                    ClientInfo me2 = HandBean.this.clients.getMyClient();
                    if (HandDebug.EMOTICON.show()) {
                        LogSupport.message((Object)this, (String)"run", (String)("Emoticon Reset Timer - me = " + me2));
                    }
                    if (HandProtocol.DEBUG.show()) {
                        System.out.println("Hand: Emotion Reset.");
                    }
                    if (me2 != null) {
                        me2.setProperty("hand.emotion", ' ');
                    }
                }
            });
        }
        if (HandProtocol.DEBUG.show()) {
            System.out.println("Hand: Emotion Set: " + which);
        }
        this.emotionTimer.scheduleIn(5000L);
    }

    private void flashOn() {
        this.flashBG[0] = UIManager.getColor("Button.background");
        this.flashFG[0] = UIManager.getColor("Button.foreground");
        if (this.hStatusTimer == null) {
            this.hStatusTimer = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HandBean.this.flashState = 1 - HandBean.this.flashState;
                }
            });
        }
        if (!this.hStatusTimer.isRunning()) {
            this.hStatusTimer.start();
        }
        if (HandProtocol.DEBUG.show()) {
            System.out.println("Hand: Flash On");
        }
    }

    private void flashOff() {
        this.flashBG[0] = UIManager.getColor("Button.background");
        this.flashFG[0] = UIManager.getColor("Button.foreground");
        if (this.hStatusTimer != null && this.hStatusTimer.isRunning()) {
            this.hStatusTimer.stop();
        }
        if (HandProtocol.DEBUG.show()) {
            System.out.println("Hand: Flash Off");
        }
        this.flashState = 0;
    }

    void setStatusText(int nHands, int nParticipants) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (GroupwareDebug.EVENTS.show()) {
            LogSupport.message((Object)this, (String)"onPropertyChange", (String)(e.getPropertyName() + ": " + e.getOldValue() + "->" + e.getNewValue()));
        }
        class PropertyChangeUI
        implements Runnable {
            PropertyChangeEvent e;

            public PropertyChangeUI(PropertyChangeEvent event) {
                this.e = event;
            }

            @Override
            public void run() {
                if (HandBean.this.clients == null) {
                    return;
                }
                short addr = HandBean.this.clients.getPropertyOwner(this.e.getSource());
                ClientInfo ci = HandBean.this.clients.get(addr);
                String prop = this.e.getPropertyName();
                if (prop.equals("hand.count")) {
                    short nHands = HandBean.this.clients.getProperty("hand.count", (short)0);
                    int nParticipants = HandBean.this.clients.getVisibleSize();
                    if (HandProtocol.DEBUG.show()) {
                        System.out.println("Hand: Count Property Changed: nHands=" + nHands + " - nParticipants=" + nParticipants);
                    }
                    if (nHands == 0 && HandBean.this.hStatusTimer != null) {
                        HandBean.this.flashOff();
                    }
                    HandBean.this.setStatusText(nHands, nParticipants);
                } else if (prop.equals("hand.index")) {
                    Short old = (Short)this.e.getOldValue();
                    Short value = (Short)this.e.getNewValue();
                    short from = old == null ? (short)0 : old;
                    short to = value == null ? (short)0 : value;
                    Chair chair = HandBean.this.chairProtocol.fetchChair(HandBean.this.clients);
                    if (ci == null) {
                        return;
                    }
                    if (from > 0 && to == 0) {
                        if (ci == HandBean.this.clients.getMyClient()) {
                            HandBean.this.handRaised = false;
                            HandBean.this.handModule.updateFeatures();
                            HandBean.this.fireNotification(HandBean.MY_HAND_DOWN_NOTICE, "");
                            if (HandProtocol.DEBUG.show()) {
                                System.out.println("Hand: Hand Status Changed. Lowering Hand");
                            }
                        }
                    } else if (from == 0 && to > 0) {
                        if (ci == HandBean.this.clients.getMyClient()) {
                            HandBean.this.fireNotification(HandBean.MY_HAND_UP_NOTICE, "");
                            if (HandProtocol.DEBUG.show()) {
                                System.out.println("Hand: Hand Status Changed. Raising Hand");
                            }
                        } else if (chair.isMe()) {
                            HandBean.this.flashOn();
                            HandBean.this.fireNotification(HandBean.ALARM_NOTICE, "");
                        }
                    }
                    HandBean.this.sendHandStateRouterMessage(ci, old, value);
                } else if (prop.equals("hand.notifyOnJoin")) {
                    if (this.e.getNewValue() instanceof Boolean) {
                        boolean autoRaiseHand = (Boolean)this.e.getNewValue();
                        HandBean.this.setAutoRaise(autoRaiseHand);
                    }
                    HandBean.this.handModule.updateFeatures();
                }
            }
        }
        SwingRunnerSupport.invokeLater((Runnable)new PropertyChangeUI(e));
    }

    private void sendHandStateRouterMessage(ClientInfo ci, Short oldValue, Short newValue) {
        short newVal;
        short oldVal = oldValue == null ? (short)0 : oldValue;
        short s = newVal = newValue == null ? (short)0 : newValue;
        if (!ci.isVisible()) {
            return;
        }
        if (oldVal == 0 && newVal > 0) {
            this.msgPublisher.sendHandUpMessage(ci.getDisplayName(), ci.isMe());
        } else if (oldVal > 0 && newVal == 0) {
            this.msgPublisher.sendHandDownMessage(ci.getDisplayName(), ci.isMe());
        }
    }

    public void onAddClient(ClientEvent event) {
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                short nHands = HandBean.this.clients.getProperty("hand.count", (short)0);
                int nParticipants = HandBean.this.clients.getVisibleSize();
                HandBean.this.setStatusText(nHands, nParticipants);
            }
        });
    }

    public void onRemoveClient(ClientEvent event) {
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                int nHands = 0;
                int nParticipants = 0;
                if (HandBean.this.clients != null) {
                    nHands = HandBean.this.clients.getProperty("hand.count", (short)0);
                    nParticipants = HandBean.this.clients.getVisibleSize();
                }
                HandBean.this.setStatusText(nHands, nParticipants);
            }
        });
    }

    public void channelStateChanged(ChannelEvent event) {
        if (event.getState() == 2) {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (HandProtocol.DEBUG.show()) {
                        LogSupport.message((String)"HandBean - channelStateChanged. Channel going down");
                    }
                }
            });
        } else {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (HandProtocol.DEBUG.show()) {
                        LogSupport.message((String)"HandBean - channelStateChanged. Channel going up");
                    }
                    HandBean.this.handsRaisedStr = "HandBean.nHandsRaised2";
                    HandBean.this.participantCountStr = "HandBean.participantCount2";
                    HandBean.this.participantsCountStr = "HandBean.participantsCount2";
                    short nHands = HandBean.this.clients.getProperty("hand.count", (short)0);
                    int nParticipants = HandBean.this.clients.getVisibleSize();
                    HandBean.this.setStatusText(nHands, nParticipants);
                    if (HandBean.this.raiseOnJoin) {
                        if (HandProtocol.DEBUG.show()) {
                            LogSupport.message((String)"HandBean - channelStateChanged. raiseOnJoin set: Raising Hand");
                        }
                        HandBean.this.handModule.setHandFeatureValue(true);
                    }
                    HandBean.this.handModule.updateFeatures();
                }
            });
        }
    }

    private void sendRaiseHandMessage() {
        ChannelDataEvent msg = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)1);
        this.terminal.fireChannelData(msg);
        this.handRaised = true;
    }

    public boolean isRaiseOnJoinEnabled() {
        return this.raiseOnJoin;
    }

    public void setAutoRaise(boolean autoRaise) {
        this.raiseOnJoin = autoRaise;
        this.clients.setProperty("hand.notifyOnJoin", this.raiseOnJoin);
        if (HandProtocol.DEBUG.show()) {
            System.out.println("HandBean.setAutoRaise(): Raise Hand on Entry state changed; State=" + autoRaise);
        }
    }

    public ClientList getClients() {
        return this.clients;
    }

    public JinxTerminal getTerminal() {
        return this.terminal;
    }

    public void onChannelData(ChannelDataEvent event) {
        System.out.println("Hand: onChannelData **********NOT IMPLEMENTED***");
    }

    public boolean isHandRaised() {
        return this.handRaised;
    }

    class EmotionListener
    implements ActionListener {
        char which;

        public EmotionListener(char which) {
            this.which = which;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HandBean.this.setEmotion(this.which);
        }
    }
}

