/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.hand.module;

import com.elluminate.framework.session.CRSession;
import com.elluminate.groupware.hand.HandProtocol;
import com.elluminate.groupware.hand.module.HandBean;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.util.log.Logger;
import com.google.inject.Inject;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class HandAnnotationHandler {
    private Logger log = null;
    private CRSession session = null;
    private PropertyChangeListener responseChangeListener = null;
    private ClientProvider clientProvider = null;
    private HandBean handBean;

    @Inject
    public void initCRSession(CRSession crs) {
        this.session = crs;
    }

    @Inject
    public void initClientProvider(ClientProvider cp) {
        this.clientProvider = cp;
    }

    @Inject
    public void initLogger(Logger l) {
        this.log = l;
    }

    public void setup(HandBean handBean) {
        this.handBean = handBean;
        this.session.registerAnnotation("HandRaiseAnnotation", (Object)0);
        this.responseChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                HandAnnotationHandler.this.handleResponseChange(evt);
            }
        };
        this.clientProvider.get().getClientList().addClientPropertyChangeListener("hand.index", this.responseChangeListener);
    }

    private void handleResponseChange(PropertyChangeEvent event) {
        ClientInfo ci = (ClientInfo)event.getSource();
        if (event.getPropertyName().equals("hand.index") && event.getNewValue() != null && event.getNewValue() instanceof Number) {
            int newValue = ((Number)event.getNewValue()).intValue();
            this.session.setAnnotationValue(ci.getAddress(), "HandRaiseAnnotation", (Object)newValue);
        }
    }

    public void cleanup() {
        block2: {
            try {
                this.session.deRegisterAnnotation("HandRaiseAnnotation");
                this.clientProvider.get().getClientList().removeClientPropertyChangeListener("hand.count", this.responseChangeListener);
            }
            catch (Exception e) {
                if (!HandProtocol.DEBUG.show()) break block2;
                this.log.message("Exception thrown during cleanup, no action required");
            }
        }
    }
}

