/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.session;

import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRRoom;
import com.elluminate.framework.session.CRSession;
import com.elluminate.framework.session.CRSessionDebug;
import com.elluminate.framework.session.listener.event.CRParticipantEvent;
import com.elluminate.framework.session.listener.event.CRRoomEvent;
import com.elluminate.framework.session.listener.event.CRRoomEventType;
import com.elluminate.jinx.ClientGroup;
import com.elluminate.jinx.ClientGroupEvent;
import com.elluminate.jinx.ClientGroupListener;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.util.log.LogSupport;

public class CRSessionGroupListener
implements ClientGroupListener {
    private CRSession session;

    public CRSessionGroupListener(CRSession session) {
        this.session = session;
    }

    public void clientGroupChanged(ClientGroupEvent event) {
        if (CRSessionDebug.INFO.isEnabled()) {
            LogSupport.message((Object)this, (String)"clientGroupChanged", (String)("client group changed: " + event.getSource()));
        }
        CRParticipantEvent joinEvent = null;
        CRParticipantEvent leaveEvent = null;
        ClientInfo ci = event.getClient();
        ClientGroup group = event.getGroup();
        CRParticipant participant = this.session.getParticipantById(ci.getAddress());
        CRRoom prevRoom = participant.getRoom();
        CRRoom currRoom = this.session.getRoomById(group.getGroupID());
        if (prevRoom != null) {
            leaveEvent = prevRoom.removeParticipant(participant);
        }
        joinEvent = currRoom.addParticipant(participant);
        this.session.fireParticipantEvent(leaveEvent);
        this.session.fireParticipantEvent(joinEvent);
    }

    public void clientGroupCreated(ClientGroupEvent event) {
        if (CRSessionDebug.INFO.isEnabled()) {
            LogSupport.message((Object)this, (String)"clientGroupCreated", (String)("client group created: " + event.getSource()));
        }
        CRRoom room = new CRRoom(this.session, event.getGroup());
        this.session.addRoom(room);
    }

    public void clientGroupDeleted(ClientGroupEvent event) {
        if (CRSessionDebug.INFO.isEnabled()) {
            LogSupport.message((Object)this, (String)"clientGroupDeleted", (String)("client group deleted: " + event.getSource()));
        }
        this.session.removeRoom(event.getGroupID());
    }

    public void clientGroupRenamed(ClientGroupEvent event) {
        CRRoom room;
        if (CRSessionDebug.INFO.isEnabled()) {
            LogSupport.message((Object)this, (String)"clientGroupRenamed", (String)("client group renamed: " + event.getSource()));
        }
        if ((room = this.session.getRoomById(event.getGroupID())) != null) {
            this.session.fireRoomEvent(new CRRoomEvent(CRRoomEventType.RENAMED, room));
        }
    }
}

