/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.session;

import com.elluminate.framework.session.CRAnnotation;
import com.elluminate.framework.session.CRPermissionScope;
import com.elluminate.framework.session.CRPermissionStore;
import com.elluminate.framework.session.CRRoom;
import com.elluminate.framework.session.CRSession;
import com.elluminate.framework.session.CRSessionDebug;
import com.elluminate.framework.session.listener.CRPermissionChangeListener;
import com.elluminate.framework.session.listener.event.CRPermissionChangeEvent;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.PropertyAccessAPI;
import com.elluminate.util.log.LogSupport;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class CRParticipant
extends CRPermissionStore {
    private CRRoom room;
    private ClientInfo clientInfo;
    private CRSession session;
    private Object lock = new Object();
    private Map<String, CRAnnotation> nameAnnotationMap = new LinkedHashMap<String, CRAnnotation>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CRParticipant(CRSession session, ClientInfo clientInfo) {
        if (session == null) {
            throw new IllegalArgumentException("session may not be null in CRParticipant constructor.");
        }
        if (clientInfo == null) {
            throw new IllegalArgumentException("clientInfo may not be null in CRParticipant constructor.");
        }
        Object object = this.lock;
        synchronized (object) {
            this.session = session;
            this.clientInfo = clientInfo;
        }
        this.init(session.getConnection(), clientInfo.getAddress(), CRPermissionScope.PARTICIPANT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CRSession getSession() {
        CRSession s;
        Object object = this.lock;
        synchronized (object) {
            s = this.session;
        }
        return s;
    }

    @Override
    public short getID() {
        short id = this.clientInfo.getAddress();
        return id;
    }

    public PropertyAccessAPI getPropertyStore() {
        return this.clientInfo;
    }

    public String getName() {
        return this.clientInfo.getName();
    }

    public String getDisplayName() {
        return this.clientInfo.getDisplayName();
    }

    public boolean isMe() {
        return this.clientInfo.isMe();
    }

    public boolean isChair() {
        return this.session.isChair(this);
    }

    public boolean isVisible() {
        return this.clientInfo.isVisible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CRRoom getRoom() {
        CRRoom rm;
        Object object = this.lock;
        synchronized (object) {
            rm = this.room;
        }
        return rm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRoom(CRRoom room) {
        Object object = this.lock;
        synchronized (object) {
            this.room = room;
        }
    }

    public ClientInfo getClientInfo() {
        return this.clientInfo;
    }

    @Override
    public String toString() {
        return "[Participant: ID = " + this.getID() + ", name=" + this.getName() + ", displayName=" + this.getDisplayName() + ", isMe=" + this.isMe() + ", " + this.room + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAnnotation(CRAnnotation annotation) {
        if (annotation == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            LinkedHashMap<String, CRAnnotation> copy = new LinkedHashMap<String, CRAnnotation>(this.nameAnnotationMap);
            copy.put(annotation.getName(), annotation);
            this.nameAnnotationMap = copy;
        }
        if (CRSessionDebug.ANNOTATION_TRACE.show()) {
            LogSupport.message((Object)this, (String)"addAnnotation", (String)("Added annotation: " + annotation + " to store: " + this));
        }
    }

    public CRAnnotation getAnnotation(String annotationName) {
        CRAnnotation annotation = this.nameAnnotationMap.get(annotationName);
        if (CRSessionDebug.ANNOTATION_TRACE.show()) {
            LogSupport.message((Object)this, (String)"getAnnotation", (String)("Fetched annotation " + annotation + " from store: " + this));
        }
        return annotation;
    }

    public Iterator<CRAnnotation> getAnnotationIterator() {
        return this.nameAnnotationMap.values().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAnnotation(String annotationName) {
        CRAnnotation annotation = null;
        Object object = this.lock;
        synchronized (object) {
            LinkedHashMap<String, CRAnnotation> copy = new LinkedHashMap<String, CRAnnotation>(this.nameAnnotationMap);
            annotation = (CRAnnotation)copy.remove(annotationName);
            this.nameAnnotationMap = copy;
        }
        if (CRSessionDebug.ANNOTATION_TRACE.show()) {
            LogSupport.message((Object)this, (String)"removeAnnotation", (String)("Removed annotation " + annotation + " from store: " + this));
        }
    }

    public Object getAnnotationValue(String annotationName) {
        if (annotationName != null) {
            CRAnnotation annotation = this.getAnnotation(annotationName);
            if (annotation != null) {
                Object value = annotation.getValue();
                return value;
            }
            return null;
        }
        return null;
    }

    public void setAnnotationValue(String annotationName, Object value) {
        CRAnnotation annotation;
        if (annotationName != null && (annotation = this.getAnnotation(annotationName)) != null) {
            annotation.setValue(value);
        }
    }

    public boolean hasPermission(String permissionName) {
        return this.session.getPermissionValue(permissionName, this.getID());
    }

    public void addPermissionChangeListener(String permissionName, CRPermissionChangeListener listener) {
        this.session.addPermissionChangeListener(permissionName, new ParticipantPermisionChangeListener(listener));
    }

    public void removePermissionChangeListener(String permissionName, CRPermissionChangeListener listener) {
        this.session.removePermissionChangeListener(permissionName, new ParticipantPermisionChangeListener(listener));
    }

    public String getDeviceType() {
        if (this.clientInfo == null) {
            return "";
        }
        return (String)this.clientInfo.getProperty("jinx.deviceType");
    }

    private class ParticipantPermisionChangeListener
    implements CRPermissionChangeListener {
        private final CRPermissionChangeListener listener;

        private ParticipantPermisionChangeListener(CRPermissionChangeListener listener) {
            this.listener = listener;
        }

        @Override
        public void onPermissionValueChange(CRPermissionChangeEvent event) {
            if (event.getPermission().getID() == CRParticipant.this.getID()) {
                this.listener.onPermissionValueChange(event);
            }
        }

        @Override
        public void onPermissionDefaultChange(CRPermissionChangeEvent event) {
            if (event.getPermission().getID() == CRParticipant.this.getID()) {
                this.listener.onPermissionDefaultChange(event);
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.listener == null ? 0 : this.listener.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ParticipantPermisionChangeListener other = (ParticipantPermisionChangeListener)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.listener == null ? other.listener != null : !this.listener.equals(other.listener));
        }

        private CRParticipant getOuterType() {
            return CRParticipant.this;
        }
    }
}

