/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.agenda.protocols.agenda;

import com.elluminate.groupware.agenda.Agenda;
import com.elluminate.groupware.agenda.AgendaFile;
import com.elluminate.groupware.agenda.AgendaLibrary;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;

public class AgendaURLConnection
extends URLConnection {
    private static final String FILES_PATH = "/files/";
    private AgendaFile file;

    public AgendaURLConnection(URL url) {
        super(url);
    }

    @Override
    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        String host = this.url.getHost();
        Agenda ag = null;
        try {
            ag = AgendaLibrary.getAgendaByIDFromAnySession(Integer.parseInt(host));
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        if (ag == null) {
            throw new IOException("Cannot get agenda corresponding to ID " + host);
        }
        String path = this.url.getPath();
        if (!path.startsWith(FILES_PATH)) {
            throw new IOException("Invalid path: " + path);
        }
        String name = URLDecoder.decode(path.substring(FILES_PATH.length()), "UTF-8");
        this.file = ag.getFileByName(name);
        if (this.file == null) {
            throw new IOException("No embedded file named \"" + name + "\" exists in the active agenda \"" + ag.getName() + "\"");
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        return new FileInputStream(this.file.getPath());
    }

    @Override
    public String getContentType() {
        return "application/octet-stream";
    }

    @Override
    public int getContentLength() {
        try {
            this.connect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.file != null) {
            return (int)new File(this.file.getPath()).length();
        }
        return -1;
    }
}

