/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.agenda;

import com.elluminate.groupware.agenda.Agenda;
import com.elluminate.util.event.Operation;
import com.elluminate.util.event.OperationProgressException;
import com.elluminate.util.log.LogSupport;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class SaveAgendaTextOperation
extends Operation {
    private File file;
    private boolean expandCompoundActions = false;

    public SaveAgendaTextOperation(Agenda agenda, File file, String name) {
        super((Object)agenda, name, 1L);
        this.file = file;
    }

    public void setExpandCompoundActions(boolean expandCompoundActions) {
        this.expandCompoundActions = expandCompoundActions;
    }

    protected void perform() throws OperationProgressException {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(this.file));
            Agenda ag = (Agenda)this.getObject();
            ag.writeDefinitionAsText(out, this.expandCompoundActions);
        }
        catch (IOException ex) {
            LogSupport.error((Object)((Object)this), (String)"perform", (String)ex.getMessage());
            throw new OperationProgressException(ex.getMessage());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
        }
    }
}

